/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IDebugRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.Messages;

public class Compiler
implements ITypeRequestor,
ProblemSeverities {
    public Parser parser;
    public ICompilerRequestor requestor;
    public CompilerOptions options;
    public ProblemReporter problemReporter;
    public CompilationUnitDeclaration[] unitsToProcess;
    public int totalUnits;
    public LookupEnvironment lookupEnvironment;
    public static boolean DEBUG = false;
    public int parseThreshold = -1;
    public static IDebugRequestor DebugRequestor = null;

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, Map map, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory) {
        this.options = new CompilerOptions(map);
        this.requestor = DebugRequestor == null ? iCompilerRequestor : new ICompilerRequestor(this, iCompilerRequestor){
            public final Compiler a;
            private final ICompilerRequestor val$requestor;
            {
                this.a = compiler;
                this.val$requestor = iCompilerRequestor;
            }

            public void acceptResult(CompilationResult compilationResult) {
                if (DebugRequestor.isActive()) {
                    DebugRequestor.acceptDebugResult(compilationResult);
                }
                this.val$requestor.acceptResult(compilationResult);
            }
        };
        this.problemReporter = new ProblemReporter(iErrorHandlingPolicy, this.options, iProblemFactory);
        this.lookupEnvironment = new LookupEnvironment(this, this.options, this.problemReporter, iNameEnvironment);
        this.initializeParser();
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, Map map, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory, boolean bl2) {
        this.options = new CompilerOptions(map);
        this.requestor = DebugRequestor == null ? iCompilerRequestor : new ICompilerRequestor(this, iCompilerRequestor){
            public final Compiler a;
            private final ICompilerRequestor val$requestor;
            {
                this.a = compiler;
                this.val$requestor = iCompilerRequestor;
            }

            public void acceptResult(CompilationResult compilationResult) {
                if (DebugRequestor.isActive()) {
                    DebugRequestor.acceptDebugResult(compilationResult);
                }
                this.val$requestor.acceptResult(compilationResult);
            }
        };
        this.problemReporter = new ProblemReporter(iErrorHandlingPolicy, this.options, iProblemFactory);
        this.lookupEnvironment = new LookupEnvironment(this, this.options, this.problemReporter, iNameEnvironment);
        this.initializeParser();
    }

    public void accept(IBinaryType iBinaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        if (this.options.verbose) {
            System.out.println(Messages.bind(Messages.compilation_loadBinary, new String(iBinaryType.getName())));
        }
        this.lookupEnvironment.createBinaryTypeFrom(iBinaryType, packageBinding, accessRestriction);
    }

    public void accept(ICompilationUnit iCompilationUnit, AccessRestriction accessRestriction) {
        CompilationResult compilationResult = new CompilationResult(iCompilationUnit, this.totalUnits, this.totalUnits, this.options.maxProblemsPerUnit);
        try {
            Object object;
            if (this.options.verbose) {
                object = String.valueOf(this.totalUnits + 1);
                System.out.println(Messages.bind(Messages.compilation_request, new String[]{object, object, new String(iCompilationUnit.getFileName())}));
            }
            object = this.totalUnits < this.parseThreshold ? this.parser.parse(iCompilationUnit, compilationResult) : this.parser.dietParse(iCompilationUnit, compilationResult);
            this.lookupEnvironment.buildTypeBindings((CompilationUnitDeclaration)object, accessRestriction);
            this.addCompilationUnit(iCompilationUnit, (CompilationUnitDeclaration)object);
            this.lookupEnvironment.completeTypeBindings((CompilationUnitDeclaration)object);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            if (compilationResult.compilationUnit == iCompilationUnit) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
            }
            throw abortCompilationUnit;
        }
    }

    public void accept(ISourceType[] iSourceTypeArray, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.problemReporter.abortDueToInternalError(Messages.bind(Messages.abort_againstSourceModel, new String[]{String.valueOf(iSourceTypeArray[0].getName()), String.valueOf(iSourceTypeArray[0].getFileName())}));
    }

    public void addCompilationUnit(ICompilationUnit iCompilationUnit, CompilationUnitDeclaration compilationUnitDeclaration) {
        int n2 = this.unitsToProcess.length;
        if (this.totalUnits == n2) {
            this.unitsToProcess = new CompilationUnitDeclaration[n2 * 2];
            System.arraycopy(this.unitsToProcess, 0, this.unitsToProcess, 0, this.totalUnits);
        }
        this.unitsToProcess[this.totalUnits++] = compilationUnitDeclaration;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beginToCompile(ICompilationUnit[] iCompilationUnitArray) {
        int n2 = iCompilationUnitArray.length;
        this.totalUnits = 0;
        this.unitsToProcess = new CompilationUnitDeclaration[n2];
        int n3 = 0;
        while (true) {
            Object var6_6;
            if (n3 >= n2) {
                this.lookupEnvironment.completeTypeBindings();
                return;
            }
            CompilationResult compilationResult = new CompilationResult(iCompilationUnitArray[n3], n3, n2, this.options.maxProblemsPerUnit);
            try {
                if (this.options.verbose) {
                    System.out.println(Messages.bind(Messages.compilation_request, new String[]{String.valueOf(n3 + 1), String.valueOf(n2), new String(iCompilationUnitArray[n3].getFileName())}));
                }
                CompilationUnitDeclaration compilationUnitDeclaration = this.totalUnits < this.parseThreshold ? this.parser.parse(iCompilationUnitArray[n3], compilationResult) : this.parser.dietParse(iCompilationUnitArray[n3], compilationResult);
                this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, null);
                this.addCompilationUnit(iCompilationUnitArray[n3], compilationUnitDeclaration);
            }
            catch (Throwable throwable) {
                var6_6 = null;
                iCompilationUnitArray[n3] = null;
                throw throwable;
            }
            {
                var6_6 = null;
                iCompilationUnitArray[n3] = null;
                ++n3;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compile(ICompilationUnit[] iCompilationUnitArray) {
        CompilationUnitDeclaration compilationUnitDeclaration = null;
        int n2 = 0;
        try {
            try {
                this.beginToCompile(iCompilationUnitArray);
                while (n2 < this.totalUnits) {
                    block13: {
                        Object var4_4;
                        compilationUnitDeclaration = this.unitsToProcess[n2];
                        try {
                            if (this.options.verbose) {
                                System.out.println(Messages.bind(Messages.compilation_process, new String[]{String.valueOf(n2 + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[n2].getFileName())}));
                            }
                            this.process(compilationUnitDeclaration, n2);
                        }
                        catch (Throwable throwable) {
                            var4_4 = null;
                            compilationUnitDeclaration.cleanUp();
                            throw throwable;
                        }
                        {
                            var4_4 = null;
                            compilationUnitDeclaration.cleanUp();
                            this.unitsToProcess[n2] = null;
                            this.requestor.acceptResult(compilationUnitDeclaration.compilationResult.tagAsAccepted());
                            if (!this.options.verbose) break block13;
                        }
                        System.out.println(Messages.bind(Messages.compilation_done, new String[]{String.valueOf(n2 + 1), String.valueOf(this.totalUnits), new String(compilationUnitDeclaration.getFileName())}));
                    }
                    ++n2;
                }
            }
            catch (AbortCompilation abortCompilation) {
                this.handleInternalException(abortCompilation, compilationUnitDeclaration);
            }
            catch (Error error) {
                this.handleInternalException(error, compilationUnitDeclaration, null);
                throw error;
            }
            catch (RuntimeException runtimeException) {
                this.handleInternalException(runtimeException, compilationUnitDeclaration, null);
                throw runtimeException;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.reset();
            throw throwable;
        }
        {
            Object var6_11 = null;
            this.reset();
            if (!this.options.verbose) return;
            if (this.totalUnits > 1) {
                System.out.println(Messages.bind(Messages.compilation_units, String.valueOf(this.totalUnits)));
                return;
            }
            System.out.println(Messages.bind(Messages.compilation_unit, String.valueOf(this.totalUnits)));
            return;
        }
    }

    public void handleInternalException(Throwable throwable, CompilationUnitDeclaration compilationUnitDeclaration, CompilationResult compilationResult) {
        if (compilationResult == null && compilationUnitDeclaration != null) {
            compilationResult = compilationUnitDeclaration.compilationResult;
        }
        if (compilationResult == null && this.lookupEnvironment.unitBeingCompleted != null) {
            compilationResult = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (compilationResult == null && this.lookupEnvironment.unitBeingCompleted != null) {
            compilationResult = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (compilationResult == null && this.unitsToProcess != null && this.totalUnits > 0) {
            compilationResult = this.unitsToProcess[this.totalUnits - 1].compilationResult;
        }
        boolean bl2 = true;
        if (compilationResult != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            String[] stringArray = new String[]{String.valueOf(Messages.compilation_internalError) + "\n" + stringBuffer.toString()};
            compilationResult.record(this.problemReporter.createProblem(compilationResult.getFileName(), 0, stringArray, stringArray, 1, 0, 0, 0), compilationUnitDeclaration);
            if (!compilationResult.hasBeenAccepted) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
                bl2 = false;
            }
        }
        if (bl2) {
            throwable.printStackTrace();
        }
    }

    public void handleInternalException(AbortCompilation abortCompilation, CompilationUnitDeclaration compilationUnitDeclaration) {
        if (abortCompilation.isSilent) {
            if (abortCompilation.silentException == null) {
                return;
            }
            throw abortCompilation.silentException;
        }
        CompilationResult compilationResult = abortCompilation.compilationResult;
        if (compilationResult == null && compilationUnitDeclaration != null) {
            compilationResult = compilationUnitDeclaration.compilationResult;
        }
        if (compilationResult == null && this.lookupEnvironment.unitBeingCompleted != null) {
            compilationResult = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (compilationResult == null && this.unitsToProcess != null && this.totalUnits > 0) {
            compilationResult = this.unitsToProcess[this.totalUnits - 1].compilationResult;
        }
        if (compilationResult != null && !compilationResult.hasBeenAccepted) {
            block14: {
                if (abortCompilation.problem != null) {
                    IProblem iProblem = abortCompilation.problem;
                    IProblem[] iProblemArray = compilationResult.problems;
                    int n2 = 0;
                    while (n2 < compilationResult.problemCount) {
                        if (iProblemArray[n2] != iProblem) {
                            ++n2;
                            continue;
                        }
                        break block14;
                    }
                    if (iProblem instanceof DefaultProblem) {
                        ((DefaultProblem)iProblem).setOriginatingFileName(compilationResult.getFileName());
                    }
                    compilationResult.record(iProblem, compilationUnitDeclaration);
                } else if (abortCompilation.exception != null) {
                    this.handleInternalException(abortCompilation.exception, null, compilationResult);
                    return;
                }
            }
            if (!compilationResult.hasBeenAccepted) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
            }
        } else {
            abortCompilation.printStackTrace();
        }
    }

    public void initializeParser() {
        this.parser = new Parser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
    }

    public void process(CompilationUnitDeclaration compilationUnitDeclaration, int n2) {
        this.parser.getMethodBodies(compilationUnitDeclaration);
        if (compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.faultInTypes();
        }
        if (compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
        }
        compilationUnitDeclaration.resolve();
        compilationUnitDeclaration.analyseCode();
        compilationUnitDeclaration.generateCode();
        if (this.options.produceReferenceInfo && compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.storeDependencyInfo();
        }
        compilationUnitDeclaration.compilationResult.totalUnitsKnown = this.totalUnits;
    }

    public void reset() {
        this.lookupEnvironment.reset();
        this.parser.scanner.source = null;
        this.unitsToProcess = null;
        if (DebugRequestor != null) {
            DebugRequestor.reset();
        }
    }

    public CompilationUnitDeclaration resolve(CompilationUnitDeclaration compilationUnitDeclaration, ICompilationUnit iCompilationUnit, boolean bl2, boolean bl3, boolean bl4) {
        try {
            if (compilationUnitDeclaration == null) {
                this.parseThreshold = 0;
                this.beginToCompile(new ICompilationUnit[]{iCompilationUnit});
                compilationUnitDeclaration = this.unitsToProcess[0];
            } else {
                this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, null);
                this.lookupEnvironment.completeTypeBindings();
            }
            this.parser.getMethodBodies(compilationUnitDeclaration);
            if (compilationUnitDeclaration.scope != null) {
                compilationUnitDeclaration.scope.faultInTypes();
                if (compilationUnitDeclaration.scope != null && bl2) {
                    compilationUnitDeclaration.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                compilationUnitDeclaration.resolve();
                if (bl3) {
                    compilationUnitDeclaration.analyseCode();
                }
                if (bl4) {
                    compilationUnitDeclaration.generateCode();
                }
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(compilationUnitDeclaration.compilationResult.tagAsAccepted());
            return compilationUnitDeclaration;
        }
        catch (AbortCompilation abortCompilation) {
            this.handleInternalException(abortCompilation, compilationUnitDeclaration);
            return compilationUnitDeclaration == null ? this.unitsToProcess[0] : compilationUnitDeclaration;
        }
        catch (Error error) {
            this.handleInternalException(error, compilationUnitDeclaration, null);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            this.handleInternalException(runtimeException, compilationUnitDeclaration, null);
            throw runtimeException;
        }
    }

    public CompilationUnitDeclaration resolve(ICompilationUnit iCompilationUnit, boolean bl2, boolean bl3, boolean bl4) {
        return this.resolve(null, iCompilationUnit, bl2, bl3, bl4);
    }
}

