/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.domapi;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.domapi.XPathExpressionImpl;
import org.apache.xpath.domapi.XPathNSResolverImpl;
import org.apache.xpath.res.XPATHMessages;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathExpression;
import org.w3c.dom.xpath.XPathNSResolver;

public class XPathEvaluatorImpl
implements XPathEvaluator {
    private Document m_doc = null;

    public XPathEvaluatorImpl() {
    }

    public XPathEvaluatorImpl(Document document) {
        this.m_doc = document;
    }

    public XPathExpression createExpression(String string, XPathNSResolver xPathNSResolver) throws XPathException, DOMException {
        try {
            XPath xPath = new XPath(string, null, null == xPathNSResolver ? new DummyPrefixResolver(this) : (PrefixResolver)((Object)xPathNSResolver), 0);
            return new XPathExpressionImpl(xPath, this.m_doc);
        }
        catch (TransformerException transformerException) {
            throw new DOMException(1, transformerException.getMessageAndLocation());
        }
    }

    public XPathNSResolver createNSResolver(Node node) {
        return new XPathNSResolverImpl(node.getNodeType() == 9 ? ((Document)node).getDocumentElement() : node);
    }

    public Object evaluate(String string, Node node, XPathNSResolver xPathNSResolver, short s2, Object object) throws XPathException, DOMException {
        XPathExpression xPathExpression = this.createExpression(string, xPathNSResolver);
        return xPathExpression.evaluate(node, s2, object);
    }

    public class DummyPrefixResolver
    implements PrefixResolver {
        private final XPathEvaluatorImpl this$0;

        public DummyPrefixResolver(XPathEvaluatorImpl xPathEvaluatorImpl) {
            this.this$0 = xPathEvaluatorImpl;
        }

        public String getNamespaceForPrefix(String string, Node node) {
            String string2 = XPATHMessages.createXPATHMessage("ER_NULL_RESOLVER", null);
            throw new DOMException(14, string2);
        }

        public String getNamespaceForPrefix(String string) {
            return this.getNamespaceForPrefix(string, null);
        }

        public boolean handlesNullPrefixes() {
            return false;
        }

        public String getBaseIdentifier() {
            return null;
        }
    }
}

