/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.BasicTestIterator;
import org.apache.xpath.axes.FilterExprIteratorSimple;
import org.apache.xpath.axes.PathComponent;
import org.apache.xpath.objects.XNodeSet;

public class FilterExprIterator
extends BasicTestIterator {
    private Expression m_expr;
    private transient XNodeSet m_exprObj;
    private boolean m_mustHardReset = false;
    private boolean m_canDetachNodeset = true;

    public FilterExprIterator() {
        super((PrefixResolver)null);
    }

    public FilterExprIterator(Expression expression) {
        super((PrefixResolver)null);
        this.m_expr = expression;
    }

    public void setRoot(int n2, Object object) {
        super.setRoot(n2, object);
        this.m_exprObj = FilterExprIteratorSimple.executeFilterExpr(n2, this.m_execContext, this.getPrefixResolver(), this.getIsTopLevel(), this.d, this.m_expr);
    }

    public int getNextNode() {
        this.m_lastFetched = null != this.m_exprObj ? this.m_exprObj.nextNode() : -1;
        return this.m_lastFetched;
    }

    public void detach() {
        super.detach();
        this.m_exprObj.detach();
        this.m_exprObj = null;
    }

    public void fixupVariables(Vector vector, int n2) {
        super.fixupVariables(vector, n2);
        this.m_expr.fixupVariables(vector, n2);
    }

    public Expression getInnerExpression() {
        return this.m_expr;
    }

    public void setInnerExpression(Expression expression) {
        expression.exprSetParent(this);
        this.m_expr = expression;
    }

    public int getAnalysisBits() {
        if (null != this.m_expr && this.m_expr instanceof PathComponent) {
            return ((PathComponent)((Object)this.m_expr)).getAnalysisBits();
        }
        return 0x4000000;
    }

    public boolean isDocOrdered() {
        return this.m_exprObj.isDocOrdered();
    }

    public void callPredicateVisitors(XPathVisitor xPathVisitor) {
        this.m_expr.callVisitors(new filterExprOwner(this), xPathVisitor);
        super.callPredicateVisitors(xPathVisitor);
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        FilterExprIterator filterExprIterator = (FilterExprIterator)expression;
        return this.m_expr.deepEquals(filterExprIterator.m_expr);
    }

    public static Expression a(FilterExprIterator filterExprIterator) {
        return filterExprIterator.m_expr;
    }

    public static Expression a(FilterExprIterator filterExprIterator, Expression expression) {
        filterExprIterator.m_expr = expression;
        return filterExprIterator.m_expr;
    }

    public class filterExprOwner
    implements ExpressionOwner {
        private final FilterExprIterator this$0;

        public filterExprOwner(FilterExprIterator filterExprIterator) {
            this.this$0 = filterExprIterator;
        }

        public Expression getExpression() {
            return FilterExprIterator.a(this.this$0);
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(this.this$0);
            FilterExprIterator.a(this.this$0, expression);
        }
    }
}

