/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.util.EmptyStackException;
import org.apache.xml.utils.ObjectVector;

public class ObjectStack
extends ObjectVector {
    public ObjectStack() {
    }

    public ObjectStack(int n2) {
        super(n2);
    }

    public ObjectStack(ObjectStack objectStack) {
        super(objectStack);
    }

    public Object push(Object object) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Object[] objectArray = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, objectArray, 0, this.m_firstFree + 1);
            this.m_map = objectArray;
        }
        this.m_map[this.m_firstFree] = object;
        ++this.m_firstFree;
        return object;
    }

    public Object pop() {
        Object object = this.m_map[--this.m_firstFree];
        this.m_map[this.m_firstFree] = null;
        return object;
    }

    public void quickPop(int n2) {
        this.m_firstFree -= n2;
    }

    public Object peek() {
        try {
            return this.m_map[this.m_firstFree - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    public Object peek(int n2) {
        try {
            return this.m_map[this.m_firstFree - (1 + n2)];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    public void setTop(Object object) {
        try {
            this.m_map[this.m_firstFree - 1] = object;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    public boolean empty() {
        return this.m_firstFree == 0;
    }

    public int search(Object object) {
        int n2 = this.lastIndexOf(object);
        if (n2 >= 0) {
            return this.size() - n2;
        }
        return -1;
    }

    public Object clone() throws CloneNotSupportedException {
        return (ObjectStack)super.clone();
    }
}

