/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class WriterToUTF8Buffered
extends Writer {
    private static final int BYTES_MAX = 16384;
    private static final int CHARS_MAX = 5461;
    private final OutputStream m_os;
    private final byte[] m_outputBytes;
    private final char[] m_inputChars;
    private int count;

    public WriterToUTF8Buffered(OutputStream outputStream) throws UnsupportedEncodingException {
        this.m_os = outputStream;
        this.m_outputBytes = new byte[16387];
        this.m_inputChars = new char[5462];
        this.count = 0;
    }

    public void write(int n2) throws IOException {
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        if (n2 < 128) {
            this.m_outputBytes[this.count++] = (byte)n2;
        } else if (n2 < 2048) {
            this.m_outputBytes[this.count++] = (byte)(192 + (n2 >> 6));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 & 0x3F));
        } else {
            this.m_outputBytes[this.count++] = (byte)(224 + (n2 >> 12));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 >> 6 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 & 0x3F));
        }
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        char c2;
        int n4 = 3 * n3;
        if (n4 >= 16384 - this.count) {
            this.flushBuffer();
            if (n4 >= 16384) {
                int n5 = 1 + n3 / 5461;
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = n2 + n3 * n6 / n5;
                    int n8 = n2 + n3 * (n6 + 1) / n5;
                    int n9 = n8 - n7;
                    this.write(cArray, n7, n9);
                    ++n6;
                }
                return;
            }
        }
        int n10 = n3 + n2;
        byte[] byArray = this.m_outputBytes;
        int n11 = this.count;
        int n12 = n2;
        while (n12 < n10 && (c2 = cArray[n12]) < '\u0080') {
            byArray[n11++] = (byte)c2;
            ++n12;
        }
        while (n12 < n10) {
            c2 = cArray[n12];
            if (c2 < '\u0080') {
                byArray[n11++] = (byte)c2;
            } else if (c2 < '\u0800') {
                byArray[n11++] = (byte)(192 + (c2 >> 6));
                byArray[n11++] = (byte)(128 + (c2 & 0x3F));
            } else {
                byArray[n11++] = (byte)(224 + (c2 >> 12));
                byArray[n11++] = (byte)(128 + (c2 >> 6 & 0x3F));
                byArray[n11++] = (byte)(128 + (c2 & 0x3F));
            }
            ++n12;
        }
        this.count = n11;
    }

    private void directWrite(char[] cArray, int n2, int n3) throws IOException {
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 >= 16384) {
                int n4 = 1 + n3 / 5461;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = n2 + n3 * n5 / n4;
                    int n7 = n2 + n3 * (n5 + 1) / n4;
                    int n8 = n7 - n6;
                    this.directWrite(cArray, n6, n8);
                    ++n5;
                }
                return;
            }
        }
        int n9 = n3 + n2;
        byte[] byArray = this.m_outputBytes;
        int n10 = this.count;
        int n11 = n2;
        while (n11 < n9) {
            byArray[n10++] = byArray[n11];
            ++n11;
        }
        this.count = n10;
    }

    public void write(String string) throws IOException {
        char c2;
        int n2 = string.length();
        int n3 = 3 * n2;
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 >= 16384) {
                boolean bl2 = false;
                int n4 = 1 + n2 / 5461;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = 0 + n2 * n5 / n4;
                    int n7 = 0 + n2 * (n5 + 1) / n4;
                    int n8 = n7 - n6;
                    string.getChars(n6, n7, this.m_inputChars, 0);
                    this.write(this.m_inputChars, 0, n8);
                    ++n5;
                }
                return;
            }
        }
        string.getChars(0, n2, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        int n9 = n2;
        byte[] byArray = this.m_outputBytes;
        int n10 = this.count;
        int n11 = 0;
        while (n11 < n9 && (c2 = cArray[n11]) < '\u0080') {
            byArray[n10++] = (byte)c2;
            ++n11;
        }
        while (n11 < n9) {
            c2 = cArray[n11];
            if (c2 < '\u0080') {
                byArray[n10++] = (byte)c2;
            } else if (c2 < '\u0800') {
                byArray[n10++] = (byte)(192 + (c2 >> 6));
                byArray[n10++] = (byte)(128 + (c2 & 0x3F));
            } else {
                byArray[n10++] = (byte)(224 + (c2 >> 12));
                byArray[n10++] = (byte)(128 + (c2 >> 6 & 0x3F));
                byArray[n10++] = (byte)(128 + (c2 & 0x3F));
            }
            ++n11;
        }
        this.count = n10;
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.m_outputBytes, 0, this.count);
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public void directWrite(String string) throws IOException {
        int n2 = string.length();
        if (n2 >= 16384 - this.count) {
            this.flushBuffer();
            if (n2 >= 16384) {
                boolean bl2 = false;
                int n3 = 1 + n2 / 5461;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = 0 + n2 * n4 / n3;
                    int n6 = 0 + n2 * (n4 + 1) / n3;
                    int n7 = n6 - n5;
                    string.getChars(n5, n6, this.m_inputChars, 0);
                    this.directWrite(this.m_inputChars, 0, n7);
                    ++n4;
                }
                return;
            }
        }
        string.getChars(0, n2, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        byte[] byArray = this.m_outputBytes;
        int n8 = this.count;
        int n9 = 0;
        while (n9 < n2) {
            byArray[n8++] = (byte)cArray[n9++];
        }
        this.count = n8;
    }
}

