/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.utils.WrappedRuntimeException;

public class OutputPropertiesFactory {
    public static final String S_BUILTIN_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xalan}";
    public static final String S_KEY_INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    public static final String S_KEY_CONTENT_HANDLER = "{http://xml.apache.org/xalan}content-handler";
    public static final String S_KEY_ENTITIES = "{http://xml.apache.org/xalan}entities";
    public static final String S_USE_URL_ESCAPING = "{http://xml.apache.org/xalan}use-url-escaping";
    public static final String S_OMIT_META_TAG = "{http://xml.apache.org/xalan}omit-meta-tag";
    public static final String S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xslt}";
    public static final int S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL_LEN = "{http://xml.apache.org/xslt}".length();
    private static final String S_XSLT_PREFIX = "xslt.output.";
    private static final int S_XSLT_PREFIX_LEN = "xslt.output.".length();
    private static final String S_XALAN_PREFIX = "org.apache.xslt.";
    private static final int S_XALAN_PREFIX_LEN = "org.apache.xslt.".length();
    private static Integer m_synch_object = new Integer(1);
    private static final String PROP_DIR = "org/apache/xml/serializer/";
    private static final String PROP_FILE_XML = "output_xml.properties";
    private static final String PROP_FILE_TEXT = "output_text.properties";
    private static final String PROP_FILE_HTML = "output_html.properties";
    private static final String PROP_FILE_UNKNOWN = "output_unknown.properties";
    private static Properties m_xml_properties = null;
    private static Properties m_html_properties = null;
    private static Properties m_text_properties = null;
    private static Properties m_unknown_properties = null;
    private static final Class ACCESS_CONTROLLER_CLASS = OutputPropertiesFactory.findAccessControllerClass();
    public static Class a;

    private static Class findAccessControllerClass() {
        try {
            return Class.forName("java.security.AccessController");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Properties getDefaultMethodProperties(String string) {
        String string2 = null;
        Properties properties = null;
        try {
            Integer n2 = m_synch_object;
            synchronized (n2) {
                if (null == m_xml_properties) {
                    string2 = PROP_FILE_XML;
                    m_xml_properties = OutputPropertiesFactory.loadPropertiesFile(string2, null);
                }
            }
            if (string.equals("xml")) {
                properties = m_xml_properties;
            } else if (string.equals("html")) {
                if (null == m_html_properties) {
                    string2 = PROP_FILE_HTML;
                    m_html_properties = OutputPropertiesFactory.loadPropertiesFile(string2, m_xml_properties);
                }
                properties = m_html_properties;
            } else if (string.equals("text")) {
                if (null == m_text_properties && null == (m_text_properties = OutputPropertiesFactory.loadPropertiesFile(string2 = PROP_FILE_TEXT, m_xml_properties)).getProperty("encoding")) {
                    String string3 = Encodings.getMimeEncoding(null);
                    ((Hashtable)m_text_properties).put("encoding", string3);
                }
                properties = m_text_properties;
            } else if (string.equals("")) {
                if (null == m_unknown_properties) {
                    string2 = PROP_FILE_UNKNOWN;
                    m_unknown_properties = OutputPropertiesFactory.loadPropertiesFile(string2, m_xml_properties);
                }
                properties = m_unknown_properties;
            } else {
                properties = m_xml_properties;
            }
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(XMLMessages.createXMLMessage("ER_COULD_NOT_LOAD_METHOD_PROPERTY", new Object[]{string2, string}), iOException);
        }
        return new Properties(properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadPropertiesFile(String string, Properties properties) throws IOException {
        String string2;
        InputStream inputStream;
        Properties properties2;
        block17: {
            properties2 = new Properties(properties);
            inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    inputStream = ACCESS_CONTROLLER_CLASS != null ? (InputStream)AccessController.doPrivileged(new PrivilegedAction(string){
                        public static Class a;
                        private final String val$resourceName;
                        {
                            this.val$resourceName = string;
                        }

                        public Object run() {
                            return (a == null ? (a = 1.a("org.apache.xml.serializer.OutputPropertiesFactory")) : a).getResourceAsStream(this.val$resourceName);
                        }

                        public static Class a(String string) {
                            try {
                                return Class.forName(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                    }) : (a == null ? (a = OutputPropertiesFactory.a("org.apache.xml.serializer.OutputPropertiesFactory")) : a).getResourceAsStream(string);
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    properties2.load(bufferedInputStream);
                }
                catch (IOException iOException) {
                    if (properties == null) {
                        throw iOException;
                    }
                    throw new WrappedRuntimeException(XMLMessages.createXMLMessage("ER_COULD_NOT_LOAD_RESOURCE", new Object[]{string}), iOException);
                }
                catch (SecurityException securityException) {
                    if (properties == null) {
                        throw securityException;
                    }
                    throw new WrappedRuntimeException(XMLMessages.createXMLMessage("ER_COULD_NOT_LOAD_RESOURCE", new Object[]{string}), securityException);
                }
                string2 = null;
                if (bufferedInputStream == null) break block17;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            bufferedInputStream.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        Enumeration enumeration = ((Hashtable)((Properties)((Hashtable)properties2).clone())).keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = null;
            try {
                string4 = System.getProperty(string3);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string4 == null) {
                string4 = (String)((Hashtable)properties2).get(string3);
            }
            string2 = OutputPropertiesFactory.fixupPropertyString(string3, true);
            String string5 = null;
            try {
                string5 = System.getProperty(string2);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            string5 = string5 == null ? OutputPropertiesFactory.fixupPropertyString(string4, false) : OutputPropertiesFactory.fixupPropertyString(string5, false);
            if (string3 == string2 && string4 == string5) continue;
            ((Hashtable)properties2).remove(string3);
            ((Hashtable)properties2).put(string2, string5);
        }
        return properties2;
    }

    private static String fixupPropertyString(String string, boolean bl2) {
        int n2;
        if (bl2 && string.startsWith(S_XSLT_PREFIX)) {
            string = string.substring(S_XSLT_PREFIX_LEN);
        }
        if (string.startsWith(S_XALAN_PREFIX)) {
            string = S_BUILTIN_EXTENSIONS_UNIVERSAL + string.substring(S_XALAN_PREFIX_LEN);
        }
        if ((n2 = string.indexOf("\\u003a")) > 0) {
            String string2 = string.substring(n2 + 6);
            string = string.substring(0, n2) + ":" + string2;
        }
        return string;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

