/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.ObjectFactory;
import org.apache.xml.serializer.SecuritySupport;
import org.apache.xml.utils.WrappedRuntimeException;

public class Encodings {
    private static final Method SUN_CHAR2BYTE_CONVERTER_METHOD = Encodings.findCharToByteConverterMethod();
    public static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final Hashtable _encodingTableKeyJava = new Hashtable();
    private static final Hashtable _encodingTableKeyMime = new Hashtable();
    private static final EncodingInfo[] _encodings = Encodings.loadEncodingInfo();

    private static Method findCharToByteConverterMethod() {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){
                public static Class a;

                public Object run() {
                    try {
                        Class<?> clazz = Class.forName("sun.io.CharToByteConverter");
                        Class[] classArray = new Class[]{a == null ? (a = 1.a("java.lang.String")) : a};
                        return clazz.getMethod("getConverter", classArray);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.toString());
                    }
                }

                public static Class a(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        }
        catch (Exception exception) {
            System.err.println("Warning: Could not get charToByteConverterClass!");
        }
        return null;
    }

    public static Writer getWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        int n2 = 0;
        while (n2 < _encodings.length) {
            if (Encodings._encodings[n2].c.equalsIgnoreCase(string)) {
                try {
                    return new OutputStreamWriter(outputStream, Encodings._encodings[n2].a);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        try {
            return new OutputStreamWriter(outputStream, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    public static Object getCharToByteConverter(String string) {
        if (SUN_CHAR2BYTE_CONVERTER_METHOD == null) {
            return null;
        }
        Object[] objectArray = new Object[1];
        int n2 = 0;
        while (n2 < _encodings.length) {
            if (Encodings._encodings[n2].c.equalsIgnoreCase(string)) {
                try {
                    objectArray[0] = Encodings._encodings[n2].a;
                    Object object = SUN_CHAR2BYTE_CONVERTER_METHOD.invoke(null, objectArray);
                    if (null != object) {
                        return object;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return null;
    }

    public static int getLastPrintable(String string) {
        String string2 = string.toUpperCase();
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string2);
        if (encodingInfo == null) {
            encodingInfo = (EncodingInfo)_encodingTableKeyMime.get(string2);
        }
        if (encodingInfo != null) {
            return encodingInfo.b;
        }
        return 127;
    }

    public static int getLastPrintable() {
        return 127;
    }

    public static String getMimeEncoding(String string) {
        block5: {
            if (null == string) {
                try {
                    string = System.getProperty("file.encoding", "UTF8");
                    if (null != string) {
                        String string2 = string.equalsIgnoreCase("Cp1252") || string.equalsIgnoreCase("ISO8859_1") || string.equalsIgnoreCase("8859_1") || string.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(string);
                        string = null != string2 ? string2 : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    string = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException securityException) {
                    string = DEFAULT_MIME_ENCODING;
                }
            } else {
                string = Encodings.convertJava2MimeEncoding(string);
            }
        }
        return string;
    }

    public static String convertJava2MimeEncoding(String string) {
        EncodingInfo encodingInfo = (EncodingInfo)_encodingTableKeyJava.get(string.toUpperCase());
        if (null != encodingInfo) {
            return encodingInfo.c;
        }
        return string;
    }

    public static String convertMime2JavaEncoding(String string) {
        int n2 = 0;
        while (n2 < _encodings.length) {
            if (Encodings._encodings[n2].c.equalsIgnoreCase(string)) {
                return Encodings._encodings[n2].a;
            }
            ++n2;
        }
        return string;
    }

    private static EncodingInfo[] loadEncodingInfo() {
        URL uRL = null;
        try {
            int n2;
            EncodingInfo[] encodingInfoArray;
            Object object;
            String string = null;
            InputStream inputStream = null;
            try {
                string = System.getProperty("org.apache.xalan.serialize.encodings", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string != null && string.length() > 0) {
                uRL = new URL(string);
                inputStream = uRL.openStream();
            }
            if (inputStream == null) {
                object = SecuritySupport.b();
                inputStream = ((SecuritySupport)object).a(ObjectFactory.a(), "org/apache/xml/serializer/Encodings.properties");
            }
            object = new Properties();
            if (inputStream != null) {
                ((Properties)object).load(inputStream);
                inputStream.close();
            }
            int n3 = ((Hashtable)object).size();
            int n4 = 0;
            Enumeration enumeration = ((Hashtable)object).keys();
            int n5 = 0;
            while (n5 < n3) {
                encodingInfoArray = (String)enumeration.nextElement();
                String string2 = ((Properties)object).getProperty((String)encodingInfoArray);
                ++n4;
                n2 = string2.indexOf(32);
                int n6 = 0;
                while (n6 < n2) {
                    if (string2.charAt(n6) == ',') {
                        ++n4;
                    }
                    ++n6;
                }
                ++n5;
            }
            encodingInfoArray = new EncodingInfo[n4];
            int n7 = 0;
            enumeration = ((Hashtable)object).keys();
            n2 = 0;
            while (n2 < n3) {
                int n8;
                String string3;
                String string4 = (String)enumeration.nextElement();
                String string5 = ((Properties)object).getProperty(string4);
                int n9 = string5.indexOf(32);
                if (n9 < 0) {
                    string3 = string5;
                    n8 = 255;
                } else {
                    n8 = Integer.decode(string5.substring(n9).trim());
                    StringTokenizer stringTokenizer = new StringTokenizer(string5.substring(0, n9), ",");
                    boolean bl2 = true;
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        encodingInfoArray[n7] = new EncodingInfo(string3, string4, n8);
                        _encodingTableKeyMime.put(string3.toUpperCase(), encodingInfoArray[n7]);
                        if (bl2) {
                            _encodingTableKeyJava.put(string4.toUpperCase(), encodingInfoArray[n7]);
                        }
                        ++n7;
                        bl2 = false;
                    }
                }
                ++n2;
            }
            return encodingInfoArray;
        }
        catch (MalformedURLException malformedURLException) {
            throw new WrappedRuntimeException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(iOException);
        }
    }
}

