/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xml.dtm.ref.ExtendedType;

public class ExpandedNameTable {
    private ExtendedType[] m_extendedTypes;
    private static int m_initialSize = 128;
    private int m_nextType;
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int TEXT = 3;
    public static final int CDATA_SECTION = 4;
    public static final int ENTITY_REFERENCE = 5;
    public static final int ENTITY = 6;
    public static final int PROCESSING_INSTRUCTION = 7;
    public static final int COMMENT = 8;
    public static final int DOCUMENT = 9;
    public static final int DOCUMENT_TYPE = 10;
    public static final int DOCUMENT_FRAGMENT = 11;
    public static final int NOTATION = 12;
    public static final int NAMESPACE = 13;
    public ExtendedType a = new ExtendedType(-1, "", "");
    private static ExtendedType[] m_defaultExtendedTypes;
    private static float m_loadFactor;
    private static int m_initialCapacity;
    private int m_capacity = m_initialCapacity;
    private int m_threshold = (int)((float)this.m_capacity * m_loadFactor);
    private HashEntry[] m_table = new HashEntry[this.m_capacity];

    public ExpandedNameTable() {
        this.initExtendedTypes();
    }

    private void initExtendedTypes() {
        this.m_extendedTypes = new ExtendedType[m_initialSize];
        int n2 = 0;
        while (n2 < 14) {
            this.m_extendedTypes[n2] = m_defaultExtendedTypes[n2];
            this.m_table[n2] = new HashEntry(m_defaultExtendedTypes[n2], n2, n2, null);
            ++n2;
        }
        this.m_nextType = 14;
    }

    public int getExpandedTypeID(String string, String string2, int n2) {
        return this.getExpandedTypeID(string, string2, n2, false);
    }

    public int getExpandedTypeID(String string, String string2, int n2, boolean bl2) {
        Object object;
        if (null == string) {
            string = "";
        }
        if (null == string2) {
            string2 = "";
        }
        int n3 = n2 + string.hashCode() + string2.hashCode();
        this.a.redefine(n2, string, string2, n3);
        int n4 = n3 % this.m_capacity;
        if (n4 < 0) {
            n4 = -n4;
        }
        HashEntry hashEntry = this.m_table[n4];
        while (hashEntry != null) {
            if (hashEntry.d == n3 && hashEntry.a.equals(this.a)) {
                return hashEntry.b;
            }
            hashEntry = hashEntry.c;
        }
        if (bl2) {
            return -1;
        }
        if (this.m_nextType > this.m_threshold) {
            this.rehash();
            n4 = n3 % this.m_capacity;
            if (n4 < 0) {
                n4 = -n4;
            }
        }
        ExtendedType extendedType = new ExtendedType(n2, string, string2, n3);
        if (this.m_extendedTypes.length == this.m_nextType) {
            object = new ExtendedType[this.m_extendedTypes.length * 2];
            System.arraycopy(this.m_extendedTypes, 0, object, 0, this.m_extendedTypes.length);
            this.m_extendedTypes = object;
        }
        this.m_extendedTypes[this.m_nextType] = extendedType;
        this.m_table[n4] = object = new HashEntry(extendedType, this.m_nextType, n3, this.m_table[n4]);
        return this.m_nextType++;
    }

    private void rehash() {
        int n2;
        int n3 = this.m_capacity;
        HashEntry[] hashEntryArray = this.m_table;
        this.m_capacity = n2 = 2 * n3 + 1;
        this.m_threshold = (int)((float)n2 * m_loadFactor);
        this.m_table = new HashEntry[n2];
        int n4 = n3 - 1;
        while (n4 >= 0) {
            HashEntry hashEntry = hashEntryArray[n4];
            while (hashEntry != null) {
                HashEntry hashEntry2 = hashEntry;
                hashEntry = hashEntry.c;
                int n5 = hashEntry2.d % n2;
                if (n5 < 0) {
                    n5 = -n5;
                }
                hashEntry2.c = this.m_table[n5];
                this.m_table[n5] = hashEntry2;
            }
            --n4;
        }
    }

    public int getExpandedTypeID(int n2) {
        return n2;
    }

    public String getLocalName(int n2) {
        return this.m_extendedTypes[n2].getLocalName();
    }

    public final int getLocalNameID(int n2) {
        if (this.m_extendedTypes[n2].getLocalName().equals("")) {
            return 0;
        }
        return n2;
    }

    public String getNamespace(int n2) {
        String string = this.m_extendedTypes[n2].getNamespace();
        return string.equals("") ? null : string;
    }

    public final int getNamespaceID(int n2) {
        if (this.m_extendedTypes[n2].getNamespace().equals("")) {
            return 0;
        }
        return n2;
    }

    public final short getType(int n2) {
        return (short)this.m_extendedTypes[n2].getNodeType();
    }

    public int getSize() {
        return this.m_nextType;
    }

    public ExtendedType[] getExtendedTypes() {
        return this.m_extendedTypes;
    }

    static {
        m_loadFactor = 0.75f;
        m_initialCapacity = 203;
        m_defaultExtendedTypes = new ExtendedType[14];
        int n2 = 0;
        while (n2 < 14) {
            ExpandedNameTable.m_defaultExtendedTypes[n2] = new ExtendedType(n2, "", "");
            ++n2;
        }
    }

    private static final class HashEntry {
        public ExtendedType a;
        public int b;
        public int d;
        public HashEntry c;

        public HashEntry(ExtendedType extendedType, int n2, int n3, HashEntry hashEntry) {
            this.a = extendedType;
            this.b = n2;
            this.d = n3;
            this.c = hashEntry;
        }
    }
}

