/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.lib.sql.ConnectionPool;
import org.apache.xalan.lib.sql.ConnectionPoolManager;
import org.apache.xalan.lib.sql.DefaultConnectionPool;
import org.apache.xalan.lib.sql.QueryParameter;
import org.apache.xalan.lib.sql.SQLDocument;
import org.apache.xalan.lib.sql.SQLErrorDocument;
import org.apache.xalan.lib.sql.SQLQueryParser;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.ref.DTMManagerDefault;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBooleanStatic;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XConnection {
    private static final boolean DEBUG = false;
    private ConnectionPool m_ConnectionPool = null;
    private Connection m_Connection = null;
    private boolean m_DefaultPoolingEnabled = false;
    private Vector m_OpenSQLDocuments = new Vector();
    private ConnectionPoolManager m_PoolMgr = new ConnectionPoolManager();
    private Vector m_ParameterList = new Vector();
    private Exception m_Error = null;
    private SQLDocument m_LastSQLDocumentWithError = null;
    private boolean m_FullErrors = false;
    private SQLQueryParser m_QueryParser = new SQLQueryParser();
    private boolean m_IsDefaultPool = false;
    private boolean m_IsStreamingEnabled = true;
    private boolean m_InlineVariables = false;
    private boolean m_IsMultipleResultsEnabled = false;
    private boolean m_IsStatementCachingEnabled = false;

    public XConnection() {
    }

    public XConnection(ExpressionContext expressionContext, String string) {
        this.connect(expressionContext, string);
    }

    public XConnection(ExpressionContext expressionContext, String string, String string2) {
        this.connect(expressionContext, string, string2);
    }

    public XConnection(ExpressionContext expressionContext, NodeList nodeList) {
        this.connect(expressionContext, nodeList);
    }

    public XConnection(ExpressionContext expressionContext, String string, String string2, String string3, String string4) {
        this.connect(expressionContext, string, string2, string3, string4);
    }

    public XConnection(ExpressionContext expressionContext, String string, String string2, Element element) {
        this.connect(expressionContext, string, string2, element);
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, String string) {
        try {
            this.m_ConnectionPool = this.m_PoolMgr.getPool(string);
            if (this.m_ConnectionPool == null) {
                throw new IllegalArgumentException("Invalid Pool Name");
            }
            this.m_IsDefaultPool = false;
            return new XBooleanStatic(true);
        }
        catch (Exception exception) {
            this.setError(exception, expressionContext);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, String string, String string2) {
        try {
            this.init(string, string2, new Properties());
            return new XBooleanStatic(true);
        }
        catch (SQLException sQLException) {
            this.setError(sQLException, expressionContext);
            return new XBooleanStatic(false);
        }
        catch (Exception exception) {
            this.setError(exception, expressionContext);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, Element element) {
        try {
            this.initFromElement(element);
            return new XBooleanStatic(true);
        }
        catch (SQLException sQLException) {
            this.setError(sQLException, expressionContext);
            return new XBooleanStatic(false);
        }
        catch (Exception exception) {
            this.setError(exception, expressionContext);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, NodeList nodeList) {
        try {
            this.initFromElement((Element)nodeList.item(0));
            return new XBooleanStatic(true);
        }
        catch (SQLException sQLException) {
            this.setError(sQLException, expressionContext);
            return new XBooleanStatic(false);
        }
        catch (Exception exception) {
            this.setError(exception, expressionContext);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, String string, String string2, String string3, String string4) {
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("user", string3);
            ((Hashtable)properties).put("password", string4);
            this.init(string, string2, properties);
            return new XBooleanStatic(true);
        }
        catch (SQLException sQLException) {
            this.setError(sQLException, expressionContext);
            return new XBooleanStatic(false);
        }
        catch (Exception exception) {
            this.setError(exception, expressionContext);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, String string, String string2, Element element) {
        try {
            Properties properties = new Properties();
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n2 = 0;
            while (n2 < namedNodeMap.getLength()) {
                ((Hashtable)properties).put(namedNodeMap.item(n2).getNodeName(), namedNodeMap.item(n2).getNodeValue());
                ++n2;
            }
            this.init(string, string2, properties);
            return new XBooleanStatic(true);
        }
        catch (SQLException sQLException) {
            this.setError(sQLException, expressionContext);
            return new XBooleanStatic(false);
        }
        catch (Exception exception) {
            this.setError(exception, expressionContext);
            return new XBooleanStatic(false);
        }
    }

    private void initFromElement(Element element) throws SQLException {
        Properties properties = new Properties();
        String string = "";
        String string2 = "";
        Node node = element.getFirstChild();
        if (null == node) {
            return;
        }
        do {
            Object object;
            Object object2;
            String string3;
            if ((string3 = node.getNodeName()).equalsIgnoreCase("dbdriver")) {
                string = "";
                object2 = node.getFirstChild();
                if (null != object2) {
                    string = object2.getNodeValue();
                }
            }
            if (string3.equalsIgnoreCase("dburl")) {
                string2 = "";
                object2 = node.getFirstChild();
                if (null != object2) {
                    string2 = object2.getNodeValue();
                }
            }
            if (string3.equalsIgnoreCase("password")) {
                object2 = "";
                object = node.getFirstChild();
                if (null != object) {
                    object2 = object.getNodeValue();
                }
                ((Hashtable)properties).put("password", object2);
            }
            if (string3.equalsIgnoreCase("user")) {
                object2 = "";
                object = node.getFirstChild();
                if (null != object) {
                    object2 = object.getNodeValue();
                }
                ((Hashtable)properties).put("user", object2);
            }
            if (!string3.equalsIgnoreCase("protocol")) continue;
            object2 = "";
            object = node.getAttributes();
            Node node2 = object.getNamedItem("name");
            if (null == node2) continue;
            String string4 = "";
            object2 = node2.getNodeValue();
            Node node3 = node.getFirstChild();
            if (null != node3) {
                string4 = node3.getNodeValue();
            }
            ((Hashtable)properties).put(object2, string4);
        } while ((node = node.getNextSibling()) != null);
        this.init(string, string2, properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(String string, String string2, Properties properties) throws SQLException {
        String string3;
        ConnectionPool connectionPool;
        String string4;
        Connection connection = null;
        String string5 = properties.getProperty("user");
        if (string5 == null) {
            string5 = "";
        }
        if ((string4 = properties.getProperty("password")) == null) {
            string4 = "";
        }
        if ((connectionPool = this.m_PoolMgr.getPool(string3 = string + string2 + string5 + string4)) == null) {
            DefaultConnectionPool defaultConnectionPool = new DefaultConnectionPool();
            defaultConnectionPool.setDriver(string);
            defaultConnectionPool.setURL(string2);
            defaultConnectionPool.setProtocol(properties);
            if (this.m_DefaultPoolingEnabled) {
                defaultConnectionPool.setPoolEnabled(true);
            }
            this.m_PoolMgr.registerPool(string3, defaultConnectionPool);
            this.m_ConnectionPool = defaultConnectionPool;
        } else {
            this.m_ConnectionPool = connectionPool;
        }
        this.m_IsDefaultPool = true;
        try {
            try {
                connection = this.m_ConnectionPool.getConnection();
            }
            catch (SQLException sQLException) {
                if (connection == null) throw sQLException;
                this.m_ConnectionPool.releaseConnectionOnError(connection);
                connection = null;
                throw sQLException;
            }
            Object var11_11 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (connection == null) throw throwable;
            this.m_ConnectionPool.releaseConnection(connection);
            throw throwable;
        }
        this.m_ConnectionPool.releaseConnection(connection);
    }

    public ConnectionPool getConnectionPool() {
        return this.m_ConnectionPool;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DTM query(ExpressionContext expressionContext, String string) {
        SQLDocument sQLDocument = null;
        try {
            try {
                if (null == this.m_ConnectionPool) {
                    return null;
                }
                SQLQueryParser sQLQueryParser = this.m_QueryParser.parse(this, string, 1);
                sQLDocument = SQLDocument.getNewDocument(expressionContext);
                sQLDocument.execute(this, sQLQueryParser);
                this.m_OpenSQLDocuments.addElement(sQLDocument);
                return sQLDocument;
            }
            catch (Exception exception) {
                if (sQLDocument != null) {
                    if (sQLDocument.hasErrors()) {
                        this.setError(exception, sQLDocument, sQLDocument.checkWarnings());
                    }
                    sQLDocument.close();
                    return null;
                }
                Object var7_8 = null;
                return sQLDocument;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            throw throwable;
        }
    }

    public DTM pquery(ExpressionContext expressionContext, String string) {
        return this.pquery(expressionContext, string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DTM pquery(ExpressionContext expressionContext, String string, String string2) {
        SQLDocument sQLDocument = null;
        try {
            try {
                if (null == this.m_ConnectionPool) {
                    return null;
                }
                SQLQueryParser sQLQueryParser = this.m_QueryParser.parse(this, string, 0);
                if (!this.m_InlineVariables) {
                    this.addTypeToData(string2);
                    sQLQueryParser.setParameters(this.m_ParameterList);
                }
                sQLDocument = SQLDocument.getNewDocument(expressionContext);
                sQLDocument.execute(this, sQLQueryParser);
                this.m_OpenSQLDocuments.addElement(sQLDocument);
                return sQLDocument;
            }
            catch (Exception exception) {
                if (sQLDocument != null) {
                    if (sQLDocument.hasErrors()) {
                        this.setError(exception, sQLDocument, sQLDocument.checkWarnings());
                    }
                    sQLDocument.close();
                    return null;
                }
                Object var8_9 = null;
                return sQLDocument;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            throw throwable;
        }
    }

    private void addTypeToData(String string) {
        if (string != null && this.m_ParameterList != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                QueryParameter queryParameter = (QueryParameter)this.m_ParameterList.elementAt(n2);
                if (null != queryParameter) {
                    queryParameter.setTypeName(string2);
                }
                ++n2;
            }
        }
    }

    public void addParameter(String string) {
        this.addParameterWithType(string, null);
    }

    public void addParameterWithType(String string, String string2) {
        this.m_ParameterList.addElement(new QueryParameter(string, string2));
    }

    public void addParameterFromElement(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem("type");
        Node node2 = element.getFirstChild();
        if (null != node2) {
            String string = node2.getNodeValue();
            if (string == null) {
                string = "";
            }
            this.m_ParameterList.addElement(new QueryParameter(string, node.getNodeValue()));
        }
    }

    public void addParameterFromElement(NodeList nodeList) {
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            this.addParameters((Element)nodeList.item(n3));
            ++n3;
        }
    }

    private void addParameters(Element element) {
        Node node = element.getFirstChild();
        if (null == node) {
            return;
        }
        do {
            if (node.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("type");
            String string = node2 == null ? "string" : node2.getNodeValue();
            Node node3 = node.getFirstChild();
            if (null == node3) continue;
            String string2 = node3.getNodeValue();
            if (string2 == null) {
                string2 = "";
            }
            this.m_ParameterList.addElement(new QueryParameter(string2, string));
        } while ((node = node.getNextSibling()) != null);
    }

    public void clearParameters() {
        this.m_ParameterList.removeAllElements();
    }

    public void enableDefaultConnectionPool() {
        this.m_DefaultPoolingEnabled = true;
        if (this.m_ConnectionPool == null) {
            return;
        }
        if (this.m_IsDefaultPool) {
            return;
        }
        this.m_ConnectionPool.setPoolEnabled(true);
    }

    public void disableDefaultConnectionPool() {
        this.m_DefaultPoolingEnabled = false;
        if (this.m_ConnectionPool == null) {
            return;
        }
        if (!this.m_IsDefaultPool) {
            return;
        }
        this.m_ConnectionPool.setPoolEnabled(false);
    }

    public void enableStreamingMode() {
        this.m_IsStreamingEnabled = true;
    }

    public void disableStreamingMode() {
        this.m_IsStreamingEnabled = false;
    }

    public DTM getError() {
        if (this.m_FullErrors) {
            int n2 = 0;
            while (n2 < this.m_OpenSQLDocuments.size()) {
                SQLDocument sQLDocument = (SQLDocument)this.m_OpenSQLDocuments.elementAt(n2);
                SQLWarning sQLWarning = sQLDocument.checkWarnings();
                if (sQLWarning != null) {
                    this.setError(null, sQLDocument, sQLWarning);
                }
                ++n2;
            }
        }
        return this.buildErrorDocument();
    }

    public void close() throws SQLException {
        while (this.m_OpenSQLDocuments.size() != 0) {
            SQLDocument sQLDocument = (SQLDocument)this.m_OpenSQLDocuments.elementAt(0);
            try {
                sQLDocument.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_OpenSQLDocuments.removeElementAt(0);
        }
        if (null != this.m_Connection) {
            this.m_ConnectionPool.releaseConnection(this.m_Connection);
            this.m_Connection = null;
        }
    }

    public void close(SQLDocument sQLDocument) throws SQLException {
        int n2 = this.m_OpenSQLDocuments.size();
        int n3 = 0;
        while (n3 < n2) {
            SQLDocument sQLDocument2 = (SQLDocument)this.m_OpenSQLDocuments.elementAt(n3);
            if (sQLDocument2 == sQLDocument) {
                sQLDocument2.close();
                this.m_OpenSQLDocuments.removeElementAt(n3);
            }
            ++n3;
        }
    }

    private SQLErrorDocument buildErrorDocument() {
        SQLErrorDocument sQLErrorDocument = null;
        if (this.m_LastSQLDocumentWithError != null) {
            ExpressionContext expressionContext = this.m_LastSQLDocumentWithError.getExpressionContext();
            SQLWarning sQLWarning = this.m_LastSQLDocumentWithError.checkWarnings();
            try {
                DTMManager dTMManager = ((XPathContext.XPathExpressionContext)expressionContext).getDTMManager();
                DTMManagerDefault dTMManagerDefault = (DTMManagerDefault)dTMManager;
                int n2 = dTMManagerDefault.getFirstFreeDTMID();
                sQLErrorDocument = new SQLErrorDocument(dTMManager, n2 << 16, this.m_Error, sQLWarning, this.m_FullErrors);
                dTMManagerDefault.addDTM(sQLErrorDocument, n2);
                this.m_Error = null;
                this.m_LastSQLDocumentWithError = null;
            }
            catch (Exception exception) {
                sQLErrorDocument = null;
            }
        }
        return sQLErrorDocument;
    }

    public void setError(Exception exception, ExpressionContext expressionContext) {
        try {
            ErrorListener errorListener = expressionContext.getErrorListener();
            if (errorListener != null && exception != null) {
                errorListener.warning(new TransformerException(exception.toString(), expressionContext.getXPathContext().getSAXLocator(), exception));
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public void setError(Exception exception, SQLDocument sQLDocument, SQLWarning sQLWarning) {
        ExpressionContext expressionContext = sQLDocument.getExpressionContext();
        this.m_LastSQLDocumentWithError = sQLDocument;
        try {
            ErrorListener errorListener = expressionContext.getErrorListener();
            if (errorListener != null && exception != null) {
                errorListener.warning(new TransformerException(exception.toString(), expressionContext.getXPathContext().getSAXLocator(), exception));
            }
            if (errorListener != null && sQLWarning != null) {
                errorListener.warning(new TransformerException(sQLWarning.toString(), expressionContext.getXPathContext().getSAXLocator(), sQLWarning));
            }
            if (exception != null) {
                this.m_Error = exception;
            }
            if (sQLWarning != null) {
                SQLWarning sQLWarning2 = new SQLWarning(sQLWarning.getMessage(), sQLWarning.getSQLState(), sQLWarning.getErrorCode());
                SQLWarning sQLWarning3 = sQLWarning.getNextWarning();
                while (sQLWarning3 != null) {
                    sQLWarning2.setNextWarning(new SQLWarning(sQLWarning3.getMessage(), sQLWarning3.getSQLState(), sQLWarning3.getErrorCode()));
                    sQLWarning3 = sQLWarning3.getNextWarning();
                }
                sQLWarning2.setNextWarning(new SQLWarning(sQLWarning.getMessage(), sQLWarning.getSQLState(), sQLWarning.getErrorCode()));
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public void setFeature(String string, String string2) {
        boolean bl2 = false;
        if ("true".equalsIgnoreCase(string2)) {
            bl2 = true;
        }
        if ("streaming".equalsIgnoreCase(string)) {
            this.m_IsStreamingEnabled = bl2;
        } else if ("inline-variables".equalsIgnoreCase(string)) {
            this.m_InlineVariables = bl2;
        } else if ("multiple-results".equalsIgnoreCase(string)) {
            this.m_IsMultipleResultsEnabled = bl2;
        } else if ("cache-statements".equalsIgnoreCase(string)) {
            this.m_IsStatementCachingEnabled = bl2;
        } else if ("default-pool-enabled".equalsIgnoreCase(string)) {
            this.m_DefaultPoolingEnabled = bl2;
            if (this.m_ConnectionPool == null) {
                return;
            }
            if (this.m_IsDefaultPool) {
                return;
            }
            this.m_ConnectionPool.setPoolEnabled(bl2);
        } else if ("full-errors".equalsIgnoreCase(string)) {
            this.m_FullErrors = bl2;
        }
    }

    public String getFeature(String string) {
        String string2 = null;
        if ("streaming".equalsIgnoreCase(string)) {
            string2 = this.m_IsStreamingEnabled ? "true" : "false";
        } else if ("inline-variables".equalsIgnoreCase(string)) {
            string2 = this.m_InlineVariables ? "true" : "false";
        } else if ("multiple-results".equalsIgnoreCase(string)) {
            string2 = this.m_IsMultipleResultsEnabled ? "true" : "false";
        } else if ("cache-statements".equalsIgnoreCase(string)) {
            string2 = this.m_IsStatementCachingEnabled ? "true" : "false";
        } else if ("default-pool-enabled".equalsIgnoreCase(string)) {
            string2 = this.m_DefaultPoolingEnabled ? "true" : "false";
        } else if ("full-errors".equalsIgnoreCase(string)) {
            string2 = this.m_FullErrors ? "true" : "false";
        }
        return string2;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

