/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.xalan.lib.sql.ConnectionPool;
import org.apache.xalan.lib.sql.ObjectFactory;
import org.apache.xalan.lib.sql.PooledConnection;
import org.apache.xalan.res.XSLMessages;

public class DefaultConnectionPool
implements ConnectionPool {
    private Driver m_Driver = null;
    private static final boolean DEBUG = false;
    private String m_driver = new String("");
    private String m_url = new String("");
    private int m_PoolMinSize = 1;
    private Properties m_ConnectionProtocol = new Properties();
    private Vector m_pool = new Vector();
    private boolean m_IsActive = false;

    public boolean isEnabled() {
        return this.m_IsActive;
    }

    public void setDriver(String string) {
        this.m_driver = string;
    }

    public void setURL(String string) {
        this.m_url = string;
    }

    public void freeUnused() {
        int n2 = 0;
        while (n2 < this.m_pool.size()) {
            PooledConnection pooledConnection = (PooledConnection)this.m_pool.elementAt(n2);
            if (!pooledConnection.inUse()) {
                pooledConnection.close();
            }
            ++n2;
        }
    }

    public boolean hasActiveConnections() {
        return this.m_pool.size() > 0;
    }

    public void setPassword(String string) {
        ((Hashtable)this.m_ConnectionProtocol).put("password", string);
    }

    public void setUser(String string) {
        ((Hashtable)this.m_ConnectionProtocol).put("user", string);
    }

    public void setProtocol(Properties properties) {
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ((Hashtable)this.m_ConnectionProtocol).put(string, properties.getProperty(string));
        }
    }

    public void setMinConnections(int n2) {
        this.m_PoolMinSize = n2;
    }

    public boolean testConnection() {
        try {
            Connection connection = this.getConnection();
            if (connection == null) {
                return false;
            }
            this.releaseConnection(connection);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized Connection getConnection() throws IllegalArgumentException, SQLException {
        PooledConnection pooledConnection = null;
        if (this.m_pool.size() < this.m_PoolMinSize) {
            this.initializePool();
        }
        int n2 = 0;
        while (n2 < this.m_pool.size()) {
            pooledConnection = (PooledConnection)this.m_pool.elementAt(n2);
            if (!pooledConnection.inUse()) {
                pooledConnection.setInUse(true);
                return pooledConnection.getConnection();
            }
            ++n2;
        }
        Connection connection = this.createConnection();
        pooledConnection = new PooledConnection(connection);
        pooledConnection.setInUse(true);
        this.m_pool.addElement(pooledConnection);
        return pooledConnection.getConnection();
    }

    public synchronized void releaseConnection(Connection connection) throws SQLException {
        int n2 = 0;
        while (n2 < this.m_pool.size()) {
            PooledConnection pooledConnection = (PooledConnection)this.m_pool.elementAt(n2);
            if (pooledConnection.getConnection() == connection) {
                if (!this.isEnabled()) {
                    connection.close();
                    this.m_pool.removeElementAt(n2);
                    break;
                }
                pooledConnection.setInUse(false);
                break;
            }
            ++n2;
        }
    }

    public synchronized void releaseConnectionOnError(Connection connection) throws SQLException {
        int n2 = 0;
        while (n2 < this.m_pool.size()) {
            PooledConnection pooledConnection = (PooledConnection)this.m_pool.elementAt(n2);
            if (pooledConnection.getConnection() == connection) {
                connection.close();
                this.m_pool.removeElementAt(n2);
                break;
            }
            ++n2;
        }
    }

    private Connection createConnection() throws SQLException {
        Connection connection = null;
        connection = this.m_Driver.connect(this.m_url, this.m_ConnectionProtocol);
        return connection;
    }

    public synchronized void initializePool() throws IllegalArgumentException, SQLException {
        if (this.m_driver == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_NO_DRIVER_NAME_SPECIFIED", null));
        }
        if (this.m_url == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_NO_URL_SPECIFIED", null));
        }
        if (this.m_PoolMinSize < 1) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_POOLSIZE_LESS_THAN_ONE", null));
        }
        try {
            this.m_Driver = (Driver)ObjectFactory.b(this.m_driver, ObjectFactory.a(), true);
            DriverManager.registerDriver(this.m_Driver);
        }
        catch (ObjectFactory.ConfigurationError configurationError) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_INVALID_DRIVER_NAME", null));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_INVALID_DRIVER_NAME", null));
        }
        if (!this.m_IsActive) {
            return;
        }
        do {
            Connection connection;
            if ((connection = this.createConnection()) == null) continue;
            PooledConnection pooledConnection = new PooledConnection(connection);
            this.addConnection(pooledConnection);
        } while (this.m_pool.size() < this.m_PoolMinSize);
    }

    private void addConnection(PooledConnection pooledConnection) {
        this.m_pool.addElement(pooledConnection);
    }

    public void finalize() throws Throwable {
        int n2 = 0;
        while (n2 < this.m_pool.size()) {
            PooledConnection pooledConnection = (PooledConnection)this.m_pool.elementAt(n2);
            if (!pooledConnection.inUse()) {
                pooledConnection.close();
            } else {
                try {
                    Thread.sleep(30000L);
                    pooledConnection.close();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        super.finalize();
    }

    public void setPoolEnabled(boolean bl2) {
        this.m_IsActive = bl2;
        if (!bl2) {
            this.freeUnused();
        }
    }
}

