/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class SimpleLog
implements Log {
    public static final String systemPrefix = "org.apache.commons.logging.simplelog.";
    public static final Properties simpleLogProps;
    public static boolean showLogName;
    public static boolean showShortName;
    public static boolean showDateTime;
    public static DateFormat dateFormatter;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    public String logName = null;
    public int currentLogLevel;
    private String prefix = null;
    public static Class a;
    public static Class b;

    public SimpleLog(String string) {
        this.logName = string;
        this.setLevel(3);
        String string2 = simpleLogProps.getProperty("org.apache.commons.logging.simplelog.log." + this.logName);
        int n2 = String.valueOf(string).lastIndexOf(".");
        while (null == string2 && n2 > -1) {
            string = string.substring(0, n2);
            string2 = simpleLogProps.getProperty("org.apache.commons.logging.simplelog.log." + string);
            n2 = String.valueOf(string).lastIndexOf(".");
        }
        if (null == string2) {
            string2 = simpleLogProps.getProperty("org.apache.commons.logging.simplelog.defaultlog");
        }
        if ("all".equalsIgnoreCase(string2)) {
            this.setLevel(0);
        } else if ("trace".equalsIgnoreCase(string2)) {
            this.setLevel(1);
        } else if ("debug".equalsIgnoreCase(string2)) {
            this.setLevel(2);
        } else if ("info".equalsIgnoreCase(string2)) {
            this.setLevel(3);
        } else if ("warn".equalsIgnoreCase(string2)) {
            this.setLevel(4);
        } else if ("error".equalsIgnoreCase(string2)) {
            this.setLevel(5);
        } else if ("fatal".equalsIgnoreCase(string2)) {
            this.setLevel(6);
        } else if ("off".equalsIgnoreCase(string2)) {
            this.setLevel(7);
        }
    }

    public void setLevel(int n2) {
        this.currentLogLevel = n2;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    public void log(int n2, Object object, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        if (showDateTime) {
            stringBuffer.append(dateFormatter.format(new Date()));
            stringBuffer.append(" ");
        }
        switch (n2) {
            case 1: {
                stringBuffer.append("[TRACE] ");
                break;
            }
            case 2: {
                stringBuffer.append("[DEBUG] ");
                break;
            }
            case 3: {
                stringBuffer.append("[INFO] ");
                break;
            }
            case 4: {
                stringBuffer.append("[WARN] ");
                break;
            }
            case 5: {
                stringBuffer.append("[ERROR] ");
                break;
            }
            case 6: {
                stringBuffer.append("[FATAL] ");
            }
        }
        if (showShortName) {
            if (this.prefix == null) {
                this.prefix = this.logName.substring(this.logName.lastIndexOf(".") + 1) + " - ";
                this.prefix = this.prefix.substring(this.prefix.lastIndexOf("/") + 1) + "-";
            }
            stringBuffer.append(this.prefix);
        } else if (showLogName) {
            stringBuffer.append(String.valueOf(this.logName)).append(" - ");
        }
        stringBuffer.append(String.valueOf(object));
        if (throwable != null) {
            stringBuffer.append(" <");
            stringBuffer.append(throwable.toString());
            stringBuffer.append(">");
            throwable.printStackTrace();
        }
        System.err.println(stringBuffer.toString());
    }

    public boolean isLevelEnabled(int n2) {
        return n2 >= this.currentLogLevel;
    }

    public final void debug(Object object) {
        if (this.isLevelEnabled(2)) {
            this.log(2, object, null);
        }
    }

    public final void debug(Object object, Throwable throwable) {
        if (this.isLevelEnabled(2)) {
            this.log(2, object, throwable);
        }
    }

    public final void trace(Object object) {
        if (this.isLevelEnabled(1)) {
            this.log(1, object, null);
        }
    }

    public final void trace(Object object, Throwable throwable) {
        if (this.isLevelEnabled(1)) {
            this.log(1, object, throwable);
        }
    }

    public final void info(Object object) {
        if (this.isLevelEnabled(3)) {
            this.log(3, object, null);
        }
    }

    public final void info(Object object, Throwable throwable) {
        if (this.isLevelEnabled(3)) {
            this.log(3, object, throwable);
        }
    }

    public final void warn(Object object) {
        if (this.isLevelEnabled(4)) {
            this.log(4, object, null);
        }
    }

    public final void warn(Object object, Throwable throwable) {
        if (this.isLevelEnabled(4)) {
            this.log(4, object, throwable);
        }
    }

    public final void error(Object object) {
        if (this.isLevelEnabled(5)) {
            this.log(5, object, null);
        }
    }

    public final void error(Object object, Throwable throwable) {
        if (this.isLevelEnabled(5)) {
            this.log(5, object, throwable);
        }
    }

    public final void fatal(Object object) {
        if (this.isLevelEnabled(6)) {
            this.log(6, object, null);
        }
    }

    public final void fatal(Object object, Throwable throwable) {
        if (this.isLevelEnabled(6)) {
            this.log(6, object, throwable);
        }
    }

    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        systemPrefix = systemPrefix;
        simpleLogProps = new Properties();
        showLogName = false;
        showShortName = true;
        showDateTime = false;
        dateFormatter = null;
        LOG_LEVEL_TRACE = 1;
        LOG_LEVEL_DEBUG = 2;
        LOG_LEVEL_INFO = 3;
        LOG_LEVEL_WARN = 4;
        LOG_LEVEL_ERROR = 5;
        LOG_LEVEL_FATAL = 6;
        LOG_LEVEL_ALL = 0;
        LOG_LEVEL_OFF = 7;
        try {
            String string;
            Object object;
            Object object2;
            Enumeration<?> enumeration = System.getProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                if (null == object2 || !((String)object2).startsWith(systemPrefix)) continue;
                simpleLogProps.setProperty((String)object2, System.getProperty((String)object2));
            }
            object2 = null;
            try {
                object = (a == null ? (a = SimpleLog.a("java.lang.Thread")) : a).getMethod("getContextClassLoader", null);
                object2 = (ClassLoader)((Method)object).invoke((Object)Thread.currentThread(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object2 == null) {
                object2 = (b == null ? (b = SimpleLog.a("org.apache.commons.logging.impl.SimpleLog")) : b).getClassLoader();
            }
            if (null != (object = ((ClassLoader)object2).getResourceAsStream("simplelog.properties"))) {
                try {
                    simpleLogProps.load((InputStream)object);
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((string = simpleLogProps.getProperty("org.apache.commons.logging.simplelog.showlogname")) != null) {
                showLogName = "true".equalsIgnoreCase(string);
            }
            if ((string = simpleLogProps.getProperty("org.apache.commons.logging.simplelog.showShortLogname")) != null) {
                showShortName = "true".equalsIgnoreCase(string);
            }
            if ((string = simpleLogProps.getProperty("org.apache.commons.logging.simplelog.showdatetime")) != null) {
                showDateTime = "true".equalsIgnoreCase(string);
            }
            if (showDateTime) {
                dateFormatter = new SimpleDateFormat(simpleLogProps.getProperty("org.apache.commons.logging.simplelog.dateformat", "yyyy/MM/dd HH:mm:ss:SSS zzz"));
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

