/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class LogFactoryImpl
extends LogFactory {
    public static final String LOG_DEFAULT = "org.apache.commons.logging.impl.SimpleLog";
    public static final String LOG_PROPERTY = "org.apache.commons.logging.Log";
    public static final String LOG_PROPERTY_OLD = "org.apache.commons.logging.log";
    public Hashtable attributes = new Hashtable();
    public Hashtable instances = new Hashtable();
    public Constructor logConstructor = null;
    public LogFactory proxyFactory = null;
    public Class[] logConstructorSignature = new Class[]{c == null ? (c = LogFactoryImpl.a("java.lang.String")) : c};
    public Method logMethod = null;
    public Class[] logMethodSignature = new Class[]{a == null ? (a = LogFactoryImpl.a("org.apache.commons.logging.LogFactory")) : a};
    public static Class c;
    public static Class a;
    public static Class d;

    public LogFactoryImpl() {
        this.guessConfig();
    }

    public Object getAttribute(String string) {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getAttribute(string);
        }
        return this.attributes.get(string);
    }

    public String[] getAttributeNames() {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getAttributeNames();
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getInstance(clazz);
        }
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String string) throws LogConfigurationException {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getInstance(string);
        }
        Log log = (Log)this.instances.get(string);
        if (log == null) {
            log = this.newInstance(string);
            this.instances.put(string, log);
        }
        return log;
    }

    public void release() {
        if (this.proxyFactory != null) {
            this.proxyFactory.release();
        }
        this.instances.clear();
    }

    public void removeAttribute(String string) {
        if (this.proxyFactory != null) {
            this.proxyFactory.removeAttribute(string);
        }
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (this.proxyFactory != null) {
            this.proxyFactory.setAttribute(string, object);
        }
        if (object == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
    }

    public Constructor getLogConstructor() throws LogConfigurationException {
        if (this.logConstructor != null) {
            return this.logConstructor;
        }
        String string = null;
        if (string == null) {
            string = (String)this.getAttribute(LOG_PROPERTY);
        }
        if (string == null) {
            string = (String)this.getAttribute(LOG_PROPERTY_OLD);
        }
        if (string == null) {
            try {
                string = System.getProperty(LOG_PROPERTY);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (string == null) {
            try {
                string = System.getProperty(LOG_PROPERTY_OLD);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (string == null && this.isLog4JAvailable()) {
            string = "org.apache.commons.logging.impl.Log4JCategoryLog";
        }
        if (string == null && this.isJdk14Available()) {
            string = "org.apache.commons.logging.impl.Jdk14Logger";
        }
        if (string == null) {
            string = LOG_DEFAULT;
        }
        Class clazz = null;
        try {
            clazz = LogFactoryImpl.loadClass(string);
            if (clazz == null) {
                throw new LogConfigurationException("No suitable Log implementation for " + string);
            }
            if (!(d == null ? (d = LogFactoryImpl.a(LOG_PROPERTY)) : d).isAssignableFrom(clazz)) {
                throw new LogConfigurationException("Class " + string + " does not implement Log");
            }
        }
        catch (Throwable throwable) {
            throw new LogConfigurationException(throwable);
        }
        try {
            this.logMethod = clazz.getMethod("setLogFactory", this.logMethodSignature);
        }
        catch (Throwable throwable) {
            this.logMethod = null;
        }
        try {
            this.logConstructor = clazz.getConstructor(this.logConstructorSignature);
            return this.logConstructor;
        }
        catch (Throwable throwable) {
            throw new LogConfigurationException("No suitable Log constructor " + this.logConstructorSignature + " for " + string, throwable);
        }
    }

    private static Class loadClass(String string) throws ClassNotFoundException {
        Object t2 = AccessController.doPrivileged(new PrivilegedAction(string){
            private final String val$name;
            {
                this.val$name = string;
            }

            public Object run() {
                ClassLoader classLoader = LogFactoryImpl.a();
                if (classLoader != null) {
                    try {
                        return classLoader.loadClass(this.val$name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                try {
                    return Class.forName(this.val$name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return classNotFoundException;
                }
            }
        });
        if (t2 instanceof Class) {
            return (Class)t2;
        }
        throw (ClassNotFoundException)t2;
    }

    public void guessConfig() {
        if (this.isLog4JAvailable()) {
            this.proxyFactory = null;
            try {
                Class clazz = LogFactoryImpl.loadClass("org.apache.commons.logging.impl.Log4jFactory");
                if (clazz != null) {
                    this.proxyFactory = (LogFactory)clazz.newInstance();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isJdk14Available() {
        try {
            LogFactoryImpl.loadClass("java.util.logging.Logger");
            LogFactoryImpl.loadClass("org.apache.commons.logging.impl.Jdk14Logger");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isLog4JAvailable() {
        try {
            LogFactoryImpl.loadClass("org.apache.log4j.Category");
            LogFactoryImpl.loadClass("org.apache.commons.logging.impl.Log4JCategoryLog");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public Log newInstance(String string) throws LogConfigurationException {
        Log log = null;
        try {
            Object[] objectArray = new Object[]{string};
            log = (Log)this.getLogConstructor().newInstance(objectArray);
            if (this.logMethod != null) {
                objectArray[0] = this;
                this.logMethod.invoke((Object)log, objectArray);
            }
            return log;
        }
        catch (Throwable throwable) {
            throw new LogConfigurationException(throwable);
        }
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static ClassLoader a() throws LogConfigurationException {
        return LogFactory.getContextClassLoader();
    }

    static {
        LOG_DEFAULT = LOG_DEFAULT;
        LOG_PROPERTY = LOG_PROPERTY;
        LOG_PROPERTY_OLD = LOG_PROPERTY_OLD;
    }
}

