/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CollatingIterator
implements Iterator {
    private Comparator comparator = null;
    private ArrayList iterators = null;
    private ArrayList values = null;
    private BitSet valueSet = null;
    private int lastReturned = -1;

    public CollatingIterator() {
        this(null, 2);
    }

    public CollatingIterator(Comparator comparator) {
        this(comparator, 2);
    }

    public CollatingIterator(Comparator comparator, int n2) {
        this.iterators = new ArrayList(n2);
        this.setComparator(comparator);
    }

    public CollatingIterator(Comparator comparator, Collection collection) {
        this(comparator, collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = (Iterator)iterator.next();
            this.addIterator(iterator2);
        }
    }

    public CollatingIterator(Comparator comparator, Iterator iterator, Iterator iterator2) {
        this(comparator, 2);
        this.addIterator(iterator);
        this.addIterator(iterator2);
    }

    public CollatingIterator(Comparator comparator, Iterator[] iteratorArray) {
        this(comparator, iteratorArray.length);
        int n2 = 0;
        while (n2 < iteratorArray.length) {
            this.addIterator(iteratorArray[n2]);
            ++n2;
        }
    }

    public void addIterator(Iterator iterator) {
        this.checkNotStarted();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iterators.add(iterator);
    }

    private boolean anyHasNext(ArrayList arrayList) {
        int n2 = 0;
        while (n2 < arrayList.size()) {
            Iterator iterator = (Iterator)arrayList.get(n2);
            if (iterator.hasNext()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean anyValueSet(BitSet bitSet) {
        int n2 = 0;
        while (n2 < bitSet.size()) {
            if (bitSet.get(n2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void checkNotStarted() throws IllegalStateException {
        if (this.values != null) {
            throw new IllegalStateException("Can't do that after next or hasNext has been called.");
        }
    }

    private void clear(int n2) {
        this.values.set(n2, null);
        this.valueSet.clear(n2);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public List getIterators() {
        return Collections.unmodifiableList(this.iterators);
    }

    public boolean hasNext() {
        this.start();
        return this.anyValueSet(this.valueSet) || this.anyHasNext(this.iterators);
    }

    private int least() throws IllegalStateException {
        int n2 = -1;
        Object t2 = null;
        int n3 = 0;
        while (n3 < this.values.size()) {
            if (!this.valueSet.get(n3)) {
                this.set(n3);
            }
            if (this.valueSet.get(n3)) {
                if (n2 == -1) {
                    n2 = n3;
                    t2 = this.values.get(n3);
                } else {
                    Object e2 = this.values.get(n3);
                    if (this.comparator.compare(e2, t2) < 0) {
                        t2 = e2;
                        n2 = n3;
                    }
                }
            }
            ++n3;
        }
        return n2;
    }

    public Object next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int n2 = this.least();
        if (n2 == -1) {
            throw new NoSuchElementException();
        }
        Object e2 = this.values.get(n2);
        this.clear(n2);
        this.lastReturned = n2;
        return e2;
    }

    public void remove() {
        if (this.lastReturned == -1) {
            throw new NoSuchElementException("No value has been returned yet.");
        }
        Iterator iterator = (Iterator)this.iterators.get(this.lastReturned);
        iterator.remove();
    }

    private boolean set(int n2) {
        Iterator iterator = (Iterator)this.iterators.get(n2);
        if (iterator.hasNext()) {
            this.values.set(n2, iterator.next());
            this.valueSet.set(n2);
            return true;
        }
        this.values.set(n2, null);
        this.valueSet.clear(n2);
        return false;
    }

    public void setComparator(Comparator comparator) {
        this.checkNotStarted();
        this.comparator = comparator;
    }

    public void setIterator(int n2, Iterator iterator) throws IndexOutOfBoundsException {
        this.checkNotStarted();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iterators.set(n2, iterator);
    }

    private void start() {
        if (this.values == null) {
            this.values = new ArrayList(this.iterators.size());
            this.valueSet = new BitSet(this.iterators.size());
            int n2 = 0;
            while (n2 < this.iterators.size()) {
                this.values.add(null);
                this.valueSet.clear(n2);
                ++n2;
            }
        }
    }
}

