/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;

public final class UnboundedFifoBuffer
extends AbstractCollection
implements Buffer {
    public Object[] m_buffer;
    public int m_head;
    public int m_tail;

    public UnboundedFifoBuffer() {
        this(32);
    }

    public UnboundedFifoBuffer(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.m_buffer = new Object[n2 + 1];
        this.m_head = 0;
        this.m_tail = 0;
    }

    public static int b(UnboundedFifoBuffer unboundedFifoBuffer, int n2) {
        return unboundedFifoBuffer.increment(n2);
    }

    public static int a(UnboundedFifoBuffer unboundedFifoBuffer, int n2) {
        return unboundedFifoBuffer.decrement(n2);
    }

    public boolean add(Object object) {
        if (object == null) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.size() + 1 >= this.m_buffer.length) {
            Object[] objectArray = new Object[(this.m_buffer.length - 1) * 2 + 1];
            int n2 = 0;
            int n3 = this.m_head;
            while (n3 != this.m_tail) {
                objectArray[n2] = this.m_buffer[n3];
                this.m_buffer[n3] = null;
                ++n2;
                if (++n3 != this.m_buffer.length) continue;
                n3 = 0;
            }
            this.m_buffer = objectArray;
            this.m_head = 0;
            this.m_tail = n2;
        }
        this.m_buffer[this.m_tail] = object;
        ++this.m_tail;
        if (this.m_tail >= this.m_buffer.length) {
            this.m_tail = 0;
        }
        return true;
    }

    private int decrement(int n2) {
        if (--n2 < 0) {
            n2 = this.m_buffer.length - 1;
        }
        return n2;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        return this.m_buffer[this.m_head];
    }

    private int increment(int n2) {
        if (++n2 >= this.m_buffer.length) {
            n2 = 0;
        }
        return n2;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new Iterator(this){
            private final UnboundedFifoBuffer this$0;
            private int index;
            private int lastReturnedIndex;
            {
                this.this$0 = unboundedFifoBuffer;
                this.index = unboundedFifoBuffer.m_head;
                this.lastReturnedIndex = -1;
            }

            public boolean hasNext() {
                return this.index != this.this$0.m_tail;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index;
                this.index = UnboundedFifoBuffer.b(this.this$0, this.index);
                return this.this$0.m_buffer[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == this.this$0.m_head) {
                    this.this$0.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int n2 = this.lastReturnedIndex + 1;
                while (n2 != this.this$0.m_tail) {
                    if (n2 >= this.this$0.m_buffer.length) {
                        this.this$0.m_buffer[n2 - 1] = this.this$0.m_buffer[0];
                        n2 = 0;
                        continue;
                    }
                    this.this$0.m_buffer[n2 - 1] = this.this$0.m_buffer[n2];
                    ++n2;
                }
                this.lastReturnedIndex = -1;
                this.this$0.m_tail = UnboundedFifoBuffer.a(this.this$0, this.this$0.m_tail);
                this.this$0.m_buffer[this.this$0.m_tail] = null;
                this.index = UnboundedFifoBuffer.a(this.this$0, this.index);
            }
        };
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object object = this.m_buffer[this.m_head];
        if (object != null) {
            this.m_buffer[this.m_head] = null;
            ++this.m_head;
            if (this.m_head >= this.m_buffer.length) {
                this.m_head = 0;
            }
        }
        return object;
    }

    public int size() {
        int n2 = 0;
        n2 = this.m_tail < this.m_head ? this.m_buffer.length - this.m_head + this.m_tail : this.m_tail - this.m_head;
        return n2;
    }
}

