/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.ProxyMap;

public class MapUtils {
    private static int debugIndent = 0;

    public static synchronized void debugPrint(PrintStream printStream, Object object, Map map) {
        MapUtils.debugPrintIndent(printStream);
        printStream.println(String.valueOf(String.valueOf(object)) + " = ");
        MapUtils.debugPrintIndent(printStream);
        printStream.println("{");
        ++debugIndent;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v2 = entry.getValue();
            if (v2 instanceof Map) {
                MapUtils.verbosePrint(printStream, string, (Map)v2);
                continue;
            }
            MapUtils.debugPrintIndent(printStream);
            String string2 = v2 != null ? v2.getClass().getName() : null;
            printStream.println(String.valueOf(string) + " = " + v2 + " class: " + string2);
        }
        --debugIndent;
        MapUtils.debugPrintIndent(printStream);
        printStream.println("}");
    }

    public static void debugPrintIndent(PrintStream printStream) {
        int n2 = 0;
        while (n2 < debugIndent) {
            printStream.print("    ");
            ++n2;
        }
    }

    public static Map fixedSizeMap(Map map) {
        return new FixedSizeMap(map);
    }

    public static SortedMap fixedSizeSortedMap(SortedMap sortedMap) {
        return new FixedSizeSortedMap(sortedMap);
    }

    public static Boolean getBoolean(Map map, Object object) {
        Object v2;
        if (map != null && (v2 = map.get(object)) != null) {
            if (v2 instanceof Boolean) {
                return (Boolean)v2;
            }
            if (v2 instanceof String) {
                return new Boolean((String)v2);
            }
            if (v2 instanceof Number) {
                Number number = (Number)v2;
                return number.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public static Boolean getBoolean(Map map, Object object, Boolean bl2) {
        Boolean bl3 = MapUtils.getBoolean(map, object);
        if (bl3 == null) {
            bl3 = bl2;
        }
        return bl3;
    }

    public static Byte getByte(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Byte) {
            return (Byte)number;
        }
        return new Byte(number.byteValue());
    }

    public static Byte getByte(Map map, Object object, Byte by2) {
        Byte by3 = MapUtils.getByte(map, object);
        if (by3 == null) {
            by3 = by2;
        }
        return by3;
    }

    public static Double getDouble(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return new Double(number.doubleValue());
    }

    public static Double getDouble(Map map, Object object, Double d2) {
        Double d3 = MapUtils.getDouble(map, object);
        if (d3 == null) {
            d3 = d2;
        }
        return d3;
    }

    public static Float getFloat(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Float) {
            return (Float)number;
        }
        return new Float(number.floatValue());
    }

    public static Float getFloat(Map map, Object object, Float f2) {
        Float f3 = MapUtils.getFloat(map, object);
        if (f3 == null) {
            f3 = f2;
        }
        return f3;
    }

    public static Integer getInteger(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return new Integer(number.intValue());
    }

    public static Integer getInteger(Map map, Object object, Integer n2) {
        Integer n3 = MapUtils.getInteger(map, object);
        if (n3 == null) {
            n3 = n2;
        }
        return n3;
    }

    public static Long getLong(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return new Long(number.longValue());
    }

    public static Long getLong(Map map, Object object, Long l2) {
        Long l3 = MapUtils.getLong(map, object);
        if (l3 == null) {
            l3 = l2;
        }
        return l3;
    }

    public static Map getMap(Map map, Object object) {
        Object v2;
        if (map != null && (v2 = map.get(object)) != null && v2 instanceof Map) {
            return (Map)v2;
        }
        return null;
    }

    public static Map getMap(Map map, Object object, Map map2) {
        Map map3 = MapUtils.getMap(map, object);
        if (map3 == null) {
            map3 = map2;
        }
        return map3;
    }

    public static Number getNumber(Map map, Object object) {
        Object v2;
        if (map != null && (v2 = map.get(object)) != null) {
            if (v2 instanceof Number) {
                return (Number)v2;
            }
            if (v2 instanceof String) {
                try {
                    String string = (String)v2;
                    return NumberFormat.getInstance().parse(string);
                }
                catch (ParseException parseException) {
                    MapUtils.logInfo(parseException);
                }
            }
        }
        return null;
    }

    public static Number getNumber(Map map, Object object, Number number) {
        Number number2 = MapUtils.getNumber(map, object);
        if (number2 == null) {
            number2 = number;
        }
        return number2;
    }

    public static Object getObject(Map map, Object object) {
        if (map != null) {
            return map.get(object);
        }
        return null;
    }

    public static Object getObject(Map map, Object object, Object object2) {
        Object v2;
        if (map != null && (v2 = map.get(object)) != null) {
            return v2;
        }
        return object2;
    }

    public static Short getShort(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Short) {
            return (Short)number;
        }
        return new Short(number.shortValue());
    }

    public static Short getShort(Map map, Object object, Short s2) {
        Short s3 = MapUtils.getShort(map, object);
        if (s3 == null) {
            s3 = s2;
        }
        return s3;
    }

    public static String getString(Map map, Object object) {
        Object v2;
        if (map != null && (v2 = map.get(object)) != null) {
            return v2.toString();
        }
        return null;
    }

    public static String getString(Map map, Object object, String string) {
        String string2 = MapUtils.getString(map, object);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static Map lazyMap(Map map, Factory factory) {
        return new LazyMap(map, factory);
    }

    public static SortedMap lazySortedMap(SortedMap sortedMap, Factory factory) {
        return new LazySortedMap(sortedMap, factory);
    }

    public static void logInfo(Exception exception) {
        System.out.println("INFO: Exception: " + exception);
    }

    public static Map predicatedMap(Map map, Predicate predicate, Predicate predicate2) {
        return new PredicatedMap(map, predicate, predicate2);
    }

    public static SortedMap predicatedSortedMap(SortedMap sortedMap, Predicate predicate, Predicate predicate2) {
        return new PredicatedSortedMap(sortedMap, predicate, predicate2);
    }

    public static final void safeAddToMap(Map map, Object object, Object object2) throws NullPointerException {
        if (object2 == null) {
            map.put(object, "");
        } else {
            map.put(object, object2);
        }
    }

    public static Properties toProperties(Map map) {
        Properties properties = new Properties();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                ((Hashtable)properties).put(k2, v2);
            }
        }
        return properties;
    }

    public static synchronized void verbosePrint(PrintStream printStream, Object object, Map map) {
        MapUtils.debugPrintIndent(printStream);
        printStream.println(String.valueOf(String.valueOf(object)) + " = ");
        MapUtils.debugPrintIndent(printStream);
        printStream.println("{");
        ++debugIndent;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v2 = entry.getValue();
            if (v2 instanceof Map) {
                MapUtils.verbosePrint(printStream, string, (Map)v2);
                continue;
            }
            MapUtils.debugPrintIndent(printStream);
            printStream.println(String.valueOf(string) + " = " + v2);
        }
        --debugIndent;
        MapUtils.debugPrintIndent(printStream);
        printStream.println("}");
    }

    public static class PredicatedMap
    extends ProxyMap {
        public final Predicate keyPredicate;
        public final Predicate valuePredicate;

        public PredicatedMap(Map map, Predicate predicate, Predicate predicate2) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map must not be null");
            }
            if (predicate == null) {
                throw new IllegalArgumentException("Key Predicate must not be null");
            }
            if (predicate2 == null) {
                throw new IllegalArgumentException("Value Predicate must not be null");
            }
            this.keyPredicate = predicate;
            this.valuePredicate = predicate2;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                this.validate(k2, v2);
            }
        }

        public Set entrySet() {
            return new PredicatedMapEntrySet(this.map.entrySet(), this.valuePredicate);
        }

        public Object put(Object object, Object object2) {
            this.validate(object, object2);
            return this.map.put(object, object2);
        }

        public void putAll(Map map) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                this.validate(k2, v2);
            }
            this.map.putAll(map);
        }

        private void validate(Object object, Object object2) {
            if (!this.keyPredicate.evaluate(object)) {
                throw new IllegalArgumentException("Cannot add key - Predicate rejected it");
            }
            if (!this.valuePredicate.evaluate(object2)) {
                throw new IllegalArgumentException("Cannot add value - Predicate rejected it");
            }
        }
    }

    public static class PredicatedMapEntrySet
    extends CollectionUtils.CollectionWrapper
    implements Set {
        private final Predicate predicate;

        public PredicatedMapEntrySet(Set set, Predicate predicate) {
            super(set);
            this.predicate = predicate;
        }

        public static Predicate a(PredicatedMapEntrySet predicatedMapEntrySet) {
            return predicatedMapEntrySet.predicate;
        }

        public Iterator iterator() {
            Iterator iterator = this.collection.iterator();
            return new Iterator(iterator, this){
                private final PredicatedMapEntrySet this$0;
                private final Iterator val$iterator;
                {
                    this.val$iterator = iterator;
                    this.this$0 = predicatedMapEntrySet;
                }

                public boolean hasNext() {
                    return this.val$iterator.hasNext();
                }

                public Object next() {
                    Map.Entry entry = (Map.Entry)this.val$iterator.next();
                    return new PredicatedMapEntry(entry, PredicatedMapEntrySet.a(this.this$0));
                }

                public void remove() {
                    this.val$iterator.remove();
                }
            };
        }
    }

    public static class PredicatedMapEntry
    implements Map.Entry {
        private final Map.Entry entry;
        private final Predicate predicate;

        public PredicatedMapEntry(Map.Entry entry, Predicate predicate) {
            if (entry == null) {
                throw new IllegalArgumentException("Map.Entry must not be null");
            }
            if (predicate == null) {
                throw new IllegalArgumentException("Predicate must not be null");
            }
            this.entry = entry;
            this.predicate = predicate;
        }

        public boolean equals(Object object) {
            return this.entry.equals(object);
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public int hashCode() {
            return this.entry.hashCode();
        }

        public Object setValue(Object object) {
            if (!this.predicate.evaluate(object)) {
                throw new IllegalArgumentException("Cannot set value - Predicate rejected it");
            }
            return this.entry.setValue(object);
        }

        public String toString() {
            return this.entry.toString();
        }
    }

    public static class FixedSizeMap
    extends ProxyMap {
        public FixedSizeMap(Map map) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map must not be null");
            }
        }

        public Object put(Object object, Object object2) {
            if (!this.map.containsKey(object)) {
                throw new IllegalArgumentException("Cannot put new key/value pair - List is fixed size");
            }
            return this.map.put(object, object2);
        }

        public void putAll(Map map) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                if (this.map.containsKey(iterator.next())) continue;
                throw new IllegalArgumentException("Cannot put new key/value pair - List is fixed size");
            }
            this.map.putAll(map);
        }
    }

    public static class LazyMap
    extends ProxyMap {
        public final Factory factory;

        public LazyMap(Map map, Factory factory) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map must not be null");
            }
            if (factory == null) {
                throw new IllegalArgumentException("Factory must not be null");
            }
            this.factory = factory;
        }

        public Object get(Object object) {
            if (!this.map.containsKey(object)) {
                Object object2 = this.factory.create();
                this.map.put(object, object2);
                return object2;
            }
            return this.map.get(object);
        }
    }

    public static class PredicatedSortedMap
    extends PredicatedMap
    implements SortedMap {
        public PredicatedSortedMap(SortedMap sortedMap, Predicate predicate, Predicate predicate2) {
            super(sortedMap, predicate, predicate2);
        }

        public Comparator comparator() {
            return this.getSortedMap().comparator();
        }

        public Object firstKey() {
            return this.getSortedMap().firstKey();
        }

        private SortedMap getSortedMap() {
            return (SortedMap)this.map;
        }

        public SortedMap headMap(Object object) {
            SortedMap sortedMap = this.getSortedMap().headMap(object);
            return new PredicatedSortedMap(sortedMap, this.keyPredicate, this.valuePredicate);
        }

        public Object lastKey() {
            return this.getSortedMap().lastKey();
        }

        public SortedMap subMap(Object object, Object object2) {
            SortedMap sortedMap = this.getSortedMap().subMap(object, object2);
            return new PredicatedSortedMap(sortedMap, this.keyPredicate, this.valuePredicate);
        }

        public SortedMap tailMap(Object object) {
            SortedMap sortedMap = this.getSortedMap().tailMap(object);
            return new PredicatedSortedMap(sortedMap, this.keyPredicate, this.valuePredicate);
        }
    }

    public static class FixedSizeSortedMap
    extends FixedSizeMap
    implements SortedMap {
        public FixedSizeSortedMap(SortedMap sortedMap) {
            super(sortedMap);
        }

        public Comparator comparator() {
            return this.getSortedMap().comparator();
        }

        public Object firstKey() {
            return this.getSortedMap().firstKey();
        }

        private SortedMap getSortedMap() {
            return (SortedMap)this.map;
        }

        public SortedMap headMap(Object object) {
            return new FixedSizeSortedMap(this.getSortedMap().headMap(object));
        }

        public Object lastKey() {
            return this.getSortedMap().lastKey();
        }

        public SortedMap subMap(Object object, Object object2) {
            return new FixedSizeSortedMap(this.getSortedMap().subMap(object, object2));
        }

        public SortedMap tailMap(Object object) {
            return new FixedSizeSortedMap(this.getSortedMap().tailMap(object));
        }
    }

    public static class LazySortedMap
    extends LazyMap
    implements SortedMap {
        public LazySortedMap(SortedMap sortedMap, Factory factory) {
            super(sortedMap, factory);
        }

        public Comparator comparator() {
            return this.getSortedMap().comparator();
        }

        public Object firstKey() {
            return this.getSortedMap().firstKey();
        }

        private SortedMap getSortedMap() {
            return (SortedMap)this.map;
        }

        public SortedMap headMap(Object object) {
            return new LazySortedMap(this.getSortedMap().headMap(object), this.factory);
        }

        public Object lastKey() {
            return this.getSortedMap().lastKey();
        }

        public SortedMap subMap(Object object, Object object2) {
            return new LazySortedMap(this.getSortedMap().subMap(object, object2), this.factory);
        }

        public SortedMap tailMap(Object object) {
            return new LazySortedMap(this.getSortedMap().tailMap(object), this.factory);
        }
    }
}

