/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.Predicate;

public class ListUtils {
    public static List fixedSizeList(List list) {
        return new FixedSizeList(list);
    }

    public static List intersection(List list, List list2) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!list.contains(e2)) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    public static List lazyList(List list, Factory factory) {
        return new LazyList(list, factory);
    }

    public static List predicatedList(List list, Predicate predicate) {
        return new PredicatedList(list, predicate);
    }

    public static List subtract(List list, List list2) {
        ArrayList arrayList = new ArrayList(list);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((AbstractCollection)arrayList).remove(iterator.next());
        }
        return arrayList;
    }

    public static List sum(List list, List list2) {
        return ListUtils.subtract(ListUtils.union(list, list2), ListUtils.intersection(list, list2));
    }

    public static List union(List list, List list2) {
        ArrayList arrayList = new ArrayList(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    public static class ListIteratorWrapper
    implements ListIterator {
        public final ListIterator iterator;

        public ListIteratorWrapper(ListIterator listIterator) {
            this.iterator = listIterator;
        }

        public void add(Object object) {
            this.iterator.add(object);
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public Object next() {
            return this.iterator.next();
        }

        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        public Object previous() {
            return this.iterator.previous();
        }

        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        public void remove() {
            this.iterator.remove();
        }

        public void set(Object object) {
            this.iterator.set(object);
        }
    }

    public static class PredicatedList
    extends CollectionUtils.PredicatedCollection
    implements List {
        public PredicatedList(List list, Predicate predicate) {
            super(list, predicate);
        }

        public void add(int n2, Object object) {
            this.validate(object);
            this.getList().add(n2, object);
        }

        public boolean addAll(int n2, Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.validate(iterator.next());
            }
            return this.getList().addAll(n2, collection);
        }

        public Object get(int n2) {
            return this.getList().get(n2);
        }

        private List getList() {
            return (List)this.collection;
        }

        public int indexOf(Object object) {
            return this.getList().indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.getList().lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int n2) {
            return new ListIteratorWrapper(this, this.getList().listIterator(n2)){
                private final PredicatedList this$0;
                {
                    this.this$0 = predicatedList;
                }

                public void add(Object object) {
                    this.this$0.validate(object);
                    this.iterator.add(object);
                }

                public void set(Object object) {
                    this.this$0.validate(object);
                    this.iterator.set(object);
                }
            };
        }

        public Object remove(int n2) {
            return this.getList().remove(n2);
        }

        public Object set(int n2, Object object) {
            this.validate(object);
            return this.getList().set(n2, object);
        }

        public List subList(int n2, int n3) {
            List list = this.getList().subList(n2, n3);
            return new PredicatedList(list, this.predicate);
        }
    }

    public static class FixedSizeList
    extends CollectionUtils.UnmodifiableCollection
    implements List {
        public FixedSizeList(List list) {
            super(list);
        }

        public void add(int n2, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int n2, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public Object get(int n2) {
            return this.getList().get(n2);
        }

        private List getList() {
            return (List)this.collection;
        }

        public int indexOf(Object object) {
            return this.getList().indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.getList().lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int n2) {
            return new ListIteratorWrapper(this.getList().listIterator(n2)){

                public void add(Object object) {
                    throw new UnsupportedOperationException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void remove(Object object) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Object remove(int n2) {
            throw new UnsupportedOperationException();
        }

        public Object set(int n2, Object object) {
            return this.getList().set(n2, object);
        }

        public List subList(int n2, int n3) {
            List list = this.getList().subList(n2, n3);
            return new FixedSizeList(list);
        }
    }

    public static class LazyList
    extends CollectionUtils.CollectionWrapper
    implements List {
        public final Factory factory;

        public LazyList(List list, Factory factory) {
            super(list);
            if (factory == null) {
                throw new IllegalArgumentException("Factory must not be null");
            }
            this.factory = factory;
        }

        public void add(int n2, Object object) {
            this.getList().add(n2, object);
        }

        public boolean addAll(int n2, Collection collection) {
            return this.getList().addAll(n2, collection);
        }

        public Object get(int n2) {
            if (n2 < this.getList().size()) {
                Object object = this.getList().get(n2);
                if (object == null) {
                    object = this.factory.create();
                    this.getList().set(n2, object);
                    return object;
                }
                return object;
            }
            int n3 = this.getList().size();
            while (n3 < n2) {
                this.getList().add(null);
                ++n3;
            }
            Object object = this.factory.create();
            this.getList().add(object);
            return object;
        }

        private List getList() {
            return (List)this.collection;
        }

        public int indexOf(Object object) {
            return this.getList().indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.getList().lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return this.getList().listIterator();
        }

        public ListIterator listIterator(int n2) {
            return this.getList().listIterator(n2);
        }

        public Object remove(int n2) {
            return this.getList().remove(n2);
        }

        public Object set(int n2, Object object) {
            return this.getList().set(n2, object);
        }

        public List subList(int n2, int n3) {
            return new LazyList(this.getList().subList(n2, n3), this.factory);
        }
    }
}

