/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FastArrayList
extends ArrayList {
    public ArrayList list = null;
    public boolean fast = false;

    public FastArrayList() {
        this.list = new ArrayList();
    }

    public FastArrayList(int n2) {
        this.list = new ArrayList(n2);
    }

    public FastArrayList(Collection collection) {
        this.list = new ArrayList(collection);
    }

    public void add(int n2, Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.add(n2, object);
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(n2, object);
        }
    }

    public boolean add(Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl2 = arrayList.add(object);
                this.list = arrayList;
                boolean bl3 = bl2;
                Object var4_8 = null;
                return bl3;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl4 = this.list.add(object);
            Object var4_9 = null;
            return bl4;
        }
    }

    public boolean addAll(int n2, Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl2 = arrayList.addAll(n2, collection);
                this.list = arrayList;
                boolean bl3 = bl2;
                Object var5_9 = null;
                return bl3;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl4 = this.list.addAll(n2, collection);
            Object var5_10 = null;
            return bl4;
        }
    }

    public boolean addAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl2 = arrayList.addAll(collection);
                this.list = arrayList;
                boolean bl3 = bl2;
                Object var4_8 = null;
                return bl3;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl4 = this.list.addAll(collection);
            Object var4_9 = null;
            return bl4;
        }
    }

    public void clear() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.clear();
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
    }

    public Object clone() {
        FastArrayList fastArrayList = null;
        if (this.fast) {
            fastArrayList = new FastArrayList((Collection)this.list);
        } else {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                fastArrayList = new FastArrayList((Collection)this.list);
            }
        }
        fastArrayList.setFast(this.getFast());
        return fastArrayList;
    }

    public boolean contains(Object object) {
        if (this.fast) {
            return this.list.contains(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl2 = this.list.contains(object);
            Object var4_4 = null;
            return bl2;
        }
    }

    public boolean containsAll(Collection collection) {
        if (this.fast) {
            return this.list.containsAll(collection);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl2 = this.list.containsAll(collection);
            Object var4_4 = null;
            return bl2;
        }
    }

    public void ensureCapacity(int n2) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.ensureCapacity(n2);
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.ensureCapacity(n2);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.fast) {
            ListIterator listIterator = ((AbstractList)this.list).listIterator();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                boolean bl2;
                Object e2 = listIterator.next();
                Object e3 = listIterator2.next();
                if (e2 == null) {
                    if (e3 == null) continue;
                    bl2 = false;
                } else {
                    bl2 = e2.equals(e3);
                }
                if (bl2) continue;
                return false;
            }
            return (listIterator.hasNext() || listIterator2.hasNext()) ^ true;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ListIterator listIterator = ((AbstractList)this.list).listIterator();
            ListIterator listIterator3 = list.listIterator();
            while (listIterator.hasNext() && listIterator3.hasNext()) {
                boolean bl3;
                Object e4 = listIterator.next();
                Object e5 = listIterator3.next();
                if (e4 == null) {
                    if (e5 == null) continue;
                    bl3 = false;
                } else {
                    bl3 = e4.equals(e5);
                }
                if (bl3) continue;
                boolean bl4 = false;
                Object var5_9 = null;
                return bl4;
            }
            boolean bl5 = (listIterator.hasNext() || listIterator3.hasNext()) ^ true;
            Object var5_10 = null;
            return bl5;
        }
    }

    public Object get(int n2) {
        if (this.fast) {
            return this.list.get(n2);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object e2 = this.list.get(n2);
            Object var4_4 = null;
            return e2;
        }
    }

    public boolean getFast() {
        return this.fast;
    }

    public int hashCode() {
        if (this.fast) {
            int n2 = 1;
            Iterator iterator = ((AbstractList)this.list).iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                n2 = 31 * n2 + (e2 == null ? 0 : e2.hashCode());
            }
            return n2;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n3 = 1;
            Iterator iterator = ((AbstractList)this.list).iterator();
            while (iterator.hasNext()) {
                Object e3 = iterator.next();
                n3 = 31 * n3 + (e3 == null ? 0 : e3.hashCode());
            }
            int n4 = n3;
            Object var3_6 = null;
            return n4;
        }
    }

    public int indexOf(Object object) {
        if (this.fast) {
            return this.list.indexOf(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n2 = this.list.indexOf(object);
            Object var4_4 = null;
            return n2;
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.list.isEmpty();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl2 = this.list.isEmpty();
            Object var3_3 = null;
            return bl2;
        }
    }

    public Iterator iterator() {
        if (this.fast) {
            return new ListIter(this, 0);
        }
        return ((AbstractList)this.list).iterator();
    }

    public int lastIndexOf(Object object) {
        if (this.fast) {
            return this.list.lastIndexOf(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n2 = this.list.lastIndexOf(object);
            Object var4_4 = null;
            return n2;
        }
    }

    public ListIterator listIterator() {
        if (this.fast) {
            return new ListIter(this, 0);
        }
        return ((AbstractList)this.list).listIterator();
    }

    public ListIterator listIterator(int n2) {
        if (this.fast) {
            return new ListIter(this, n2);
        }
        return ((AbstractList)this.list).listIterator(n2);
    }

    public Object remove(int n2) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                Object e2 = arrayList.remove(n2);
                this.list = arrayList;
                Object e3 = e2;
                Object var4_8 = null;
                return e3;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object e4 = this.list.remove(n2);
            Object var4_9 = null;
            return e4;
        }
    }

    public boolean remove(Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl2 = ((AbstractCollection)arrayList).remove(object);
                this.list = arrayList;
                boolean bl3 = bl2;
                Object var4_8 = null;
                return bl3;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl4 = ((AbstractCollection)this.list).remove(object);
            Object var4_9 = null;
            return bl4;
        }
    }

    public boolean removeAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl2 = ((AbstractCollection)arrayList).removeAll(collection);
                this.list = arrayList;
                boolean bl3 = bl2;
                Object var4_8 = null;
                return bl3;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl4 = ((AbstractCollection)this.list).removeAll(collection);
            Object var4_9 = null;
            return bl4;
        }
    }

    public boolean retainAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl2 = ((AbstractCollection)arrayList).retainAll(collection);
                this.list = arrayList;
                boolean bl3 = bl2;
                Object var4_8 = null;
                return bl3;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl4 = ((AbstractCollection)this.list).retainAll(collection);
            Object var4_9 = null;
            return bl4;
        }
    }

    public Object set(int n2, Object object) {
        if (this.fast) {
            return this.list.set(n2, object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object2 = this.list.set(n2, object);
            Object var5_5 = null;
            return object2;
        }
    }

    public void setFast(boolean bl2) {
        this.fast = bl2;
    }

    public int size() {
        if (this.fast) {
            return this.list.size();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n2 = this.list.size();
            Object var3_3 = null;
            return n2;
        }
    }

    public List subList(int n2, int n3) {
        if (this.fast) {
            return new SubList(this, n2, n3);
        }
        return ((AbstractList)this.list).subList(n2, n3);
    }

    public Object[] toArray() {
        if (this.fast) {
            return this.list.toArray();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object[] objectArray = this.list.toArray();
            Object var3_3 = null;
            return objectArray;
        }
    }

    public Object[] toArray(Object[] objectArray) {
        if (this.fast) {
            return this.list.toArray(objectArray);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object[] objectArray2 = this.list.toArray(objectArray);
            Object var4_4 = null;
            return objectArray2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FastArrayList[");
        stringBuffer.append(this.list.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void trimToSize() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.trimToSize();
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.trimToSize();
        }
    }

    private class SubList
    implements List {
        private final FastArrayList this$0;
        private int first;
        private int last;
        private List expected;

        public SubList(FastArrayList fastArrayList, int n2, int n3) {
            this.this$0 = fastArrayList;
            this.first = n2;
            this.last = n3;
            this.expected = fastArrayList.list;
        }

        public static FastArrayList b(SubList subList) {
            return subList.this$0;
        }

        public static List a(SubList subList, List list) {
            return subList.get(list);
        }

        public static int a(SubList subList) {
            return subList.last;
        }

        public static void a(SubList subList, int n2) {
            subList.last = n2;
        }

        public void add(int n2, Object object) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    this.get(arrayList).add(n2, object);
                    ++this.last;
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                this.get(this.expected).add(n2, object);
            }
        }

        public boolean add(Object object) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    boolean bl2 = this.get(arrayList).add(object);
                    if (bl2) {
                        ++this.last;
                    }
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    boolean bl3 = bl2;
                    Object var4_8 = null;
                    return bl3;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                boolean bl4 = this.get(this.expected).add(object);
                Object var4_9 = null;
                return bl4;
            }
        }

        public boolean addAll(int n2, Collection collection) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    boolean bl2 = this.get(arrayList).addAll(n2, collection);
                    this.this$0.list = arrayList;
                    if (bl2) {
                        this.last += collection.size();
                    }
                    this.expected = arrayList;
                    boolean bl3 = bl2;
                    Object var5_9 = null;
                    return bl3;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                boolean bl4 = this.get(this.expected).addAll(n2, collection);
                Object var5_10 = null;
                return bl4;
            }
        }

        public boolean addAll(Collection collection) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    boolean bl2 = this.get(arrayList).addAll(collection);
                    if (bl2) {
                        this.last += collection.size();
                    }
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    boolean bl3 = bl2;
                    Object var4_8 = null;
                    return bl3;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                boolean bl4 = this.get(this.expected).addAll(collection);
                Object var4_9 = null;
                return bl4;
            }
        }

        public void clear() {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    this.get(arrayList).clear();
                    this.last = this.first;
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                this.get(this.expected).clear();
            }
        }

        public boolean contains(Object object) {
            if (this.this$0.fast) {
                return this.get(this.expected).contains(object);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                boolean bl2 = this.get(this.expected).contains(object);
                Object var4_4 = null;
                return bl2;
            }
        }

        public boolean containsAll(Collection collection) {
            if (this.this$0.fast) {
                return this.get(this.expected).containsAll(collection);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                boolean bl2 = this.get(this.expected).containsAll(collection);
                Object var4_4 = null;
                return bl2;
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (this.this$0.fast) {
                return this.get(this.expected).equals(object);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                boolean bl2 = this.get(this.expected).equals(object);
                Object var4_4 = null;
                return bl2;
            }
        }

        public Object get(int n2) {
            if (this.this$0.fast) {
                return this.get(this.expected).get(n2);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                Object e2 = this.get(this.expected).get(n2);
                Object var4_4 = null;
                return e2;
            }
        }

        private List get(List list) {
            if (this.this$0.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return list.subList(this.first, this.last);
        }

        public int hashCode() {
            if (this.this$0.fast) {
                return this.get(this.expected).hashCode();
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).hashCode();
                Object var3_3 = null;
                return n2;
            }
        }

        public int indexOf(Object object) {
            if (this.this$0.fast) {
                return this.get(this.expected).indexOf(object);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).indexOf(object);
                Object var4_4 = null;
                return n2;
            }
        }

        public boolean isEmpty() {
            if (this.this$0.fast) {
                return this.get(this.expected).isEmpty();
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                boolean bl2 = this.get(this.expected).isEmpty();
                Object var3_3 = null;
                return bl2;
            }
        }

        public Iterator iterator() {
            return new SubListIter(this, 0);
        }

        public int lastIndexOf(Object object) {
            if (this.this$0.fast) {
                return this.get(this.expected).lastIndexOf(object);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).lastIndexOf(object);
                Object var4_4 = null;
                return n2;
            }
        }

        public ListIterator listIterator() {
            return new SubListIter(this, 0);
        }

        public ListIterator listIterator(int n2) {
            return new SubListIter(this, n2);
        }

        public Object remove(int n2) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    Object e2 = this.get(arrayList).remove(n2);
                    --this.last;
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    Object e3 = e2;
                    Object var4_8 = null;
                    return e3;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                Object e4 = this.get(this.expected).remove(n2);
                Object var4_9 = null;
                return e4;
            }
        }

        public boolean remove(Object object) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    boolean bl2 = this.get(arrayList).remove(object);
                    if (bl2) {
                        --this.last;
                    }
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    boolean bl3 = bl2;
                    Object var4_8 = null;
                    return bl3;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                boolean bl4 = this.get(this.expected).remove(object);
                Object var4_9 = null;
                return bl4;
            }
        }

        public boolean removeAll(Collection collection) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    List list = this.get(arrayList);
                    boolean bl2 = list.removeAll(collection);
                    if (bl2) {
                        this.last = this.first + list.size();
                    }
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    boolean bl3 = bl2;
                    Object var4_9 = null;
                    return bl3;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                boolean bl4 = this.get(this.expected).removeAll(collection);
                Object var4_10 = null;
                return bl4;
            }
        }

        public boolean retainAll(Collection collection) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    List list = this.get(arrayList);
                    boolean bl2 = list.retainAll(collection);
                    if (bl2) {
                        this.last = this.first + list.size();
                    }
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    boolean bl3 = bl2;
                    Object var4_9 = null;
                    return bl3;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                boolean bl4 = this.get(this.expected).retainAll(collection);
                Object var4_10 = null;
                return bl4;
            }
        }

        public Object set(int n2, Object object) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    Object object2 = this.get(arrayList).set(n2, object);
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    Object object3 = object2;
                    Object var5_9 = null;
                    return object3;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                Object object4 = this.get(this.expected).set(n2, object);
                Object var5_10 = null;
                return object4;
            }
        }

        public int size() {
            if (this.this$0.fast) {
                return this.get(this.expected).size();
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).size();
                Object var3_3 = null;
                return n2;
            }
        }

        public List subList(int n2, int n3) {
            if (this.this$0.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return new SubList(this.this$0, this.first + n2, n2 + n3);
        }

        public Object[] toArray() {
            if (this.this$0.fast) {
                return this.get(this.expected).toArray();
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                Object[] objectArray = this.get(this.expected).toArray();
                Object var3_3 = null;
                return objectArray;
            }
        }

        public Object[] toArray(Object[] objectArray) {
            if (this.this$0.fast) {
                return this.get(this.expected).toArray(objectArray);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                Object[] objectArray2 = this.get(this.expected).toArray(objectArray);
                Object var4_4 = null;
                return objectArray2;
            }
        }

        private class SubListIter
        implements ListIterator {
            private final SubList this$1;
            private List expected;
            private ListIterator iter;
            private int lastReturnedIndex;

            public SubListIter(SubList subList, int n2) {
                this.this$1 = subList;
                this.lastReturnedIndex = -1;
                this.expected = SubList.b((SubList)subList).list;
                this.iter = SubList.a(subList, this.expected).listIterator(n2);
            }

            public void add(Object object) {
                this.checkMod();
                int n2 = this.nextIndex();
                this.a().add(n2, object);
                SubList subList = this.this$1;
                SubList.a(subList, SubList.a(subList) + 1);
                this.iter = this.a().listIterator(n2 + 1);
                this.lastReturnedIndex = 1;
            }

            private void checkMod() {
                if (SubList.b((SubList)this.this$1).list != this.expected) {
                    throw new ConcurrentModificationException();
                }
            }

            public List a() {
                return SubList.a(this.this$1, this.expected);
            }

            public boolean hasNext() {
                this.checkMod();
                return this.iter.hasNext();
            }

            public boolean hasPrevious() {
                this.checkMod();
                return this.iter.hasPrevious();
            }

            public Object next() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.nextIndex();
                return this.iter.next();
            }

            public int nextIndex() {
                this.checkMod();
                return this.iter.nextIndex();
            }

            public Object previous() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.previousIndex();
                return this.iter.previous();
            }

            public int previousIndex() {
                this.checkMod();
                return this.iter.previousIndex();
            }

            public void remove() {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.a().remove(this.lastReturnedIndex);
                SubList subList = this.this$1;
                SubList.a(subList, SubList.a(subList) - 1);
                this.expected = SubList.b((SubList)this.this$1).list;
                this.iter = this.a().listIterator(this.previousIndex());
                this.lastReturnedIndex = -1;
            }

            public void set(Object object) {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.a().set(this.lastReturnedIndex, object);
                this.expected = SubList.b((SubList)this.this$1).list;
                this.iter = this.a().listIterator(this.previousIndex() + 1);
            }
        }
    }

    private class ListIter
    implements ListIterator {
        private final FastArrayList this$0;
        private List expected;
        private ListIterator iter;
        private int lastReturnedIndex;

        public ListIter(FastArrayList fastArrayList, int n2) {
            this.this$0 = fastArrayList;
            this.lastReturnedIndex = -1;
            this.expected = fastArrayList.list;
            this.iter = this.a().listIterator(n2);
        }

        public void add(Object object) {
            this.checkMod();
            int n2 = this.nextIndex();
            this.a().add(n2, object);
            this.iter = this.a().listIterator(n2 + 1);
            this.lastReturnedIndex = 1;
        }

        private void checkMod() {
            if (this.this$0.list != this.expected) {
                throw new ConcurrentModificationException();
            }
        }

        public List a() {
            return this.expected;
        }

        public boolean hasNext() {
            this.checkMod();
            return this.iter.hasNext();
        }

        public boolean hasPrevious() {
            this.checkMod();
            return this.iter.hasPrevious();
        }

        public Object next() {
            this.checkMod();
            this.lastReturnedIndex = this.iter.nextIndex();
            return this.iter.next();
        }

        public int nextIndex() {
            this.checkMod();
            return this.iter.nextIndex();
        }

        public Object previous() {
            this.checkMod();
            this.lastReturnedIndex = this.iter.previousIndex();
            return this.iter.previous();
        }

        public int previousIndex() {
            this.checkMod();
            return this.iter.previousIndex();
        }

        public void remove() {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.a().remove(this.lastReturnedIndex);
            this.expected = this.this$0.list;
            this.iter = this.a().listIterator(this.previousIndex());
            this.lastReturnedIndex = -1;
        }

        public void set(Object object) {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.a().set(this.lastReturnedIndex, object);
            this.expected = this.this$0.list;
            this.iter = this.a().listIterator(this.previousIndex() + 1);
        }
    }
}

