/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.collections.comparators.TransformingComparator;

public class ComparatorUtils {
    public static final Comparator NATURAL_COMPARATOR = ComparableComparator.getInstance();

    private ComparatorUtils() {
    }

    public static Comparator chainedComparator(Collection collection) {
        return ComparatorUtils.chainedComparator(collection.toArray(new Comparator[collection.size()]));
    }

    public static Comparator chainedComparator(Comparator comparator, Comparator comparator2) {
        return ComparatorUtils.chainedComparator(new Comparator[]{comparator, comparator2});
    }

    public static Comparator chainedComparator(Comparator[] comparatorArray) {
        ComparatorChain comparatorChain = new ComparatorChain();
        int n2 = 0;
        while (n2 < comparatorArray.length) {
            if (comparatorArray[n2] == null) {
                throw new NullPointerException("Comparator cannot be null");
            }
            comparatorChain.addComparator(comparatorArray[n2]);
            ++n2;
        }
        return comparatorChain;
    }

    public static Object max(Object object, Object object2, Comparator comparator) {
        int n2;
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return (n2 = comparator.compare(object, object2)) > 0 ? object : object2;
    }

    public static Object min(Object object, Object object2, Comparator comparator) {
        int n2;
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return (n2 = comparator.compare(object, object2)) < 0 ? object : object2;
    }

    public static Comparator naturalComparator() {
        return NATURAL_COMPARATOR;
    }

    public static Comparator nullHighComparator(Comparator comparator) {
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return new NullComparator(comparator, true);
    }

    public static Comparator nullLowComparator(Comparator comparator) {
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return new NullComparator(comparator, false);
    }

    public static Comparator reversedComparator(Comparator comparator) {
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return new ReverseComparator(comparator);
    }

    public static Comparator transformedComparator(Comparator comparator, Transformer transformer) {
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return new TransformingComparator(transformer, comparator);
    }
}

