/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class BufferUtils {
    private BufferUtils() {
    }

    public static Buffer blockingBuffer(Buffer buffer) {
        return new SynchronizedBuffer(buffer){

            public synchronized boolean add(Object object) {
                boolean bl2 = this.collection.add(object);
                this.notify();
                return bl2;
            }

            public synchronized boolean addAll(Collection collection) {
                boolean bl2 = this.collection.addAll(collection);
                this.notifyAll();
                return bl2;
            }

            public synchronized Object get() {
                while (this.collection.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BufferUnderflowException();
                    }
                }
                return ((Buffer)this.collection).get();
            }

            public synchronized Object remove() {
                while (this.collection.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BufferUnderflowException();
                    }
                }
                return ((Buffer)this.collection).remove();
            }
        };
    }

    public static Buffer predicatedBuffer(Buffer buffer, Predicate predicate) {
        return new PredicatedBuffer(buffer, predicate);
    }

    public static Buffer synchronizedBuffer(Buffer buffer) {
        return new SynchronizedBuffer(buffer);
    }

    public static Buffer unmodifiableBuffer(Buffer buffer) {
        return new UnmodifiableBuffer(buffer);
    }

    public static class SynchronizedBuffer
    extends CollectionUtils.SynchronizedCollection
    implements Buffer {
        public SynchronizedBuffer(Buffer buffer) {
            super(buffer);
        }

        public synchronized Object get() {
            return ((Buffer)this.collection).get();
        }

        public synchronized Object remove() {
            return ((Buffer)this.collection).remove();
        }
    }

    public static class UnmodifiableBuffer
    extends CollectionUtils.UnmodifiableCollection
    implements Buffer {
        public UnmodifiableBuffer(Buffer buffer) {
            super(buffer);
        }

        public Object get() {
            return ((Buffer)this.collection).get();
        }

        public Object remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PredicatedBuffer
    extends CollectionUtils.PredicatedCollection
    implements Buffer {
        public PredicatedBuffer(Buffer buffer, Predicate predicate) {
            super(buffer, predicate);
        }

        public Object get() {
            return ((Buffer)this.collection).get();
        }

        public Object remove() {
            return ((Buffer)this.collection).remove();
        }
    }
}

