/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.locale.converters.DecimalLocaleConverter;

public class FloatLocaleConverter
extends DecimalLocaleConverter {
    public FloatLocaleConverter() {
        this(false);
    }

    public FloatLocaleConverter(boolean bl2) {
        this(Locale.getDefault(), bl2);
    }

    public FloatLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public FloatLocaleConverter(Locale locale, boolean bl2) {
        this(locale, (String)null, bl2);
    }

    public FloatLocaleConverter(Locale locale, String string) {
        this(locale, string, false);
    }

    public FloatLocaleConverter(Locale locale, String string, boolean bl2) {
        super(locale, string, bl2);
    }

    public FloatLocaleConverter(Object object) {
        this(object, false);
    }

    public FloatLocaleConverter(Object object, boolean bl2) {
        this(object, Locale.getDefault(), bl2);
    }

    public FloatLocaleConverter(Object object, Locale locale) {
        this(object, locale, false);
    }

    public FloatLocaleConverter(Object object, Locale locale, boolean bl2) {
        this(object, locale, null, bl2);
    }

    public FloatLocaleConverter(Object object, Locale locale, String string) {
        this(object, locale, string, false);
    }

    public FloatLocaleConverter(Object object, Locale locale, String string, boolean bl2) {
        super(object, locale, string);
    }

    public Object parse(Object object, String string) throws ParseException {
        Number number = (Number)super.parse(object, string);
        if (Math.abs(number.doubleValue() - (double)number.floatValue()) > (double)number.floatValue() * 1.0E-5) {
            throw new ConversionException("Suplied number is not of type Float: " + number.longValue());
        }
        return new Float(number.floatValue());
    }
}

