/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class LongArrayConverter
extends AbstractArrayConverter {
    private static long[] model = new long[0];

    public LongArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public LongArrayConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == object.getClass()) {
            return object;
        }
        if (AbstractArrayConverter.strings.getClass() == object.getClass()) {
            try {
                String[] stringArray = (String[])object;
                long[] lArray = new long[stringArray.length];
                int n2 = 0;
                while (n2 < stringArray.length) {
                    lArray[n2] = Long.parseLong(stringArray[n2]);
                    ++n2;
                }
                return lArray;
            }
            catch (Exception exception) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString(), exception);
            }
        }
        try {
            List list = this.parseElements(object.toString());
            long[] lArray = new long[list.size()];
            int n3 = 0;
            while (n3 < lArray.length) {
                lArray[n3] = Long.parseLong((String)list.get(n3));
                ++n3;
            }
            return lArray;
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(object.toString(), exception);
        }
    }
}

