/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class DoubleConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public DoubleConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public DoubleConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (object instanceof Double) {
            return object;
        }
        if (object instanceof Number) {
            return new Double(((Number)object).doubleValue());
        }
        try {
            return new Double(object.toString());
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(exception);
        }
    }
}

