/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Array;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanArrayConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteArrayConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterArrayConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.ClassConverter;
import org.apache.commons.beanutils.converters.DoubleArrayConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FileConverter;
import org.apache.commons.beanutils.converters.FloatArrayConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerArrayConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongArrayConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortArrayConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.beanutils.converters.URLConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertUtilsBean {
    private FastHashMap converters = new FastHashMap();
    private Log log = LogFactory.getLog(p == null ? (p = ConvertUtilsBean.a("org.apache.commons.beanutils.ConvertUtils")) : p);
    private Boolean defaultBoolean = Boolean.FALSE;
    private Byte defaultByte = new Byte(0);
    private Character defaultCharacter = new Character(' ');
    private Double defaultDouble = new Double(0.0);
    private Float defaultFloat = new Float(0.0f);
    private Integer defaultInteger = new Integer(0);
    private Long defaultLong = new Long(0L);
    private static Short defaultShort = new Short(0);
    public static Class p;
    public static Class r;
    public static Class d;
    public static Class k;
    public static Class a;
    public static Class h;
    public static Class n;
    public static Class f;
    public static Class j;
    public static Class c;
    public static Class b;
    public static Class l;
    public static Class m;
    public static Class o;
    public static Class i;
    public static Class e;
    public static Class q;
    public static Class g;

    public static ConvertUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getConvertUtils();
    }

    public ConvertUtilsBean() {
        this.converters.setFast(false);
        this.deregister();
        this.converters.setFast(true);
    }

    public boolean getDefaultBoolean() {
        return this.defaultBoolean;
    }

    public void setDefaultBoolean(boolean bl2) {
        this.defaultBoolean = new Boolean(bl2);
        this.register(new BooleanConverter(this.defaultBoolean), Boolean.TYPE);
        this.register(new BooleanConverter(this.defaultBoolean), r == null ? (r = ConvertUtilsBean.a("java.lang.Boolean")) : r);
    }

    public byte getDefaultByte() {
        return this.defaultByte;
    }

    public void setDefaultByte(byte by2) {
        this.defaultByte = new Byte(by2);
        this.register(new ByteConverter(this.defaultByte), Byte.TYPE);
        this.register(new ByteConverter(this.defaultByte), d == null ? (d = ConvertUtilsBean.a("java.lang.Byte")) : d);
    }

    public char getDefaultCharacter() {
        return this.defaultCharacter.charValue();
    }

    public void setDefaultCharacter(char c2) {
        this.defaultCharacter = new Character(c2);
        this.register(new CharacterConverter(this.defaultCharacter), Character.TYPE);
        this.register(new CharacterConverter(this.defaultCharacter), k == null ? (k = ConvertUtilsBean.a("java.lang.Character")) : k);
    }

    public double getDefaultDouble() {
        return this.defaultDouble;
    }

    public void setDefaultDouble(double d2) {
        this.defaultDouble = new Double(d2);
        this.register(new DoubleConverter(this.defaultDouble), Double.TYPE);
        this.register(new DoubleConverter(this.defaultDouble), a == null ? (a = ConvertUtilsBean.a("java.lang.Double")) : a);
    }

    public float getDefaultFloat() {
        return this.defaultFloat.floatValue();
    }

    public void setDefaultFloat(float f2) {
        this.defaultFloat = new Float(f2);
        this.register(new FloatConverter(this.defaultFloat), Float.TYPE);
        this.register(new FloatConverter(this.defaultFloat), h == null ? (h = ConvertUtilsBean.a("java.lang.Float")) : h);
    }

    public int getDefaultInteger() {
        return this.defaultInteger;
    }

    public void setDefaultInteger(int n2) {
        this.defaultInteger = new Integer(n2);
        this.register(new IntegerConverter(this.defaultInteger), Integer.TYPE);
        this.register(new IntegerConverter(this.defaultInteger), n == null ? (n = ConvertUtilsBean.a("java.lang.Integer")) : n);
    }

    public long getDefaultLong() {
        return this.defaultLong;
    }

    public void setDefaultLong(long l2) {
        this.defaultLong = new Long(l2);
        this.register(new LongConverter(this.defaultLong), Long.TYPE);
        this.register(new LongConverter(this.defaultLong), f == null ? (f = ConvertUtilsBean.a("java.lang.Long")) : f);
    }

    public short getDefaultShort() {
        return defaultShort;
    }

    public void setDefaultShort(short s2) {
        defaultShort = new Short(s2);
        this.register(new ShortConverter(defaultShort), Short.TYPE);
        this.register(new ShortConverter(defaultShort), j == null ? (j = ConvertUtilsBean.a("java.lang.Short")) : j);
    }

    public String convert(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            if (Array.getLength(object) < 1) {
                return null;
            }
            if ((object = Array.get(object, 0)) == null) {
                return null;
            }
            Converter converter = this.lookup(c == null ? (c = ConvertUtilsBean.a("java.lang.String")) : c);
            return (String)converter.convert(c == null ? (c = ConvertUtilsBean.a("java.lang.String")) : c, object);
        }
        Converter converter = this.lookup(c == null ? (c = ConvertUtilsBean.a("java.lang.String")) : c);
        return (String)converter.convert(c == null ? (c = ConvertUtilsBean.a("java.lang.String")) : c, object);
    }

    public Object convert(String string, Class clazz) {
        Converter converter;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert string '" + string + "' to class '" + clazz.getName() + "'");
        }
        if ((converter = this.lookup(clazz)) == null) {
            converter = this.lookup(c == null ? (c = ConvertUtilsBean.a("java.lang.String")) : c);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Using converter " + converter);
        }
        return converter.convert(clazz, string);
    }

    public Object convert(String[] stringArray, Class clazz) {
        Converter converter;
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert String[" + stringArray.length + "] to class '" + clazz2.getName() + "[]'");
        }
        if ((converter = this.lookup(clazz2)) == null) {
            converter = this.lookup(c == null ? (c = ConvertUtilsBean.a("java.lang.String")) : c);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Using converter " + converter);
        }
        Object object = Array.newInstance(clazz2, stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            Array.set(object, n2, converter.convert(clazz2, stringArray[n2]));
            ++n2;
        }
        return object;
    }

    public void deregister() {
        boolean[] blArray = new boolean[]{};
        byte[] byArray = new byte[]{};
        char[] cArray = new char[]{};
        double[] dArray = new double[]{};
        float[] fArray = new float[]{};
        int[] nArray = new int[]{};
        long[] lArray = new long[]{};
        short[] sArray = new short[]{};
        String[] stringArray = new String[]{};
        this.converters.clear();
        this.register(b == null ? (b = ConvertUtilsBean.a("java.math.BigDecimal")) : b, new BigDecimalConverter());
        this.register(l == null ? (l = ConvertUtilsBean.a("java.math.BigInteger")) : l, new BigIntegerConverter());
        this.register(Boolean.TYPE, new BooleanConverter(this.defaultBoolean));
        this.register(r == null ? (r = ConvertUtilsBean.a("java.lang.Boolean")) : r, new BooleanConverter(this.defaultBoolean));
        this.register(blArray.getClass(), new BooleanArrayConverter(blArray));
        this.register(Byte.TYPE, new ByteConverter(this.defaultByte));
        this.register(d == null ? (d = ConvertUtilsBean.a("java.lang.Byte")) : d, new ByteConverter(this.defaultByte));
        this.register(byArray.getClass(), new ByteArrayConverter(byArray));
        this.register(Character.TYPE, new CharacterConverter(this.defaultCharacter));
        this.register(k == null ? (k = ConvertUtilsBean.a("java.lang.Character")) : k, new CharacterConverter(this.defaultCharacter));
        this.register(cArray.getClass(), new CharacterArrayConverter(cArray));
        this.register(m == null ? (m = ConvertUtilsBean.a("java.lang.Class")) : m, new ClassConverter());
        this.register(Double.TYPE, new DoubleConverter(this.defaultDouble));
        this.register(a == null ? (a = ConvertUtilsBean.a("java.lang.Double")) : a, new DoubleConverter(this.defaultDouble));
        this.register(dArray.getClass(), new DoubleArrayConverter(dArray));
        this.register(Float.TYPE, new FloatConverter(this.defaultFloat));
        this.register(h == null ? (h = ConvertUtilsBean.a("java.lang.Float")) : h, new FloatConverter(this.defaultFloat));
        this.register(fArray.getClass(), new FloatArrayConverter(fArray));
        this.register(Integer.TYPE, new IntegerConverter(this.defaultInteger));
        this.register(n == null ? (n = ConvertUtilsBean.a("java.lang.Integer")) : n, new IntegerConverter(this.defaultInteger));
        this.register(nArray.getClass(), new IntegerArrayConverter(nArray));
        this.register(Long.TYPE, new LongConverter(this.defaultLong));
        this.register(f == null ? (f = ConvertUtilsBean.a("java.lang.Long")) : f, new LongConverter(this.defaultLong));
        this.register(lArray.getClass(), new LongArrayConverter(lArray));
        this.register(Short.TYPE, new ShortConverter(defaultShort));
        this.register(j == null ? (j = ConvertUtilsBean.a("java.lang.Short")) : j, new ShortConverter(defaultShort));
        this.register(sArray.getClass(), new ShortArrayConverter(sArray));
        this.register(c == null ? (c = ConvertUtilsBean.a("java.lang.String")) : c, new StringConverter());
        this.register(stringArray.getClass(), new StringArrayConverter(stringArray));
        this.register(o == null ? (o = ConvertUtilsBean.a("java.sql.Date")) : o, new SqlDateConverter());
        this.register(i == null ? (i = ConvertUtilsBean.a("java.sql.Time")) : i, new SqlTimeConverter());
        this.register(e == null ? (e = ConvertUtilsBean.a("java.sql.Timestamp")) : e, new SqlTimestampConverter());
        this.register(q == null ? (q = ConvertUtilsBean.a("java.io.File")) : q, new FileConverter());
        this.register(g == null ? (g = ConvertUtilsBean.a("java.net.URL")) : g, new URLConverter());
    }

    private void register(Class clazz, Converter converter) {
        this.register(converter, clazz);
    }

    public void deregister(Class clazz) {
        this.converters.remove(clazz);
    }

    public Converter lookup(Class clazz) {
        return (Converter)this.converters.get(clazz);
    }

    public void register(Converter converter, Class clazz) {
        this.converters.put(clazz, converter);
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

