/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRPdfSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_PDF = ".pdf";
    public static final JRPdfSaveContributor INSTANCE = new JRPdfSaveContributor();

    public static JRPdfSaveContributor getInstance() {
        return INSTANCE;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(EXTENSION_PDF);
    }

    public String getDescription() {
        return "PDF (*.pdf)";
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().endsWith(EXTENSION_PDF)) {
            file = new File(file.getAbsolutePath() + EXTENSION_PDF);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("file.exists"), file.getName()), ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("save"), 2)) {
            JRPdfExporter jRPdfExporter = new JRPdfExporter();
            jRPdfExporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            jRPdfExporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
            jRPdfExporter.exportReport();
        }
    }
}

