/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.xmla;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.olap.JROlapDataSource;
import net.sf.jasperreports.olap.xmla.JRXmlaCell;
import net.sf.jasperreports.olap.xmla.JRXmlaHierarchy;
import net.sf.jasperreports.olap.xmla.JRXmlaMember;
import net.sf.jasperreports.olap.xmla.JRXmlaMemberTuple;
import net.sf.jasperreports.olap.xmla.JRXmlaResult;
import net.sf.jasperreports.olap.xmla.JRXmlaResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXmlaQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRXmlaQueryExecuter.a("net.sf.jasperreports.olap.xmla.JRXmlaQueryExecuter")) : a);
    private static final String SLICER_AXIS_NAME = "SlicerAxis";
    private static final String MDD_URI = "urn:schemas-microsoft-com:xml-analysis:mddataset";
    private static final String XMLA_URI = "urn:schemas-microsoft-com:xml-analysis";
    private static final Pattern LEVEL_UNIQUE_NAME_PATTERN = Pattern.compile("\\[[^\\]]+\\]\\.\\[([^\\]]+)\\]");
    private static final int LEVEL_UNIQUE_NAME_PATTERN_NAME_GROUP = 1;
    private SOAPFactory sf;
    private SOAPConnection connection;
    private JRXmlaResult xmlaResult;
    public static Class a;

    public JRXmlaQueryExecuter(JRDataset jRDataset, Map map) {
        super(jRDataset, map);
        this.parseQuery();
    }

    public String getParameterReplacement(String string) {
        return String.valueOf(this.getParameterValue(string));
    }

    public JRDataSource createDatasource() throws JRException {
        Object object;
        try {
            this.sf = SOAPFactory.newInstance();
            this.connection = this.createSOAPConnection();
            object = this.createQueryMessage();
            URL uRL = new URL(this.getSoapUrl());
            SOAPMessage sOAPMessage = this.executeQuery((SOAPMessage)object, uRL);
            this.xmlaResult = new JRXmlaResult();
            this.parseResult(sOAPMessage);
        }
        catch (MalformedURLException malformedURLException) {
            log.error(malformedURLException);
            throw new JRRuntimeException(malformedURLException);
        }
        catch (SOAPException sOAPException) {
            log.error((Object)sOAPException);
            throw new JRRuntimeException(sOAPException);
        }
        object = new JROlapDataSource(this.dataset, this.xmlaResult);
        return object;
    }

    public String getSoapUrl() throws MalformedURLException {
        String string;
        String string2 = (String)this.getParameterValue("XMLA_URL");
        String string3 = (String)this.getParameterValue("XMLA_USER", true);
        if (string3 == null || string3.length() == 0) {
            string = string2;
        } else {
            URL uRL = new URL(string2);
            string = uRL.getProtocol() + "://" + string3;
            String string4 = (String)this.getParameterValue("XMLA_PASSWORD", true);
            if (string4 != null && string4.length() > 0) {
                string = string + ":" + string4;
            }
            string = string + "@" + uRL.getHost() + ":" + uRL.getPort() + uRL.getPath();
        }
        return string;
    }

    public boolean cancelQuery() throws JRException {
        return false;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SOAPException sOAPException) {
                log.error((Object)sOAPException);
                throw new JRRuntimeException(sOAPException);
            }
            this.connection = null;
        }
    }

    public SOAPConnection createSOAPConnection() {
        try {
            SOAPConnectionFactory sOAPConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection sOAPConnection = sOAPConnectionFactory.createConnection();
            return sOAPConnection;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            log.error(unsupportedOperationException);
            throw new JRRuntimeException(unsupportedOperationException);
        }
        catch (SOAPException sOAPException) {
            log.error((Object)sOAPException);
            throw new JRRuntimeException(sOAPException);
        }
    }

    public SOAPMessage createQueryMessage() {
        String string = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug("MDX query: " + string);
        }
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage sOAPMessage = messageFactory.createMessage();
            MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
            mimeHeaders.setHeader("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Execute\"");
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            Name name = sOAPEnvelope.createName("Execute", "", XMLA_URI);
            SOAPElement sOAPElement = sOAPBody.addChildElement(name);
            Name name2 = sOAPEnvelope.createName("Command", "", XMLA_URI);
            SOAPElement sOAPElement2 = sOAPElement.addChildElement(name2);
            Name name3 = sOAPEnvelope.createName("Statement", "", XMLA_URI);
            SOAPElement sOAPElement3 = sOAPElement2.addChildElement(name3);
            sOAPElement3.addTextNode(string);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string2 = (String)this.getParameterValue("XMLA_DATASOURCE");
            hashMap.put("DataSourceInfo", string2);
            String string3 = (String)this.getParameterValue("XMLA_CATALOG");
            hashMap.put("Catalog", string3);
            hashMap.put("Format", "Multidimensional");
            hashMap.put("AxisFormat", "TupleFormat");
            this.addParameterList(sOAPEnvelope, sOAPElement, "Properties", "PropertyList", hashMap);
            sOAPMessage.saveChanges();
            if (log.isDebugEnabled()) {
                log.debug("XML/A query message: " + sOAPMessage.toString());
            }
            return sOAPMessage;
        }
        catch (SOAPException sOAPException) {
            log.error((Object)sOAPException);
            throw new JRRuntimeException(sOAPException);
        }
    }

    public void addParameterList(SOAPEnvelope sOAPEnvelope, SOAPElement sOAPElement, String string, String string2, Map map) throws SOAPException {
        Name name = sOAPEnvelope.createName(string, "", XMLA_URI);
        SOAPElement sOAPElement2 = sOAPElement.addChildElement(name);
        name = sOAPEnvelope.createName(string2, "", XMLA_URI);
        SOAPElement sOAPElement3 = sOAPElement2.addChildElement(name);
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = (String)map.get(string3);
            name = sOAPEnvelope.createName(string3, "", XMLA_URI);
            SOAPElement sOAPElement4 = sOAPElement3.addChildElement(name);
            sOAPElement4.addTextNode(string4);
        }
    }

    public SOAPMessage executeQuery(SOAPMessage sOAPMessage, URL uRL) {
        try {
            SOAPMessage sOAPMessage2 = this.connection.call(sOAPMessage, (Object)uRL);
            return sOAPMessage2;
        }
        catch (SOAPException sOAPException) {
            log.error("Message-Call failed.", sOAPException);
            throw new JRRuntimeException(sOAPException);
        }
    }

    public void parseResult(SOAPMessage sOAPMessage) throws SOAPException {
        Object e2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Name name;
        Iterator iterator;
        SOAPFault sOAPFault;
        SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
        SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
        SOAPBody sOAPBody = sOAPEnvelope.getBody();
        SOAPElement sOAPElement = null;
        if (log.isDebugEnabled()) {
            log.debug("XML/A result envelope: " + sOAPEnvelope.toString());
        }
        if ((sOAPFault = sOAPBody.getFault()) != null) {
            this.handleResultFault(sOAPFault);
        }
        if ((iterator = sOAPBody.getChildElements(name = sOAPEnvelope.createName("ExecuteResponse", "", XMLA_URI))).hasNext()) {
            object6 = iterator.next();
            if (object6 == null) {
                log.error("ExecuteResponse Element is null.");
                throw new JRRuntimeException("ExecuteResponse Element is null.");
            }
        } else {
            log.error("Could not retrieve ExecuteResponse Element.");
            throw new JRRuntimeException("Could not retrieve ExecuteResponse Element.");
        }
        sOAPElement = (SOAPElement)object6;
        object6 = sOAPEnvelope.createName("return", "", XMLA_URI);
        Iterator iterator2 = sOAPElement.getChildElements(object6);
        SOAPElement sOAPElement2 = null;
        if (iterator2.hasNext()) {
            object5 = iterator2.next();
            if (object5 == null) {
                log.error("return Element is null.");
                throw new JRRuntimeException("return Element is null.");
            }
            sOAPElement2 = (SOAPElement)object5;
        } else {
            object5 = sOAPEnvelope.createName("return", "", "");
            iterator2 = sOAPElement.getChildElements(object5);
            if (iterator2.hasNext()) {
                object4 = iterator2.next();
                if (object4 == null) {
                    log.error("return Element is null.");
                    throw new JRRuntimeException("return Element is null.");
                }
                sOAPElement2 = (SOAPElement)object4;
            } else {
                log.error("Could not retrieve return Element.");
                throw new JRRuntimeException("Could not retrieve return Element.");
            }
        }
        object5 = sOAPEnvelope.createName("root", "", MDD_URI);
        object4 = null;
        Iterator iterator3 = sOAPElement2.getChildElements(object5);
        if (iterator3.hasNext()) {
            object3 = iterator3.next();
            if (object3 == null) {
                log.error("root Element is null.");
                throw new JRRuntimeException("root Element is null.");
            }
        } else {
            log.error("Could not retrieve root Element.");
            throw new JRRuntimeException("Could not retrieve root Element.");
        }
        object4 = (SOAPElement)object3;
        object3 = sOAPEnvelope.createName("OlapInfo", "", MDD_URI);
        SOAPElement sOAPElement3 = null;
        Iterator iterator4 = object4.getChildElements(object3);
        if (iterator4.hasNext()) {
            object2 = iterator4.next();
            if (object2 == null) {
                log.error("OlapInfo Element is null.");
                throw new JRRuntimeException("OlapInfo Element is null.");
            }
        } else {
            log.error("Could not retrieve OlapInfo Element.");
            throw new JRRuntimeException("Could not retrieve OlapInfo Element.");
        }
        sOAPElement3 = (SOAPElement)object2;
        this.parseOLAPInfoElement(sOAPElement3);
        object2 = sOAPEnvelope.createName("Axes", "", MDD_URI);
        SOAPElement sOAPElement4 = null;
        Iterator iterator5 = object4.getChildElements(object2);
        if (iterator5.hasNext()) {
            object = iterator5.next();
            if (object == null) {
                log.error("Axes Element is null");
                throw new JRRuntimeException("Axes Element is null");
            }
        } else {
            log.error("Could not retrieve Axes Element.");
            throw new JRRuntimeException("Could not retrieve Axes Element.");
        }
        sOAPElement4 = (SOAPElement)object;
        this.parseAxesElement(sOAPElement4);
        object = sOAPEnvelope.createName("CellData", "", MDD_URI);
        SOAPElement sOAPElement5 = null;
        Iterator iterator6 = object4.getChildElements(object);
        if (iterator6.hasNext()) {
            e2 = iterator6.next();
            if (e2 == null) {
                log.error("CellData element is null");
                throw new JRRuntimeException("CellData element is null");
            }
        } else {
            log.error("Could not retrieve CellData Element.");
            throw new JRRuntimeException("Could not retrieve CellData Element.");
        }
        sOAPElement5 = (SOAPElement)e2;
        this.parseCellDataElement(sOAPElement5);
    }

    public void handleResultFault(SOAPFault sOAPFault) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("XML/A fault: ");
        String string3 = sOAPFault.getFaultString();
        if (string3 != null) {
            stringBuffer.append(string3);
            stringBuffer.append("; ");
        }
        if ((string2 = sOAPFault.getFaultActor()) != null) {
            stringBuffer.append("Actor: ");
            stringBuffer.append(string2);
            stringBuffer.append("; ");
        }
        if ((string = sOAPFault.getFaultCode()) != null) {
            stringBuffer.append("Code: ");
            stringBuffer.append(string);
            stringBuffer.append("; ");
        }
        throw new JRRuntimeException(stringBuffer.toString());
    }

    public void parseOLAPInfoElement(SOAPElement sOAPElement) throws SOAPException {
        Object e2;
        Name name = this.sf.createName("AxesInfo", "", MDD_URI);
        SOAPElement sOAPElement2 = null;
        Iterator iterator = sOAPElement.getChildElements(name);
        if (iterator.hasNext()) {
            e2 = iterator.next();
            if (e2 == null) {
                log.error("AxisInfo Element is null.");
                throw new JRRuntimeException("AxisInfo Element is null.");
            }
        } else {
            log.error("Could not retrieve AxesInfo Element.");
            throw new JRRuntimeException("Could not retrieve AxesInfo Element.");
        }
        sOAPElement2 = (SOAPElement)e2;
        this.parseAxesInfoElement(sOAPElement2);
    }

    public void parseAxesInfoElement(SOAPElement sOAPElement) throws SOAPException {
        Name name = this.sf.createName("AxisInfo", "", MDD_URI);
        Iterator iterator = sOAPElement.getChildElements(name);
        while (iterator.hasNext()) {
            Name name2;
            SOAPElement sOAPElement2 = (SOAPElement)iterator.next();
            String string = sOAPElement2.getAttributeValue(name2 = this.sf.createName("name"));
            if (string.equals(SLICER_AXIS_NAME)) continue;
            JRXmlaResultAxis jRXmlaResultAxis = new JRXmlaResultAxis(string);
            this.xmlaResult.addAxis(jRXmlaResultAxis);
            name2 = this.sf.createName("HierarchyInfo", "", MDD_URI);
            Iterator iterator2 = sOAPElement2.getChildElements(name2);
            while (iterator2.hasNext()) {
                SOAPElement sOAPElement3 = (SOAPElement)iterator2.next();
                this.handleHierInfo(jRXmlaResultAxis, sOAPElement3);
            }
        }
    }

    public void parseAxesElement(SOAPElement sOAPElement) throws SOAPException {
        Name name = this.sf.createName("Axis", "", MDD_URI);
        Iterator iterator = sOAPElement.getChildElements(name);
        while (iterator.hasNext()) {
            Name name2;
            SOAPElement sOAPElement2 = (SOAPElement)iterator.next();
            String string = sOAPElement2.getAttributeValue(name2 = this.sf.createName("name"));
            if (string.equals(SLICER_AXIS_NAME)) continue;
            JRXmlaResultAxis jRXmlaResultAxis = this.xmlaResult.getAxisByName(string);
            name2 = this.sf.createName("Tuples", "", MDD_URI);
            Iterator iterator2 = sOAPElement2.getChildElements(name2);
            if (!iterator2.hasNext()) continue;
            SOAPElement sOAPElement3 = (SOAPElement)iterator2.next();
            this.handleTuplesElement(jRXmlaResultAxis, sOAPElement3);
        }
    }

    public void parseCellDataElement(SOAPElement sOAPElement) throws SOAPException {
        Name name = this.sf.createName("Cell", "", MDD_URI);
        Iterator iterator = sOAPElement.getChildElements(name);
        while (iterator.hasNext()) {
            Object object;
            String string;
            Name name2;
            SOAPElement sOAPElement2 = (SOAPElement)iterator.next();
            Iterator iterator2 = sOAPElement2.getChildElements(name2 = this.sf.createName("Error", "", MDD_URI));
            if (iterator2.hasNext()) {
                this.handleCellErrors(iterator2);
            }
            Name name3 = this.sf.createName("CellOrdinal");
            String string2 = sOAPElement2.getAttributeValue(name3);
            Object object2 = null;
            Iterator iterator3 = sOAPElement2.getChildElements(this.sf.createName("Value", "", MDD_URI));
            if (iterator3.hasNext()) {
                string = (SOAPElement)iterator3.next();
                object = string.getAttribute("xsi:type");
                object2 = ((String)object).equals("xsd:int") ? new Long(string.getValue()) : (((String)object).equals("xsd:double") ? new Double(string.getValue()) : (((String)object).equals("xsd:decimal") ? new Double(string.getValue()) : string.getValue()));
            }
            string = "";
            object = sOAPElement2.getChildElements(this.sf.createName("FmtValue", "", MDD_URI));
            if (object.hasNext()) {
                SOAPElement sOAPElement3 = (SOAPElement)object.next();
                string = sOAPElement3.getValue();
            }
            int n2 = Integer.parseInt(string2);
            JRXmlaCell jRXmlaCell = new JRXmlaCell(object2, string);
            this.xmlaResult.setCell(jRXmlaCell, n2);
        }
    }

    public void handleCellErrors(Iterator iterator) throws SOAPException {
        Object object;
        Object object2;
        SOAPElement sOAPElement = (SOAPElement)iterator.next();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cell error: ");
        Iterator iterator2 = sOAPElement.getChildElements(this.sf.createName("Description", "", MDD_URI));
        if (iterator2.hasNext()) {
            object2 = (SOAPElement)iterator2.next();
            stringBuffer.append(object2.getValue());
            stringBuffer.append("; ");
        }
        if ((object2 = sOAPElement.getChildElements(this.sf.createName("Source", "", MDD_URI))).hasNext()) {
            object = (SOAPElement)object2.next();
            stringBuffer.append("Source: ");
            stringBuffer.append(object.getValue());
            stringBuffer.append("; ");
        }
        if ((object = sOAPElement.getChildElements(this.sf.createName("ErrorCode", "", MDD_URI))).hasNext()) {
            SOAPElement sOAPElement2 = (SOAPElement)object.next();
            stringBuffer.append("Code: ");
            stringBuffer.append(sOAPElement2.getValue());
            stringBuffer.append("; ");
        }
        throw new JRRuntimeException(stringBuffer.toString());
    }

    public void handleHierInfo(JRXmlaResultAxis jRXmlaResultAxis, SOAPElement sOAPElement) throws SOAPException {
        Name name = this.sf.createName("name");
        String string = sOAPElement.getAttributeValue(name);
        JRXmlaHierarchy jRXmlaHierarchy = new JRXmlaHierarchy(string);
        jRXmlaResultAxis.addHierarchy(jRXmlaHierarchy);
    }

    public void handleTuplesElement(JRXmlaResultAxis jRXmlaResultAxis, SOAPElement sOAPElement) throws SOAPException {
        Name name = this.sf.createName("Tuple", "", MDD_URI);
        Iterator iterator = sOAPElement.getChildElements(name);
        while (iterator.hasNext()) {
            SOAPElement sOAPElement2 = (SOAPElement)iterator.next();
            this.handleTupleElement(jRXmlaResultAxis, sOAPElement2);
        }
    }

    public void handleTupleElement(JRXmlaResultAxis jRXmlaResultAxis, SOAPElement sOAPElement) throws SOAPException {
        JRXmlaMemberTuple jRXmlaMemberTuple = new JRXmlaMemberTuple(jRXmlaResultAxis.getHierarchiesOnAxis().length);
        Name name = this.sf.createName("Member", "", MDD_URI);
        Iterator iterator = sOAPElement.getChildElements(name);
        int n2 = 0;
        while (iterator.hasNext()) {
            String string;
            Object object;
            SOAPElement sOAPElement2 = (SOAPElement)iterator.next();
            Name name2 = this.sf.createName("Hierarchy", "", "");
            String string2 = sOAPElement2.getAttributeValue(name2);
            String string3 = "";
            Iterator iterator2 = sOAPElement2.getChildElements(this.sf.createName("UName", "", MDD_URI));
            if (iterator2.hasNext()) {
                string3 = ((SOAPElement)iterator2.next()).getValue();
            }
            String string4 = "";
            Iterator iterator3 = sOAPElement2.getChildElements(this.sf.createName("Caption", "", MDD_URI));
            if (iterator3.hasNext()) {
                string4 = ((SOAPElement)iterator3.next()).getValue();
            }
            String string5 = "";
            Iterator iterator4 = sOAPElement2.getChildElements(this.sf.createName("LName", "", MDD_URI));
            if (iterator4.hasNext() && ((Matcher)(object = LEVEL_UNIQUE_NAME_PATTERN.matcher(string = ((SOAPElement)iterator4.next()).getValue()))).matches()) {
                string5 = ((Matcher)object).group(1);
            }
            int n3 = 0;
            object = sOAPElement2.getChildElements(this.sf.createName("LNum", "", MDD_URI));
            if (object.hasNext()) {
                n3 = Integer.parseInt(((SOAPElement)object.next()).getValue());
            }
            JRXmlaMember jRXmlaMember = new JRXmlaMember(string4, string3, string2, string5, n3);
            jRXmlaMemberTuple.setMember(n2++, jRXmlaMember);
        }
        jRXmlaResultAxis.addTuple(jRXmlaMemberTuple);
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

