/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import antlr.ANTLRException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.olap.mapping.Axis;
import net.sf.jasperreports.olap.mapping.AxisPosition;
import net.sf.jasperreports.olap.mapping.DataMapping;
import net.sf.jasperreports.olap.mapping.Mapping;
import net.sf.jasperreports.olap.mapping.MappingLexer;
import net.sf.jasperreports.olap.mapping.MappingMetadata;
import net.sf.jasperreports.olap.mapping.MappingParser;
import net.sf.jasperreports.olap.mapping.Member;
import net.sf.jasperreports.olap.mapping.MemberDepth;
import net.sf.jasperreports.olap.mapping.MemberMapping;
import net.sf.jasperreports.olap.mapping.MemberProperty;
import net.sf.jasperreports.olap.mapping.Tuple;
import net.sf.jasperreports.olap.mapping.TuplePosition;
import net.sf.jasperreports.olap.result.JROlapCell;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapHierarchyLevel;
import net.sf.jasperreports.olap.result.JROlapMember;
import net.sf.jasperreports.olap.result.JROlapMemberTuple;
import net.sf.jasperreports.olap.result.JROlapResult;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JROlapDataSource
implements JRDataSource,
MappingMetadata {
    private static final Log log = LogFactory.getLog(a == null ? (a = JROlapDataSource.a("net.sf.jasperreports.olap.JROlapDataSource")) : a);
    public final JROlapResult olapResult;
    public JROlapResultAxis[] axes;
    public final JROlapHierarchy[][] queryHierarchies;
    public final int hierarchiesCount;
    public Map fieldMatchers;
    public int[][] fieldsMaxDepths;
    public boolean[] iteratePositions;
    public boolean iterate;
    public boolean dataField;
    public Map fieldValues;
    public int[] axisPositions;
    public boolean first;
    public int[][] maxDepths;
    public static Class a;

    public JROlapDataSource(JRDataset jRDataset, JROlapResult jROlapResult) {
        this.olapResult = jROlapResult;
        this.axes = jROlapResult.getAxes();
        this.queryHierarchies = new JROlapHierarchy[this.axes.length][];
        this.fieldsMaxDepths = new int[this.axes.length][];
        this.maxDepths = new int[this.axes.length][];
        int n2 = 0;
        for (int i2 = 0; i2 < this.axes.length; ++i2) {
            this.queryHierarchies[i2] = this.axes[i2].getHierarchiesOnAxis();
            n2 += this.queryHierarchies[i2].length;
            this.fieldsMaxDepths[i2] = new int[this.queryHierarchies[i2].length];
            this.maxDepths[i2] = new int[this.queryHierarchies[i2].length];
        }
        this.hierarchiesCount = n2;
        this.axisPositions = new int[this.axes.length];
        this.init(jRDataset);
    }

    public boolean next() throws JRException {
        boolean bl2;
        boolean bl3;
        block0: do {
            if (this.iterate) {
                bl2 = this.nextPositions();
            } else {
                bl2 = this.first;
                this.first = false;
            }
            if (!bl2) break;
            this.resetMaxDepths();
            Iterator iterator = this.fieldMatchers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                FieldMatcher fieldMatcher = (FieldMatcher)entry.getValue();
                if (!fieldMatcher.matches()) continue;
                Object object = fieldMatcher.value();
                this.fieldValues.put(k2, object);
            }
            bl3 = true;
            for (int i2 = 0; i2 < this.axes.length; ++i2) {
                if (!this.iteratePositions[i2]) continue;
                for (int i3 = 0; i3 < this.fieldsMaxDepths[i2].length; ++i3) {
                    if (this.maxDepths[i2][i3] >= this.fieldsMaxDepths[i2][i3]) continue;
                    bl3 = false;
                    continue block0;
                }
            }
        } while (!bl3);
        return bl2;
    }

    private void resetMaxDepths() {
        for (int i2 = 0; i2 < this.axes.length; ++i2) {
            if (!this.iteratePositions[i2]) continue;
            for (int i3 = 0; i3 < this.maxDepths[i2].length; ++i3) {
                this.maxDepths[i2][i3] = 0;
            }
        }
    }

    public boolean nextPositions() {
        int n2;
        for (n2 = 0; n2 < this.axes.length; ++n2) {
            if (!this.iteratePositions[n2]) continue;
            int n3 = n2;
            this.axisPositions[n3] = this.axisPositions[n3] + 1;
            if (this.axisPositions[n2] < this.axes[n2].getTupleCount()) break;
            this.axisPositions[n2] = 0;
        }
        boolean bl2 = n2 < this.axes.length;
        return bl2;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        return this.fieldValues.get(jRField.getName());
    }

    private void init(JRDataset jRDataset) {
        this.iteratePositions = new boolean[this.axes.length];
        this.fieldMatchers = new HashMap();
        this.dataField = false;
        JRField[] jRFieldArray = jRDataset.getFields();
        if (jRFieldArray != null) {
            for (int i2 = 0; i2 < jRFieldArray.length; ++i2) {
                Mapping mapping;
                JRField jRField = jRFieldArray[i2];
                String string = this.getFieldMapping(jRField);
                MappingLexer mappingLexer = new MappingLexer(new StringReader(string));
                MappingParser mappingParser = new MappingParser(mappingLexer);
                mappingParser.setMappingMetadata(this);
                try {
                    mapping = mappingParser.mapping();
                }
                catch (ANTLRException aNTLRException) {
                    log.error("Error parsing field mapping", aNTLRException);
                    throw new JRRuntimeException(aNTLRException);
                }
                if (mapping == null) {
                    throw new JRRuntimeException("Invalid field mapping \"" + string + "\".");
                }
                this.processMappingMembers(mapping);
                FieldMatcher fieldMatcher = this.createFieldMatcher(mapping);
                this.fieldMatchers.put(jRField.getName(), fieldMatcher);
            }
        }
        if (!this.dataField) {
            Arrays.fill(this.iteratePositions, true);
        }
        this.initIterate();
    }

    private void processMappingMembers(Mapping mapping) {
        Iterator iterator = mapping.memberMappings();
        while (iterator.hasNext()) {
            Member member = (Member)iterator.next();
            this.processMemberInfo(member);
        }
    }

    private FieldMatcher createFieldMatcher(Mapping mapping) {
        FieldMatcher fieldMatcher;
        if (mapping instanceof MemberMapping) {
            fieldMatcher = new MemberFieldMatcher(this, (MemberMapping)mapping);
        } else if (mapping instanceof DataMapping) {
            this.dataField = true;
            fieldMatcher = new DataFieldMatcher(this, (DataMapping)mapping);
        } else {
            throw new JRRuntimeException("internal error");
        }
        return fieldMatcher;
    }

    public String getFieldMapping(JRField jRField) {
        return jRField.getDescription();
    }

    private void initIterate() {
        int n2;
        for (n2 = 0; n2 < this.axes.length && !this.iteratePositions[n2]; ++n2) {
        }
        if (n2 < this.axes.length) {
            this.iterate = true;
            this.axisPositions[n2] = -1;
        } else {
            this.iterate = false;
            this.first = true;
        }
        this.fieldValues = new HashMap();
    }

    public void processMemberInfo(Member member) {
        int n2;
        int n3;
        int n4;
        MemberDepth memberDepth = member.getDepth();
        if (memberDepth != null && (n4 = memberDepth.getDepth()) > this.fieldsMaxDepths[n3 = member.getAxis().getIdx()][n2 = member.getPosition().getIdx()]) {
            this.fieldsMaxDepths[n3][n2] = n4;
        }
    }

    public int getDimensionIndex(Axis axis, String string) {
        JROlapHierarchy[] jROlapHierarchyArray = this.axes[axis.getIdx()].getHierarchiesOnAxis();
        int n2 = -1;
        for (int i2 = 0; i2 < jROlapHierarchyArray.length; ++i2) {
            JROlapHierarchy jROlapHierarchy = jROlapHierarchyArray[i2];
            if (!string.equals(jROlapHierarchy.getDimensionName())) continue;
            n2 = i2;
        }
        if (n2 == -1) {
            throw new JRRuntimeException("Could not find dimension \"" + string + "\" on axis " + axis.getIdx() + ".");
        }
        return n2;
    }

    public int getLevelDepth(TuplePosition tuplePosition, String string) {
        JROlapHierarchy jROlapHierarchy = this.axes[tuplePosition.getAxis().getIdx()].getHierarchiesOnAxis()[tuplePosition.getIdx()];
        JROlapHierarchyLevel[] jROlapHierarchyLevelArray = jROlapHierarchy.getLevels();
        int n2 = -1;
        for (int i2 = 0; i2 < jROlapHierarchyLevelArray.length; ++i2) {
            JROlapHierarchyLevel jROlapHierarchyLevel = jROlapHierarchyLevelArray[i2];
            if (jROlapHierarchyLevel == null || !jROlapHierarchyLevel.getName().equals(string)) continue;
            n2 = jROlapHierarchyLevel.getDepth();
            break;
        }
        if (n2 == -1) {
            throw new JRRuntimeException("Could not find level \"" + string + "\" on hierarchy #" + tuplePosition.getIdx() + " (dimension " + jROlapHierarchy.getDimensionName() + ") on axis #" + tuplePosition.getAxis().getIdx());
        }
        return n2;
    }

    public void setMatchMemberDepth(Member member, JROlapMember jROlapMember) {
        int n2;
        int n3 = jROlapMember.getDepth();
        int n4 = member.getAxis().getIdx();
        if (this.maxDepths[n4][n2 = member.getPosition().getIdx()] < n3) {
            this.maxDepths[n4][n2] = n3;
        }
    }

    public int getTuplePosition(int n2, Tuple tuple) {
        if (n2 > this.axes.length) {
            throw new JRRuntimeException("OLAP result doesn't contain Axis(" + n2 + ").");
        }
        String[] stringArray = tuple.getMemberUniqueNames();
        JROlapResultAxis jROlapResultAxis = this.axes[n2];
        int n3 = jROlapResultAxis.getTupleCount();
        int n4 = -1;
        for (int i2 = 0; i2 < n3; ++i2) {
            JROlapMemberTuple jROlapMemberTuple = jROlapResultAxis.getTuple(i2);
            JROlapMember[] jROlapMemberArray = jROlapMemberTuple.getMembers();
            if (jROlapMemberArray.length != stringArray.length) continue;
            boolean bl2 = true;
            for (int i3 = 0; bl2 && i3 < jROlapMemberArray.length; ++i3) {
                if (stringArray[i3].equals(jROlapMemberArray[i3].getUniqueName())) continue;
                bl2 = false;
            }
            if (!bl2) continue;
            n4 = i2;
            break;
        }
        if (n4 == -1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            for (int i4 = 0; i4 < stringArray.length; ++i4) {
                if (i4 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[i4]);
            }
            throw new JRRuntimeException("No such tuple " + stringBuffer + " on axis " + n2 + ".");
        }
        return n4;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class DataFieldMatcher
    extends FieldMatcher {
        private final boolean formatted;
        private final int[] dataPositions;
        private final Member[] members;
        private int[] positions;
        private final JROlapDataSource this$0;

        public DataFieldMatcher(JROlapDataSource jROlapDataSource, DataMapping dataMapping) {
            super(jROlapDataSource);
            this.this$0 = jROlapDataSource;
            this.formatted = dataMapping.isFormatted();
            List list = dataMapping.getPositions();
            if (list == null) {
                this.dataPositions = null;
                this.positions = jROlapDataSource.axisPositions;
            } else {
                if (list.size() != jROlapDataSource.axes.length) {
                    throw new JRRuntimeException("Incorrect data mapping: the number of positions doesn't match the number of axes.");
                }
                this.dataPositions = new int[jROlapDataSource.axes.length];
                int n2 = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int n3;
                    AxisPosition axisPosition = (AxisPosition)iterator.next();
                    if (axisPosition.isSpecified()) {
                        n3 = axisPosition.getPosition();
                    } else {
                        n3 = -1;
                        jROlapDataSource.iteratePositions[n2] = true;
                    }
                    this.dataPositions[n2] = n3;
                    ++n2;
                }
            }
            List list2 = dataMapping.getFilter();
            if (list2 == null || list2.isEmpty()) {
                this.members = null;
            } else {
                this.members = new Member[list2.size()];
                list2.toArray(this.members);
            }
        }

        public boolean matches() {
            if (this.dataPositions != null) {
                this.a();
            }
            boolean bl2 = true;
            if (this.members != null) {
                for (int i2 = 0; i2 < this.members.length; ++i2) {
                    Member member = this.members[i2];
                    JROlapMember jROlapMember = this.member(member, this.positions);
                    this.this$0.setMatchMemberDepth(member, jROlapMember);
                    if (member.matches(jROlapMember)) continue;
                    bl2 = false;
                    break;
                }
            }
            return bl2;
        }

        public Object value() {
            JROlapCell jROlapCell = this.this$0.olapResult.getCell(this.positions);
            if (jROlapCell != null && jROlapCell.isError()) {
                throw new JRRuntimeException("OLAP cell calculation returned error.");
            }
            Object object = jROlapCell == null || jROlapCell.isNull() ? null : (this.formatted ? jROlapCell.getFormattedValue() : jROlapCell.getValue());
            return object;
        }

        public void a() {
            this.positions = new int[this.this$0.axes.length];
            for (int i2 = 0; i2 < this.this$0.axes.length; ++i2) {
                int n2 = this.dataPositions[i2];
                this.positions[i2] = n2 == -1 ? this.this$0.axisPositions[i2] : n2;
            }
        }
    }

    protected class MemberFieldMatcher
    extends FieldMatcher {
        public final Member a;
        public final MemberProperty b;
        public JROlapMember c;
        private final JROlapDataSource this$0;

        public MemberFieldMatcher(JROlapDataSource jROlapDataSource, MemberMapping memberMapping) {
            super(jROlapDataSource);
            this.this$0 = jROlapDataSource;
            this.a = memberMapping.getMember();
            this.b = memberMapping.getProperty();
        }

        public boolean matches() {
            this.c = this.member(this.a, this.this$0.axisPositions);
            this.this$0.setMatchMemberDepth(this.a, this.c);
            this.c = this.a.ancestorMatch(this.c);
            return this.c != null;
        }

        public Object value() {
            Object object = this.b != null ? this.c.getPropertyValue(this.b.getName()) : (this.a.getDepth() == null ? this.c.getMondrianMember() : this.c.getName());
            return object;
        }
    }

    protected abstract class FieldMatcher {
        private final JROlapDataSource this$0;

        public FieldMatcher(JROlapDataSource jROlapDataSource) {
            this.this$0 = jROlapDataSource;
        }

        public abstract boolean matches();

        public abstract Object value();

        public final JROlapMember member(Member member, int[] nArray) {
            int n2 = member.getAxis().getIdx();
            JROlapResultAxis jROlapResultAxis = this.this$0.axes[n2];
            JROlapMemberTuple jROlapMemberTuple = jROlapResultAxis.getTuple(nArray[n2]);
            JROlapMember[] jROlapMemberArray = jROlapMemberTuple.getMembers();
            int n3 = member.getPosition().getIdx();
            return jROlapMemberArray[n3];
        }
    }
}

