/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlBaseWriter;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import net.sf.jasperreports.engine.xml.XmlWriterVisitor;
import org.jfree.chart.plot.PlotOrientation;

public class JRXmlWriter
extends JRXmlBaseWriter {
    private JRReport report = null;
    private String encoding = null;
    private Map fontsMap = new HashMap();
    private XmlWriterVisitor xmlWriterVisitor = new XmlWriterVisitor(this);
    public static Class a;
    public static Class b;

    public JRXmlWriter(JRReport jRReport, String string) {
        this.report = jRReport;
        this.encoding = string;
    }

    public static String writeReport(JRReport jRReport, String string) {
        JRXmlWriter jRXmlWriter = new JRXmlWriter(jRReport, string);
        StringWriter stringWriter = new StringWriter();
        try {
            jRXmlWriter.writeReport(stringWriter);
        }
        catch (IOException iOException) {
            throw new JRRuntimeException("Error writing report design.", iOException);
        }
        return stringWriter.toString();
    }

    public static void writeReport(JRReport jRReport, String string, String string2) throws JRException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            JRXmlWriter jRXmlWriter = new JRXmlWriter(jRReport, string2);
            jRXmlWriter.writeReport(outputStreamWriter);
        }
        catch (IOException iOException) {
            throw new JRException("Error writing to file : " + string, iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeReport(JRReport jRReport, OutputStream outputStream, String string) throws JRException {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            JRXmlWriter jRXmlWriter = new JRXmlWriter(jRReport, string);
            jRXmlWriter.writeReport(outputStreamWriter);
        }
        catch (Exception exception) {
            throw new JRException("Error writing to OutputStream : " + jRReport.getName(), exception);
        }
    }

    public void writeReport(Writer writer) throws IOException {
        JRDataset[] jRDatasetArray;
        JRStyle[] jRStyleArray;
        this.useWriter(new JRXmlWriteHelper(writer));
        this.writer.writeProlog(this.encoding);
        this.writer.writePublicDoctype("jasperReport", "-//JasperReports//DTD JasperReport//EN", "http://jasperreports.sourceforge.net/dtds/jasperreport.dtd");
        this.writer.startElement("jasperReport");
        this.writer.addEncodedAttribute("name", this.report.getName());
        this.writer.addEncodedAttribute("language", this.report.getLanguage(), "java");
        this.writer.addAttribute("columnCount", this.report.getColumnCount(), 1);
        this.writer.addAttribute("printOrder", this.report.getPrintOrder(), JRXmlConstants.getPrintOrderMap(), (byte)1);
        this.writer.addAttribute("pageWidth", this.report.getPageWidth());
        this.writer.addAttribute("pageHeight", this.report.getPageHeight());
        this.writer.addAttribute("orientation", this.report.getOrientation(), JRXmlConstants.getOrientationMap(), (byte)1);
        this.writer.addAttribute("whenNoDataType", this.report.getWhenNoDataType(), JRXmlConstants.getWhenNoDataTypeMap(), (byte)1);
        this.writer.addAttribute("columnWidth", this.report.getColumnWidth());
        this.writer.addAttribute("columnSpacing", this.report.getColumnSpacing(), 0);
        this.writer.addAttribute("leftMargin", this.report.getLeftMargin());
        this.writer.addAttribute("rightMargin", this.report.getRightMargin());
        this.writer.addAttribute("topMargin", this.report.getTopMargin());
        this.writer.addAttribute("bottomMargin", this.report.getBottomMargin());
        this.writer.addAttribute("isTitleNewPage", this.report.isTitleNewPage(), false);
        this.writer.addAttribute("isSummaryNewPage", this.report.isSummaryNewPage(), false);
        this.writer.addAttribute("isFloatColumnFooter", this.report.isFloatColumnFooter(), false);
        this.writer.addAttribute("scriptletClass", this.report.getScriptletClass());
        this.writer.addAttribute("formatFactoryClass", this.report.getFormatFactoryClass());
        this.writer.addEncodedAttribute("resourceBundle", this.report.getResourceBundle());
        this.writer.addAttribute("whenResourceMissingType", this.report.getWhenResourceMissingType(), JRXmlConstants.getWhenResourceMissingTypeMap(), (byte)1);
        this.writer.addAttribute("isIgnorePagination", this.report.isIgnorePagination(), false);
        this.writeProperties(this.report);
        String[] stringArray = this.report.getImports();
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                if (string == null) continue;
                this.writer.startElement("import");
                this.writer.addEncodedAttribute("value", string);
                this.writer.closeElement();
            }
        }
        this.writeTemplates();
        JRReportFont[] jRReportFontArray = this.report.getFonts();
        if (jRReportFontArray != null && jRReportFontArray.length > 0) {
            for (int i3 = 0; i3 < jRReportFontArray.length; ++i3) {
                this.fontsMap.put(jRReportFontArray[i3].getName(), jRReportFontArray[i3]);
                this.writeReportFont(jRReportFontArray[i3]);
            }
        }
        if ((jRStyleArray = this.report.getStyles()) != null && jRStyleArray.length > 0) {
            for (int i4 = 0; i4 < jRStyleArray.length; ++i4) {
                this.writeStyle(jRStyleArray[i4]);
            }
        }
        if ((jRDatasetArray = this.report.getDatasets()) != null && jRDatasetArray.length > 0) {
            for (int i5 = 0; i5 < jRDatasetArray.length; ++i5) {
                this.writeDataset(jRDatasetArray[i5]);
            }
        }
        this.writeDatasetContents(this.report.getMainDataset());
        if (this.report.getBackground() != null) {
            this.writer.startElement("background");
            this.writeBand(this.report.getBackground());
            this.writer.closeElement();
        }
        if (this.report.getTitle() != null) {
            this.writer.startElement("title");
            this.writeBand(this.report.getTitle());
            this.writer.closeElement();
        }
        if (this.report.getPageHeader() != null) {
            this.writer.startElement("pageHeader");
            this.writeBand(this.report.getPageHeader());
            this.writer.closeElement();
        }
        if (this.report.getColumnHeader() != null) {
            this.writer.startElement("columnHeader");
            this.writeBand(this.report.getColumnHeader());
            this.writer.closeElement();
        }
        if (this.report.getDetail() != null) {
            this.writer.startElement("detail");
            this.writeBand(this.report.getDetail());
            this.writer.closeElement();
        }
        if (this.report.getColumnFooter() != null) {
            this.writer.startElement("columnFooter");
            this.writeBand(this.report.getColumnFooter());
            this.writer.closeElement();
        }
        if (this.report.getPageFooter() != null) {
            this.writer.startElement("pageFooter");
            this.writeBand(this.report.getPageFooter());
            this.writer.closeElement();
        }
        if (this.report.getLastPageFooter() != null) {
            this.writer.startElement("lastPageFooter");
            this.writeBand(this.report.getLastPageFooter());
            this.writer.closeElement();
        }
        if (this.report.getSummary() != null) {
            this.writer.startElement("summary");
            this.writeBand(this.report.getSummary());
            this.writer.closeElement();
        }
        if (this.report.getNoData() != null) {
            this.writer.startElement("noData");
            this.writeBand(this.report.getNoData());
            this.writer.closeElement();
        }
        this.writer.closeElement();
        writer.flush();
    }

    private void writeProperties(JRPropertiesHolder jRPropertiesHolder) throws IOException {
        JRPropertiesMap jRPropertiesMap;
        String[] stringArray;
        if (jRPropertiesHolder.hasProperties() && (stringArray = (jRPropertiesMap = jRPropertiesHolder.getPropertiesMap()).getPropertyNames()) != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.writer.startElement("property");
                this.writer.addEncodedAttribute("name", stringArray[i2]);
                String string = jRPropertiesMap.getProperty(stringArray[i2]);
                if (string != null) {
                    this.writer.addEncodedAttribute("value", string);
                }
                this.writer.closeElement();
            }
        }
    }

    public void writeTemplates() throws IOException {
        JRReportTemplate[] jRReportTemplateArray = this.report.getTemplates();
        if (jRReportTemplateArray != null) {
            for (int i2 = 0; i2 < jRReportTemplateArray.length; ++i2) {
                JRReportTemplate jRReportTemplate = jRReportTemplateArray[i2];
                this.writeTemplate(jRReportTemplate);
            }
        }
    }

    public void writeTemplate(JRReportTemplate jRReportTemplate) throws IOException {
        this.writer.writeExpression("template", jRReportTemplate.getSourceExpression(), true, (a == null ? (a = JRXmlWriter.a("java.lang.String")) : a).getName());
    }

    private void writeReportFont(JRReportFont jRReportFont) throws IOException {
        this.writer.startElement("reportFont");
        this.writer.addEncodedAttribute("name", jRReportFont.getName());
        this.writer.addAttribute("isDefault", jRReportFont.isDefault());
        this.writer.addEncodedAttribute("fontName", jRReportFont.getOwnFontName());
        this.writer.addAttribute("size", jRReportFont.getOwnFontSize());
        this.writer.addAttribute("isBold", jRReportFont.isOwnBold());
        this.writer.addAttribute("isItalic", jRReportFont.isOwnItalic());
        this.writer.addAttribute("isUnderline", jRReportFont.isOwnUnderline());
        this.writer.addAttribute("isStrikeThrough", jRReportFont.isOwnStrikeThrough());
        this.writer.addEncodedAttribute("pdfFontName", jRReportFont.getOwnPdfFontName());
        this.writer.addEncodedAttribute("pdfEncoding", jRReportFont.getOwnPdfEncoding());
        this.writer.addAttribute("isPdfEmbedded", jRReportFont.isOwnPdfEmbedded());
        this.writer.closeElement();
    }

    private void writeParameter(JRParameter jRParameter) throws IOException {
        this.writer.startElement("parameter");
        this.writer.addEncodedAttribute("name", jRParameter.getName());
        this.writer.addAttribute("class", jRParameter.getValueClassName());
        this.writer.addAttribute("isForPrompting", jRParameter.isForPrompting(), true);
        this.writeProperties(jRParameter);
        this.writer.writeCDATAElement("parameterDescription", jRParameter.getDescription());
        this.writer.writeExpression("defaultValueExpression", jRParameter.getDefaultValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeQuery(JRQuery jRQuery) throws IOException {
        this.writer.startElement("queryString");
        this.writer.addEncodedAttribute("language", jRQuery.getLanguage(), "sql");
        this.writer.writeCDATA(jRQuery.getText());
        this.writer.closeElement();
    }

    private void writeField(JRField jRField) throws IOException {
        this.writer.startElement("field");
        this.writer.addEncodedAttribute("name", jRField.getName());
        this.writer.addAttribute("class", jRField.getValueClassName());
        this.writeProperties(jRField);
        this.writer.writeCDATAElement("fieldDescription", jRField.getDescription());
        this.writer.closeElement();
    }

    private void writeSortField(JRSortField jRSortField) throws IOException {
        this.writer.startElement("sortField");
        this.writer.addEncodedAttribute("name", jRSortField.getName());
        this.writer.addAttribute("order", jRSortField.getOrder(), JRXmlConstants.getSortOrderMap(), (byte)0);
        this.writer.closeElement();
    }

    private void writeVariable(JRVariable jRVariable) throws IOException {
        this.writer.startElement("variable");
        this.writer.addEncodedAttribute("name", jRVariable.getName());
        this.writer.addAttribute("class", jRVariable.getValueClassName());
        this.writer.addAttribute("resetType", jRVariable.getResetType(), JRXmlConstants.getResetTypeMap(), (byte)1);
        if (jRVariable.getResetGroup() != null) {
            this.writer.addEncodedAttribute("resetGroup", jRVariable.getResetGroup().getName());
        }
        this.writer.addAttribute("incrementType", jRVariable.getIncrementType(), JRXmlConstants.getResetTypeMap(), (byte)5);
        if (jRVariable.getIncrementGroup() != null) {
            this.writer.addEncodedAttribute("incrementGroup", jRVariable.getIncrementGroup().getName());
        }
        this.writer.addAttribute("calculation", jRVariable.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("incrementerFactoryClass", jRVariable.getIncrementerFactoryClassName());
        this.writer.writeExpression("variableExpression", jRVariable.getExpression(), false);
        this.writer.writeExpression("initialValueExpression", jRVariable.getInitialValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeGroup(JRGroup jRGroup) throws IOException {
        this.writer.startElement("group");
        this.writer.addEncodedAttribute("name", jRGroup.getName());
        this.writer.addAttribute("isStartNewColumn", jRGroup.isStartNewColumn(), false);
        this.writer.addAttribute("isStartNewPage", jRGroup.isStartNewPage(), false);
        this.writer.addAttribute("isResetPageNumber", jRGroup.isResetPageNumber(), false);
        this.writer.addAttribute("isReprintHeaderOnEachPage", jRGroup.isReprintHeaderOnEachPage(), false);
        this.writer.addAttributePositive("minHeightToStartNewPage", jRGroup.getMinHeightToStartNewPage());
        this.writer.writeExpression("groupExpression", jRGroup.getExpression(), false);
        if (jRGroup.getGroupHeader() != null) {
            this.writer.startElement("groupHeader");
            this.writeBand(jRGroup.getGroupHeader());
            this.writer.closeElement();
        }
        if (jRGroup.getGroupFooter() != null) {
            this.writer.startElement("groupFooter");
            this.writeBand(jRGroup.getGroupFooter());
            this.writer.closeElement();
        }
        this.writer.closeElement();
    }

    private void writeBand(JRBand jRBand) throws IOException {
        this.writer.startElement("band");
        this.writer.addAttributePositive("height", jRBand.getHeight());
        this.writer.addAttribute("isSplitAllowed", jRBand.isSplitAllowed(), true);
        this.writer.writeExpression("printWhenExpression", jRBand.getPrintWhenExpression(), false);
        List list = jRBand.getChildren();
        if (list != null && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ((JRChild)list.get(i2)).visit(this.xmlWriterVisitor);
            }
        }
        this.writer.closeElement();
    }

    public void writeElementGroup(JRElementGroup jRElementGroup) throws IOException {
        this.writer.startElement("elementGroup");
        List list = jRElementGroup.getChildren();
        if (list != null && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ((JRChild)list.get(i2)).visit(this.xmlWriterVisitor);
            }
        }
        this.writer.closeElement();
    }

    public void writeBreak(JRBreak jRBreak) throws IOException {
        this.writer.startElement("break");
        this.writer.addAttribute("type", jRBreak.getType(), JRXmlConstants.getBreakTypeMap(), (byte)1);
        this.writeReportElement(jRBreak);
        this.writer.closeElement();
    }

    public void writeLine(JRLine jRLine) throws IOException {
        this.writer.startElement("line");
        this.writer.addAttribute("direction", jRLine.getDirection(), JRXmlConstants.getDirectionMap(), (byte)1);
        this.writeReportElement(jRLine);
        this.writeGraphicElement(jRLine);
        this.writer.closeElement();
    }

    private void writeReportElement(JRElement jRElement) throws IOException {
        this.writer.startElement("reportElement");
        this.writer.addEncodedAttribute("key", jRElement.getKey());
        this.writeStyleReferenceAttr(jRElement);
        this.writer.addAttribute("positionType", jRElement.getPositionType(), JRXmlConstants.getPositionTypeMap(), (byte)2);
        this.writer.addAttribute("stretchType", jRElement.getStretchType(), JRXmlConstants.getStretchTypeMap(), (byte)0);
        this.writer.addAttribute("isPrintRepeatedValues", jRElement.isPrintRepeatedValues(), true);
        this.writer.addAttribute("mode", jRElement.getOwnMode(), JRXmlConstants.getModeMap());
        this.writer.addAttribute("x", jRElement.getX());
        this.writer.addAttribute("y", jRElement.getY());
        this.writer.addAttribute("width", jRElement.getWidth());
        this.writer.addAttribute("height", jRElement.getHeight());
        this.writer.addAttribute("isRemoveLineWhenBlank", jRElement.isRemoveLineWhenBlank(), false);
        this.writer.addAttribute("isPrintInFirstWholeBand", jRElement.isPrintInFirstWholeBand(), false);
        this.writer.addAttribute("isPrintWhenDetailOverflows", jRElement.isPrintWhenDetailOverflows(), false);
        if (jRElement.getPrintWhenGroupChanges() != null) {
            this.writer.addEncodedAttribute("printWhenGroupChanges", jRElement.getPrintWhenGroupChanges().getName());
        }
        this.writer.addAttribute("forecolor", jRElement.getOwnForecolor());
        this.writer.addAttribute("backcolor", jRElement.getOwnBackcolor());
        this.writeProperties(jRElement);
        this.writer.writeExpression("printWhenExpression", jRElement.getPrintWhenExpression(), false);
        this.writer.closeElement();
    }

    private void writeGraphicElement(JRGraphicElement jRGraphicElement) throws IOException {
        this.writer.startElement("graphicElement");
        this.writer.addAttribute("fill", jRGraphicElement.getOwnFill(), JRXmlConstants.getFillMap());
        this.writePen(jRGraphicElement.getLinePen());
        this.writer.closeElement(true);
    }

    public void writeRectangle(JRRectangle jRRectangle) throws IOException {
        this.writer.startElement("rectangle");
        this.writer.addAttribute("radius", jRRectangle.getOwnRadius());
        this.writeReportElement(jRRectangle);
        this.writeGraphicElement(jRRectangle);
        this.writer.closeElement();
    }

    public void writeEllipse(JREllipse jREllipse) throws IOException {
        this.writer.startElement("ellipse");
        this.writeReportElement(jREllipse);
        this.writeGraphicElement(jREllipse);
        this.writer.closeElement();
    }

    public void writeImage(JRImage jRImage) throws IOException {
        this.writer.startElement("image");
        this.writer.addAttribute("scaleImage", jRImage.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.writer.addAttribute("hAlign", jRImage.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("vAlign", jRImage.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("isUsingCache", jRImage.isOwnUsingCache());
        this.writer.addAttribute("isLazy", jRImage.isLazy(), false);
        this.writer.addAttribute("onErrorType", jRImage.getOnErrorType(), JRXmlConstants.getOnErrorTypeMap(), (byte)1);
        this.writer.addAttribute("evaluationTime", jRImage.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (jRImage.getEvaluationGroup() != null) {
            this.writer.addEncodedAttribute("evaluationGroup", jRImage.getEvaluationGroup().getName());
        }
        this.writer.addEncodedAttribute("hyperlinkType", jRImage.getLinkType());
        this.writer.addAttribute("hyperlinkTarget", jRImage.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.writer.addAttribute("bookmarkLevel", jRImage.getBookmarkLevel(), 0);
        this.writeReportElement(jRImage);
        this.writeBox(jRImage.getLineBox());
        this.writeGraphicElement(jRImage);
        this.writer.writeExpression("imageExpression", jRImage.getExpression(), true);
        this.writer.writeExpression("anchorNameExpression", jRImage.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", jRImage.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", jRImage.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", jRImage.getHyperlinkPageExpression(), false);
        this.writer.writeExpression("hyperlinkTooltipExpression", jRImage.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(jRImage.getHyperlinkParameters());
        this.writer.closeElement();
    }

    public void writeStaticText(JRStaticText jRStaticText) throws IOException {
        this.writer.startElement("staticText");
        this.writeReportElement(jRStaticText);
        this.writeBox(jRStaticText.getLineBox());
        this.writeTextElement(jRStaticText);
        this.writer.writeCDATAElement("text", jRStaticText.getText());
        this.writer.closeElement();
    }

    private void writeTextElement(JRTextElement jRTextElement) throws IOException {
        this.writer.startElement("textElement");
        this.writer.addAttribute("textAlignment", jRTextElement.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("verticalAlignment", jRTextElement.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("rotation", jRTextElement.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.writer.addAttribute("lineSpacing", jRTextElement.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.writer.addAttribute("isStyledText", jRTextElement.isOwnStyledText());
        this.writeFont(jRTextElement);
        this.writer.closeElement();
    }

    private void writeFont(JRFont jRFont) throws IOException {
        if (jRFont != null) {
            this.writer.startElement("font");
            if (jRFont.getReportFont() != null) {
                JRFont jRFont2 = (JRFont)this.fontsMap.get(jRFont.getReportFont().getName());
                if (jRFont2 != null) {
                    this.writer.addEncodedAttribute("reportFont", jRFont.getReportFont().getName());
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + jRFont.getReportFont().getName());
                }
            }
            this.writer.addEncodedAttribute("fontName", jRFont.getOwnFontName());
            this.writer.addAttribute("size", jRFont.getOwnFontSize());
            this.writer.addAttribute("isBold", jRFont.isOwnBold());
            this.writer.addAttribute("isItalic", jRFont.isOwnItalic());
            this.writer.addAttribute("isUnderline", jRFont.isOwnUnderline());
            this.writer.addAttribute("isStrikeThrough", jRFont.isOwnStrikeThrough());
            this.writer.addEncodedAttribute("pdfFontName", jRFont.getOwnPdfFontName());
            this.writer.addEncodedAttribute("pdfEncoding", jRFont.getOwnPdfEncoding());
            this.writer.addAttribute("isPdfEmbedded", jRFont.isOwnPdfEmbedded());
            this.writer.closeElement(true);
        }
    }

    public void writeTextField(JRTextField jRTextField) throws IOException {
        this.writer.startElement("textField");
        this.writer.addAttribute("isStretchWithOverflow", jRTextField.isStretchWithOverflow(), false);
        this.writer.addAttribute("evaluationTime", jRTextField.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (jRTextField.getEvaluationGroup() != null) {
            this.writer.addEncodedAttribute("evaluationGroup", jRTextField.getEvaluationGroup().getName());
        }
        this.writer.addEncodedAttribute("pattern", jRTextField.getOwnPattern());
        this.writer.addAttribute("isBlankWhenNull", jRTextField.isOwnBlankWhenNull());
        this.writer.addEncodedAttribute("hyperlinkType", jRTextField.getLinkType());
        this.writer.addAttribute("hyperlinkTarget", jRTextField.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.writer.addAttribute("bookmarkLevel", jRTextField.getBookmarkLevel(), 0);
        this.writeReportElement(jRTextField);
        this.writeBox(jRTextField.getLineBox());
        this.writeTextElement(jRTextField);
        this.writer.writeExpression("textFieldExpression", jRTextField.getExpression(), true);
        this.writer.writeExpression("anchorNameExpression", jRTextField.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", jRTextField.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", jRTextField.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", jRTextField.getHyperlinkPageExpression(), false);
        this.writer.writeExpression("hyperlinkTooltipExpression", jRTextField.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(jRTextField.getHyperlinkParameters());
        this.writer.closeElement();
    }

    public void writeSubreport(JRSubreport jRSubreport) throws IOException {
        this.writer.startElement("subreport");
        this.writer.addAttribute("isUsingCache", jRSubreport.isOwnUsingCache());
        this.writeReportElement(jRSubreport);
        this.writer.writeExpression("parametersMapExpression", jRSubreport.getParametersMapExpression(), false);
        JRSubreportParameter[] jRSubreportParameterArray = jRSubreport.getParameters();
        if (jRSubreportParameterArray != null && jRSubreportParameterArray.length > 0) {
            for (int i2 = 0; i2 < jRSubreportParameterArray.length; ++i2) {
                this.writeSubreportParameter(jRSubreportParameterArray[i2]);
            }
        }
        this.writer.writeExpression("connectionExpression", jRSubreport.getConnectionExpression(), false);
        this.writer.writeExpression("dataSourceExpression", jRSubreport.getDataSourceExpression(), false);
        JRSubreportReturnValue[] jRSubreportReturnValueArray = jRSubreport.getReturnValues();
        if (jRSubreportReturnValueArray != null && jRSubreportReturnValueArray.length > 0) {
            for (int i3 = 0; i3 < jRSubreportReturnValueArray.length; ++i3) {
                this.writeSubreportReturnValue(jRSubreportReturnValueArray[i3]);
            }
        }
        this.writer.writeExpression("subreportExpression", jRSubreport.getExpression(), true);
        this.writer.closeElement();
    }

    private void writeSubreportParameter(JRSubreportParameter jRSubreportParameter) throws IOException {
        this.writer.startElement("subreportParameter");
        this.writer.addEncodedAttribute("name", jRSubreportParameter.getName());
        this.writer.writeExpression("subreportParameterExpression", jRSubreportParameter.getExpression(), false);
        this.writer.closeElement();
    }

    private void writeDatasetParameter(JRDatasetParameter jRDatasetParameter) throws IOException {
        this.writer.startElement("datasetParameter");
        this.writer.addEncodedAttribute("name", jRDatasetParameter.getName());
        this.writer.writeExpression("datasetParameterExpression", jRDatasetParameter.getExpression(), false);
        this.writer.closeElement();
    }

    private void writeChart(JRChart jRChart) throws IOException {
        this.writer.startElement("chart");
        this.writer.addAttribute("isShowLegend", jRChart.isShowLegend(), true);
        this.writer.addAttribute("evaluationTime", jRChart.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (jRChart.getEvaluationTime() == 5) {
            this.writer.addEncodedAttribute("evaluationGroup", jRChart.getEvaluationGroup().getName());
        }
        this.writer.addEncodedAttribute("hyperlinkType", jRChart.getLinkType());
        this.writer.addAttribute("hyperlinkTarget", jRChart.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.writer.addAttribute("bookmarkLevel", jRChart.getBookmarkLevel(), 0);
        this.writer.addAttribute("customizerClass", jRChart.getCustomizerClass());
        this.writeReportElement(jRChart);
        this.writeBox(jRChart.getLineBox());
        this.writer.startElement("chartTitle");
        this.writer.addAttribute("position", jRChart.getTitlePosition(), JRXmlConstants.getChartEdgeMap(), (byte)1);
        this.writer.addAttribute("color", jRChart.getOwnTitleColor());
        this.writeFont(jRChart.getTitleFont());
        if (jRChart.getTitleExpression() != null) {
            this.writer.writeExpression("titleExpression", jRChart.getTitleExpression(), false);
        }
        this.writer.closeElement();
        this.writer.startElement("chartSubtitle");
        this.writer.addAttribute("color", jRChart.getOwnSubtitleColor());
        this.writeFont(jRChart.getSubtitleFont());
        if (jRChart.getSubtitleExpression() != null) {
            this.writer.writeExpression("subtitleExpression", jRChart.getSubtitleExpression(), false);
        }
        this.writer.closeElement();
        this.writer.startElement("chartLegend");
        if (jRChart.getOwnLegendColor() != null) {
            this.writer.addAttribute("textColor", jRChart.getOwnLegendColor());
        }
        if (jRChart.getOwnLegendBackgroundColor() != null) {
            this.writer.addAttribute("backgroundColor", jRChart.getOwnLegendBackgroundColor());
        }
        this.writer.addAttribute("position", jRChart.getLegendPosition(), JRXmlConstants.getChartEdgeMap(), (byte)2);
        this.writeFont(jRChart.getLegendFont());
        this.writer.closeElement();
        this.writer.writeExpression("anchorNameExpression", jRChart.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", jRChart.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", jRChart.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", jRChart.getHyperlinkPageExpression(), false);
        this.writer.writeExpression("hyperlinkTooltipExpression", jRChart.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(jRChart.getHyperlinkParameters());
        this.writer.closeElement();
    }

    private void writeElementDataset(JRElementDataset jRElementDataset) throws IOException {
        this.writer.startElement("dataset");
        this.writer.addAttribute("resetType", jRElementDataset.getResetType(), JRXmlConstants.getResetTypeMap(), (byte)1);
        if (jRElementDataset.getResetType() == 4) {
            this.writer.addEncodedAttribute("resetGroup", jRElementDataset.getResetGroup().getName());
        }
        this.writer.addAttribute("incrementType", jRElementDataset.getIncrementType(), JRXmlConstants.getResetTypeMap(), (byte)5);
        if (jRElementDataset.getIncrementType() == 4) {
            this.writer.addEncodedAttribute("incrementGroup", jRElementDataset.getIncrementGroup().getName());
        }
        this.writer.writeExpression("incrementWhenExpression", jRElementDataset.getIncrementWhenExpression(), false);
        JRDatasetRun jRDatasetRun = jRElementDataset.getDatasetRun();
        if (jRDatasetRun != null) {
            this.writeDatasetRun(jRDatasetRun);
        }
        this.writer.closeElement(true);
    }

    private void writeCategoryDataSet(JRCategoryDataset jRCategoryDataset) throws IOException {
        this.writer.startElement("categoryDataset");
        this.writeElementDataset(jRCategoryDataset);
        JRCategorySeries[] jRCategorySeriesArray = jRCategoryDataset.getSeries();
        if (jRCategorySeriesArray != null && jRCategorySeriesArray.length > 0) {
            for (int i2 = 0; i2 < jRCategorySeriesArray.length; ++i2) {
                this.writeCategorySeries(jRCategorySeriesArray[i2]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimeSeriesDataset(JRTimeSeriesDataset jRTimeSeriesDataset) throws IOException {
        this.writer.startElement("timeSeriesDataset");
        if (jRTimeSeriesDataset.getTimePeriod() != null && !(b == null ? (b = JRXmlWriter.a("org.jfree.data.time.Day")) : b).getName().equals(jRTimeSeriesDataset.getTimePeriod().getName())) {
            this.writer.addAttribute("timePeriod", JRXmlConstants.getTimePeriodName(jRTimeSeriesDataset.getTimePeriod()));
        }
        this.writeElementDataset(jRTimeSeriesDataset);
        JRTimeSeries[] jRTimeSeriesArray = jRTimeSeriesDataset.getSeries();
        if (jRTimeSeriesArray != null && jRTimeSeriesArray.length > 0) {
            for (int i2 = 0; i2 < jRTimeSeriesArray.length; ++i2) {
                this.writeTimeSeries(jRTimeSeriesArray[i2]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimePeriodDataset(JRTimePeriodDataset jRTimePeriodDataset) throws IOException {
        this.writer.startElement("timePeriodDataset");
        this.writeElementDataset(jRTimePeriodDataset);
        JRTimePeriodSeries[] jRTimePeriodSeriesArray = jRTimePeriodDataset.getSeries();
        if (jRTimePeriodSeriesArray != null && jRTimePeriodSeriesArray.length > 0) {
            for (int i2 = 0; i2 < jRTimePeriodSeriesArray.length; ++i2) {
                this.writeTimePeriodSeries(jRTimePeriodSeriesArray[i2]);
            }
        }
        this.writer.closeElement();
    }

    private void writeCategorySeries(JRCategorySeries jRCategorySeries) throws IOException {
        this.writer.startElement("categorySeries");
        this.writer.writeExpression("seriesExpression", jRCategorySeries.getSeriesExpression(), false);
        this.writer.writeExpression("categoryExpression", jRCategorySeries.getCategoryExpression(), false);
        this.writer.writeExpression("valueExpression", jRCategorySeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", jRCategorySeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", jRCategorySeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXyzDataset(JRXyzDataset jRXyzDataset) throws IOException {
        this.writer.startElement("xyzDataset");
        this.writeElementDataset(jRXyzDataset);
        JRXyzSeries[] jRXyzSeriesArray = jRXyzDataset.getSeries();
        if (jRXyzSeriesArray != null && jRXyzSeriesArray.length > 0) {
            for (int i2 = 0; i2 < jRXyzSeriesArray.length; ++i2) {
                this.writeXyzSeries(jRXyzSeriesArray[i2]);
            }
        }
        this.writer.closeElement();
    }

    private void writeXyzSeries(JRXyzSeries jRXyzSeries) throws IOException {
        this.writer.startElement("xyzSeries");
        this.writer.writeExpression("seriesExpression", jRXyzSeries.getSeriesExpression(), false);
        this.writer.writeExpression("xValueExpression", jRXyzSeries.getXValueExpression(), false);
        this.writer.writeExpression("yValueExpression", jRXyzSeries.getYValueExpression(), false);
        this.writer.writeExpression("zValueExpression", jRXyzSeries.getZValueExpression(), false);
        this.writeHyperlink("itemHyperlink", jRXyzSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXySeries(JRXySeries jRXySeries) throws IOException {
        this.writer.startElement("xySeries");
        this.writer.writeExpression("seriesExpression", jRXySeries.getSeriesExpression(), false);
        this.writer.writeExpression("xValueExpression", jRXySeries.getXValueExpression(), false);
        this.writer.writeExpression("yValueExpression", jRXySeries.getYValueExpression(), false);
        this.writer.writeExpression("labelExpression", jRXySeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", jRXySeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXyDataset(JRXyDataset jRXyDataset) throws IOException {
        this.writer.startElement("xyDataset");
        this.writeElementDataset(jRXyDataset);
        JRXySeries[] jRXySeriesArray = jRXyDataset.getSeries();
        if (jRXySeriesArray != null && jRXySeriesArray.length > 0) {
            for (int i2 = 0; i2 < jRXySeriesArray.length; ++i2) {
                this.writeXySeries(jRXySeriesArray[i2]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimeSeries(JRTimeSeries jRTimeSeries) throws IOException {
        this.writer.startElement("timeSeries");
        this.writer.writeExpression("seriesExpression", jRTimeSeries.getSeriesExpression(), false);
        this.writer.writeExpression("timePeriodExpression", jRTimeSeries.getTimePeriodExpression(), false);
        this.writer.writeExpression("valueExpression", jRTimeSeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", jRTimeSeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", jRTimeSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeTimePeriodSeries(JRTimePeriodSeries jRTimePeriodSeries) throws IOException {
        this.writer.startElement("timePeriodSeries");
        this.writer.writeExpression("seriesExpression", jRTimePeriodSeries.getSeriesExpression(), false);
        this.writer.writeExpression("startDateExpression", jRTimePeriodSeries.getStartDateExpression(), false);
        this.writer.writeExpression("endDateExpression", jRTimePeriodSeries.getEndDateExpression(), false);
        this.writer.writeExpression("valueExpression", jRTimePeriodSeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", jRTimePeriodSeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", jRTimePeriodSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    public void writePieDataset(JRPieDataset jRPieDataset) throws IOException {
        this.writer.startElement("pieDataset");
        this.writeElementDataset(jRPieDataset);
        this.writer.writeExpression("keyExpression", jRPieDataset.getKeyExpression(), false);
        this.writer.writeExpression("valueExpression", jRPieDataset.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", jRPieDataset.getLabelExpression(), false);
        this.writeHyperlink("sectionHyperlink", jRPieDataset.getSectionHyperlink());
        this.writer.closeElement();
    }

    public void writeValueDataset(JRValueDataset jRValueDataset) throws IOException {
        this.writer.startElement("valueDataset");
        this.writeElementDataset(jRValueDataset);
        this.writer.writeExpression("valueExpression", jRValueDataset.getValueExpression(), false);
        this.writer.closeElement();
    }

    public void writeValueDisplay(JRValueDisplay jRValueDisplay) throws IOException {
        this.writer.startElement("valueDisplay");
        this.writer.addAttribute("color", jRValueDisplay.getColor());
        this.writer.addAttribute("mask", jRValueDisplay.getMask());
        this.writeFont(jRValueDisplay.getFont());
        this.writer.closeElement();
    }

    public void writeDataRange(JRDataRange jRDataRange) throws IOException {
        this.writer.startElement("dataRange");
        this.writer.writeExpression("lowExpression", jRDataRange.getLowExpression(), false);
        this.writer.writeExpression("highExpression", jRDataRange.getHighExpression(), false);
        this.writer.closeElement();
    }

    private void writeMeterInterval(JRMeterInterval jRMeterInterval) throws IOException {
        this.writer.startElement("meterInterval");
        this.writer.addAttribute("label", jRMeterInterval.getLabel());
        this.writer.addAttribute("color", jRMeterInterval.getBackgroundColor());
        this.writer.addAttribute("alpha", jRMeterInterval.getAlpha());
        this.writeDataRange(jRMeterInterval.getDataRange());
        this.writer.closeElement();
    }

    private void writeSeriesColors(SortedSet sortedSet) throws IOException {
        if (sortedSet == null || sortedSet.size() == 0) {
            return;
        }
        JRChartPlot.JRSeriesColor[] jRSeriesColorArray = sortedSet.toArray(new JRChartPlot.JRSeriesColor[0]);
        for (int i2 = 0; i2 < jRSeriesColorArray.length; ++i2) {
            this.writer.startElement("seriesColor");
            this.writer.addAttribute("seriesOrder", jRSeriesColorArray[i2].getSeriesOrder());
            this.writer.addAttribute("color", jRSeriesColorArray[i2].getColor());
            this.writer.closeElement();
        }
    }

    private void writeChartAxis(JRChartAxis jRChartAxis) throws IOException {
        this.writer.startElement("axis");
        this.writer.addAttribute("position", jRChartAxis.getPosition(), JRXmlConstants.getAxisPositionMap(), (byte)1);
        this.writeChartTag(jRChartAxis.getChart());
        this.writer.closeElement();
    }

    private void writePlot(JRChartPlot jRChartPlot) throws IOException {
        this.writer.startElement("plot");
        this.writer.addAttribute("backcolor", jRChartPlot.getOwnBackcolor());
        this.writer.addAttribute("orientation", jRChartPlot.getOrientation(), JRXmlConstants.getPlotOrientationMap(), PlotOrientation.VERTICAL);
        this.writer.addAttribute("backgroundAlpha", jRChartPlot.getBackgroundAlpha(), 1.0f);
        this.writer.addAttribute("foregroundAlpha", jRChartPlot.getForegroundAlpha(), 1.0f);
        this.writer.addAttribute("labelRotation", jRChartPlot.getLabelRotation(), 0.0);
        this.writeSeriesColors(jRChartPlot.getSeriesColors());
        this.writer.closeElement();
    }

    public void writePieChart(JRChart jRChart) throws IOException {
        this.writer.startElement("pieChart");
        this.writeChart(jRChart);
        this.writePieDataset((JRPieDataset)jRChart.getDataset());
        JRPiePlot jRPiePlot = (JRPiePlot)jRChart.getPlot();
        this.writer.startElement("piePlot");
        this.writer.addAttribute("isCircular", jRPiePlot.isCircular(), false);
        this.writePlot(jRChart.getPlot());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writePie3DChart(JRChart jRChart) throws IOException {
        this.writer.startElement("pie3DChart");
        this.writeChart(jRChart);
        this.writePieDataset((JRPieDataset)jRChart.getDataset());
        JRPie3DPlot jRPie3DPlot = (JRPie3DPlot)jRChart.getPlot();
        this.writer.startElement("pie3DPlot");
        this.writer.addAttribute("depthFactor", jRPie3DPlot.getDepthFactor(), 0.2);
        this.writer.addAttribute("isCircular", jRPie3DPlot.isCircular(), false);
        this.writePlot(jRChart.getPlot());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeAxisFormat(String string, JRFont jRFont, Color color, JRFont jRFont2, Color color2, String string2, Color color3) throws IOException {
        if (jRFont == null && color == null && jRFont2 == null && color2 == null && color3 == null) {
            return;
        }
        this.writer.startElement(string);
        this.writer.startElement("axisFormat");
        this.writer.addAttribute("labelColor", color);
        this.writer.addAttribute("tickLabelColor", color2);
        this.writer.addAttribute("tickLabelMask", string2);
        this.writer.addAttribute("axisLineColor", color3);
        if (jRFont != null) {
            this.writer.startElement("labelFont");
            this.writeFont(jRFont);
            this.writer.closeElement();
        }
        if (jRFont2 != null) {
            this.writer.startElement("tickLabelFont");
            this.writeFont(jRFont2);
            this.writer.closeElement();
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    private void writeBarPlot(JRBarPlot jRBarPlot) throws IOException {
        this.writer.startElement("barPlot");
        this.writer.addAttribute("isShowLabels", jRBarPlot.isShowLabels(), false);
        this.writer.addAttribute("isShowTickLabels", jRBarPlot.isShowTickLabels(), true);
        this.writer.addAttribute("isShowTickMarks", jRBarPlot.isShowTickMarks(), true);
        this.writePlot(jRBarPlot);
        this.writer.writeExpression("categoryAxisLabelExpression", jRBarPlot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", jRBarPlot.getCategoryAxisLabelFont(), jRBarPlot.getOwnCategoryAxisLabelColor(), jRBarPlot.getCategoryAxisTickLabelFont(), jRBarPlot.getOwnCategoryAxisTickLabelColor(), jRBarPlot.getCategoryAxisTickLabelMask(), jRBarPlot.getOwnCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRBarPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRBarPlot.getValueAxisLabelFont(), jRBarPlot.getOwnValueAxisLabelColor(), jRBarPlot.getValueAxisTickLabelFont(), jRBarPlot.getOwnValueAxisTickLabelColor(), jRBarPlot.getValueAxisTickLabelMask(), jRBarPlot.getOwnValueAxisLineColor());
        this.writer.closeElement();
    }

    private void writeBubblePlot(JRBubblePlot jRBubblePlot) throws IOException {
        this.writer.startElement("bubblePlot");
        this.writer.addAttribute("scaleType", jRBubblePlot.getScaleType(), JRXmlConstants.getScaleTypeMap());
        this.writePlot(jRBubblePlot);
        this.writer.writeExpression("xAxisLabelExpression", jRBubblePlot.getXAxisLabelExpression(), false);
        this.writeAxisFormat("xAxisFormat", jRBubblePlot.getXAxisLabelFont(), jRBubblePlot.getOwnXAxisLabelColor(), jRBubblePlot.getXAxisTickLabelFont(), jRBubblePlot.getOwnXAxisTickLabelColor(), jRBubblePlot.getXAxisTickLabelMask(), jRBubblePlot.getOwnXAxisLineColor());
        this.writer.writeExpression("yAxisLabelExpression", jRBubblePlot.getYAxisLabelExpression(), false);
        this.writeAxisFormat("yAxisFormat", jRBubblePlot.getYAxisLabelFont(), jRBubblePlot.getOwnYAxisLabelColor(), jRBubblePlot.getYAxisTickLabelFont(), jRBubblePlot.getOwnYAxisTickLabelColor(), jRBubblePlot.getYAxisTickLabelMask(), jRBubblePlot.getOwnYAxisLineColor());
        this.writer.closeElement();
    }

    private void writeLinePlot(JRLinePlot jRLinePlot) throws IOException {
        this.writer.startElement("linePlot");
        this.writer.addAttribute("isShowLines", jRLinePlot.isShowLines(), true);
        this.writer.addAttribute("isShowShapes", jRLinePlot.isShowShapes(), true);
        this.writePlot(jRLinePlot);
        this.writer.writeExpression("categoryAxisLabelExpression", jRLinePlot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", jRLinePlot.getCategoryAxisLabelFont(), jRLinePlot.getOwnCategoryAxisLabelColor(), jRLinePlot.getCategoryAxisTickLabelFont(), jRLinePlot.getOwnCategoryAxisTickLabelColor(), jRLinePlot.getCategoryAxisTickLabelMask(), jRLinePlot.getOwnCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRLinePlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRLinePlot.getValueAxisLabelFont(), jRLinePlot.getOwnValueAxisLabelColor(), jRLinePlot.getValueAxisTickLabelFont(), jRLinePlot.getOwnValueAxisTickLabelColor(), jRLinePlot.getValueAxisTickLabelMask(), jRLinePlot.getOwnValueAxisLineColor());
        this.writer.closeElement();
    }

    private void writeTimeSeriesPlot(JRTimeSeriesPlot jRTimeSeriesPlot) throws IOException {
        this.writer.startElement("timeSeriesPlot");
        this.writer.addAttribute("isShowLines", jRTimeSeriesPlot.isShowLines(), true);
        this.writer.addAttribute("isShowShapes", jRTimeSeriesPlot.isShowShapes(), true);
        this.writePlot(jRTimeSeriesPlot);
        this.writer.writeExpression("timeAxisLabelExpression", jRTimeSeriesPlot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", jRTimeSeriesPlot.getTimeAxisLabelFont(), jRTimeSeriesPlot.getOwnTimeAxisLabelColor(), jRTimeSeriesPlot.getTimeAxisTickLabelFont(), jRTimeSeriesPlot.getOwnTimeAxisTickLabelColor(), jRTimeSeriesPlot.getTimeAxisTickLabelMask(), jRTimeSeriesPlot.getOwnTimeAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRTimeSeriesPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRTimeSeriesPlot.getValueAxisLabelFont(), jRTimeSeriesPlot.getOwnValueAxisLabelColor(), jRTimeSeriesPlot.getValueAxisTickLabelFont(), jRTimeSeriesPlot.getOwnValueAxisTickLabelColor(), jRTimeSeriesPlot.getValueAxisTickLabelMask(), jRTimeSeriesPlot.getOwnValueAxisLineColor());
        this.writer.closeElement();
    }

    public void writeBar3DPlot(JRBar3DPlot jRBar3DPlot) throws IOException {
        this.writer.startElement("bar3DPlot");
        this.writer.addAttribute("isShowLabels", jRBar3DPlot.isShowLabels(), false);
        this.writer.addAttribute("xOffset", jRBar3DPlot.getXOffset(), 12.0);
        this.writer.addAttribute("yOffset", jRBar3DPlot.getYOffset(), 8.0);
        this.writePlot(jRBar3DPlot);
        this.writer.writeExpression("categoryAxisLabelExpression", jRBar3DPlot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", jRBar3DPlot.getCategoryAxisLabelFont(), jRBar3DPlot.getOwnCategoryAxisLabelColor(), jRBar3DPlot.getCategoryAxisTickLabelFont(), jRBar3DPlot.getOwnCategoryAxisTickLabelColor(), jRBar3DPlot.getCategoryAxisTickLabelMask(), jRBar3DPlot.getOwnCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRBar3DPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRBar3DPlot.getValueAxisLabelFont(), jRBar3DPlot.getOwnValueAxisLabelColor(), jRBar3DPlot.getValueAxisTickLabelFont(), jRBar3DPlot.getOwnValueAxisTickLabelColor(), jRBar3DPlot.getValueAxisTickLabelMask(), jRBar3DPlot.getOwnValueAxisLineColor());
        this.writer.closeElement();
    }

    public void writeBarChart(JRChart jRChart) throws IOException {
        this.writer.startElement("barChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeBarPlot((JRBarPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeBar3DChart(JRChart jRChart) throws IOException {
        this.writer.startElement("bar3DChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeBubbleChart(JRChart jRChart) throws IOException {
        this.writer.startElement("bubbleChart");
        this.writeChart(jRChart);
        this.writeXyzDataset((JRXyzDataset)jRChart.getDataset());
        this.writeBubblePlot((JRBubblePlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeStackedBarChart(JRChart jRChart) throws IOException {
        this.writer.startElement("stackedBarChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeBarPlot((JRBarPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeStackedBar3DChart(JRChart jRChart) throws IOException {
        this.writer.startElement("stackedBar3DChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeLineChart(JRChart jRChart) throws IOException {
        this.writer.startElement("lineChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeLinePlot((JRLinePlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeTimeSeriesChart(JRChart jRChart) throws IOException {
        this.writer.startElement("timeSeriesChart");
        this.writeChart(jRChart);
        this.writeTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset());
        this.writeTimeSeriesPlot((JRTimeSeriesPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeHighLowDataset(JRHighLowDataset jRHighLowDataset) throws IOException {
        this.writer.startElement("highLowDataset");
        this.writeElementDataset(jRHighLowDataset);
        this.writer.writeExpression("seriesExpression", jRHighLowDataset.getSeriesExpression(), false);
        this.writer.writeExpression("dateExpression", jRHighLowDataset.getDateExpression(), false);
        this.writer.writeExpression("highExpression", jRHighLowDataset.getHighExpression(), false);
        this.writer.writeExpression("lowExpression", jRHighLowDataset.getLowExpression(), false);
        this.writer.writeExpression("openExpression", jRHighLowDataset.getOpenExpression(), false);
        this.writer.writeExpression("closeExpression", jRHighLowDataset.getCloseExpression(), false);
        this.writer.writeExpression("volumeExpression", jRHighLowDataset.getVolumeExpression(), false);
        this.writeHyperlink("itemHyperlink", jRHighLowDataset.getItemHyperlink());
        this.writer.closeElement();
    }

    public void writeHighLowChart(JRChart jRChart) throws IOException {
        this.writer.startElement("highLowChart");
        this.writeChart(jRChart);
        this.writeHighLowDataset((JRHighLowDataset)jRChart.getDataset());
        JRHighLowPlot jRHighLowPlot = (JRHighLowPlot)jRChart.getPlot();
        this.writer.startElement("highLowPlot");
        this.writer.addAttribute("isShowOpenTicks", jRHighLowPlot.isShowOpenTicks(), true);
        this.writer.addAttribute("isShowCloseTicks", jRHighLowPlot.isShowCloseTicks(), true);
        this.writePlot(jRHighLowPlot);
        this.writer.writeExpression("timeAxisLabelExpression", jRHighLowPlot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", jRHighLowPlot.getTimeAxisLabelFont(), jRHighLowPlot.getOwnTimeAxisLabelColor(), jRHighLowPlot.getTimeAxisTickLabelFont(), jRHighLowPlot.getOwnTimeAxisTickLabelColor(), jRHighLowPlot.getTimeAxisTickLabelMask(), jRHighLowPlot.getOwnTimeAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRHighLowPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRHighLowPlot.getValueAxisLabelFont(), jRHighLowPlot.getOwnValueAxisLabelColor(), jRHighLowPlot.getValueAxisTickLabelFont(), jRHighLowPlot.getOwnValueAxisTickLabelColor(), jRHighLowPlot.getValueAxisTickLabelMask(), jRHighLowPlot.getOwnValueAxisLineColor());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeCandlestickChart(JRChart jRChart) throws IOException {
        this.writer.startElement("candlestickChart");
        this.writeChart(jRChart);
        this.writeHighLowDataset((JRHighLowDataset)jRChart.getDataset());
        JRCandlestickPlot jRCandlestickPlot = (JRCandlestickPlot)jRChart.getPlot();
        this.writer.startElement("candlestickPlot");
        this.writer.addAttribute("isShowVolume", jRCandlestickPlot.isShowVolume(), true);
        this.writePlot(jRCandlestickPlot);
        this.writer.writeExpression("timeAxisLabelExpression", jRCandlestickPlot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", jRCandlestickPlot.getTimeAxisLabelFont(), jRCandlestickPlot.getOwnTimeAxisLabelColor(), jRCandlestickPlot.getTimeAxisTickLabelFont(), jRCandlestickPlot.getOwnTimeAxisTickLabelColor(), jRCandlestickPlot.getTimeAxisTickLabelMask(), jRCandlestickPlot.getOwnTimeAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRCandlestickPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRCandlestickPlot.getValueAxisLabelFont(), jRCandlestickPlot.getOwnValueAxisLabelColor(), jRCandlestickPlot.getValueAxisTickLabelFont(), jRCandlestickPlot.getOwnValueAxisTickLabelColor(), jRCandlestickPlot.getValueAxisTickLabelMask(), jRCandlestickPlot.getOwnValueAxisLineColor());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    private void writeAreaPlot(JRAreaPlot jRAreaPlot) throws IOException {
        this.writer.startElement("areaPlot");
        this.writePlot(jRAreaPlot);
        this.writer.writeExpression("categoryAxisLabelExpression", jRAreaPlot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", jRAreaPlot.getCategoryAxisLabelFont(), jRAreaPlot.getOwnCategoryAxisLabelColor(), jRAreaPlot.getCategoryAxisTickLabelFont(), jRAreaPlot.getOwnCategoryAxisTickLabelColor(), jRAreaPlot.getCategoryAxisTickLabelMask(), jRAreaPlot.getOwnCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRAreaPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRAreaPlot.getValueAxisLabelFont(), jRAreaPlot.getOwnValueAxisLabelColor(), jRAreaPlot.getValueAxisTickLabelFont(), jRAreaPlot.getOwnValueAxisTickLabelColor(), jRAreaPlot.getValueAxisTickLabelMask(), jRAreaPlot.getOwnValueAxisLineColor());
        this.writer.closeElement();
    }

    public void writeAreaChart(JRChart jRChart) throws IOException {
        this.writer.startElement("areaChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeAreaPlot((JRAreaPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    private void writeScatterPlot(JRScatterPlot jRScatterPlot) throws IOException {
        this.writer.startElement("scatterPlot");
        this.writer.addAttribute("isShowLines", jRScatterPlot.isShowLines(), true);
        this.writer.addAttribute("isShowShapes", jRScatterPlot.isShowShapes(), true);
        this.writePlot(jRScatterPlot);
        this.writer.writeExpression("xAxisLabelExpression", jRScatterPlot.getXAxisLabelExpression(), false);
        this.writeAxisFormat("xAxisFormat", jRScatterPlot.getXAxisLabelFont(), jRScatterPlot.getOwnXAxisLabelColor(), jRScatterPlot.getXAxisTickLabelFont(), jRScatterPlot.getOwnXAxisTickLabelColor(), jRScatterPlot.getXAxisTickLabelMask(), jRScatterPlot.getOwnXAxisLineColor());
        this.writer.writeExpression("yAxisLabelExpression", jRScatterPlot.getYAxisLabelExpression(), false);
        this.writeAxisFormat("yAxisFormat", jRScatterPlot.getYAxisLabelFont(), jRScatterPlot.getOwnYAxisLabelColor(), jRScatterPlot.getYAxisTickLabelFont(), jRScatterPlot.getOwnYAxisTickLabelColor(), jRScatterPlot.getYAxisTickLabelMask(), jRScatterPlot.getOwnYAxisLineColor());
        this.writer.closeElement();
    }

    public void writeScatterChart(JRChart jRChart) throws IOException {
        this.writer.startElement("scatterChart");
        this.writeChart(jRChart);
        this.writeXyDataset((JRXyDataset)jRChart.getDataset());
        this.writeScatterPlot((JRScatterPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyAreaChart(JRChart jRChart) throws IOException {
        this.writer.startElement("xyAreaChart");
        this.writeChart(jRChart);
        this.writeXyDataset((JRXyDataset)jRChart.getDataset());
        this.writeAreaPlot((JRAreaPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyBarChart(JRChart jRChart) throws IOException {
        this.writer.startElement("xyBarChart");
        this.writeChart(jRChart);
        JRChartDataset jRChartDataset = jRChart.getDataset();
        if (jRChartDataset.getDatasetType() == 6) {
            this.writeTimeSeriesDataset((JRTimeSeriesDataset)jRChartDataset);
        } else if (jRChartDataset.getDatasetType() == 5) {
            this.writeTimePeriodDataset((JRTimePeriodDataset)jRChartDataset);
        } else if (jRChartDataset.getDatasetType() == 3) {
            this.writeXyDataset((JRXyDataset)jRChartDataset);
        }
        this.writeBarPlot((JRBarPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyLineChart(JRChart jRChart) throws IOException {
        this.writer.startElement("xyLineChart");
        this.writeChart(jRChart);
        this.writeXyDataset((JRXyDataset)jRChart.getDataset());
        this.writeLinePlot((JRLinePlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeMeterChart(JRChart jRChart) throws IOException {
        this.writer.startElement("meterChart");
        this.writeChart(jRChart);
        this.writeValueDataset((JRValueDataset)jRChart.getDataset());
        JRMeterPlot jRMeterPlot = (JRMeterPlot)jRChart.getPlot();
        this.writer.startElement("meterPlot");
        this.writer.addAttribute("shape", jRMeterPlot.getShape(), JRXmlConstants.getMeterShapeMap(), (byte)2);
        this.writer.addAttribute("angle", jRMeterPlot.getMeterAngle());
        this.writer.addAttribute("units", jRMeterPlot.getUnits());
        this.writer.addAttribute("tickInterval", jRMeterPlot.getTickInterval());
        this.writer.addAttribute("meterColor", jRMeterPlot.getMeterBackgroundColor());
        this.writer.addAttribute("needleColor", jRMeterPlot.getNeedleColor());
        this.writer.addAttribute("tickColor", jRMeterPlot.getTickColor());
        this.writePlot(jRChart.getPlot());
        this.writeValueDisplay(jRMeterPlot.getValueDisplay());
        this.writeDataRange(jRMeterPlot.getDataRange());
        List list = jRMeterPlot.getIntervals();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JRMeterInterval jRMeterInterval = (JRMeterInterval)iterator.next();
                this.writeMeterInterval(jRMeterInterval);
            }
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeThermometerChart(JRChart jRChart) throws IOException {
        this.writer.startElement("thermometerChart");
        this.writeChart(jRChart);
        this.writeValueDataset((JRValueDataset)jRChart.getDataset());
        JRThermometerPlot jRThermometerPlot = (JRThermometerPlot)jRChart.getPlot();
        this.writer.startElement("thermometerPlot");
        this.writer.addAttribute("valueLocation", jRThermometerPlot.getValueLocation(), JRXmlConstants.getThermometerValueLocationMap(), (byte)3);
        this.writer.addAttribute("isShowValueLines", jRThermometerPlot.isShowValueLines());
        this.writer.addAttribute("mercuryColor", jRThermometerPlot.getMercuryColor());
        this.writePlot(jRChart.getPlot());
        this.writeValueDisplay(jRThermometerPlot.getValueDisplay());
        this.writeDataRange(jRThermometerPlot.getDataRange());
        if (jRThermometerPlot.getLowRange() != null) {
            this.writer.startElement("lowRange");
            this.writeDataRange(jRThermometerPlot.getLowRange());
            this.writer.closeElement();
        }
        if (jRThermometerPlot.getMediumRange() != null) {
            this.writer.startElement("mediumRange");
            this.writeDataRange(jRThermometerPlot.getMediumRange());
            this.writer.closeElement();
        }
        if (jRThermometerPlot.getHighRange() != null) {
            this.writer.startElement("highRange");
            this.writeDataRange(jRThermometerPlot.getHighRange());
            this.writer.closeElement();
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeMultiAxisChart(JRChart jRChart) throws IOException {
        this.writer.startElement("multiAxisChart");
        this.writeChart(jRChart);
        JRMultiAxisPlot jRMultiAxisPlot = (JRMultiAxisPlot)jRChart.getPlot();
        this.writer.startElement("multiAxisPlot");
        this.writePlot(jRChart.getPlot());
        List list = jRMultiAxisPlot.getAxes();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JRChartAxis jRChartAxis = (JRChartAxis)iterator.next();
                this.writeChartAxis(jRChartAxis);
            }
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeStackedAreaChart(JRChart jRChart) throws IOException {
        this.writer.startElement("stackedAreaChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeAreaPlot((JRAreaPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeChartTag(JRChart jRChart) throws IOException {
        switch (jRChart.getChartType()) {
            case 1: {
                this.writeAreaChart(jRChart);
                break;
            }
            case 3: {
                this.writeBarChart(jRChart);
                break;
            }
            case 2: {
                this.writeBar3DChart(jRChart);
                break;
            }
            case 4: {
                this.writeBubbleChart(jRChart);
                break;
            }
            case 5: {
                this.writeCandlestickChart(jRChart);
                break;
            }
            case 6: {
                this.writeHighLowChart(jRChart);
                break;
            }
            case 7: {
                this.writeLineChart(jRChart);
                break;
            }
            case 17: {
                this.writeMeterChart(jRChart);
                break;
            }
            case 19: {
                this.writeMultiAxisChart(jRChart);
                break;
            }
            case 9: {
                this.writePieChart(jRChart);
                break;
            }
            case 8: {
                this.writePie3DChart(jRChart);
                break;
            }
            case 10: {
                this.writeScatterChart(jRChart);
                break;
            }
            case 12: {
                this.writeStackedBarChart(jRChart);
                break;
            }
            case 11: {
                this.writeStackedBar3DChart(jRChart);
                break;
            }
            case 18: {
                this.writeThermometerChart(jRChart);
                break;
            }
            case 16: {
                this.writeTimeSeriesChart(jRChart);
                break;
            }
            case 13: {
                this.writeXyAreaChart(jRChart);
                break;
            }
            case 14: {
                this.writeXyBarChart(jRChart);
                break;
            }
            case 15: {
                this.writeXyLineChart(jRChart);
                break;
            }
            case 20: {
                this.writeStackedAreaChart(jRChart);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    private void writeSubreportReturnValue(JRSubreportReturnValue jRSubreportReturnValue) throws IOException {
        this.writer.startElement("returnValue");
        this.writer.addEncodedAttribute("subreportVariable", jRSubreportReturnValue.getSubreportVariable());
        this.writer.addEncodedAttribute("toVariable", jRSubreportReturnValue.getToVariable());
        this.writer.addAttribute("calculation", jRSubreportReturnValue.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("incrementerFactoryClass", jRSubreportReturnValue.getIncrementerFactoryClassName());
        this.writer.closeElement();
    }

    public void writeCrosstab(JRCrosstab jRCrosstab) throws IOException {
        this.writer.startElement("crosstab");
        this.writer.addAttribute("isRepeatColumnHeaders", jRCrosstab.isRepeatColumnHeaders(), true);
        this.writer.addAttribute("isRepeatRowHeaders", jRCrosstab.isRepeatRowHeaders(), true);
        this.writer.addAttribute("columnBreakOffset", jRCrosstab.getColumnBreakOffset(), 10);
        this.writer.addAttribute("runDirection", jRCrosstab.getRunDirection(), JRXmlConstants.getRunDirectionMap(), (byte)0);
        this.writeReportElement(jRCrosstab);
        JRCrosstabParameter[] jRCrosstabParameterArray = jRCrosstab.getParameters();
        if (jRCrosstabParameterArray != null) {
            for (int i2 = 0; i2 < jRCrosstabParameterArray.length; ++i2) {
                if (jRCrosstabParameterArray[i2].isSystemDefined()) continue;
                this.writeCrosstabParameter(jRCrosstabParameterArray[i2]);
            }
        }
        this.writer.writeExpression("parametersMapExpression", jRCrosstab.getParametersMapExpression(), false);
        this.writeCrosstabDataset(jRCrosstab);
        this.writeCrosstabHeaderCell(jRCrosstab);
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        for (int i3 = 0; i3 < jRCrosstabRowGroupArray.length; ++i3) {
            this.writeCrosstabRowGroup(jRCrosstabRowGroupArray[i3]);
        }
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        for (int i4 = 0; i4 < jRCrosstabColumnGroupArray.length; ++i4) {
            this.writeCrosstabColumnGroup(jRCrosstabColumnGroupArray[i4]);
        }
        JRCrosstabMeasure[] jRCrosstabMeasureArray = jRCrosstab.getMeasures();
        for (int i5 = 0; i5 < jRCrosstabMeasureArray.length; ++i5) {
            this.writeCrosstabMeasure(jRCrosstabMeasureArray[i5]);
        }
        if (jRCrosstab instanceof JRDesignCrosstab) {
            List list = ((JRDesignCrosstab)jRCrosstab).getCellsList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JRCrosstabCell jRCrosstabCell = (JRCrosstabCell)iterator.next();
                this.writeCrosstabCell(jRCrosstabCell);
            }
        } else {
            JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
            HashSet<JRCrosstabCell> hashSet = new HashSet<JRCrosstabCell>();
            for (int i6 = jRCrosstabCellArray.length - 1; i6 >= 0; --i6) {
                for (int i7 = jRCrosstabCellArray[i6].length - 1; i7 >= 0; --i7) {
                    JRCrosstabCell jRCrosstabCell = jRCrosstabCellArray[i6][i7];
                    if (jRCrosstabCell == null || !hashSet.add(jRCrosstabCell)) continue;
                    this.writeCrosstabCell(jRCrosstabCell);
                }
            }
        }
        this.writeCrosstabWhenNoDataCell(jRCrosstab);
        this.writer.closeElement();
    }

    private void writeCrosstabDataset(JRCrosstab jRCrosstab) throws IOException {
        JRCrosstabDataset jRCrosstabDataset = jRCrosstab.getDataset();
        this.writer.startElement("crosstabDataset");
        this.writer.addAttribute("isDataPreSorted", jRCrosstabDataset.isDataPreSorted(), false);
        this.writeElementDataset(jRCrosstabDataset);
        this.writer.closeElement(true);
    }

    private void writeCrosstabWhenNoDataCell(JRCrosstab jRCrosstab) throws IOException {
        JRCellContents jRCellContents = jRCrosstab.getWhenNoDataCell();
        if (jRCellContents != null) {
            this.writer.startElement("whenNoDataCell");
            this.writeCellContents(jRCellContents);
            this.writer.closeElement();
        }
    }

    private void writeCrosstabHeaderCell(JRCrosstab jRCrosstab) throws IOException {
        JRCellContents jRCellContents = jRCrosstab.getHeaderCell();
        if (jRCellContents != null) {
            this.writer.startElement("crosstabHeaderCell");
            this.writeCellContents(jRCellContents);
            this.writer.closeElement();
        }
    }

    public void writeCrosstabRowGroup(JRCrosstabRowGroup jRCrosstabRowGroup) throws IOException {
        this.writer.startElement("rowGroup");
        this.writer.addEncodedAttribute("name", jRCrosstabRowGroup.getName());
        this.writer.addAttribute("width", jRCrosstabRowGroup.getWidth());
        this.writer.addAttribute("totalPosition", jRCrosstabRowGroup.getTotalPosition(), JRXmlConstants.getCrosstabTotalPositionMap(), (byte)0);
        this.writer.addAttribute("headerPosition", jRCrosstabRowGroup.getPosition(), JRXmlConstants.getCrosstabRowPositionMap(), (byte)1);
        this.writeBucket(jRCrosstabRowGroup.getBucket());
        JRCellContents jRCellContents = jRCrosstabRowGroup.getHeader();
        this.writer.startElement("crosstabRowHeader");
        this.writeCellContents(jRCellContents);
        this.writer.closeElement();
        JRCellContents jRCellContents2 = jRCrosstabRowGroup.getTotalHeader();
        this.writer.startElement("crosstabTotalRowHeader");
        this.writeCellContents(jRCellContents2);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeCrosstabColumnGroup(JRCrosstabColumnGroup jRCrosstabColumnGroup) throws IOException {
        this.writer.startElement("columnGroup");
        this.writer.addEncodedAttribute("name", jRCrosstabColumnGroup.getName());
        this.writer.addAttribute("height", jRCrosstabColumnGroup.getHeight());
        this.writer.addAttribute("totalPosition", jRCrosstabColumnGroup.getTotalPosition(), JRXmlConstants.getCrosstabTotalPositionMap(), (byte)0);
        this.writer.addAttribute("headerPosition", jRCrosstabColumnGroup.getPosition(), JRXmlConstants.getCrosstabColumnPositionMap(), (byte)1);
        this.writeBucket(jRCrosstabColumnGroup.getBucket());
        JRCellContents jRCellContents = jRCrosstabColumnGroup.getHeader();
        this.writer.startElement("crosstabColumnHeader");
        this.writeCellContents(jRCellContents);
        this.writer.closeElement();
        JRCellContents jRCellContents2 = jRCrosstabColumnGroup.getTotalHeader();
        this.writer.startElement("crosstabTotalColumnHeader");
        this.writeCellContents(jRCellContents2);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeBucket(JRCrosstabBucket jRCrosstabBucket) throws IOException {
        this.writer.startElement("bucket");
        this.writer.addAttribute("order", jRCrosstabBucket.getOrder(), JRXmlConstants.getCrosstabBucketOrderMap(), (byte)1);
        this.writer.writeExpression("bucketExpression", jRCrosstabBucket.getExpression(), true);
        this.writer.writeExpression("comparatorExpression", jRCrosstabBucket.getComparatorExpression(), false);
        this.writer.closeElement();
    }

    public void writeCrosstabMeasure(JRCrosstabMeasure jRCrosstabMeasure) throws IOException {
        this.writer.startElement("measure");
        this.writer.addEncodedAttribute("name", jRCrosstabMeasure.getName());
        this.writer.addAttribute("class", jRCrosstabMeasure.getValueClassName());
        this.writer.addAttribute("calculation", jRCrosstabMeasure.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("percentageOf", jRCrosstabMeasure.getPercentageOfType(), JRXmlConstants.getCrosstabPercentageMap(), (byte)0);
        this.writer.addAttribute("percentageCalculatorClass", jRCrosstabMeasure.getPercentageCalculatorClassName());
        this.writer.writeExpression("measureExpression", jRCrosstabMeasure.getValueExpression(), false);
        this.writer.closeElement();
    }

    public void writeCrosstabCell(JRCrosstabCell jRCrosstabCell) throws IOException {
        this.writer.startElement("crosstabCell");
        this.writer.addAttribute("width", jRCrosstabCell.getWidth());
        this.writer.addAttribute("height", jRCrosstabCell.getHeight());
        this.writer.addEncodedAttribute("rowTotalGroup", jRCrosstabCell.getRowTotalGroup());
        this.writer.addEncodedAttribute("columnTotalGroup", jRCrosstabCell.getColumnTotalGroup());
        this.writeCellContents(jRCrosstabCell.getContents());
        this.writer.closeElement();
    }

    public void writeCellContents(JRCellContents jRCellContents) throws IOException {
        if (jRCellContents != null) {
            this.writer.startElement("cellContents");
            this.writer.addAttribute("backcolor", jRCellContents.getBackcolor());
            this.writer.addAttribute("mode", jRCellContents.getMode(), JRXmlConstants.getModeMap());
            this.writeStyleReferenceAttr(jRCellContents);
            this.writeBox(jRCellContents.getLineBox());
            List list = jRCellContents.getChildren();
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ((JRChild)iterator.next()).visit(this.xmlWriterVisitor);
                }
            }
            this.writer.closeElement();
        }
    }

    public void writeCrosstabParameter(JRCrosstabParameter jRCrosstabParameter) throws IOException {
        this.writer.startElement("crosstabParameter");
        this.writer.addEncodedAttribute("name", jRCrosstabParameter.getName());
        this.writer.addAttribute("class", jRCrosstabParameter.getValueClassName(), "java.lang.String");
        this.writer.writeExpression("parameterValueExpression", jRCrosstabParameter.getExpression(), false);
        this.writer.closeElement();
    }

    public void writeDataset(JRDataset jRDataset) throws IOException {
        this.writer.startElement("subDataset");
        this.writer.addEncodedAttribute("name", jRDataset.getName());
        this.writer.addAttribute("scriptletClass", jRDataset.getScriptletClass());
        this.writer.addEncodedAttribute("resourceBundle", jRDataset.getResourceBundle());
        this.writer.addAttribute("whenResourceMissingType", jRDataset.getWhenResourceMissingType(), JRXmlConstants.getWhenResourceMissingTypeMap(), (byte)1);
        this.writeProperties(jRDataset);
        this.writeDatasetContents(jRDataset);
        this.writer.closeElement();
    }

    public void writeDatasetContents(JRDataset jRDataset) throws IOException {
        JRVariable[] jRVariableArray;
        JRSortField[] jRSortFieldArray;
        JRField[] jRFieldArray;
        JRParameter[] jRParameterArray = jRDataset.getParameters();
        if (jRParameterArray != null && jRParameterArray.length > 0) {
            for (int i2 = 0; i2 < jRParameterArray.length; ++i2) {
                if (jRParameterArray[i2].isSystemDefined()) continue;
                this.writeParameter(jRParameterArray[i2]);
            }
        }
        if (jRDataset.getQuery() != null) {
            this.writeQuery(jRDataset.getQuery());
        }
        if ((jRFieldArray = jRDataset.getFields()) != null && jRFieldArray.length > 0) {
            for (int i3 = 0; i3 < jRFieldArray.length; ++i3) {
                this.writeField(jRFieldArray[i3]);
            }
        }
        if ((jRSortFieldArray = jRDataset.getSortFields()) != null && jRSortFieldArray.length > 0) {
            for (int i4 = 0; i4 < jRSortFieldArray.length; ++i4) {
                this.writeSortField(jRSortFieldArray[i4]);
            }
        }
        if ((jRVariableArray = jRDataset.getVariables()) != null && jRVariableArray.length > 0) {
            for (int i5 = 0; i5 < jRVariableArray.length; ++i5) {
                if (jRVariableArray[i5].isSystemDefined()) continue;
                this.writeVariable(jRVariableArray[i5]);
            }
        }
        this.writer.writeExpression("filterExpression", jRDataset.getFilterExpression(), false);
        JRGroup[] jRGroupArray = jRDataset.getGroups();
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            for (int i6 = 0; i6 < jRGroupArray.length; ++i6) {
                this.writeGroup(jRGroupArray[i6]);
            }
        }
    }

    public void writeDatasetRun(JRDatasetRun jRDatasetRun) throws IOException {
        this.writer.startElement("datasetRun");
        this.writer.addEncodedAttribute("subDataset", jRDatasetRun.getDatasetName());
        this.writer.writeExpression("parametersMapExpression", jRDatasetRun.getParametersMapExpression(), false);
        JRDatasetParameter[] jRDatasetParameterArray = jRDatasetRun.getParameters();
        if (jRDatasetParameterArray != null && jRDatasetParameterArray.length > 0) {
            for (int i2 = 0; i2 < jRDatasetParameterArray.length; ++i2) {
                this.writeDatasetParameter(jRDatasetParameterArray[i2]);
            }
        }
        this.writer.writeExpression("connectionExpression", jRDatasetRun.getConnectionExpression(), false);
        this.writer.writeExpression("dataSourceExpression", jRDatasetRun.getDataSourceExpression(), false);
        this.writer.closeElement();
    }

    public void writeFrame(JRFrame jRFrame) throws IOException {
        this.writer.startElement("frame");
        this.writeReportElement(jRFrame);
        this.writeBox(jRFrame.getLineBox());
        List list = jRFrame.getChildren();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((JRChild)iterator.next()).visit(this.xmlWriterVisitor);
            }
        }
        this.writer.closeElement();
    }

    public void writeHyperlinkParameters(JRHyperlinkParameter[] jRHyperlinkParameterArray) throws IOException {
        if (jRHyperlinkParameterArray != null) {
            for (int i2 = 0; i2 < jRHyperlinkParameterArray.length; ++i2) {
                JRHyperlinkParameter jRHyperlinkParameter = jRHyperlinkParameterArray[i2];
                this.writeHyperlinkParameter(jRHyperlinkParameter);
            }
        }
    }

    public void writeHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) throws IOException {
        if (jRHyperlinkParameter != null) {
            this.writer.startElement("hyperlinkParameter");
            this.writer.addEncodedAttribute("name", jRHyperlinkParameter.getName());
            this.writer.writeExpression("hyperlinkParameterExpression", jRHyperlinkParameter.getValueExpression(), true, (a == null ? (a = JRXmlWriter.a("java.lang.String")) : a).getName());
            this.writer.closeElement();
        }
    }

    public void writeHyperlink(String string, JRHyperlink jRHyperlink) throws IOException {
        if (jRHyperlink != null) {
            this.writer.startElement(string);
            this.writer.addEncodedAttribute("hyperlinkType", jRHyperlink.getLinkType());
            this.writer.addAttribute("hyperlinkTarget", jRHyperlink.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
            this.writer.writeExpression("hyperlinkReferenceExpression", jRHyperlink.getHyperlinkReferenceExpression(), false);
            this.writer.writeExpression("hyperlinkAnchorExpression", jRHyperlink.getHyperlinkAnchorExpression(), false);
            this.writer.writeExpression("hyperlinkPageExpression", jRHyperlink.getHyperlinkPageExpression(), false);
            this.writer.writeExpression("hyperlinkTooltipExpression", jRHyperlink.getHyperlinkTooltipExpression(), false);
            this.writeHyperlinkParameters(jRHyperlink.getHyperlinkParameters());
            this.writer.closeElement();
        }
    }

    public boolean toWriteConditionalStyles() {
        return true;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

