/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlDigester;
import net.sf.jasperreports.engine.xml.JRXmlTemplateDigesterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class JRXmlTemplateLoader {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRXmlTemplateLoader.a("net.sf.jasperreports.engine.xml.JRXmlTemplateLoader")) : a);
    public static Class a;

    public static JRTemplate load(String string) throws JRException {
        byte[] byArray = JRLoader.loadBytesFromLocation(string);
        return JRXmlTemplateLoader.load(new ByteArrayInputStream(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JRTemplate load(File file) {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JRRuntimeException("Template XML file not found", fileNotFoundException);
        }
        try {
            JRTemplate jRTemplate = JRXmlTemplateLoader.load(bufferedInputStream);
            return jRTemplate;
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                log.warn("Error closing XML file", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JRTemplate load(URL uRL) {
        InputStream inputStream;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            throw new JRRuntimeException("Error opening connection to template URL " + uRL, iOException);
        }
        try {
            JRTemplate jRTemplate = JRXmlTemplateLoader.load(inputStream);
            return jRTemplate;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                log.warn("Error closing connection to template URL " + uRL, iOException);
            }
        }
    }

    public static JRTemplate load(InputStream inputStream) {
        JRXmlTemplateLoader jRXmlTemplateLoader = new JRXmlTemplateLoader();
        return jRXmlTemplateLoader.loadTemplate(inputStream);
    }

    public JRTemplate loadTemplate(InputStream inputStream) {
        JRXmlDigester jRXmlDigester = JRXmlTemplateDigesterFactory.instance().createDigester();
        try {
            JRTemplate jRTemplate = (JRTemplate)jRXmlDigester.parse(inputStream);
            return jRTemplate;
        }
        catch (IOException iOException) {
            throw new JRRuntimeException("Error reading template XML", iOException);
        }
        catch (SAXException sAXException) {
            throw new JRRuntimeException("Error parsing template XML", sAXException);
        }
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

