/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JRXmlUtils {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRXmlUtils.a("net.sf.jasperreports.engine.util.JRXmlUtils")) : a);
    public static Class a;

    public static Document parse(InputSource inputSource) throws JRException {
        try {
            return JRXmlUtils.createDocumentBuilder().parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new JRException("Failed to parse the xml document", sAXException);
        }
        catch (IOException iOException) {
            throw new JRException("Failed to parse the xml document", iOException);
        }
    }

    public static Document parse(String string) throws JRException {
        return JRXmlUtils.parse(new InputSource(string));
    }

    public static Document parse(File file) throws JRException {
        try {
            return JRXmlUtils.createDocumentBuilder().parse(file);
        }
        catch (SAXException sAXException) {
            throw new JRException("Failed to parse the xmlf document", sAXException);
        }
        catch (IOException iOException) {
            throw new JRException("Failed to parse the xml document", iOException);
        }
    }

    public static Document parse(InputStream inputStream) throws JRException {
        return JRXmlUtils.parse(new InputSource(inputStream));
    }

    public static Document parse(URL uRL) throws JRException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Document document = JRXmlUtils.createDocumentBuilder().parse(inputStream);
            return document;
        }
        catch (SAXException sAXException) {
            throw new JRException("Failed to parse the xmlf document", sAXException);
        }
        catch (IOException iOException) {
            throw new JRException("Failed to parse the xml document", iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    log.warn("Error closing stream of URL " + uRL, iOException);
                }
            }
        }
    }

    public static DocumentBuilder createDocumentBuilder() throws JRException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringComments(true);
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JRException("Failed to create a document builder factory", parserConfigurationException);
        }
    }

    public static Document createDocument(Node node) throws JRException {
        Document document = JRXmlUtils.createDocumentBuilder().newDocument();
        Node node2 = node.getNodeType() == 9 ? ((Document)node).getDocumentElement() : node;
        Node node3 = document.importNode(node2, true);
        document.appendChild(node3);
        return document;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

