/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JRStyledTextParser {
    private static final String ROOT_START = "<st>";
    private static final String ROOT_END = "</st>";
    private static final String NODE_style = "style";
    private static final String NODE_bold = "b";
    private static final String NODE_italic = "i";
    private static final String NODE_underline = "u";
    private static final String NODE_sup = "sup";
    private static final String NODE_sub = "sub";
    private static final String NODE_font = "font";
    private static final String NODE_br = "br";
    private static final String NODE_li = "li";
    private static final String ATTRIBUTE_fontName = "fontName";
    private static final String ATTRIBUTE_fontFace = "face";
    private static final String ATTRIBUTE_color = "color";
    private static final String ATTRIBUTE_size = "size";
    private static final String ATTRIBUTE_isBold = "isBold";
    private static final String ATTRIBUTE_isItalic = "isItalic";
    private static final String ATTRIBUTE_isUnderline = "isUnderline";
    private static final String ATTRIBUTE_isStrikeThrough = "isStrikeThrough";
    private static final String ATTRIBUTE_forecolor = "forecolor";
    private static final String ATTRIBUTE_backcolor = "backcolor";
    private static final String ATTRIBUTE_pdfFontName = "pdfFontName";
    private static final String ATTRIBUTE_pdfEncoding = "pdfEncoding";
    private static final String ATTRIBUTE_isPdfEmbedded = "isPdfEmbedded";
    private static final String SPACE = " ";
    private static final String EQUAL_QUOTE = "=\"";
    private static final String QUOTE = "\"";
    private static final String SHARP = "#";
    private static final String LESS = "<";
    private static final String LESS_SLASH = "</";
    private static final String GREATER = ">";
    private static final ThreadLocal threadInstances = new ThreadLocal();
    private DocumentBuilder documentBuilder = null;

    public static JRStyledTextParser getInstance() {
        JRStyledTextParser jRStyledTextParser = null;
        SoftReference softReference = (SoftReference)threadInstances.get();
        if (softReference != null) {
            jRStyledTextParser = (JRStyledTextParser)softReference.get();
        }
        if (jRStyledTextParser == null) {
            jRStyledTextParser = new JRStyledTextParser();
            threadInstances.set(new SoftReference<JRStyledTextParser>(jRStyledTextParser));
        }
        return jRStyledTextParser;
    }

    public JRStyledTextParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JRRuntimeException(parserConfigurationException);
        }
    }

    public JRStyledText parse(Map map, String string) throws SAXException {
        JRStyledText jRStyledText = new JRStyledText();
        Document document = null;
        try {
            document = this.documentBuilder.parse(new InputSource(new StringReader(ROOT_START + string + ROOT_END)));
        }
        catch (IOException iOException) {
            throw new JRRuntimeException(iOException);
        }
        this.parseStyle(jRStyledText, document.getDocumentElement());
        jRStyledText.setGlobalAttributes(map);
        return jRStyledText;
    }

    public JRStyledText getStyledText(Map map, String string, boolean bl2) {
        JRStyledText jRStyledText = null;
        if (bl2) {
            try {
                jRStyledText = this.parse(map, string);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        if (jRStyledText == null) {
            jRStyledText = new JRStyledText();
            jRStyledText.append(string);
            jRStyledText.setGlobalAttributes(map);
        }
        return jRStyledText;
    }

    public String write(JRStyledText jRStyledText) {
        return this.write(jRStyledText.getGlobalAttributes(), jRStyledText.getAttributedString().getIterator(), jRStyledText.getText());
    }

    public String write(Map map, AttributedCharacterIterator attributedCharacterIterator, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < attributedCharacterIterator.getEndIndex() && (n2 = attributedCharacterIterator.getRunLimit()) <= attributedCharacterIterator.getEndIndex()) {
            String string2 = string.substring(attributedCharacterIterator.getIndex(), n2);
            Map<AttributedCharacterIterator.Attribute, Object> map2 = attributedCharacterIterator.getAttributes();
            StringBuffer stringBuffer2 = this.writeStyleAttributes(map, map2);
            if (stringBuffer2.length() > 0) {
                stringBuffer.append(LESS);
                stringBuffer.append(NODE_style);
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append(GREATER);
                this.writeChunk(stringBuffer, map, map2, string2);
                stringBuffer.append(LESS_SLASH);
                stringBuffer.append(NODE_style);
                stringBuffer.append(GREATER);
            } else {
                this.writeChunk(stringBuffer, map, map2, string2);
            }
            attributedCharacterIterator.setIndex(n2);
        }
        return stringBuffer.toString();
    }

    public String write(JRStyledText jRStyledText, int n2, int n3) {
        AttributedCharacterIterator attributedCharacterIterator = new AttributedString(jRStyledText.getAttributedString().getIterator(), n2, n3).getIterator();
        String string = jRStyledText.getText().substring(n2, n3);
        return this.write(jRStyledText.getGlobalAttributes(), attributedCharacterIterator, string);
    }

    public void writeChunk(StringBuffer stringBuffer, Map map, Map map2, String string) {
        Object v2 = map2.get(TextAttribute.SUPERSCRIPT);
        Object v3 = map.get(TextAttribute.SUPERSCRIPT);
        boolean bl2 = false;
        boolean bl3 = false;
        if (v2 != null && !v2.equals(v3)) {
            bl2 = TextAttribute.SUPERSCRIPT_SUPER.equals(v2);
            bl3 = TextAttribute.SUPERSCRIPT_SUB.equals(v2);
        }
        if (bl2 || bl3) {
            String string2 = bl2 ? NODE_sup : NODE_sub;
            stringBuffer.append(LESS);
            stringBuffer.append(string2);
            stringBuffer.append(GREATER);
            stringBuffer.append(JRStringUtil.xmlEncode(string));
            stringBuffer.append(LESS_SLASH);
            stringBuffer.append(string2);
            stringBuffer.append(GREATER);
        } else {
            stringBuffer.append(JRStringUtil.xmlEncode(string));
        }
    }

    private void parseStyle(JRStyledText jRStyledText, Node node) throws SAXException {
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string;
            Node node2 = nodeList.item(i2);
            if (node2.getNodeType() == 3) {
                jRStyledText.append(node2.getNodeValue());
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_style.equals(node2.getNodeName())) {
                Color color;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                if (namedNodeMap.getNamedItem(ATTRIBUTE_fontName) != null) {
                    hashMap.put(TextAttribute.FAMILY, namedNodeMap.getNamedItem(ATTRIBUTE_fontName).getNodeValue());
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_isBold) != null) {
                    hashMap.put(TextAttribute.WEIGHT, Boolean.valueOf(namedNodeMap.getNamedItem(ATTRIBUTE_isBold).getNodeValue()) != false ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_isItalic) != null) {
                    hashMap.put(TextAttribute.POSTURE, Boolean.valueOf(namedNodeMap.getNamedItem(ATTRIBUTE_isItalic).getNodeValue()) != false ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_isUnderline) != null) {
                    hashMap.put(TextAttribute.UNDERLINE, Boolean.valueOf(namedNodeMap.getNamedItem(ATTRIBUTE_isUnderline).getNodeValue()) != false ? TextAttribute.UNDERLINE_ON : null);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_isStrikeThrough) != null) {
                    hashMap.put(TextAttribute.STRIKETHROUGH, Boolean.valueOf(namedNodeMap.getNamedItem(ATTRIBUTE_isStrikeThrough).getNodeValue()) != false ? TextAttribute.STRIKETHROUGH_ON : null);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_size) != null) {
                    hashMap.put(TextAttribute.SIZE, new Float(namedNodeMap.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_pdfFontName) != null) {
                    hashMap.put(JRTextAttribute.PDF_FONT_NAME, namedNodeMap.getNamedItem(ATTRIBUTE_pdfFontName).getNodeValue());
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_pdfEncoding) != null) {
                    hashMap.put(JRTextAttribute.PDF_ENCODING, namedNodeMap.getNamedItem(ATTRIBUTE_pdfEncoding).getNodeValue());
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_isPdfEmbedded) != null) {
                    hashMap.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.valueOf(namedNodeMap.getNamedItem(ATTRIBUTE_isPdfEmbedded).getNodeValue()));
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_forecolor) != null) {
                    color = JRXmlConstants.getColor(namedNodeMap.getNamedItem(ATTRIBUTE_forecolor).getNodeValue(), Color.black);
                    hashMap.put(TextAttribute.FOREGROUND, color);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_backcolor) != null) {
                    color = JRXmlConstants.getColor(namedNodeMap.getNamedItem(ATTRIBUTE_backcolor).getNodeValue(), Color.black);
                    hashMap.put(TextAttribute.BACKGROUND, color);
                }
                int n2 = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap, n2, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_bold.equalsIgnoreCase(node2.getNodeName())) {
                HashMap<TextAttribute, Float> hashMap = new HashMap<TextAttribute, Float>();
                hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                int n3 = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap, n3, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_italic.equalsIgnoreCase(node2.getNodeName())) {
                HashMap<TextAttribute, Float> hashMap = new HashMap<TextAttribute, Float>();
                hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                int n4 = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap, n4, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_underline.equalsIgnoreCase(node2.getNodeName())) {
                HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>();
                hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                int n5 = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap, n5, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_sup.equalsIgnoreCase(node2.getNodeName())) {
                HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>();
                hashMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
                int n6 = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap, n6, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_sub.equalsIgnoreCase(node2.getNodeName())) {
                HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>();
                hashMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
                int n7 = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap, n7, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_font.equalsIgnoreCase(node2.getNodeName())) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                if (namedNodeMap.getNamedItem(ATTRIBUTE_fontFace) != null) {
                    hashMap.put(JRTextAttribute.HTML_FONT_FACE, namedNodeMap.getNamedItem(ATTRIBUTE_fontFace).getNodeValue());
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_size) != null) {
                    hashMap.put(TextAttribute.SIZE, new Float(namedNodeMap.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_color) != null) {
                    Color color = JRXmlConstants.getColor(namedNodeMap.getNamedItem(ATTRIBUTE_color).getNodeValue(), Color.black);
                    hashMap.put(TextAttribute.FOREGROUND, color);
                }
                if (namedNodeMap.getNamedItem(ATTRIBUTE_fontFace) != null) {
                    String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    string = namedNodeMap.getNamedItem(ATTRIBUTE_fontFace).getNodeValue();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    block1: while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken().trim();
                        for (int i3 = 0; i3 < stringArray.length; ++i3) {
                            if (!stringArray[i3].equals(string2)) continue;
                            hashMap.put(TextAttribute.FAMILY, string2);
                            break block1;
                        }
                    }
                }
                int n8 = jRStyledText.length();
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(hashMap, n8, jRStyledText.length()));
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_br.equalsIgnoreCase(node2.getNodeName())) {
                jRStyledText.append("\n");
                int n9 = jRStyledText.length();
                this.resizeRuns(jRStyledText.getRuns(), n9, 1);
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(new HashMap(), n9, jRStyledText.length()));
                if (n9 >= jRStyledText.length()) continue;
                jRStyledText.append("\n");
                this.resizeRuns(jRStyledText.getRuns(), n9, 1);
                continue;
            }
            if (node2.getNodeType() == 1 && NODE_li.equalsIgnoreCase(node2.getNodeName())) {
                String string3 = jRStyledText.getText();
                if (string3.length() > 0 && !string3.endsWith("\n")) {
                    jRStyledText.append("\n");
                }
                jRStyledText.append(" \u2022 ");
                int n10 = jRStyledText.length();
                this.resizeRuns(jRStyledText.getRuns(), n10, 1);
                this.parseStyle(jRStyledText, node2);
                jRStyledText.addRun(new JRStyledText.Run(new HashMap(), n10, jRStyledText.length()));
                Node node3 = node2.getNextSibling();
                string = this.getFirstTextOccurence(node3);
                if (node3 == null || node3.getNodeType() == 1 && NODE_li.equalsIgnoreCase(node3.getNodeName()) || string != null && string.startsWith("\n")) continue;
                jRStyledText.append("\n");
                this.resizeRuns(jRStyledText.getRuns(), n10, 1);
                continue;
            }
            if (node2.getNodeType() != 1) continue;
            String string4 = LESS + node2.getNodeName() + GREATER;
            throw new SAXException("Tag " + string4 + " is not a valid styled text tag.");
        }
    }

    private void resizeRuns(List list, int n2, int n3) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            JRStyledText.Run run = (JRStyledText.Run)list.get(i2);
            if (run.startIndex > n2 || run.endIndex <= n2 - n3) continue;
            run.endIndex += n3;
        }
    }

    private StringBuffer writeStyleAttributes(Map map, Map map2) {
        StringBuffer stringBuffer = new StringBuffer();
        Object v2 = map2.get(TextAttribute.FAMILY);
        Object v3 = map.get(TextAttribute.FAMILY);
        if (v2 != null && !v2.equals(v3)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_fontName);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v2);
            stringBuffer.append(QUOTE);
        }
        v2 = map2.get(TextAttribute.WEIGHT);
        v3 = map.get(TextAttribute.WEIGHT);
        if (v2 != null && !v2.equals(v3)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_isBold);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v2.equals(TextAttribute.WEIGHT_BOLD));
            stringBuffer.append(QUOTE);
        }
        v2 = map2.get(TextAttribute.POSTURE);
        v3 = map.get(TextAttribute.POSTURE);
        if (v2 != null && !v2.equals(v3)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_isItalic);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v2.equals(TextAttribute.POSTURE_OBLIQUE));
            stringBuffer.append(QUOTE);
        }
        v2 = map2.get(TextAttribute.UNDERLINE);
        v3 = map.get(TextAttribute.UNDERLINE);
        if (v2 == null && v3 != null || v2 != null && !v2.equals(v3)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_isUnderline);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v2 != null);
            stringBuffer.append(QUOTE);
        }
        v2 = map2.get(TextAttribute.STRIKETHROUGH);
        v3 = map.get(TextAttribute.STRIKETHROUGH);
        if (v2 == null && v3 != null || v2 != null && !v2.equals(v3)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_isStrikeThrough);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v2 != null);
            stringBuffer.append(QUOTE);
        }
        v2 = map2.get(TextAttribute.SIZE);
        v3 = map.get(TextAttribute.SIZE);
        if (v2 != null && !v2.equals(v3)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_size);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(((Float)v2).intValue());
            stringBuffer.append(QUOTE);
        }
        v2 = map2.get(JRTextAttribute.PDF_FONT_NAME);
        v3 = map.get(JRTextAttribute.PDF_FONT_NAME);
        if (v2 != null && !v2.equals(v3)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_pdfFontName);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v2);
            stringBuffer.append(QUOTE);
        }
        v2 = map2.get(JRTextAttribute.PDF_ENCODING);
        v3 = map.get(JRTextAttribute.PDF_ENCODING);
        if (v2 != null && !v2.equals(v3)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_pdfEncoding);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v2);
            stringBuffer.append(QUOTE);
        }
        v2 = map2.get(JRTextAttribute.IS_PDF_EMBEDDED);
        v3 = map.get(JRTextAttribute.IS_PDF_EMBEDDED);
        if (v2 != null && !v2.equals(v3)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_isPdfEmbedded);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(v2);
            stringBuffer.append(QUOTE);
        }
        v2 = map2.get(TextAttribute.FOREGROUND);
        v3 = map.get(TextAttribute.FOREGROUND);
        if (v2 != null && !v2.equals(v3)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_forecolor);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(SHARP);
            stringBuffer.append(JRColorUtil.getColorHexa((Color)v2));
            stringBuffer.append(QUOTE);
        }
        v2 = map2.get(TextAttribute.BACKGROUND);
        v3 = map.get(TextAttribute.BACKGROUND);
        if (v2 != null && !v2.equals(v3)) {
            stringBuffer.append(SPACE);
            stringBuffer.append(ATTRIBUTE_backcolor);
            stringBuffer.append(EQUAL_QUOTE);
            stringBuffer.append(SHARP);
            stringBuffer.append(JRColorUtil.getColorHexa((Color)v2));
            stringBuffer.append(QUOTE);
        }
        return stringBuffer;
    }

    private String getFirstTextOccurence(Node node) {
        if (node != null) {
            if (node.getNodeValue() != null) {
                return node.getNodeValue();
            }
            NodeList nodeList = node.getChildNodes();
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                String string = this.getFirstTextOccurence(nodeList.item(i2));
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }
}

