/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.lang.reflect.Array;
import java.util.Collection;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;

public abstract class JRSqlAbstractInClause
implements JRClauseFunction {
    public static final int POSITION_DB_COLUMN = 1;
    public static final int POSITION_PARAMETER = 2;
    public static final String CLAUSE_TRUISM = "0 = 0";

    public void apply(JRClauseTokens jRClauseTokens, JRQueryClauseContext jRQueryClauseContext) {
        String string = jRClauseTokens.getToken(1);
        String string2 = jRClauseTokens.getToken(2);
        if (string == null) {
            throw new JRRuntimeException("SQL IN clause missing DB column token");
        }
        if (string2 == null) {
            throw new JRRuntimeException("SQL IN clause missing parameter token");
        }
        StringBuffer stringBuffer = jRQueryClauseContext.queryBuffer();
        Object object = jRQueryClauseContext.getValueParameter(string2).getValue();
        if (object == null) {
            this.handleNoValues(jRQueryClauseContext);
        } else {
            int n2 = this.valuesCount(string2, object);
            if (n2 == 0) {
                this.handleNoValues(jRQueryClauseContext);
            } else {
                stringBuffer.append(string);
                stringBuffer.append(' ');
                this.appendInOperator(stringBuffer);
                stringBuffer.append(' ');
                stringBuffer.append('(');
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (i2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append('?');
                }
                stringBuffer.append(')');
                jRQueryClauseContext.addQueryMultiParameters(string2, n2);
            }
        }
    }

    public void handleNoValues(JRQueryClauseContext jRQueryClauseContext) {
        jRQueryClauseContext.queryBuffer().append(CLAUSE_TRUISM);
    }

    public int valuesCount(String string, Object object) {
        int n2;
        if (object.getClass().isArray()) {
            n2 = Array.getLength(object);
        } else if (object instanceof Collection) {
            n2 = ((Collection)object).size();
        } else {
            throw new JRRuntimeException("Invalid type + " + object.getClass().getName() + " for parameter " + string + " used in an IN clause; the value must be an array or a collection.");
        }
        return n2;
    }

    public abstract void appendInOperator(StringBuffer var1);
}

