/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.JRJpaDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJpaQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRJpaQueryExecuter.a("net.sf.jasperreports.engine.query.JRJpaQueryExecuter")) : a);
    private final Integer reportMaxCount;
    private EntityManager em = (EntityManager)this.getParameterValue("JPA_ENTITY_MANAGER");
    private Query query;
    public static Class a;

    public JRJpaQueryExecuter(JRDataset jRDataset, Map map) {
        super(jRDataset, map);
        this.reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
        if (this.em == null) {
            log.warn("The supplied javax.persistence.EntityManager object is null.");
        }
        this.parseQuery();
    }

    public JRDataSource createDatasource() throws JRException {
        JRDataSource jRDataSource = null;
        String string = this.getQueryString();
        if (this.em != null && string != null && string.trim().length() > 0) {
            this.createQuery(string);
            jRDataSource = this.createResultDatasource();
        }
        return jRDataSource;
    }

    public synchronized void createQuery(String string) {
        Object object;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (log.isDebugEnabled()) {
            log.debug("EJBQL query: " + string);
        }
        this.query = this.em.createQuery(string);
        List list = this.getCollectedParameterNames();
        if (!list.isEmpty()) {
            object5 = new HashSet();
            object4 = list.iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                if (!object5.add(object3)) continue;
                object2 = this.getValueParameter((String)object3);
                string2 = this.getEjbqlParameterName((String)object3);
                object = object2.getValue();
                if (log.isDebugEnabled()) {
                    log.debug("Parameter " + string2 + ": " + object);
                }
                this.query.setParameter(string2, object);
            }
        }
        if ((object5 = (Map)this.getParameterValue("JPA_QUERY_HINTS_MAP")) != null) {
            object4 = object5.entrySet().iterator();
            while (object4.hasNext()) {
                object3 = (Map.Entry)object4.next();
                log.debug("EJBQL query hint [" + object3.getKey() + "] set.");
                this.query.setHint((String)object3.getKey(), object3.getValue());
            }
        }
        object4 = JRProperties.getProperties(this.dataset, "net.sf.jasperreports.ejbql.query.hint.");
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object2 = (JRProperties.PropertySuffix)object3.next();
            string2 = ((JRProperties.PropertySuffix)object2).getSuffix();
            if (string2.length() <= 0) continue;
            object = ((JRProperties.PropertySuffix)object2).getValue();
            if (log.isDebugEnabled()) {
                log.debug("EJBQL query hint [" + string2 + "] set to: " + (String)object);
            }
            this.query.setHint(string2, object2);
        }
    }

    public JRDataSource createResultDatasource() {
        JRJpaDataSource jRJpaDataSource;
        try {
            int n2 = JRProperties.getIntegerProperty(this.dataset, "net.sf.jasperreports.ejbql.query.page.size", 0);
            jRJpaDataSource = new JRJpaDataSource(this, n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JRRuntimeException("The net.sf.jasperreports.ejbql.query.page.size property must be numerical.");
        }
        return jRJpaDataSource;
    }

    public synchronized void close() {
        this.query = null;
    }

    public synchronized boolean cancelQuery() throws JRException {
        return false;
    }

    public String getParameterReplacement(String string) {
        return ':' + this.getEjbqlParameterName(string);
    }

    public String getEjbqlParameterName(String string) {
        return JRStringUtil.getLiteral(string);
    }

    public List getResultList() {
        if (this.reportMaxCount != null) {
            this.query.setMaxResults(this.reportMaxCount.intValue());
        }
        return this.query.getResultList();
    }

    public List getResultList(int n2, int n3) {
        if (this.reportMaxCount != null && n2 + n3 > this.reportMaxCount) {
            n3 = this.reportMaxCount - n2;
        }
        this.query.setFirstResult(n2);
        this.query.setMaxResults(n3);
        return this.query.getResultList();
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

