/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.query.JRSqlInClause;
import net.sf.jasperreports.engine.query.JRSqlNotInClause;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJdbcQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(k == null ? (k = JRJdbcQueryExecuter.a("net.sf.jasperreports.engine.query.JRJdbcQueryExecuter")) : k);
    public static final String CLAUSE_ID_IN = "IN";
    public static final String CLAUSE_ID_NOTIN = "NOTIN";
    private Connection connection = (Connection)this.getParameterValue("REPORT_CONNECTION");
    private PreparedStatement statement;
    private ResultSet resultSet;
    public static Class k;
    public static Class m;
    public static Class d;
    public static Class a;
    public static Class h;
    public static Class l;
    public static Class g;
    public static Class j;
    public static Class b;
    public static Class c;
    public static Class e;
    public static Class i;
    public static Class f;

    public JRJdbcQueryExecuter(JRDataset jRDataset, Map map) {
        super(jRDataset, map);
        if (this.connection == null && log.isWarnEnabled()) {
            log.warn("The supplied java.sql.Connection object is null.");
        }
        this.registerFunctions();
        this.parseQuery();
    }

    public void registerFunctions() {
        this.registerClauseFunction(CLAUSE_ID_IN, JRSqlInClause.instance());
        this.registerClauseFunction(CLAUSE_ID_NOTIN, JRSqlNotInClause.instance());
    }

    public String getParameterReplacement(String string) {
        return "?";
    }

    public JRDataSource createDatasource() throws JRException {
        JRResultSetDataSource jRResultSetDataSource = null;
        this.createStatement();
        if (this.statement != null) {
            try {
                Integer n2 = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
                if (n2 != null) {
                    this.statement.setMaxRows(n2);
                }
                this.resultSet = this.statement.executeQuery();
                jRResultSetDataSource = new JRResultSetDataSource(this.resultSet);
            }
            catch (SQLException sQLException) {
                throw new JRException("Error executing SQL statement for : " + this.dataset.getName(), sQLException);
            }
        }
        return jRResultSetDataSource;
    }

    private void createStatement() throws JRException {
        String string = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug("SQL query string: " + string);
        }
        if (this.connection != null && string != null && string.trim().length() > 0) {
            try {
                List list;
                this.statement = this.connection.prepareStatement(string);
                int n2 = JRProperties.getIntegerProperty(this.dataset, "net.sf.jasperreports.jdbc.fetch.size", 0);
                if (n2 != 0) {
                    this.statement.setFetchSize(n2);
                }
                if (!(list = this.getCollectedParameters()).isEmpty()) {
                    int n3 = 1;
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        JRAbstractQueryExecuter.QueryParameter queryParameter = (JRAbstractQueryExecuter.QueryParameter)list.get(i2);
                        if (queryParameter.isMulti()) {
                            n3 += this.setStatementMultiParameters(n3, queryParameter.getName());
                            continue;
                        }
                        this.setStatementParameter(n3, queryParameter.getName());
                        ++n3;
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new JRException("Error preparing statement for executing the report query : \n\n" + string + "\n\n", sQLException);
            }
        }
    }

    public void setStatementParameter(int n2, String string) throws SQLException {
        JRValueParameter jRValueParameter = this.getValueParameter(string);
        Class clazz = jRValueParameter.getValueClass();
        Object object = jRValueParameter.getValue();
        if (log.isDebugEnabled()) {
            log.debug("Parameter #" + n2 + " (" + string + " of type " + clazz.getName() + "): " + object);
        }
        this.setStatementParameter(n2, clazz, object);
    }

    public int setStatementMultiParameters(int n2, String string) throws SQLException {
        int n3;
        Object object = this.getParameterValue(string);
        if (object.getClass().isArray()) {
            int n4 = Array.getLength(object);
            for (n3 = 0; n3 < n4; ++n3) {
                Object object2 = Array.get(object, n3);
                this.setStatementMultiParameter(n2 + n3, string, n3, object2);
            }
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            n3 = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                this.setStatementMultiParameter(n2 + n3, string, n3, e2);
                ++n3;
            }
        } else {
            throw new JRRuntimeException("Multi parameter value is not array nor collection.");
        }
        return n3;
    }

    public void setStatementMultiParameter(int n2, String string, int n3, Object object) throws SQLException {
        if (object == null) {
            throw new JRRuntimeException("Multi parameters cannot contain null values.");
        }
        Class<?> clazz = object.getClass();
        if (log.isDebugEnabled()) {
            log.debug("Parameter #" + n2 + " (" + string + "[" + n3 + "] of type " + clazz.getName() + "): " + object);
        }
        this.setStatementParameter(n2, clazz, object);
    }

    public void setStatementParameter(int n2, Class clazz, Object object) throws SQLException {
        if ((m == null ? (m = JRJdbcQueryExecuter.a("java.lang.Boolean")) : m).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, -7);
            } else {
                this.statement.setBoolean(n2, (Boolean)object);
            }
        } else if ((d == null ? (d = JRJdbcQueryExecuter.a("java.lang.Byte")) : d).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, -6);
            } else {
                this.statement.setByte(n2, (Byte)object);
            }
        } else if ((a == null ? (a = JRJdbcQueryExecuter.a("java.lang.Double")) : a).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, 8);
            } else {
                this.statement.setDouble(n2, (Double)object);
            }
        } else if ((h == null ? (h = JRJdbcQueryExecuter.a("java.lang.Float")) : h).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, 6);
            } else {
                this.statement.setFloat(n2, ((Float)object).floatValue());
            }
        } else if ((l == null ? (l = JRJdbcQueryExecuter.a("java.lang.Integer")) : l).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, 4);
            } else {
                this.statement.setInt(n2, (Integer)object);
            }
        } else if ((g == null ? (g = JRJdbcQueryExecuter.a("java.lang.Long")) : g).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, -5);
            } else {
                this.statement.setLong(n2, (Long)object);
            }
        } else if ((j == null ? (j = JRJdbcQueryExecuter.a("java.lang.Short")) : j).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, 5);
            } else {
                this.statement.setShort(n2, (Short)object);
            }
        } else if ((b == null ? (b = JRJdbcQueryExecuter.a("java.math.BigDecimal")) : b).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, 3);
            } else {
                this.statement.setBigDecimal(n2, (BigDecimal)object);
            }
        } else if ((c == null ? (c = JRJdbcQueryExecuter.a("java.lang.String")) : c).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, 12);
            } else {
                this.statement.setString(n2, object.toString());
            }
        } else if ((e == null ? (e = JRJdbcQueryExecuter.a("java.sql.Timestamp")) : e).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, 93);
            } else {
                this.statement.setTimestamp(n2, (Timestamp)object);
            }
        } else if ((i == null ? (i = JRJdbcQueryExecuter.a("java.sql.Time")) : i).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, 92);
            } else {
                this.statement.setTime(n2, (Time)object);
            }
        } else if ((f == null ? (f = JRJdbcQueryExecuter.a("java.util.Date")) : f).isAssignableFrom(clazz)) {
            if (object == null) {
                this.statement.setNull(n2, 91);
            } else {
                this.statement.setDate(n2, new Date(((java.util.Date)object).getTime()));
            }
        } else if (object == null) {
            this.statement.setNull(n2, 2000);
        } else {
            this.statement.setObject(n2, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException sQLException) {
                log.error("Error while closing result set.", sQLException);
            }
            finally {
                this.resultSet = null;
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                log.error("Error while closing statement.", sQLException);
            }
            finally {
                this.statement = null;
            }
        }
    }

    public synchronized boolean cancelQuery() throws JRException {
        if (this.statement != null) {
            try {
                this.statement.cancel();
                return true;
            }
            catch (Throwable throwable) {
                throw new JRException("Error cancelling SQL statement", throwable);
            }
        }
        return false;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

