/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.data.JRHibernateAbstractDataSource;
import net.sf.jasperreports.engine.data.JRHibernateIterateDataSource;
import net.sf.jasperreports.engine.data.JRHibernateListDataSource;
import net.sf.jasperreports.engine.data.JRHibernateScrollDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.type.Type;

public class JRHibernateQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRHibernateQueryExecuter.a("net.sf.jasperreports.engine.query.JRHibernateQueryExecuter")) : a);
    private static final Map hibernateTypeMap = new HashMap();
    private final Integer reportMaxCount;
    private Session session = (Session)this.getParameterValue("HIBERNATE_SESSION");
    private Query query;
    private boolean queryRunning;
    private ScrollableResults scrollableResults;
    private boolean isClearCache;
    public static Class a;
    public static Class o;
    public static Class e;
    public static Class b;
    public static Class i;
    public static Class n;
    public static Class h;
    public static Class k;
    public static Class c;
    public static Class l;
    public static Class m;
    public static Class d;
    public static Class f;
    public static Class g;
    public static Class j;
    public static Class p;

    public JRHibernateQueryExecuter(JRDataset jRDataset, Map map) {
        super(jRDataset, map);
        this.reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
        this.isClearCache = JRProperties.getBooleanProperty(jRDataset, "net.sf.jasperreports.hql.clear.cache", false);
        if (this.session == null) {
            log.warn("The supplied org.hibernate.Session object is null.");
        }
        this.parseQuery();
    }

    public JRDataSource createDatasource() throws JRException {
        JRDataSource jRDataSource = null;
        String string = this.getQueryString();
        if (this.session != null && string != null && string.trim().length() > 0) {
            this.createQuery(string);
            jRDataSource = this.createResultDatasource();
        }
        return jRDataSource;
    }

    public JRDataSource createResultDatasource() {
        JRHibernateAbstractDataSource jRHibernateAbstractDataSource;
        String string = JRProperties.getProperty(this.dataset, "net.sf.jasperreports.hql.query.run.type");
        boolean bl2 = JRProperties.getBooleanProperty(this.dataset, "net.sf.jasperreports.hql.field.mapping.descriptions", true);
        if (string == null || string.equals("list")) {
            try {
                int n2 = JRProperties.getIntegerProperty(this.dataset, "net.sf.jasperreports.hql.query.list.page.size", 0);
                jRHibernateAbstractDataSource = new JRHibernateListDataSource(this, bl2, n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("The net.sf.jasperreports.hql.query.list.page.size property must be numerical.");
            }
        } else if (string.equals("iterate")) {
            jRHibernateAbstractDataSource = new JRHibernateIterateDataSource(this, bl2);
        } else if (string.equals("scroll")) {
            jRHibernateAbstractDataSource = new JRHibernateScrollDataSource(this, bl2);
        } else {
            throw new JRRuntimeException("Unknown value for the net.sf.jasperreports.hql.query.run.type property.  Possible values are list, iterate and scroll.");
        }
        return jRHibernateAbstractDataSource;
    }

    public synchronized void createQuery(String string) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug("HQL query: " + string);
        }
        this.query = (object = this.getParameterValue("HIBERNATE_FILTER_COLLECTION")) == null ? this.session.createQuery(string) : this.session.createFilter(object, string);
        this.query.setReadOnly(true);
        int n2 = JRProperties.getIntegerProperty(this.dataset, "net.sf.jasperreports.jdbc.fetch.size", 0);
        if (n2 != 0) {
            this.query.setFetchSize(n2);
        }
        this.setParameters();
    }

    public void setParameters() {
        List list = this.getCollectedParameterNames();
        if (!list.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!hashSet.add(string)) continue;
                JRValueParameter jRValueParameter = this.getValueParameter(string);
                this.setParameter(jRValueParameter);
            }
        }
    }

    public void setParameter(JRValueParameter jRValueParameter) {
        Type type;
        String string = this.getHqlParameterName(jRValueParameter.getName());
        Class clazz = jRValueParameter.getValueClass();
        Object object = jRValueParameter.getValue();
        if (log.isDebugEnabled()) {
            log.debug("Parameter " + string + " of type " + clazz.getName() + ": " + object);
        }
        if ((type = (Type)hibernateTypeMap.get(clazz)) != null) {
            this.query.setParameter(string, object, type);
        } else if ((p == null ? (p = JRHibernateQueryExecuter.a("java.util.Collection")) : p).isAssignableFrom(clazz)) {
            this.query.setParameterList(string, (Collection)object);
        } else if (this.session.getSessionFactory().getClassMetadata(clazz) != null) {
            this.query.setEntity(string, object);
        } else {
            this.query.setParameter(string, object);
        }
    }

    public synchronized void close() {
        this.closeScrollableResults();
        this.query = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeScrollableResults() {
        if (this.scrollableResults != null) {
            try {
                this.scrollableResults.close();
            }
            finally {
                this.scrollableResults = null;
            }
        }
    }

    public synchronized boolean cancelQuery() throws JRException {
        if (this.queryRunning) {
            this.session.cancelQuery();
            return true;
        }
        return false;
    }

    public String getParameterReplacement(String string) {
        return ':' + this.getHqlParameterName(string);
    }

    public String getHqlParameterName(String string) {
        return '_' + JRStringUtil.getLiteral(string);
    }

    public Type[] getReturnTypes() {
        return this.query.getReturnTypes();
    }

    public String[] getReturnAliases() {
        return this.query.getReturnAliases();
    }

    public JRDataset getDataset() {
        return this.dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            List list = this.query.list();
            return list;
        }
        finally {
            this.setQueryRunning(false);
        }
    }

    public synchronized void setQueryRunning(boolean bl2) {
        this.queryRunning = bl2;
    }

    private void setMaxCount() {
        if (this.reportMaxCount != null) {
            this.query.setMaxResults(this.reportMaxCount.intValue());
        }
    }

    public List list(int n2, int n3) {
        if (this.reportMaxCount != null && n2 + n3 > this.reportMaxCount) {
            n3 = this.reportMaxCount - n2;
        }
        this.query.setFirstResult(n2);
        this.query.setMaxResults(n3);
        if (this.isClearCache) {
            this.clearCache();
        }
        return this.query.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterate() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            Iterator iterator = this.query.iterate();
            return iterator;
        }
        finally {
            this.setQueryRunning(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            this.scrollableResults = this.query.scroll(ScrollMode.FORWARD_ONLY);
        }
        finally {
            this.setQueryRunning(false);
        }
        return this.scrollableResults;
    }

    public void clearCache() {
        this.session.flush();
        this.session.clear();
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        hibernateTypeMap.put(o == null ? (o = JRHibernateQueryExecuter.a("java.lang.Boolean")) : o, Hibernate.BOOLEAN);
        hibernateTypeMap.put(e == null ? (e = JRHibernateQueryExecuter.a("java.lang.Byte")) : e, Hibernate.BYTE);
        hibernateTypeMap.put(b == null ? (b = JRHibernateQueryExecuter.a("java.lang.Double")) : b, Hibernate.DOUBLE);
        hibernateTypeMap.put(i == null ? (i = JRHibernateQueryExecuter.a("java.lang.Float")) : i, Hibernate.FLOAT);
        hibernateTypeMap.put(n == null ? (n = JRHibernateQueryExecuter.a("java.lang.Integer")) : n, Hibernate.INTEGER);
        hibernateTypeMap.put(h == null ? (h = JRHibernateQueryExecuter.a("java.lang.Long")) : h, Hibernate.LONG);
        hibernateTypeMap.put(k == null ? (k = JRHibernateQueryExecuter.a("java.lang.Short")) : k, Hibernate.SHORT);
        hibernateTypeMap.put(c == null ? (c = JRHibernateQueryExecuter.a("java.math.BigDecimal")) : c, Hibernate.BIG_DECIMAL);
        hibernateTypeMap.put(l == null ? (l = JRHibernateQueryExecuter.a("java.math.BigInteger")) : l, Hibernate.BIG_INTEGER);
        hibernateTypeMap.put(m == null ? (m = JRHibernateQueryExecuter.a("java.lang.Character")) : m, Hibernate.CHARACTER);
        hibernateTypeMap.put(d == null ? (d = JRHibernateQueryExecuter.a("java.lang.String")) : d, Hibernate.STRING);
        hibernateTypeMap.put(f == null ? (f = JRHibernateQueryExecuter.a("java.util.Date")) : f, Hibernate.DATE);
        hibernateTypeMap.put(g == null ? (g = JRHibernateQueryExecuter.a("java.sql.Timestamp")) : g, Hibernate.TIMESTAMP);
        hibernateTypeMap.put(j == null ? (j = JRHibernateQueryExecuter.a("java.sql.Time")) : j, Hibernate.TIME);
    }
}

