/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.Serializable;
import java.util.Random;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRTemplateElement
implements JRCommonElement,
Serializable {
    private static final long serialVersionUID = 10200L;
    private static final Random randomId = new Random();
    private String key;
    private Byte mode = null;
    private Color forecolor = null;
    private Color backcolor = null;
    public JROrigin origin = null;
    public JRDefaultStyleProvider defaultStyleProvider;
    public JRStyle parentStyle = null;
    private final String id;

    public JRTemplateElement(JROrigin jROrigin, JRDefaultStyleProvider jRDefaultStyleProvider) {
        this.origin = jROrigin;
        this.defaultStyleProvider = jRDefaultStyleProvider;
        this.id = this.createId();
    }

    public JRTemplateElement(JROrigin jROrigin, JRElement jRElement) {
        this.origin = jROrigin;
        this.setElement(jRElement);
        this.id = this.createId();
    }

    public JRTemplateElement(String string) {
        this.id = string;
    }

    private String createId() {
        return System.identityHashCode(this) + "_" + System.currentTimeMillis() + "_" + randomId.nextInt();
    }

    public void setElement(JRElement jRElement) {
        this.parentStyle = jRElement.getStyle();
        this.setKey(jRElement.getKey());
        this.mode = jRElement.getOwnMode();
        this.forecolor = jRElement.getOwnForecolor();
        this.backcolor = jRElement.getOwnBackcolor();
    }

    public JROrigin getOrigin() {
        return this.origin;
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    public JRStyle getStyle() {
        return this.parentStyle;
    }

    public JRStyle getBaseStyle() {
        if (this.parentStyle != null) {
            return this.parentStyle;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultStyle();
        }
        return null;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)1);
    }

    public Byte getOwnMode() {
        return this.mode;
    }

    public void setMode(byte by2) {
        this.mode = new Byte(by2);
    }

    public void setMode(Byte by2) {
        this.mode = by2;
    }

    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    public Color getOwnForecolor() {
        return this.forecolor;
    }

    public void setForecolor(Color color) {
        this.forecolor = color;
    }

    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color color) {
        this.backcolor = color;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getStyleNameReference() {
        return null;
    }
}

