/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRLongIncrementerFactory;

public class JRLongCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRLongCountIncrementer mainInstance = new JRLongCountIncrementer();

    private JRLongCountIncrementer() {
    }

    public static JRLongCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable jRCalculable, Object object, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRLongIncrementerFactory.ZERO;
        }
        if (object == null) {
            return number;
        }
        return new Long(number.longValue() + 1L);
    }

    public Object combine(JRCalculable jRCalculable, JRCalculable jRCalculable2, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        Number number2 = (Number)jRCalculable2.getValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRLongIncrementerFactory.ZERO;
        }
        if (number2 == null) {
            return number;
        }
        return new Long(number.longValue() + number2.longValue());
    }

    public Object initialValue() {
        return JRLongIncrementerFactory.ZERO;
    }
}

