/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRFloatIncrementerFactory;

public class JRFloatCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRFloatCountIncrementer mainInstance = new JRFloatCountIncrementer();

    private JRFloatCountIncrementer() {
    }

    public static JRFloatCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable jRCalculable, Object object, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRFloatIncrementerFactory.ZERO;
        }
        if (object == null) {
            return number;
        }
        return new Float(number.floatValue() + 1.0f);
    }

    public Object combine(JRCalculable jRCalculable, JRCalculable jRCalculable2, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        Number number2 = (Number)jRCalculable2.getValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRFloatIncrementerFactory.ZERO;
        }
        if (number2 == null) {
            return number;
        }
        return new Float(number.floatValue() + number2.floatValue());
    }

    public Object initialValue() {
        return JRFloatIncrementerFactory.ZERO;
    }
}

