/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillBreak;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCrosstab;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillFrame;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRYComparator;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRFillElementContainer
extends JRFillElementGroup {
    public JRBaseFiller filler;
    private JRFillElement[] ySortedElements = null;
    private JRFillElement[] stretchElements = null;
    private JRFillElement[] bandBottomElements = null;
    private JRFillElement[] removableElements = null;
    private boolean willOverflow = false;
    public boolean isOverflow = false;
    private int stretchHeight = 0;
    private int firstY = 0;
    public JRFillElement firstYElement = null;
    public final JRFillExpressionEvaluator expressionEvaluator;
    public JRFillElement[] deepElements;
    public Set stylesToEvaluate = new HashSet();
    public Map evaluatedStyles = new HashMap();
    public boolean hasPrintWhenOverflowElement;

    public JRFillElementContainer(JRBaseFiller jRBaseFiller, JRElementGroup jRElementGroup, JRFillObjectFactory jRFillObjectFactory) {
        super(jRElementGroup, jRFillObjectFactory);
        this.expressionEvaluator = jRFillObjectFactory.getExpressionEvaluator();
        this.initDeepElements();
        this.filler = jRBaseFiller;
    }

    public JRFillElementContainer(JRFillElementContainer jRFillElementContainer, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillElementContainer, jRFillCloneFactory);
        this.expressionEvaluator = jRFillElementContainer.expressionEvaluator;
        this.initDeepElements();
        this.filler = jRFillElementContainer.filler;
    }

    private void initDeepElements() {
        if (this.elements == null) {
            this.deepElements = new JRFillElement[0];
        } else {
            ArrayList arrayList = new ArrayList(this.elements.length);
            JRFillElementContainer.collectDeepElements(this.elements, arrayList);
            this.deepElements = new JRFillElement[arrayList.size()];
            arrayList.toArray(this.deepElements);
        }
    }

    private static void collectDeepElements(JRElement[] jRElementArray, List list) {
        for (int i2 = 0; i2 < jRElementArray.length; ++i2) {
            JRElement jRElement = jRElementArray[i2];
            list.add(jRElement);
            if (!(jRElement instanceof JRFillFrame)) continue;
            JRFrame jRFrame = (JRFrame)jRElement;
            JRFillElementContainer.collectDeepElements(jRFrame.getElements(), list);
        }
    }

    public final void initElements() {
        this.hasPrintWhenOverflowElement = false;
        if (this.elements != null && this.elements.length > 0) {
            ArrayList<JRFillElement> arrayList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> arrayList2 = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> arrayList3 = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> arrayList4 = new ArrayList<JRFillElement>();
            for (int i2 = 0; i2 < this.elements.length; ++i2) {
                JRFillElement jRFillElement = this.elements[i2];
                arrayList.add(jRFillElement);
                if (jRFillElement.getPositionType() == 3) {
                    arrayList3.add(jRFillElement);
                }
                if (jRFillElement.getStretchType() != 0) {
                    arrayList2.add(jRFillElement);
                }
                if (jRFillElement.isRemoveLineWhenBlank()) {
                    arrayList4.add(jRFillElement);
                }
                if (!jRFillElement.isPrintWhenDetailOverflows()) continue;
                this.hasPrintWhenOverflowElement = true;
            }
            Collections.sort(arrayList, new JRYComparator());
            this.ySortedElements = new JRFillElement[this.elements.length];
            arrayList.toArray(this.ySortedElements);
            this.stretchElements = new JRFillElement[arrayList2.size()];
            arrayList2.toArray(this.stretchElements);
            this.bandBottomElements = new JRFillElement[arrayList3.size()];
            arrayList3.toArray(this.bandBottomElements);
            this.removableElements = new JRFillElement[arrayList4.size()];
            arrayList4.toArray(this.removableElements);
        }
        this.setDependentElements();
        this.setElementsBandBottomY();
    }

    public final void setElementsBandBottomY() {
        if (this.elements != null && this.elements.length > 0) {
            for (int i2 = 0; i2 < this.elements.length; ++i2) {
                this.elements[i2].setBandBottomY(this.getContainerHeight() - this.elements[i2].getY() - this.elements[i2].getHeight());
            }
        }
    }

    private void setDependentElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i2 = 0; i2 < this.ySortedElements.length - 1; ++i2) {
                JRFillElement jRFillElement = this.ySortedElements[i2];
                boolean bl2 = jRFillElement instanceof JRFillBreak;
                for (int i3 = i2 + 1; i3 < this.ySortedElements.length; ++i3) {
                    JRFillElement jRFillElement2 = this.ySortedElements[i3];
                    int n2 = Math.min(jRFillElement.getX(), jRFillElement2.getX());
                    int n3 = Math.max(jRFillElement.getX() + jRFillElement.getWidth(), jRFillElement2.getX() + jRFillElement2.getWidth());
                    if ((!bl2 || jRFillElement2.getPositionType() != 2) && jRFillElement2.getPositionType() != 1 || jRFillElement.getY() + jRFillElement.getHeight() > jRFillElement2.getY() || jRFillElement.getWidth() + jRFillElement2.getWidth() <= n3 - n2) continue;
                    jRFillElement.addDependantElement(jRFillElement2);
                }
            }
        }
    }

    public void evaluate(byte by2) throws JRException {
        JRElement[] jRElementArray = this.getElements();
        if (jRElementArray != null && jRElementArray.length > 0) {
            for (int i2 = 0; i2 < jRElementArray.length; ++i2) {
                JRFillElement jRFillElement = (JRFillElement)jRElementArray[i2];
                jRFillElement.setCurrentEvaluation(by2);
                jRFillElement.evaluate(by2);
            }
        }
    }

    public void resetElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i2 = 0; i2 < this.ySortedElements.length; ++i2) {
                JRFillElement jRFillElement = this.ySortedElements[i2];
                jRFillElement.reset();
                if (this.isOverflow) continue;
                jRFillElement.setAlreadyPrinted(false);
            }
        }
    }

    public boolean willOverflow() {
        return this.willOverflow;
    }

    public void initFill() {
        this.isOverflow = this.willOverflow;
        this.firstY = 0;
        this.firstYElement = null;
    }

    public void prepareElements(int n2, boolean bl2) throws JRException {
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        this.firstY = this.isOverflow ? this.getContainerHeight() : 0;
        this.firstYElement = null;
        boolean bl4 = false;
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i2 = 0; i2 < this.ySortedElements.length; ++i2) {
                JRFillElement jRFillElement = this.ySortedElements[i2];
                bl3 = jRFillElement.prepare(n2 + this.getElementFirstY(jRFillElement), this.isOverflow) || bl3;
                jRFillElement.moveDependantElements();
                if (!jRFillElement.isToPrint()) continue;
                if (this.isOverflow) {
                    if (jRFillElement.isReprinted()) {
                        this.firstY = 0;
                    } else if (!bl4) {
                        this.firstY = jRFillElement.getY();
                    }
                    bl4 = true;
                }
                this.firstYElement = jRFillElement;
                n4 = jRFillElement.getRelativeY() + jRFillElement.getStretchHeight() - this.getContainerHeight() + jRFillElement.getBandBottomY();
                if (n4 <= n3) continue;
                n3 = n4;
            }
        }
        if (n3 > n2 + this.firstY) {
            bl3 = true;
        }
        this.stretchHeight = bl3 ? this.getContainerHeight() + n2 : this.getContainerHeight() + n3;
        this.willOverflow = bl3 && bl2;
    }

    private int getElementFirstY(JRFillElement jRFillElement) {
        int n2 = !this.isOverflow || this.hasPrintWhenOverflowElement ? 0 : (jRFillElement.getY() >= this.firstY ? this.firstY : jRFillElement.getY());
        return n2;
    }

    public void setStretchHeight(int n2) {
        if (n2 > this.stretchHeight) {
            this.stretchHeight = n2;
        }
    }

    public void stretchElements() {
        JRFillElement jRFillElement;
        int n2;
        if (this.stretchElements != null && this.stretchElements.length > 0) {
            for (n2 = 0; n2 < this.stretchElements.length; ++n2) {
                jRFillElement = this.stretchElements[n2];
                jRFillElement.stretchElement(this.stretchHeight - this.getContainerHeight());
                jRFillElement.moveDependantElements();
            }
        }
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (n2 = 0; n2 < this.ySortedElements.length; ++n2) {
                jRFillElement = this.ySortedElements[n2];
                jRFillElement.stretchHeightFinal();
            }
        }
    }

    public int getStretchHeight() {
        return this.stretchHeight;
    }

    public void moveBandBottomElements() {
        if (this.bandBottomElements != null && this.bandBottomElements.length > 0) {
            for (int i2 = 0; i2 < this.bandBottomElements.length; ++i2) {
                JRFillElement jRFillElement = this.bandBottomElements[i2];
                jRFillElement.setRelativeY(jRFillElement.getY() + this.stretchHeight - this.getContainerHeight());
                jRFillElement.setToPrint(jRFillElement.isToPrint() && !this.willOverflow);
            }
        }
    }

    public void removeBlankElements() {
        JRFillElement[] jRFillElementArray = this.removableElements;
        if (jRFillElementArray != null && jRFillElementArray.length > 0) {
            JRFillElement[] jRFillElementArray2 = this.ySortedElements;
            for (int i2 = 0; i2 < jRFillElementArray.length; ++i2) {
                JRFillElement jRFillElement;
                int n2;
                JRFillElement jRFillElement2 = jRFillElementArray[i2];
                int n3 = jRFillElement2.isToPrint() ? jRFillElement2.getHeight() - jRFillElement2.getStretchHeight() : jRFillElement2.getHeight();
                if (n3 <= 0 || jRFillElement2.getRelativeY() + jRFillElement2.getStretchHeight() > this.stretchHeight || jRFillElement2.getRelativeY() < this.firstY) continue;
                int n4 = jRFillElement2.getRelativeY() + jRFillElement2.getHeight() - n3;
                boolean bl2 = true;
                for (n2 = 0; n2 < jRFillElementArray2.length; ++n2) {
                    jRFillElement = jRFillElementArray2[n2];
                    if (jRFillElement2 == jRFillElement || !jRFillElement.isToPrint()) continue;
                    int n5 = Math.min(n4, jRFillElement.getRelativeY());
                    int n6 = Math.max(n4 + n3, jRFillElement.getRelativeY() + jRFillElement.getStretchHeight());
                    if (n3 + jRFillElement.getStretchHeight() <= n6 - n5) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                for (n2 = 0; n2 < jRFillElementArray2.length; ++n2) {
                    jRFillElement = jRFillElementArray2[n2];
                    if (jRFillElement.getRelativeY() < n4 + n3) continue;
                    jRFillElement.setRelativeY(jRFillElement.getRelativeY() - n3);
                }
                this.stretchHeight -= n3;
            }
        }
    }

    public void fillElements(JRPrintElementContainer jRPrintElementContainer) throws JRException {
        JRElement[] jRElementArray = this.getElements();
        if (jRElementArray != null && jRElementArray.length > 0) {
            for (int i2 = 0; i2 < jRElementArray.length; ++i2) {
                Object object;
                JRPrintElement jRPrintElement;
                JRFillElement jRFillElement = (JRFillElement)jRElementArray[i2];
                jRFillElement.setRelativeY(jRFillElement.getRelativeY() - this.firstY);
                if (jRFillElement.getRelativeY() + jRFillElement.getStretchHeight() > this.stretchHeight) {
                    jRFillElement.setToPrint(false);
                }
                jRFillElement.setAlreadyPrinted(jRFillElement.isToPrint() || jRFillElement.isAlreadyPrinted());
                if (!jRFillElement.isToPrint() || (jRPrintElement = jRFillElement.fill()) == null) continue;
                jRPrintElementContainer.addElement(jRPrintElement);
                if (jRFillElement instanceof JRFillSubreport) {
                    object = (JRFillSubreport)jRFillElement;
                    List list = ((JRFillSubreport)object).subreportFiller.getJasperPrint().getFontsList();
                    for (int i3 = 0; i3 < list.size(); ++i3) {
                        this.filler.getJasperPrint().addFont((JRReportFont)list.get(i3), true);
                    }
                    List list2 = ((JRFillSubreport)object).subreportFiller.getJasperPrint().getStylesList();
                    for (int i4 = 0; i4 < list2.size(); ++i4) {
                        this.filler.addPrintStyle((JRStyle)list2.get(i4));
                    }
                    List list3 = ((JRFillSubreport)object).subreportFiller.getJasperPrint().getOriginsList();
                    for (int i5 = 0; i5 < list3.size(); ++i5) {
                        this.filler.getJasperPrint().addOrigin((JROrigin)list3.get(i5));
                    }
                    Collection collection = ((JRFillSubreport)object).getPrintElements();
                    this.addSubElements(jRPrintElementContainer, jRFillElement, collection);
                    continue;
                }
                if (!(jRFillElement instanceof JRFillCrosstab)) continue;
                object = ((JRFillCrosstab)jRFillElement).getPrintElements();
                this.addSubElements(jRPrintElementContainer, jRFillElement, (Collection)object);
            }
        }
        jRPrintElementContainer.setHeight(this.stretchHeight - this.firstY);
    }

    public void addSubElements(JRPrintElementContainer jRPrintElementContainer, JRFillElement jRFillElement, Collection collection) {
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
                jRPrintElement.setX(jRFillElement.getX() + jRPrintElement.getX());
                jRPrintElement.setY(jRFillElement.getRelativeY() + jRPrintElement.getY());
                jRPrintElementContainer.addElement(jRPrintElement);
            }
        }
    }

    public void rewind() throws JRException {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i2 = 0; i2 < this.ySortedElements.length; ++i2) {
                JRFillElement jRFillElement = this.ySortedElements[i2];
                jRFillElement.rewind();
                jRFillElement.setAlreadyPrinted(false);
            }
        }
        this.willOverflow = false;
    }

    public int getFirstY() {
        return this.firstY;
    }

    public abstract int getContainerHeight();

    public void initConditionalStyles() {
        int n2;
        this.filler.addDefaultStyleListener(new JRBaseFiller.DefaultStyleListener(this){
            private final JRFillElementContainer this$0;
            {
                this.this$0 = jRFillElementContainer;
            }

            public void defaultStyleSet(JRStyle jRStyle) {
                this.this$0.collectConditionalStyle(jRStyle);
            }
        });
        for (n2 = 0; n2 < this.deepElements.length; ++n2) {
            JRStyle jRStyle = this.deepElements[n2].initStyle;
            this.collectConditionalStyle(jRStyle);
        }
        if (this.deepElements.length > 0) {
            for (n2 = 0; n2 < this.deepElements.length; ++n2) {
                this.deepElements[n2].setConditionalStylesContainer(this);
            }
        }
    }

    public void collectConditionalStyle(JRStyle jRStyle) {
        if (jRStyle != null) {
            this.stylesToEvaluate.add(jRStyle);
        }
    }

    public void evaluateConditionalStyles(byte by2) throws JRException {
        Iterator iterator = this.stylesToEvaluate.iterator();
        while (iterator.hasNext()) {
            this.evaluateConditionalStyle((JRStyle)iterator.next(), by2);
        }
    }

    public JRStyle evaluateConditionalStyle(JRStyle jRStyle, byte by2) throws JRException {
        JRStyle jRStyle2 = jRStyle;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList();
        boolean bl2 = this.buildConsolidatedStyle(jRStyle, by2, stringBuffer, arrayList);
        if (bl2) {
            String string = jRStyle.getName() + stringBuffer.toString();
            jRStyle2 = (JRStyle)this.filler.getJasperPrint().getStylesMap().get(string);
            if (jRStyle2 == null) {
                jRStyle2 = new JRBaseStyle(string);
                for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                    JRStyleResolver.appendStyle(jRStyle2, (JRStyle)arrayList.get(i2));
                }
                this.filler.addPrintStyle(jRStyle2);
            }
        }
        this.evaluatedStyles.put(jRStyle, jRStyle2);
        return jRStyle2;
    }

    public boolean buildConsolidatedStyle(JRStyle jRStyle, byte by2, StringBuffer stringBuffer, List list) throws JRException {
        boolean bl2 = false;
        JRConditionalStyle[] jRConditionalStyleArray = jRStyle.getConditionalStyles();
        if (jRConditionalStyleArray != null && jRConditionalStyleArray.length > 0) {
            for (int i2 = 0; i2 < jRConditionalStyleArray.length; ++i2) {
                JRConditionalStyle jRConditionalStyle = jRConditionalStyleArray[i2];
                Boolean bl3 = (Boolean)this.expressionEvaluator.evaluate(jRConditionalStyle.getConditionExpression(), by2);
                boolean bl4 = bl3 == null ? false : bl3;
                stringBuffer.append(bl4 ? (char)'1' : '0');
                bl2 |= bl4;
                if (!bl4) continue;
                list.add(jRConditionalStyle);
            }
        }
        list.add(jRStyle);
        if (jRStyle.getStyle() != null) {
            bl2 |= this.buildConsolidatedStyle(jRStyle.getStyle(), by2, stringBuffer, list);
        }
        return bl2;
    }

    public JRStyle getEvaluatedConditionalStyle(JRStyle jRStyle) {
        return (JRStyle)this.evaluatedStyles.get(jRStyle);
    }
}

