/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillDatasetRun
implements JRDatasetRun {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRFillDatasetRun.a("net.sf.jasperreports.engine.fill.JRFillDatasetRun")) : a);
    private final JRBaseFiller filler;
    private final JRFillDataset dataset;
    private JRExpression parametersMapExpression;
    private JRDatasetParameter[] parameters;
    private JRExpression connectionExpression;
    private JRExpression dataSourceExpression;
    public static Class a;

    public JRFillDatasetRun(JRBaseFiller jRBaseFiller, JRDatasetRun jRDatasetRun, JRFillObjectFactory jRFillObjectFactory) {
        jRFillObjectFactory.put(jRDatasetRun, this);
        this.filler = jRBaseFiller;
        this.dataset = (JRFillDataset)jRBaseFiller.datasetMap.get(jRDatasetRun.getDatasetName());
        this.parametersMapExpression = jRDatasetRun.getParametersMapExpression();
        this.parameters = jRDatasetRun.getParameters();
        this.connectionExpression = jRDatasetRun.getConnectionExpression();
        this.dataSourceExpression = jRDatasetRun.getDataSourceExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(JRFillElementDataset jRFillElementDataset, byte by2) throws JRException {
        Map map = JRFillSubreport.getParameterValues(this.filler, this.parametersMapExpression, this.parameters, by2, false, this.dataset.getResourceBundle() != null, false);
        try {
            if (this.dataSourceExpression != null) {
                JRDataSource jRDataSource = (JRDataSource)this.filler.evaluateExpression(this.dataSourceExpression, by2);
                this.dataset.setDatasourceParameterValue(map, jRDataSource);
            } else if (this.connectionExpression != null) {
                Connection connection = (Connection)this.filler.evaluateExpression(this.connectionExpression, by2);
                this.dataset.setConnectionParameterValue(map, connection);
            }
            this.copyConnectionParameter(map);
            this.dataset.setParameterValues(map);
            this.dataset.initDatasource();
            this.dataset.filterElementDatasets(jRFillElementDataset);
            this.dataset.initCalculator();
            this.iterate();
        }
        finally {
            this.dataset.closeDatasource();
            this.dataset.restoreElementDatasets();
        }
    }

    public void copyConnectionParameter(Map map) {
        JRQuery jRQuery = this.dataset.getQuery();
        if (jRQuery != null) {
            String string = jRQuery.getLanguage();
            if (this.connectionExpression == null && (string.equals("sql") || string.equals("SQL")) && !map.containsKey("REPORT_CONNECTION")) {
                JRFillParameter jRFillParameter = (JRFillParameter)this.filler.getParametersMap().get("REPORT_CONNECTION");
                Connection connection = (Connection)jRFillParameter.getValue();
                map.put("REPORT_CONNECTION", connection);
            }
        }
    }

    public void iterate() throws JRException {
        this.dataset.start();
        this.init();
        if (this.dataset.next()) {
            this.detail();
            while (this.dataset.next()) {
                this.checkInterrupted();
                this.group();
                this.detail();
            }
        }
    }

    public void checkInterrupted() {
        if (Thread.currentThread().isInterrupted() || this.filler.isInterrupted()) {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.filler.fillerId + ": interrupting");
            }
            this.filler.setInterrupted(true);
            throw new JRFillInterruptedException();
        }
    }

    public void group() throws JRException, JRScriptletException {
        this.dataset.calculator.estimateGroupRuptures();
        this.dataset.scriptlet.callBeforeGroupInit();
        this.dataset.calculator.initializeVariables((byte)4);
        this.dataset.scriptlet.callAfterGroupInit();
    }

    public void init() throws JRScriptletException, JRException {
        this.dataset.scriptlet.callBeforeReportInit();
        this.dataset.calculator.initializeVariables((byte)1);
        this.dataset.scriptlet.callAfterReportInit();
    }

    public void detail() throws JRScriptletException, JRException {
        this.dataset.scriptlet.callBeforeDetailEval();
        this.dataset.calculator.calculateVariables();
        this.dataset.scriptlet.callAfterDetailEval();
    }

    public String getDatasetName() {
        return this.dataset.getName();
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public JRDatasetParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    public JRFillDataset getDataset() {
        return this.dataset;
    }

    public Object clone() {
        return null;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

