/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.fill.JRCrosstabExpressionEvaluator;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabCell;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabMeasure;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabParameter;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingService;
import net.sf.jasperreports.crosstabs.fill.calculation.CrosstabCell;
import net.sf.jasperreports.crosstabs.fill.calculation.HeaderCell;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillCellContents;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRTemplatePrintRectangle;
import net.sf.jasperreports.engine.fill.JRTemplateRectangle;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import org.jfree.data.general.Dataset;

public class JRFillCrosstab
extends JRFillElement
implements JRCrosstab {
    public final JRCrosstab parentCrosstab;
    public JRFillCrosstabDataset dataset;
    public JRFillCrosstabRowGroup[] rowGroups;
    public Map rowGroupsMap;
    public JRFillCrosstabColumnGroup[] columnGroups;
    public Map columnGroupsMap;
    public JRFillCrosstabMeasure[] measures;
    public BucketingService bucketingService;
    public JRFillVariable[] variables;
    public Map variablesMap;
    public JRFillVariable[][][] totalVariables;
    public boolean[][] retrieveTotal;
    public JRFillCrosstabParameter[] parameters;
    public Map parametersMap;
    public JRCrosstabExpressionEvaluator crosstabEvaluator;
    public JRFillCrosstabCell[][] crossCells;
    public JRFillCellContents headerCell;
    public JRFillCellContents whenNoDataCell;
    public boolean hasData;
    public HeaderCell[][] columnHeadersData;
    public HeaderCell[][] rowHeadersData;
    public CrosstabCell[][] cellData;
    public MeasureDefinition.MeasureValue[] grandTotals;
    private boolean percentage;
    private CrosstabFiller crosstabFiller;

    public JRFillCrosstab(JRBaseFiller jRBaseFiller, JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRCrosstab, jRFillObjectFactory);
        this.parentCrosstab = jRCrosstab;
        this.loadEvaluator(jRBaseFiller.getJasperReport());
        JRFillObjectFactory jRFillObjectFactory2 = new JRFillObjectFactory(jRFillObjectFactory, (JRFillExpressionEvaluator)this.crosstabEvaluator);
        this.headerCell = jRFillObjectFactory2.getCell(jRCrosstab.getHeaderCell());
        this.copyRowGroups(jRCrosstab, jRFillObjectFactory2);
        this.copyColumnGroups(jRCrosstab, jRFillObjectFactory2);
        this.copyMeasures(jRCrosstab, jRFillObjectFactory2);
        this.copyCells(jRCrosstab, jRFillObjectFactory2);
        this.whenNoDataCell = jRFillObjectFactory2.getCell(jRCrosstab.getWhenNoDataCell());
        this.dataset = jRFillObjectFactory.getCrosstabDataset(jRCrosstab.getDataset(), this);
        this.copyParameters(jRCrosstab, jRFillObjectFactory);
        this.copyVariables(jRCrosstab, jRFillObjectFactory2);
        this.crosstabFiller = new CrosstabFiller(this);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    private void copyRowGroups(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        this.rowGroups = new JRFillCrosstabRowGroup[jRCrosstabRowGroupArray.length];
        this.rowGroupsMap = new HashMap();
        for (int i2 = 0; i2 < jRCrosstabRowGroupArray.length; ++i2) {
            JRFillCrosstabRowGroup jRFillCrosstabRowGroup = jRFillObjectFactory.getCrosstabRowGroup(jRCrosstabRowGroupArray[i2]);
            jRFillCrosstabRowGroup.getFillHeader().setVerticalPositionType(jRCrosstabRowGroupArray[i2].getPosition());
            this.rowGroups[i2] = jRFillCrosstabRowGroup;
            this.rowGroupsMap.put(jRFillCrosstabRowGroup.getName(), new Integer(i2));
        }
    }

    private void copyColumnGroups(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        this.columnGroups = new JRFillCrosstabColumnGroup[jRCrosstabColumnGroupArray.length];
        this.columnGroupsMap = new HashMap();
        for (int i2 = 0; i2 < jRCrosstabColumnGroupArray.length; ++i2) {
            JRFillCrosstabColumnGroup jRFillCrosstabColumnGroup;
            this.columnGroups[i2] = jRFillCrosstabColumnGroup = jRFillObjectFactory.getCrosstabColumnGroup(jRCrosstabColumnGroupArray[i2]);
            this.columnGroupsMap.put(jRFillCrosstabColumnGroup.getName(), new Integer(i2));
        }
    }

    private void copyMeasures(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        JRCrosstabMeasure[] jRCrosstabMeasureArray = jRCrosstab.getMeasures();
        this.measures = new JRFillCrosstabMeasure[jRCrosstabMeasureArray.length];
        for (int i2 = 0; i2 < jRCrosstabMeasureArray.length; ++i2) {
            this.measures[i2] = jRFillObjectFactory.getCrosstabMeasure(jRCrosstabMeasureArray[i2]);
        }
    }

    private void copyParameters(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        JRCrosstabParameter[] jRCrosstabParameterArray = jRCrosstab.getParameters();
        this.parameters = new JRFillCrosstabParameter[jRCrosstabParameterArray.length];
        this.parametersMap = new HashMap();
        for (int i2 = 0; i2 < jRCrosstabParameterArray.length; ++i2) {
            this.parameters[i2] = jRFillObjectFactory.getCrosstabParameter(jRCrosstabParameterArray[i2]);
            this.parametersMap.put(this.parameters[i2].getName(), this.parameters[i2]);
        }
    }

    private void copyCells(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
        this.crossCells = new JRFillCrosstabCell[this.rowGroups.length + 1][this.columnGroups.length + 1];
        for (int i2 = 0; i2 <= this.rowGroups.length; ++i2) {
            for (int i3 = 0; i3 <= this.columnGroups.length; ++i3) {
                if (jRCrosstabCellArray[i2][i3] == null) continue;
                this.crossCells[i2][i3] = jRFillObjectFactory.getCrosstabCell(jRCrosstabCellArray[i2][i3]);
            }
        }
    }

    private void copyVariables(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        Object object;
        int n2;
        JRExpressionChunk[] jRExpressionChunkArray;
        Object object2;
        JRVariable[] jRVariableArray = jRCrosstab.getVariables();
        this.variables = new JRFillVariable[jRVariableArray.length];
        this.variablesMap = new HashMap();
        for (int i2 = 0; i2 < this.variables.length; ++i2) {
            this.variables[i2] = jRFillObjectFactory.getVariable(jRVariableArray[i2]);
            this.variablesMap.put(this.variables[i2].getName(), this.variables[i2]);
        }
        HashMap<Object, int[]> hashMap = new HashMap<Object, int[]>();
        this.totalVariables = new JRFillVariable[this.rowGroups.length + 1][this.columnGroups.length + 1][this.measures.length];
        for (int i3 = 0; i3 <= this.rowGroups.length; ++i3) {
            object2 = i3 == this.rowGroups.length ? null : this.rowGroups[i3];
            for (int i4 = 0; i4 <= this.columnGroups.length; ++i4) {
                JRExpressionChunk[] jRExpressionChunkArray2 = jRExpressionChunkArray = i4 == this.columnGroups.length ? null : this.columnGroups[i4];
                if (i3 >= this.rowGroups.length && i4 >= this.columnGroups.length) continue;
                for (n2 = 0; n2 < this.measures.length; ++n2) {
                    object = JRDesignCrosstab.getTotalVariableName(this.measures[n2], (JRCrosstabRowGroup)object2, (JRCrosstabColumnGroup)jRExpressionChunkArray);
                    this.totalVariables[i3][i4][n2] = (JRFillVariable)this.variablesMap.get(object);
                    hashMap.put(object, new int[]{i3, i4});
                }
            }
        }
        this.retrieveTotal = new boolean[this.rowGroups.length + 1][this.columnGroups.length + 1];
        List list = JRExpressionCollector.collectExpressions(this.filler.getJasperReport(), jRCrosstab);
        object2 = list.iterator();
        while (object2.hasNext()) {
            JRExpression jRExpression = (JRExpression)object2.next();
            jRExpressionChunkArray = jRExpression.getChunks();
            if (jRExpressionChunkArray == null) continue;
            for (n2 = 0; n2 < jRExpressionChunkArray.length; ++n2) {
                String string;
                int[] nArray;
                object = jRExpressionChunkArray[n2];
                if (object.getType() != 4 || (nArray = (int[])hashMap.get(string = object.getText())) == null) continue;
                this.retrieveTotal[nArray[0]][nArray[1]] = true;
            }
        }
    }

    public void loadEvaluator(JasperReport jasperReport) {
        try {
            JREvaluator jREvaluator = JasperCompileManager.loadEvaluator(jasperReport, this.parentCrosstab);
            this.crosstabEvaluator = new JRCrosstabExpressionEvaluator(jREvaluator);
        }
        catch (JRException jRException) {
            throw new JRRuntimeException("Could not load evaluator for crosstab.", jRException);
        }
    }

    private BucketingService createService(byte by2) throws JRException {
        ArrayList<BucketDefinition> arrayList = new ArrayList<BucketDefinition>(this.rowGroups.length);
        for (int i2 = 0; i2 < this.rowGroups.length; ++i2) {
            arrayList.add(this.createServiceBucket(this.rowGroups[i2], by2));
        }
        ArrayList<BucketDefinition> arrayList2 = new ArrayList<BucketDefinition>(this.columnGroups.length);
        for (int i3 = 0; i3 < this.columnGroups.length; ++i3) {
            arrayList2.add(this.createServiceBucket(this.columnGroups[i3], by2));
        }
        this.percentage = false;
        ArrayList<MeasureDefinition> arrayList3 = new ArrayList<MeasureDefinition>(this.measures.length);
        for (int i4 = 0; i4 < this.measures.length; ++i4) {
            arrayList3.add(this.createServiceMeasure(this.measures[i4]));
            this.percentage |= this.measures[i4].getPercentageOfType() == 1;
        }
        if (this.percentage) {
            ((BucketDefinition)arrayList.get(0)).setComputeTotal();
            ((BucketDefinition)arrayList2.get(0)).setComputeTotal();
        }
        return new BucketingService(arrayList, arrayList2, arrayList3, this.dataset.isDataPreSorted(), this.retrieveTotal);
    }

    private BucketDefinition createServiceBucket(JRCrosstabGroup jRCrosstabGroup, byte by2) throws JRException {
        JRCrosstabBucket jRCrosstabBucket = jRCrosstabGroup.getBucket();
        Comparator comparator = null;
        JRExpression jRExpression = jRCrosstabBucket.getComparatorExpression();
        if (jRExpression != null) {
            comparator = (Comparator)this.evaluateExpression(jRExpression, by2);
        }
        byte by3 = jRCrosstabGroup.getTotalPosition();
        return new BucketDefinition(jRCrosstabBucket.getExpression().getValueClass(), comparator, jRCrosstabBucket.getOrder(), by3);
    }

    private MeasureDefinition createServiceMeasure(JRFillCrosstabMeasure jRFillCrosstabMeasure) {
        return new MeasureDefinition(jRFillCrosstabMeasure.getValueClass(), jRFillCrosstabMeasure.getCalculation(), jRFillCrosstabMeasure.getIncrementerFactory());
    }

    public void reset() {
        super.reset();
        for (int i2 = 0; i2 < this.variables.length; ++i2) {
            this.variables[i2].setValue(null);
            this.variables[i2].setInitialized(true);
        }
    }

    public void evaluate(byte by2) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(by2);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.dataset.evaluateDatasetRun(by2);
            this.initEvaluator(by2);
            this.bucketingService.processData();
            this.hasData = this.bucketingService.hasData();
            if (this.hasData) {
                this.columnHeadersData = this.bucketingService.getColumnHeaders();
                this.rowHeadersData = this.bucketingService.getRowHeaders();
                this.cellData = this.bucketingService.getCrosstabCells();
                if (this.percentage) {
                    this.grandTotals = this.bucketingService.getGrandTotals();
                }
                this.crosstabFiller.initCrosstab();
            }
        }
    }

    public void initEvaluator(byte by2) throws JRException {
        Map map = JRFillSubreport.getParameterValues(this.filler, this.getParametersMapExpression(), this.getParameters(), by2, true, false, false);
        ResourceBundle resourceBundle = (ResourceBundle)map.get("REPORT_RESOURCE_BUNDLE");
        if (resourceBundle == null) {
            JRFillParameter jRFillParameter = (JRFillParameter)this.filler.getParametersMap().get("REPORT_RESOURCE_BUNDLE");
            map.put("REPORT_RESOURCE_BUNDLE", jRFillParameter.getValue());
        }
        map.put("REPORT_PARAMETERS_MAP", map);
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            Object v2 = map.get(this.parameters[i2].getName());
            this.parameters[i2].setValue(v2);
        }
        this.crosstabEvaluator.init(this.parametersMap, this.variablesMap, this.filler.getWhenResourceMissingType());
    }

    public void initBucketingService() {
        if (this.bucketingService == null) {
            try {
                this.bucketingService = this.createService((byte)1);
            }
            catch (JRException jRException) {
                throw new JRRuntimeException("Could not create bucketing service", jRException);
            }
        } else {
            this.bucketingService.clear();
        }
    }

    public boolean prepare(int n2, boolean bl2) throws JRException {
        super.prepare(n2, bl2);
        if (!this.isToPrint()) {
            return false;
        }
        if (n2 < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
            this.setToPrint(false);
            return true;
        }
        if (bl2 && this.crosstabFiller.ended() && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setStretchHeight(this.getHeight());
                this.setToPrint(false);
                return false;
            }
        }
        if (bl2 && this.isPrintWhenDetailOverflows()) {
            this.setReprinted(true);
        }
        int n3 = this.getHeight() + n2 - this.getRelativeY() + this.getY() + this.getBandBottomY();
        this.crosstabFiller.fill(n3);
        boolean bl3 = this.crosstabFiller.willOverflow();
        this.setStretchHeight(bl3 ? n3 : this.crosstabFiller.getUsedHeight());
        return bl3;
    }

    public JRPrintElement fill() {
        JRTemplatePrintRectangle jRTemplatePrintRectangle = null;
        jRTemplatePrintRectangle = new JRTemplatePrintRectangle(this.getJRTemplateRectangle());
        jRTemplatePrintRectangle.setX(this.getX());
        jRTemplatePrintRectangle.setY(this.getRelativeY());
        jRTemplatePrintRectangle.setWidth(this.getWidth());
        jRTemplatePrintRectangle.setHeight(this.getStretchHeight());
        return jRTemplatePrintRectangle;
    }

    public JRTemplateRectangle getJRTemplateRectangle() {
        JRStyle jRStyle = this.getStyle();
        JRTemplateRectangle jRTemplateRectangle = (JRTemplateRectangle)this.getTemplate(jRStyle);
        if (jRTemplateRectangle == null) {
            JRDesignRectangle jRDesignRectangle = new JRDesignRectangle();
            jRDesignRectangle.setKey(this.getKey());
            jRDesignRectangle.setPositionType(this.getPositionType());
            jRDesignRectangle.setMode(this.getMode());
            jRDesignRectangle.setX(this.getX());
            jRDesignRectangle.setY(this.getY());
            jRDesignRectangle.setWidth(this.getWidth());
            jRDesignRectangle.setHeight(this.getHeight());
            jRDesignRectangle.setRemoveLineWhenBlank(this.isRemoveLineWhenBlank());
            jRDesignRectangle.setPrintInFirstWholeBand(this.isPrintInFirstWholeBand());
            jRDesignRectangle.setPrintWhenDetailOverflows(this.isPrintWhenDetailOverflows());
            jRDesignRectangle.setPrintWhenGroupChanges(this.getPrintWhenGroupChanges());
            jRDesignRectangle.setForecolor(this.getForecolor());
            jRDesignRectangle.setBackcolor(this.getBackcolor());
            jRDesignRectangle.getLinePen().setLineWidth(0.0f);
            jRTemplateRectangle = new JRTemplateRectangle(this.band.getOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), jRDesignRectangle);
            this.registerTemplate(jRStyle, jRTemplateRectangle);
        }
        return jRTemplateRectangle;
    }

    public void rewind() {
        this.crosstabFiller.initCrosstab();
    }

    public List getPrintElements() {
        List list = this.crosstabFiller.getPrintElements();
        if (this.getRunDirection() == 1) {
            this.mirrorPrintElements(list);
        }
        return list;
    }

    public void mirrorPrintElements(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
            int n2 = this.getWidth() - jRPrintElement.getX() - jRPrintElement.getWidth();
            jRPrintElement.setX(n2);
        }
    }

    public void resolveElement(JRPrintElement jRPrintElement, byte by2) {
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void visit(JRVisitor jRVisitor) {
        jRVisitor.visitCrosstab(this);
    }

    public int getId() {
        return this.parentCrosstab.getId();
    }

    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    public JRCrosstabRowGroup[] getRowGroups() {
        return this.rowGroups;
    }

    public JRCrosstabColumnGroup[] getColumnGroups() {
        return this.columnGroups;
    }

    public JRCrosstabMeasure[] getMeasures() {
        return this.measures;
    }

    public int getColumnBreakOffset() {
        return this.parentCrosstab.getColumnBreakOffset();
    }

    public boolean isRepeatColumnHeaders() {
        return this.parentCrosstab.isRepeatColumnHeaders();
    }

    public boolean isRepeatRowHeaders() {
        return this.parentCrosstab.isRepeatRowHeaders();
    }

    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public JRCrosstabParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getParametersMapExpression() {
        return this.parentCrosstab.getParametersMapExpression();
    }

    public JRElement getElementByKey(String string) {
        return JRBaseCrosstab.getElementByKey(this, string);
    }

    public JRFillCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return null;
    }

    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public byte getRunDirection() {
        return this.parentCrosstab.getRunDirection();
    }

    public void setRunDirection(byte by2) {
    }

    protected class CrosstabFiller {
        private int yOffset;
        private boolean willOverflow;
        private int[] rowHeadersXOffsets;
        private boolean[] columnBreakable;
        private boolean[] rowBreakable;
        private int[] columnCount;
        private int[] rowCount;
        private int[] columnXOffsets;
        private boolean noDataCellPrinted;
        private int startRowIndex;
        private int startColumnIndex;
        private int lastColumnIndex;
        private List columnHeaders;
        private List printRows;
        private HeaderCell[] spanHeaders;
        private int[] spanHeadersStart;
        private List rowYs;
        private int rowIdx;
        private List preparedRow;
        private int preparedRowHeight;
        private boolean printRowHeaders;
        private boolean printColumnHeaders;
        private JRFillVariable rowCountVar;
        private JRFillVariable colCountVar;
        private final JRFillCrosstab this$0;

        public CrosstabFiller(JRFillCrosstab jRFillCrosstab) {
            this.this$0 = jRFillCrosstab;
            this.rowYs = new ArrayList();
            this.preparedRow = new ArrayList();
            this.setRowHeadersXOffsets();
            this.printRows = new ArrayList();
            this.rowCountVar = (JRFillVariable)jRFillCrosstab.variablesMap.get("ROW_COUNT");
            this.colCountVar = (JRFillVariable)jRFillCrosstab.variablesMap.get("COLUMN_COUNT");
        }

        public void initCrosstab() {
            this.columnXOffsets = this.computeOffsets(this.this$0.columnHeadersData, this.this$0.columnGroups, true);
            this.columnBreakable = this.computeBreakableHeaders(this.this$0.columnHeadersData, this.this$0.columnGroups, this.columnXOffsets, true, true);
            this.columnCount = this.computeCounts(this.this$0.columnHeadersData);
            int[] nArray = this.computeOffsets(this.this$0.rowHeadersData, this.this$0.rowGroups, false);
            this.rowBreakable = this.computeBreakableHeaders(this.this$0.rowHeadersData, this.this$0.rowGroups, nArray, false, false);
            this.rowCount = this.computeCounts(this.this$0.rowHeadersData);
            this.spanHeaders = new HeaderCell[this.this$0.rowGroups.length - 1];
            this.spanHeadersStart = new int[this.this$0.rowGroups.length - 1];
            this.startRowIndex = 0;
            this.startColumnIndex = 0;
            this.lastColumnIndex = 0;
            this.noDataCellPrinted = false;
        }

        public void setRowHeadersXOffsets() {
            this.rowHeadersXOffsets = new int[this.this$0.rowGroups.length + 1];
            this.rowHeadersXOffsets[0] = 0;
            for (int i2 = 0; i2 < this.this$0.rowGroups.length; ++i2) {
                this.rowHeadersXOffsets[i2 + 1] = this.rowHeadersXOffsets[i2] + this.this$0.rowGroups[i2].getWidth();
            }
        }

        public int[] computeOffsets(HeaderCell[][] headerCellArray, JRFillCrosstabGroup[] jRFillCrosstabGroupArray, boolean bl2) {
            int[] nArray = new int[headerCellArray[0].length + 1];
            nArray[0] = 0;
            for (int i2 = 0; i2 < headerCellArray[0].length; ++i2) {
                int n2 = 0;
                for (int i3 = jRFillCrosstabGroupArray.length - 1; i3 >= 0; --i3) {
                    JRFillCellContents jRFillCellContents;
                    if (headerCellArray[i3][i2] == null) continue;
                    JRFillCellContents jRFillCellContents2 = jRFillCellContents = headerCellArray[i3][i2].isTotal() ? jRFillCrosstabGroupArray[i3].getFillTotalHeader() : jRFillCrosstabGroupArray[i3].getFillHeader();
                    n2 = jRFillCellContents == null ? 0 : (bl2 ? jRFillCellContents.getWidth() : jRFillCellContents.getHeight());
                    break;
                }
                nArray[i2 + 1] = nArray[i2] + n2;
            }
            return nArray;
        }

        public boolean[] computeBreakableHeaders(HeaderCell[][] headerCellArray, JRFillCrosstabGroup[] jRFillCrosstabGroupArray, int[] nArray, boolean bl2, boolean bl3) {
            int n2;
            boolean[] blArray = new boolean[headerCellArray[0].length];
            for (n2 = 0; n2 < blArray.length; ++n2) {
                blArray[n2] = true;
            }
            for (n2 = 0; n2 < jRFillCrosstabGroupArray.length; ++n2) {
                JRFillCellContents jRFillCellContents = jRFillCrosstabGroupArray[n2].getFillHeader();
                if (jRFillCellContents == null) continue;
                int n3 = bl2 ? jRFillCellContents.getWidth() : jRFillCellContents.getHeight();
                for (int i2 = 0; i2 < headerCellArray[0].length; ++i2) {
                    int n4;
                    HeaderCell headerCell = headerCellArray[n2][i2];
                    if (headerCell == null || headerCell.isTotal() || headerCell.getLevelSpan() <= 1) continue;
                    int n5 = headerCell.getLevelSpan();
                    if (bl3) {
                        for (n4 = i2 + 1; n4 < i2 + n5 && nArray[n4] - nArray[i2] < n3; ++n4) {
                            blArray[n4] = false;
                        }
                    }
                    for (n4 = i2 + n5 - 1; n4 > i2 && nArray[i2 + n5] - nArray[n4] < n3; --n4) {
                        blArray[n4] = false;
                    }
                }
            }
            return blArray;
        }

        private int[] computeCounts(HeaderCell[][] headerCellArray) {
            int[] nArray = new int[headerCellArray[0].length];
            HeaderCell[] headerCellArray2 = headerCellArray[headerCellArray.length - 1];
            int n2 = 0;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                HeaderCell headerCell = headerCellArray2[i2];
                if (headerCell == null || !headerCell.isTotal()) {
                    // empty if block
                }
                nArray[i2] = ++n2;
            }
            return nArray;
        }

        public void fill(int n2) throws JRException {
            this.printRows.clear();
            this.yOffset = 0;
            this.willOverflow = false;
            this.fillVerticalCrosstab(n2);
        }

        public boolean willOverflow() {
            return this.willOverflow;
        }

        public int getUsedHeight() {
            return this.yOffset;
        }

        public boolean ended() {
            return this.this$0.hasData ? this.startRowIndex >= this.this$0.rowHeadersData[0].length && this.startColumnIndex >= this.this$0.columnHeadersData[0].length : this.noDataCellPrinted;
        }

        public void fillVerticalCrosstab(int n2) throws JRException {
            boolean bl2;
            int n3;
            int n4;
            if (!this.this$0.hasData) {
                this.fillNoDataCell(n2);
                return;
            }
            this.printRowHeaders = this.startColumnIndex == 0 || this.this$0.isRepeatRowHeaders();
            int n5 = n4 = this.printRowHeaders ? this.rowHeadersXOffsets[this.this$0.rowGroups.length] : 0;
            if (this.startColumnIndex == this.lastColumnIndex) {
                int n6 = this.this$0.getWidth();
                this.columnHeaders = this.getGroupHeaders(n6 - n4, this.columnXOffsets, this.columnBreakable, this.startColumnIndex, this.this$0.columnHeadersData, this.this$0.columnGroups);
                this.lastColumnIndex = this.startColumnIndex + this.columnHeaders.size();
                if (this.startColumnIndex == this.lastColumnIndex) {
                    throw new JRRuntimeException("Not enough space to render the crosstab.");
                }
            }
            this.printColumnHeaders = this.startRowIndex == 0 || this.this$0.isRepeatColumnHeaders();
            List list = null;
            if (this.printColumnHeaders) {
                list = this.fillColumnHeaders(n4, n2 - this.yOffset);
                if (this.willOverflow) {
                    return;
                }
            }
            if ((n3 = this.fillRows(n4, n2 - this.yOffset)) == this.startRowIndex) {
                this.willOverflow = true;
                return;
            }
            if (list != null) {
                this.printRows.addAll(list);
            }
            if (n3 >= this.this$0.rowHeadersData[0].length) {
                this.startColumnIndex = this.lastColumnIndex;
                if (this.startColumnIndex < this.this$0.columnHeadersData[0].length) {
                    n3 = 0;
                    this.startRowIndex = 0;
                    this.yOffset += this.this$0.getColumnBreakOffset();
                    this.fillVerticalCrosstab(n2);
                    return;
                }
            }
            boolean bl3 = bl2 = n3 >= this.this$0.rowHeadersData[0].length && this.lastColumnIndex >= this.this$0.columnHeadersData[0].length;
            if (bl2) {
                this.this$0.setStretchHeight(this.yOffset);
            } else {
                this.this$0.setStretchHeight(n2);
            }
            this.startRowIndex = n3;
            this.willOverflow = !bl2;
        }

        public List getGroupHeaders(int n2, int[] nArray, boolean[] blArray, int n3, HeaderCell[][] headerCellArray, JRFillCrosstabGroup[] jRFillCrosstabGroupArray) {
            int n4;
            HeaderCell[] headerCellArray2;
            int n5;
            ArrayList<HeaderCell[]> arrayList = new ArrayList<HeaderCell[]>();
            int n6 = n2 + nArray[n3];
            for (n5 = n3; n5 < headerCellArray[0].length && nArray[n5 + 1] <= n6; ++n5) {
                headerCellArray2 = new HeaderCell[jRFillCrosstabGroupArray.length];
                for (n4 = 0; n4 < jRFillCrosstabGroupArray.length; ++n4) {
                    headerCellArray2[n4] = headerCellArray[n4][n5];
                }
                arrayList.add(headerCellArray2);
            }
            if (n5 < headerCellArray[0].length) {
                while (n5 > n3 && !blArray[n5]) {
                    --n5;
                    arrayList.remove(arrayList.size() - 1);
                }
            }
            if (n5 > n3) {
                HeaderCell[] headerCellArray3;
                if (n3 > 0) {
                    headerCellArray2 = (HeaderCell[])arrayList.get(0);
                    for (n4 = 0; n4 < jRFillCrosstabGroupArray.length; ++n4) {
                        int n7;
                        HeaderCell headerCell = headerCellArray[n4][n3];
                        if (headerCell != null || (n7 = this.getSpanIndex(n3, n4, headerCellArray)) < 0) continue;
                        headerCellArray3 = headerCellArray[n4][n7];
                        int n8 = headerCellArray3.getLevelSpan() + n7;
                        if (n8 > n5) {
                            n8 = n5;
                        }
                        headerCellArray2[n4] = HeaderCell.createLevelSpanCopy((HeaderCell)headerCellArray3, n8 - n3);
                    }
                }
                if (n5 < headerCellArray[0].length) {
                    for (int i2 = 0; i2 < jRFillCrosstabGroupArray.length; ++i2) {
                        int n9;
                        HeaderCell headerCell = headerCellArray[i2][n5];
                        if (headerCell != null || (n9 = this.getSpanIndex(n5, i2, headerCellArray)) < n3) continue;
                        HeaderCell headerCell2 = headerCellArray[i2][n9];
                        headerCellArray3 = (HeaderCell[])arrayList.get(n9 - n3);
                        headerCellArray3[i2] = HeaderCell.createLevelSpanCopy(headerCell2, n5 - n9);
                    }
                }
            }
            return arrayList;
        }

        public int getSpanIndex(int n2, int n3, HeaderCell[][] headerCellArray) {
            HeaderCell headerCell;
            int n4;
            int n5;
            for (n5 = n2 - 1; n5 >= 0 && headerCellArray[n3][n5] == null; --n5) {
            }
            if (n5 >= 0 && (n4 = (headerCell = headerCellArray[n3][n5]).getLevelSpan()) > n2 - n5) {
                return n5;
            }
            return -1;
        }

        public void fillNoDataCell(int n2) throws JRException {
            if (this.this$0.whenNoDataCell == null) {
                this.noDataCellPrinted = true;
            } else if (n2 < this.this$0.whenNoDataCell.getHeight()) {
                this.willOverflow = true;
            } else {
                this.this$0.whenNoDataCell.evaluate((byte)3);
                this.this$0.whenNoDataCell.prepare(n2 - this.this$0.whenNoDataCell.getHeight());
                this.willOverflow = this.this$0.whenNoDataCell.willOverflow();
                if (!this.willOverflow) {
                    this.this$0.whenNoDataCell.setX(0);
                    this.this$0.whenNoDataCell.setY(0);
                    JRPrintFrame jRPrintFrame = this.this$0.whenNoDataCell.fill();
                    ArrayList<JRPrintFrame> arrayList = new ArrayList<JRPrintFrame>(1);
                    arrayList.add(jRPrintFrame);
                    this.addPrintRow(arrayList);
                    this.yOffset += this.this$0.whenNoDataCell.getPrintHeight();
                    this.noDataCellPrinted = true;
                }
            }
        }

        public List fillColumnHeaders(int n2, int n3) throws JRException {
            Object object;
            JRFillCellContents[][] jRFillCellContentsArray = new JRFillCellContents[this.this$0.columnGroups.length][this.lastColumnIndex - this.startColumnIndex + 1];
            this.rowYs.clear();
            this.rowYs.add(new Integer(0));
            if (this.printRowHeaders && this.this$0.headerCell != null) {
                object = this.fillHeader(n3);
                if (this.willOverflow) {
                    return null;
                }
                jRFillCellContentsArray[this.this$0.columnGroups.length - 1][0] = object;
            }
            this.rowIdx = 0;
            block0: while (this.rowIdx < this.this$0.columnGroups.length) {
                int n4;
                for (n4 = this.startColumnIndex; n4 < this.lastColumnIndex; ++n4) {
                    JRFillCellContents jRFillCellContents;
                    HeaderCell[] headerCellArray = (HeaderCell[])this.columnHeaders.get(n4 - this.startColumnIndex);
                    HeaderCell headerCell = headerCellArray[this.rowIdx];
                    if (headerCell == null) continue;
                    jRFillCellContentsArray[this.rowIdx + headerCell.getDepthSpan() - 1][n4 - this.startColumnIndex + 1] = jRFillCellContents = this.prepareColumnHeader(headerCell, n4, n2, n3);
                    if (this.willOverflow) break block0;
                }
                n4 = this.stretchColumnHeadersRow(jRFillCellContentsArray[this.rowIdx]);
                this.rowYs.add(new Integer((Integer)this.rowYs.get(this.rowIdx) + n4));
                ++this.rowIdx;
            }
            if (this.willOverflow) {
                object = null;
                this.releaseColumnHeaderCells(jRFillCellContentsArray);
            } else {
                object = this.fillColumnHeaders(jRFillCellContentsArray);
                this.yOffset += ((Integer)this.rowYs.get(this.this$0.columnGroups.length)).intValue();
            }
            this.resetVariables();
            return object;
        }

        private void setCountVars(int n2, int n3) {
            if (n2 == -1) {
                this.rowCountVar.setValue(null);
            } else {
                this.rowCountVar.setValue(new Integer(this.rowCount[n2]));
            }
            if (n3 == -1) {
                this.colCountVar.setValue(null);
            } else {
                this.colCountVar.setValue(new Integer(this.columnCount[n3]));
            }
        }

        private JRFillCellContents fillHeader(int n2) throws JRException {
            this.setCountVars(-1, -1);
            JRFillCellContents jRFillCellContents = this.this$0.headerCell.getWorkingClone();
            jRFillCellContents.evaluate((byte)3);
            jRFillCellContents.prepare(n2 - this.this$0.headerCell.getHeight());
            this.willOverflow = jRFillCellContents.willOverflow();
            if (!this.willOverflow) {
                jRFillCellContents.setX(0);
                jRFillCellContents.setY(this.yOffset);
                jRFillCellContents.setVerticalSpan(this.this$0.columnGroups.length);
            }
            return jRFillCellContents;
        }

        private JRFillCellContents prepareColumnHeader(HeaderCell headerCell, int n2, int n3, int n4) throws JRException {
            JRFillCrosstabColumnGroup jRFillCrosstabColumnGroup = this.this$0.columnGroups[this.rowIdx];
            JRFillCellContents jRFillCellContents = headerCell.isTotal() ? jRFillCrosstabColumnGroup.getFillTotalHeader() : jRFillCrosstabColumnGroup.getFillHeader();
            int n5 = this.columnXOffsets[n2 + headerCell.getLevelSpan()] - this.columnXOffsets[n2];
            int n6 = jRFillCellContents.getHeight();
            if (n5 <= 0 || n6 <= 0) {
                return null;
            }
            JRFillCellContents jRFillCellContents2 = null;
            int n7 = (Integer)this.rowYs.get(this.rowIdx);
            int n8 = n4 - n7 - n6;
            if (n8 >= 0) {
                this.setCountVars(-1, n2);
                this.setGroupVariables(this.this$0.columnGroups, headerCell.getBucketValues());
                jRFillCellContents = jRFillCellContents.getTransformedContents(n5, n6, jRFillCrosstabColumnGroup.getPosition(), (byte)1);
                boolean bl2 = n2 == this.startColumnIndex && (!this.printRowHeaders || this.this$0.headerCell == null);
                jRFillCellContents = jRFillCellContents.getBoxContents(bl2 && this.this$0.getRunDirection() == 0, bl2 && this.this$0.getRunDirection() == 1, false);
                jRFillCellContents = jRFillCellContents.getWorkingClone();
                jRFillCellContents.evaluate((byte)3);
                jRFillCellContents.prepare(n8);
                if (jRFillCellContents.willOverflow()) {
                    this.willOverflow = true;
                } else {
                    jRFillCellContents.setX(this.columnXOffsets[n2] - this.columnXOffsets[this.startColumnIndex] + n3);
                    jRFillCellContents.setY(n7 + this.yOffset);
                    jRFillCellContents.setVerticalSpan(headerCell.getDepthSpan());
                    jRFillCellContents2 = jRFillCellContents;
                }
            } else {
                this.willOverflow = true;
            }
            return jRFillCellContents2;
        }

        private int stretchColumnHeadersRow(JRFillCellContents[] jRFillCellContentsArray) {
            int n2;
            JRFillCellContents jRFillCellContents;
            int n3;
            int n4 = (Integer)this.rowYs.get(this.rowIdx);
            int n5 = 0;
            for (n3 = 0; n3 < jRFillCellContentsArray.length; ++n3) {
                int n6;
                jRFillCellContents = jRFillCellContentsArray[n3];
                if (jRFillCellContents == null) continue;
                n2 = n4;
                if (jRFillCellContents.getVerticalSpan() > 1) {
                    n2 = (Integer)this.rowYs.get(this.rowIdx - jRFillCellContents.getVerticalSpan() + 1);
                }
                if ((n6 = jRFillCellContents.getPrintHeight() - n4 + n2) <= n5) continue;
                n5 = n6;
            }
            for (n3 = 0; n3 < jRFillCellContentsArray.length; ++n3) {
                jRFillCellContents = jRFillCellContentsArray[n3];
                if (jRFillCellContents == null) continue;
                n2 = n4;
                if (jRFillCellContents.getVerticalSpan() > 1) {
                    n2 = (Integer)this.rowYs.get(this.rowIdx - jRFillCellContents.getVerticalSpan() + 1);
                }
                jRFillCellContents.stretchTo(n5 + n4 - n2);
            }
            return n5;
        }

        private List fillColumnHeaders(JRFillCellContents[][] jRFillCellContentsArray) throws JRException {
            ArrayList arrayList = new ArrayList(this.this$0.columnGroups.length);
            for (int i2 = 0; i2 < jRFillCellContentsArray.length; ++i2) {
                ArrayList<JRPrintFrame> arrayList2 = new ArrayList<JRPrintFrame>(this.lastColumnIndex - this.startColumnIndex);
                arrayList.add(arrayList2);
                for (int i3 = 0; i3 < jRFillCellContentsArray[i2].length; ++i3) {
                    JRFillCellContents jRFillCellContents = jRFillCellContentsArray[i2][i3];
                    if (jRFillCellContents == null) continue;
                    arrayList2.add(jRFillCellContents.fill());
                    jRFillCellContents.releaseWorkingClone();
                }
            }
            return arrayList;
        }

        private void releaseColumnHeaderCells(JRFillCellContents[][] jRFillCellContentsArray) throws JRException {
            for (int i2 = 0; i2 < jRFillCellContentsArray.length; ++i2) {
                for (int i3 = 0; i3 < jRFillCellContentsArray[i2].length; ++i3) {
                    JRFillCellContents jRFillCellContents = jRFillCellContentsArray[i2][i3];
                    if (jRFillCellContents == null) continue;
                    jRFillCellContents.rewind();
                    jRFillCellContents.releaseWorkingClone();
                }
            }
        }

        public int fillRows(int n2, int n3) throws JRException {
            this.rowYs.clear();
            this.rowYs.add(new Integer(0));
            this.rowIdx = 0;
            while (this.rowIdx < this.this$0.cellData.length - this.startRowIndex) {
                this.initPreparedRow();
                this.prepareRow(n2, n3);
                if (this.willOverflow) break;
                this.fillRow();
                this.rowYs.add(new Integer((Integer)this.rowYs.get(this.rowIdx) + this.preparedRowHeight));
                ++this.rowIdx;
            }
            if (this.rowIdx < this.this$0.cellData.length - this.startRowIndex) {
                this.releasePreparedRow();
                if (this.printRowHeaders) {
                    this.fillContinuingRowHeaders(n2, n3);
                }
            }
            this.yOffset += ((Integer)this.rowYs.get(this.rowIdx)).intValue();
            return this.rowIdx + this.startRowIndex;
        }

        private void initPreparedRow() {
            this.preparedRow.clear();
            this.preparedRowHeight = 0;
        }

        private void removeFilledRows(int n2) {
            if (n2 > 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.printRows.remove(this.printRows.size() - 1);
                    this.rowYs.remove(this.rowYs.size() - 1);
                }
                this.rowIdx -= n2;
            }
        }

        private void releasePreparedRow() throws JRException {
            Iterator iterator = this.preparedRow.iterator();
            while (iterator.hasNext()) {
                JRFillCellContents jRFillCellContents = (JRFillCellContents)iterator.next();
                jRFillCellContents.rewind();
                jRFillCellContents.releaseWorkingClone();
            }
            this.preparedRow.clear();
        }

        private void fillRow() throws JRException {
            int n2 = (Integer)this.rowYs.get(this.rowIdx);
            ArrayList<JRPrintFrame> arrayList = new ArrayList<JRPrintFrame>(this.preparedRow.size());
            Iterator iterator = this.preparedRow.iterator();
            while (iterator.hasNext()) {
                JRFillCellContents jRFillCellContents = (JRFillCellContents)iterator.next();
                int n3 = 0;
                if (jRFillCellContents.getVerticalSpan() > 1) {
                    n3 = n2 - (Integer)this.rowYs.get(this.rowIdx - jRFillCellContents.getVerticalSpan() + 1);
                }
                jRFillCellContents.stretchTo(this.preparedRowHeight + n3);
                arrayList.add(jRFillCellContents.fill());
                jRFillCellContents.releaseWorkingClone();
            }
            this.addPrintRow(arrayList);
        }

        private void prepareRow(int n2, int n3) throws JRException {
            boolean bl2;
            Object object;
            int n4;
            for (n4 = this.startColumnIndex; n4 < this.lastColumnIndex; ++n4) {
                object = this.this$0.cellData[this.rowIdx + this.startRowIndex][n4];
                bl2 = this.prepareDataCell((CrosstabCell)object, n4, n3, n2);
                if (!bl2) continue;
                this.willOverflow = true;
                return;
            }
            this.resetVariables();
            if (this.printRowHeaders) {
                for (n4 = 0; n4 < this.this$0.rowGroups.length; ++n4) {
                    object = this.this$0.rowHeadersData[n4][this.rowIdx + this.startRowIndex];
                    bl2 = false;
                    if (object == null) {
                        bl2 = this.prepareClosingRowHeader(n4, n3);
                    } else {
                        if (((HeaderCell)object).getLevelSpan() > 1) {
                            this.spanHeaders[n4] = object;
                            this.spanHeadersStart[n4] = this.rowIdx + this.startRowIndex;
                            continue;
                        }
                        bl2 = this.prepareRowHeader(n4, (HeaderCell)object, 1, n3);
                    }
                    if (!bl2) continue;
                    this.willOverflow = true;
                    return;
                }
                this.resetVariables();
            }
        }

        private boolean prepareDataCell(CrosstabCell crosstabCell, int n2, int n3, int n4) throws JRException {
            boolean bl2;
            JRFillCellContents jRFillCellContents;
            int n5 = (Integer)this.rowYs.get(this.rowIdx);
            JRFillCrosstabCell jRFillCrosstabCell = this.this$0.crossCells[crosstabCell.getRowTotalGroupIndex()][crosstabCell.getColumnTotalGroupIndex()];
            JRFillCellContents jRFillCellContents2 = jRFillCellContents = jRFillCrosstabCell == null ? null : jRFillCrosstabCell.getFillContents();
            if (jRFillCellContents == null || jRFillCellContents.getWidth() <= 0 || jRFillCellContents.getHeight() <= 0) {
                return false;
            }
            int n6 = n3 - n5 - jRFillCellContents.getHeight();
            boolean bl3 = bl2 = n6 < 0;
            if (!bl2) {
                boolean bl4 = this.startColumnIndex != 0 && !this.this$0.isRepeatRowHeaders();
                boolean bl5 = this.startRowIndex != 0 && !this.this$0.isRepeatColumnHeaders();
                this.setCountVars(this.rowIdx + this.startRowIndex, n2);
                this.setGroupVariables(this.this$0.rowGroups, crosstabCell.getRowBucketValues());
                this.setGroupVariables(this.this$0.columnGroups, crosstabCell.getColumnBucketValues());
                this.setMeasureVariables(crosstabCell);
                boolean bl6 = bl4 && n2 == this.startColumnIndex;
                jRFillCellContents = jRFillCellContents.getBoxContents(bl6 && this.this$0.getRunDirection() == 0, bl6 && this.this$0.getRunDirection() == 1, bl5 && this.rowIdx == 0);
                jRFillCellContents = jRFillCellContents.getWorkingClone();
                jRFillCellContents.evaluate((byte)3);
                jRFillCellContents.prepare(n6);
                this.preparedRow.add(jRFillCellContents);
                bl2 = jRFillCellContents.willOverflow();
                if (!bl2) {
                    jRFillCellContents.setX(this.columnXOffsets[n2] - this.columnXOffsets[this.startColumnIndex] + n4);
                    jRFillCellContents.setY(n5 + this.yOffset);
                    int n7 = jRFillCellContents.getPrintHeight();
                    if (n7 > this.preparedRowHeight) {
                        this.preparedRowHeight = n7;
                    }
                }
            }
            return bl2;
        }

        private boolean prepareRowHeader(int n2, HeaderCell headerCell, int n3, int n4) throws JRException {
            boolean bl2;
            JRFillCellContents jRFillCellContents;
            JRFillCrosstabRowGroup jRFillCrosstabRowGroup = this.this$0.rowGroups[n2];
            JRFillCellContents jRFillCellContents2 = jRFillCellContents = headerCell.isTotal() ? jRFillCrosstabRowGroup.getFillTotalHeader() : jRFillCrosstabRowGroup.getFillHeader();
            if (jRFillCellContents.getWidth() <= 0 || jRFillCellContents.getHeight() <= 0) {
                return false;
            }
            int n5 = 0;
            int n6 = (Integer)this.rowYs.get(this.rowIdx - n3 + 1);
            if (n3 > 1) {
                n5 += (Integer)this.rowYs.get(this.rowIdx) - n6;
            }
            int n7 = n5 + this.preparedRowHeight;
            boolean bl3 = jRFillCrosstabRowGroup.getPosition() == 4;
            int n8 = bl3 ? n7 : jRFillCellContents.getHeight();
            int n9 = n4 - n6 - n8;
            boolean bl4 = bl2 = n9 < 0 || n7 < jRFillCellContents.getHeight();
            if (!bl2) {
                this.setCountVars(this.rowIdx + this.startRowIndex - n3 + 1, -1);
                this.setGroupVariables(this.this$0.rowGroups, headerCell.getBucketValues());
                if (bl3) {
                    jRFillCellContents = jRFillCellContents.getTransformedContents(jRFillCellContents.getWidth(), n7, (byte)1, (byte)4);
                }
                jRFillCellContents = jRFillCellContents.getBoxContents(false, false, this.rowIdx + 1 == n3 && (!this.printColumnHeaders || this.this$0.headerCell == null));
                jRFillCellContents.getWorkingClone();
                jRFillCellContents.evaluate((byte)3);
                jRFillCellContents.prepare(n9);
                this.preparedRow.add(jRFillCellContents);
                bl2 = jRFillCellContents.willOverflow();
                if (!bl2) {
                    jRFillCellContents.setX(this.rowHeadersXOffsets[n2]);
                    jRFillCellContents.setY(n6 + this.yOffset);
                    jRFillCellContents.setVerticalSpan(n3);
                    int n10 = jRFillCellContents.getPrintHeight() - n5;
                    if (n10 > this.preparedRowHeight) {
                        this.preparedRowHeight = n10;
                    }
                }
            }
            if (bl2) {
                this.removeFilledRows(n3 - 1);
            }
            return bl2;
        }

        private boolean prepareClosingRowHeader(int n2, int n3) throws JRException {
            if (n2 < this.this$0.rowGroups.length - 1 && this.spanHeaders[n2] != null && this.spanHeaders[n2].getLevelSpan() + this.spanHeadersStart[n2] == this.rowIdx + this.startRowIndex + 1) {
                HeaderCell headerCell = this.spanHeaders[n2];
                int n4 = headerCell.getLevelSpan();
                if (this.spanHeadersStart[n2] < this.startRowIndex) {
                    n4 += this.spanHeadersStart[n2] - this.startRowIndex;
                }
                this.spanHeaders[n2] = null;
                return this.prepareRowHeader(n2, headerCell, n4, n3);
            }
            return false;
        }

        private void removeExceedingSpanHeaders() {
            for (int i2 = this.this$0.rowGroups.length - 2; i2 >= 0; --i2) {
                if (this.spanHeaders[i2] == null || this.spanHeadersStart[i2] < this.rowIdx + this.startRowIndex) continue;
                this.spanHeaders[i2] = null;
            }
        }

        private void setBackSpanHeaders() {
            for (int i2 = this.this$0.rowGroups.length - 2; i2 >= 0 && this.spanHeaders[i2] == null; --i2) {
                int n2 = this.getSpanIndex(this.rowIdx + this.startRowIndex, i2, this.this$0.rowHeadersData);
                if (n2 < 0) continue;
                this.spanHeaders[i2] = this.this$0.rowHeadersData[i2][n2];
                this.spanHeadersStart[i2] = n2;
            }
        }

        private void fillContinuingRowHeaders(int n2, int n3) throws JRException {
            boolean bl2 = false;
            block0: do {
                int n4;
                this.removeExceedingSpanHeaders();
                if (!this.rowBreakable[this.rowIdx + this.startRowIndex]) {
                    this.removeFilledRows(1);
                    this.setBackSpanHeaders();
                    continue;
                }
                this.initPreparedRow();
                for (n4 = 0; n4 < this.this$0.rowGroups.length - 1; ++n4) {
                    boolean bl3;
                    if (this.spanHeaders[n4] == null || !(bl3 = this.prepareContinuingRowHeader(n4, n3))) continue;
                    this.releasePreparedRow();
                    continue block0;
                }
                if (!this.preparedRow.isEmpty()) {
                    n4 = (Integer)this.rowYs.get(this.rowIdx) - (Integer)this.rowYs.get(this.rowIdx - 1);
                    if (this.preparedRowHeight > n4) {
                        this.refillLastRow(n2, n3);
                    } else {
                        this.fillContinuingHeaders(n4);
                    }
                }
                bl2 = true;
            } while (!bl2 && this.rowIdx > 0);
        }

        private void fillContinuingHeaders(int n2) throws JRException {
            int n3 = (Integer)this.rowYs.get(this.rowIdx - 1);
            List list = this.getLastPrintRow();
            for (int i2 = 0; i2 < this.preparedRow.size(); ++i2) {
                JRFillCellContents jRFillCellContents = (JRFillCellContents)this.preparedRow.get(i2);
                int n4 = (Integer)this.rowYs.get(this.rowIdx - jRFillCellContents.getVerticalSpan());
                jRFillCellContents.stretchTo(n3 - n4 + n2);
                list.add(jRFillCellContents.fill());
                jRFillCellContents.releaseWorkingClone();
            }
        }

        private void refillLastRow(int n2, int n3) throws JRException {
            this.removeFilledRows(1);
            this.setBackSpanHeaders();
            this.prepareRow(n2, n3);
            this.fillRow();
            this.rowYs.add(new Integer((Integer)this.rowYs.get(this.rowIdx) + this.preparedRowHeight));
            ++this.rowIdx;
        }

        private boolean prepareContinuingRowHeader(int n2, int n3) throws JRException {
            boolean bl2;
            HeaderCell headerCell = this.spanHeaders[n2];
            int n4 = this.rowIdx + this.startRowIndex - this.spanHeadersStart[n2];
            if (this.spanHeadersStart[n2] < this.startRowIndex) {
                n4 += this.spanHeadersStart[n2] - this.startRowIndex;
            }
            int n5 = (Integer)this.rowYs.get(this.rowIdx - n4);
            int n6 = (Integer)this.rowYs.get(this.rowIdx);
            int n7 = n6 - n5;
            int n8 = (Integer)this.rowYs.get(this.rowIdx - 1);
            int n9 = n8 - n5;
            JRFillCrosstabRowGroup jRFillCrosstabRowGroup = this.this$0.rowGroups[n2];
            JRFillCellContents jRFillCellContents = headerCell.isTotal() ? jRFillCrosstabRowGroup.getFillTotalHeader() : jRFillCrosstabRowGroup.getFillHeader();
            boolean bl3 = jRFillCrosstabRowGroup.getPosition() == 4;
            int n10 = bl3 ? n7 : jRFillCellContents.getHeight();
            int n11 = n3 - n5 - n10;
            boolean bl4 = bl2 = n11 < 0 || n7 < jRFillCellContents.getHeight();
            if (!bl2) {
                this.setCountVars(this.rowIdx + this.startRowIndex - n4, -1);
                this.setGroupVariables(this.this$0.rowGroups, headerCell.getBucketValues());
                if (bl3) {
                    jRFillCellContents = jRFillCellContents.getTransformedContents(jRFillCellContents.getWidth(), n7, (byte)1, (byte)4);
                }
                jRFillCellContents = jRFillCellContents.getBoxContents(false, false, this.rowIdx == n4 && (!this.printColumnHeaders || this.this$0.headerCell == null));
                jRFillCellContents.getWorkingClone();
                jRFillCellContents.evaluate((byte)3);
                jRFillCellContents.prepare(n11);
                this.preparedRow.add(jRFillCellContents);
                bl2 = jRFillCellContents.willOverflow();
                if (!bl2) {
                    jRFillCellContents.setX(this.rowHeadersXOffsets[n2]);
                    jRFillCellContents.setY(n5 + this.yOffset);
                    jRFillCellContents.setVerticalSpan(n4);
                    int n12 = jRFillCellContents.getPrintHeight() - n9;
                    if (n12 > this.preparedRowHeight) {
                        this.preparedRowHeight = n12;
                    }
                }
            }
            if (bl2) {
                this.removeFilledRows(n4);
            }
            return bl2;
        }

        public void addPrintRow(List list) {
            this.printRows.add(list);
        }

        public List getLastPrintRow() {
            return (List)this.printRows.get(this.printRows.size() - 1);
        }

        public List getPrintElements() {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.printRows.iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                arrayList.addAll(list);
            }
            return arrayList;
        }

        public void setGroupVariables(JRFillCrosstabGroup[] jRFillCrosstabGroupArray, BucketDefinition.Bucket[] bucketArray) {
            for (int i2 = 0; i2 < jRFillCrosstabGroupArray.length; ++i2) {
                Object object = null;
                if (bucketArray[i2] != null && !bucketArray[i2].isTotal()) {
                    object = bucketArray[i2].getValue();
                }
                jRFillCrosstabGroupArray[i2].getFillVariable().setValue(object);
            }
        }

        public void setMeasureVariables(CrosstabCell crosstabCell) {
            MeasureDefinition.MeasureValue[] measureValueArray = crosstabCell.getMesureValues();
            for (int i2 = 0; i2 < this.this$0.measures.length; ++i2) {
                Object object = this.measureValue(measureValueArray, i2);
                this.this$0.measures[i2].getFillVariable().setValue(object);
            }
            MeasureDefinition.MeasureValue[][][] measureValueArray2 = crosstabCell.getTotals();
            for (int i3 = 0; i3 <= this.this$0.rowGroups.length; ++i3) {
                for (int i4 = 0; i4 <= this.this$0.columnGroups.length; ++i4) {
                    MeasureDefinition.MeasureValue[] measureValueArray3 = measureValueArray2[i3][i4];
                    if (!this.this$0.retrieveTotal[i3][i4]) continue;
                    for (int i5 = 0; i5 < this.this$0.measures.length; ++i5) {
                        JRFillVariable jRFillVariable = this.this$0.totalVariables[i3][i4][i5];
                        Object object = this.measureValue(measureValueArray3, i5);
                        jRFillVariable.setValue(object);
                    }
                }
            }
        }

        public Object measureValue(MeasureDefinition.MeasureValue[] measureValueArray, int n2) {
            Object object = this.this$0.measures[n2].getPercentageOfType() == 1 ? (measureValueArray[n2].isInitialized() ? measureValueArray[n2].getValue() : this.this$0.measures[n2].getPercentageCalculator().calculatePercentage(measureValueArray[n2], this.this$0.grandTotals[n2])) : measureValueArray[n2].getValue();
            return object;
        }

        public void resetVariables() {
            int n2;
            for (n2 = 0; n2 < this.this$0.rowGroups.length; ++n2) {
                this.this$0.rowGroups[n2].getFillVariable().setValue(null);
            }
            for (n2 = 0; n2 < this.this$0.columnGroups.length; ++n2) {
                this.this$0.columnGroups[n2].getFillVariable().setValue(null);
            }
            for (n2 = 0; n2 < this.this$0.measures.length; ++n2) {
                this.this$0.measures[n2].getFillVariable().setValue(null);
            }
            for (n2 = 0; n2 <= this.this$0.rowGroups.length; ++n2) {
                for (int i2 = 0; i2 <= this.this$0.columnGroups.length; ++i2) {
                    if (!this.this$0.retrieveTotal[n2][i2]) continue;
                    for (int i3 = 0; i3 < this.this$0.measures.length; ++i3) {
                        this.this$0.totalVariables[n2][i2][i3].setValue(null);
                    }
                }
            }
        }
    }

    public class JRFillCrosstabDataset
    extends JRFillElementDataset
    implements JRCrosstabDataset {
        private Object[] bucketValues;
        private Object[] measureValues;
        private final JRFillCrosstab this$0;

        public JRFillCrosstabDataset(JRFillCrosstab jRFillCrosstab, JRCrosstabDataset jRCrosstabDataset, JRFillObjectFactory jRFillObjectFactory) {
            super(jRCrosstabDataset, jRFillObjectFactory);
            this.this$0 = jRFillCrosstab;
            this.bucketValues = new Object[jRFillCrosstab.rowGroups.length + jRFillCrosstab.columnGroups.length];
            this.measureValues = new Object[jRFillCrosstab.measures.length];
        }

        public void customInitialize() {
            this.this$0.initBucketingService();
        }

        public void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
            int n2;
            for (n2 = 0; n2 < this.this$0.rowGroups.length; ++n2) {
                this.bucketValues[n2] = jRCalculator.evaluate(this.this$0.rowGroups[n2].getBucket().getExpression());
            }
            for (n2 = 0; n2 < this.this$0.columnGroups.length; ++n2) {
                this.bucketValues[n2 + this.this$0.rowGroups.length] = jRCalculator.evaluate(this.this$0.columnGroups[n2].getBucket().getExpression());
            }
            for (n2 = 0; n2 < this.this$0.measures.length; ++n2) {
                this.measureValues[n2] = jRCalculator.evaluate(this.this$0.measures[n2].getValueExpression());
            }
        }

        public void customIncrement() {
            try {
                this.this$0.bucketingService.addData(this.bucketValues, this.measureValues);
            }
            catch (JRException jRException) {
                throw new JRRuntimeException("Error incrementing crosstab dataset", jRException);
            }
        }

        public Dataset getCustomDataset() {
            return null;
        }

        public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        }

        public boolean isDataPreSorted() {
            return ((JRCrosstabDataset)this.parent).isDataPreSorted();
        }
    }
}

