/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.fill.JRFillAreaPlot;
import net.sf.jasperreports.charts.fill.JRFillBar3DPlot;
import net.sf.jasperreports.charts.fill.JRFillBarPlot;
import net.sf.jasperreports.charts.fill.JRFillCategoryDataset;
import net.sf.jasperreports.charts.fill.JRFillChartAxis;
import net.sf.jasperreports.charts.fill.JRFillHighLowDataset;
import net.sf.jasperreports.charts.fill.JRFillLinePlot;
import net.sf.jasperreports.charts.fill.JRFillMeterPlot;
import net.sf.jasperreports.charts.fill.JRFillMultiAxisPlot;
import net.sf.jasperreports.charts.fill.JRFillPie3DPlot;
import net.sf.jasperreports.charts.fill.JRFillPieDataset;
import net.sf.jasperreports.charts.fill.JRFillPiePlot;
import net.sf.jasperreports.charts.fill.JRFillThermometerPlot;
import net.sf.jasperreports.charts.fill.JRFillTimePeriodDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillXyDataset;
import net.sf.jasperreports.charts.fill.JRFillXyzDataset;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.charts.util.PieLabelGenerator;
import net.sf.jasperreports.engine.JRAbstractChartCustomizer;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;
import net.sf.jasperreports.renderers.JFreeChartRenderer;
import net.sf.jasperreports.renderers.JRCategoryChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRHighLowChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRPieChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRTimePeriodChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRTimeSeriesChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRXYChartImageMapRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleEdge;

public class JRFillChart
extends JRFillElement
implements JRChart {
    private static final Color TRANSPARENT_PAINT = new Color(0, 0, 0, 0);
    public byte chartType = 0;
    public JRFont titleFont = null;
    public JRFont subtitleFont = null;
    public JRFont legendFont = null;
    public JRGroup evaluationGroup = null;
    public JRFillChartDataset dataset = null;
    public JRChartPlot plot = null;
    public JRRenderable renderer = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    public String customizerClass;
    public JRChartCustomizer chartCustomizer;

    public JRFillChart(JRBaseFiller jRBaseFiller, JRChart jRChart, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRChart, jRFillObjectFactory);
        this.chartType = jRChart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            case 3: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 2: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBar3DPlot((JRBar3DPlot)jRChart.getPlot());
                break;
            }
            case 4: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyzDataset((JRXyzDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBubblePlot((JRBubblePlot)jRChart.getPlot());
                break;
            }
            case 5: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getHighLowDataset((JRHighLowDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getCandlestickPlot((JRCandlestickPlot)jRChart.getPlot());
                break;
            }
            case 6: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getHighLowDataset((JRHighLowDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getHighLowPlot((JRHighLowPlot)jRChart.getPlot());
                break;
            }
            case 7: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getLinePlot((JRLinePlot)jRChart.getPlot());
                break;
            }
            case 17: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getValueDataset((JRValueDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getMeterPlot((JRMeterPlot)jRChart.getPlot());
                break;
            }
            case 19: {
                this.plot = jRFillObjectFactory.getMultiAxisPlot((JRMultiAxisPlot)jRChart.getPlot());
                this.dataset = ((JRFillMultiAxisPlot)this.plot).getMainDataset();
                break;
            }
            case 9: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getPieDataset((JRPieDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getPiePlot((JRPiePlot)jRChart.getPlot());
                break;
            }
            case 8: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getPieDataset((JRPieDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getPie3DPlot((JRPie3DPlot)jRChart.getPlot());
                break;
            }
            case 10: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getScatterPlot((JRScatterPlot)jRChart.getPlot());
                break;
            }
            case 12: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 11: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBar3DPlot((JRBar3DPlot)jRChart.getPlot());
                break;
            }
            case 18: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getValueDataset((JRValueDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getThermometerPlot((JRThermometerPlot)jRChart.getPlot());
                break;
            }
            case 16: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getTimeSeriesPlot((JRTimeSeriesPlot)jRChart.getPlot());
                break;
            }
            case 13: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            case 14: {
                switch (jRChart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset()));
                        break;
                    }
                    case 5: {
                        this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getTimePeriodDataset((JRTimePeriodDataset)jRChart.getDataset()));
                        break;
                    }
                    case 3: {
                        this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                    }
                }
                this.plot = jRFillObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 15: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getLinePlot((JRLinePlot)jRChart.getPlot());
                break;
            }
            case 20: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        this.titleFont = new JRBaseFont(null, null, jRChart, jRChart.getTitleFont());
        this.subtitleFont = new JRBaseFont(null, null, jRChart, jRChart.getSubtitleFont());
        this.legendFont = new JRBaseFont(null, null, jRChart, jRChart.getLegendFont());
        this.evaluationGroup = jRFillObjectFactory.getGroup(jRChart.getEvaluationGroup());
        this.customizerClass = jRChart.getCustomizerClass();
        if (this.customizerClass != null && this.customizerClass.length() > 0) {
            try {
                Class clazz = JRClassLoader.loadClassForName(this.customizerClass);
                this.chartCustomizer = (JRChartCustomizer)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JRRuntimeException("Could not create chart customizer instance.", exception);
            }
            if (this.chartCustomizer instanceof JRAbstractChartCustomizer) {
                ((JRAbstractChartCustomizer)this.chartCustomizer).init(jRBaseFiller, this);
            }
        }
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public boolean isShowLegend() {
        return ((JRChart)this.parent).isShowLegend();
    }

    public void setShowLegend(boolean bl2) {
    }

    public byte getEvaluationTime() {
        return ((JRChart)this.parent).getEvaluationTime();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return ((JRBoxContainer)((Object)this.parent)).getLineBox();
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getPen());
    }

    public void setBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getPen());
    }

    public void setBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getPen());
    }

    public Color getBorderColor() {
        return this.getLineBox().getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.getLineBox().getPen().getOwnLineColor();
    }

    public void setBorderColor(Color color) {
        this.getLineBox().getPen().setLineColor(color);
    }

    public int getPadding() {
        return this.getLineBox().getPadding();
    }

    public Integer getOwnPadding() {
        return this.getLineBox().getOwnPadding();
    }

    public void setPadding(int n2) {
        this.getLineBox().setPadding(n2);
    }

    public void setPadding(Integer n2) {
        this.getLineBox().setPadding(n2);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getTopPen());
    }

    public void setTopBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getTopPen());
    }

    public void setTopBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getTopPen());
    }

    public Color getTopBorderColor() {
        return this.getLineBox().getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.getLineBox().getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color color) {
        this.getLineBox().getTopPen().setLineColor(color);
    }

    public int getTopPadding() {
        return this.getLineBox().getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.getLineBox().getOwnTopPadding();
    }

    public void setTopPadding(int n2) {
        this.getLineBox().setTopPadding(n2);
    }

    public void setTopPadding(Integer n2) {
        this.getLineBox().setTopPadding(n2);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getLeftPen());
    }

    public void setLeftBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getLeftPen());
    }

    public void setLeftBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.getLineBox().getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.getLineBox().getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color color) {
        this.getLineBox().getLeftPen().setLineColor(color);
    }

    public int getLeftPadding() {
        return this.getLineBox().getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.getLineBox().getOwnLeftPadding();
    }

    public void setLeftPadding(int n2) {
        this.getLineBox().setLeftPadding(n2);
    }

    public void setLeftPadding(Integer n2) {
        this.getLineBox().setLeftPadding(n2);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getBottomPen());
    }

    public void setBottomBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getBottomPen());
    }

    public void setBottomBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.getLineBox().getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.getLineBox().getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color color) {
        this.getLineBox().getBottomPen().setLineColor(color);
    }

    public int getBottomPadding() {
        return this.getLineBox().getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.getLineBox().getOwnBottomPadding();
    }

    public void setBottomPadding(int n2) {
        this.getLineBox().setBottomPadding(n2);
    }

    public void setBottomPadding(Integer n2) {
        this.getLineBox().setBottomPadding(n2);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getRightPen());
    }

    public void setRightBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getRightPen());
    }

    public void setRightBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.getLineBox().getRightPen());
    }

    public Color getRightBorderColor() {
        return this.getLineBox().getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.getLineBox().getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color color) {
        this.getLineBox().getRightPen().setLineColor(color);
    }

    public int getRightPadding() {
        return this.getLineBox().getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.getLineBox().getOwnRightPadding();
    }

    public void setRightPadding(int n2) {
        this.getLineBox().setRightPadding(n2);
    }

    public void setRightPadding(Integer n2) {
        this.getLineBox().setRightPadding(n2);
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public byte getTitlePosition() {
        return ((JRChart)this.parent).getTitlePosition();
    }

    public void setTitlePosition(byte by2) {
    }

    public Color getTitleColor() {
        return JRStyleResolver.getTitleColor(this);
    }

    public Color getOwnTitleColor() {
        return ((JRChart)this.parent).getOwnTitleColor();
    }

    public void setTitleColor(Color color) {
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public Color getOwnSubtitleColor() {
        return ((JRChart)this.parent).getOwnSubtitleColor();
    }

    public Color getSubtitleColor() {
        return JRStyleResolver.getSubtitleColor(this);
    }

    public void setSubtitleColor(Color color) {
    }

    public Color getOwnLegendColor() {
        return ((JRChart)this.parent).getOwnLegendColor();
    }

    public Color getLegendColor() {
        return JRStyleResolver.getLegendColor(this);
    }

    public void setLegendColor(Color color) {
    }

    public Color getOwnLegendBackgroundColor() {
        return ((JRChart)this.parent).getOwnLegendBackgroundColor();
    }

    public Color getLegendBackgroundColor() {
        return JRStyleResolver.getLegendBackgroundColor(this);
    }

    public void setLegendBackgroundColor(Color color) {
    }

    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public byte getLegendPosition() {
        return ((JRChart)this.parent).getLegendPosition();
    }

    public void setLegendPosition(byte by2) {
    }

    public JRExpression getTitleExpression() {
        return ((JRChart)this.parent).getTitleExpression();
    }

    public JRExpression getSubtitleExpression() {
        return ((JRChart)this.parent).getSubtitleExpression();
    }

    public byte getHyperlinkType() {
        return ((JRChart)this.parent).getHyperlinkType();
    }

    public byte getHyperlinkTarget() {
        return ((JRChart)this.parent).getHyperlinkTarget();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRChart)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRChart)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRChart)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRChart)this.parent).getHyperlinkPageExpression();
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRFillChartDataset jRFillChartDataset) {
        this.dataset = jRFillChartDataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    public JRRenderable getRenderer() {
        return this.renderer;
    }

    public String getAnchorName() {
        return this.anchorName;
    }

    public String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    public String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    public Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    public String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    public JRTemplateImage getJRTemplateImage() {
        JRStyle jRStyle = this.getStyle();
        JRTemplateImage jRTemplateImage = (JRTemplateImage)this.getTemplate(jRStyle);
        if (jRTemplateImage == null) {
            jRTemplateImage = new JRTemplateImage(this.band.getOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.registerTemplate(jRStyle, jRTemplateImage);
        }
        return jRTemplateImage;
    }

    public void rewind() {
    }

    public void evaluate(byte by2) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(by2);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.getEvaluationTime() == 1) {
            this.evaluateImage(by2);
        }
    }

    public JFreeChartRenderer evaluateImage(byte by2) throws JRException {
        JFreeChartRenderer jFreeChartRenderer;
        this.evaluateDatasetRun(by2);
        switch (this.chartType) {
            case 1: {
                jFreeChartRenderer = this.evaluateAreaImage(by2);
                break;
            }
            case 3: {
                jFreeChartRenderer = this.evaluateBarImage(by2);
                break;
            }
            case 2: {
                jFreeChartRenderer = this.evaluateBar3DImage(by2);
                break;
            }
            case 4: {
                jFreeChartRenderer = this.evaluateBubbleImage(by2);
                break;
            }
            case 5: {
                jFreeChartRenderer = this.evaluateCandlestickImage(by2);
                break;
            }
            case 6: {
                jFreeChartRenderer = this.evaluateHighLowImage(by2);
                break;
            }
            case 7: {
                jFreeChartRenderer = this.evaluateLineImage(by2);
                break;
            }
            case 17: {
                jFreeChartRenderer = this.evaluateMeterImage(by2);
                break;
            }
            case 19: {
                jFreeChartRenderer = this.evaluateMultiAxisImage(by2);
                break;
            }
            case 9: {
                jFreeChartRenderer = this.evaluatePieImage(by2);
                break;
            }
            case 8: {
                jFreeChartRenderer = this.evaluatePie3DImage(by2);
                break;
            }
            case 10: {
                jFreeChartRenderer = this.evaluateScatterImage(by2);
                break;
            }
            case 12: {
                jFreeChartRenderer = this.evaluateStackedBarImage(by2);
                break;
            }
            case 11: {
                jFreeChartRenderer = this.evaluateStackedBar3DImage(by2);
                break;
            }
            case 18: {
                jFreeChartRenderer = this.evaluateThermometerImage(by2);
                break;
            }
            case 16: {
                jFreeChartRenderer = this.evaluateTimeSeriesImage(by2);
                break;
            }
            case 13: {
                jFreeChartRenderer = this.evaluateXyAreaImage(by2);
                break;
            }
            case 14: {
                jFreeChartRenderer = this.evaluateXYBarImage(by2);
                break;
            }
            case 15: {
                jFreeChartRenderer = this.evaluateXyLineImage(by2);
                break;
            }
            case 20: {
                jFreeChartRenderer = this.evaluateStackedAreaImage(by2);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + this.getChartType() + " not supported.");
            }
        }
        if (this.chartCustomizer != null) {
            this.chartCustomizer.customize(jFreeChartRenderer.getChart(), this);
        }
        this.renderer = jFreeChartRenderer;
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), by2);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), by2);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), by2);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), by2);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), by2);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, by2);
        return jFreeChartRenderer;
    }

    public boolean prepare(int n2, boolean bl2) {
        boolean bl3 = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return bl3;
        }
        boolean bl4 = true;
        boolean bl5 = false;
        if (this.getEvaluationTime() == 1) {
            if (bl2 && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                bl4 = false;
            }
            if (bl4 && n2 < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                bl4 = false;
                bl3 = true;
            }
            if (bl4 && bl2 && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                bl5 = true;
            }
            if (bl4 && this.isRemoveLineWhenBlank() && this.getRenderer() == null) {
                bl4 = false;
            }
        } else {
            if (bl2 && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                bl4 = false;
            }
            if (bl4 && n2 < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                bl4 = false;
                bl3 = true;
            }
            if (bl4 && bl2 && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                bl5 = true;
            }
        }
        this.setToPrint(bl4);
        this.setReprinted(bl5);
        return bl3;
    }

    public JRPrintElement fill() {
        JRTemplatePrintImage jRTemplatePrintImage = new JRTemplatePrintImage(this.getJRTemplateImage());
        jRTemplatePrintImage.setX(this.getX());
        jRTemplatePrintImage.setY(this.getRelativeY());
        jRTemplatePrintImage.setWidth(this.getWidth());
        jRTemplatePrintImage.setHeight(this.getStretchHeight());
        byte by2 = this.getEvaluationTime();
        if (by2 == 1) {
            this.copy(jRTemplatePrintImage);
        } else {
            this.filler.addBoundElement(this, jRTemplatePrintImage, by2, this.getEvaluationGroup(), this.band);
        }
        return jRTemplatePrintImage;
    }

    public void copy(JRPrintImage jRPrintImage) {
        jRPrintImage.setRenderer(this.getRenderer());
        jRPrintImage.setAnchorName(this.getAnchorName());
        jRPrintImage.setHyperlinkReference(this.getHyperlinkReference());
        jRPrintImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        jRPrintImage.setHyperlinkPage(this.getHyperlinkPage());
        jRPrintImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        jRPrintImage.setBookmarkLevel(this.getBookmarkLevel());
        jRPrintImage.setHyperlinkParameters(this.hyperlinkParameters);
    }

    public byte getChartType() {
        return this.chartType;
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void visit(JRVisitor jRVisitor) {
        jRVisitor.visitChart(this);
    }

    private void configureChart(JFreeChart jFreeChart, JRChartPlot jRChartPlot, byte by2) throws JRException {
        LegendTitle legendTitle;
        Object object;
        if (this.getMode() == 1) {
            jFreeChart.setBackgroundPaint((Paint)this.getBackcolor());
        } else {
            jFreeChart.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        }
        RectangleEdge rectangleEdge = JRFillChart.getEdge(this.getTitlePosition());
        if (jFreeChart.getTitle() != null) {
            object = jFreeChart.getTitle();
            object.setPaint((Paint)this.getTitleColor());
            object.setFont(new Font(JRFontUtil.getAttributes(this.getTitleFont())));
            object.setPosition(rectangleEdge);
        }
        if ((object = (String)this.evaluateExpression(this.getSubtitleExpression(), by2)) != null) {
            legendTitle = new TextTitle((String)object);
            legendTitle.setPaint((Paint)this.getSubtitleColor());
            legendTitle.setFont(new Font(JRFontUtil.getAttributes(this.getSubtitleFont())));
            legendTitle.setPosition(rectangleEdge);
            jFreeChart.addSubtitle((Title)legendTitle);
        }
        if ((legendTitle = jFreeChart.getLegend()) != null) {
            legendTitle.setItemPaint((Paint)this.getLegendColor());
            if (this.getOwnLegendBackgroundColor() == null) {
                legendTitle.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
            } else {
                legendTitle.setBackgroundPaint((Paint)this.getLegendBackgroundColor());
            }
            jFreeChart.getLegend().setItemFont(new Font(JRFontUtil.getAttributes(this.getLegendFont())));
            jFreeChart.getLegend().setPosition(JRFillChart.getEdge(this.getLegendPosition()));
        }
        this.configurePlot(jFreeChart.getPlot(), jRChartPlot);
    }

    private void configurePlot(Plot plot, JRChartPlot jRChartPlot) {
        Paint[] paintArray;
        plot.setOutlinePaint((Paint)TRANSPARENT_PAINT);
        if (this.getPlot().getOwnBackcolor() == null) {
            plot.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        } else {
            plot.setBackgroundPaint((Paint)this.getPlot().getBackcolor());
        }
        plot.setBackgroundAlpha(this.getPlot().getBackgroundAlpha());
        plot.setForegroundAlpha(this.getPlot().getForegroundAlpha());
        SortedSet sortedSet = this.getPlot().getSeriesColors();
        if (plot instanceof CategoryPlot) {
            paintArray = ((CategoryPlot)plot).getDomainAxis();
            double d2 = this.getPlot().getLabelRotation();
            if (d2 == 90.0) {
                paintArray.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (d2 == -90.0) {
                paintArray.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else if (d2 < 0.0) {
                paintArray.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)(-d2 / 180.0 * Math.PI)));
            } else if (d2 > 0.0) {
                paintArray.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions((double)(d2 / 180.0 * Math.PI)));
            }
        }
        if (sortedSet != null) {
            if (sortedSet.size() == 1) {
                paintArray = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + 1];
                paintArray[0] = ((JRChartPlot.JRSeriesColor)sortedSet.first()).getColor();
                for (int i2 = 0; i2 < DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length; ++i2) {
                    paintArray[i2 + 1] = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE[i2];
                }
                plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(paintArray, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            } else if (sortedSet.size() > 1) {
                paintArray = new Color[sortedSet.size()];
                JRChartPlot.JRSeriesColor[] jRSeriesColorArray = new JRChartPlot.JRSeriesColor[sortedSet.size()];
                sortedSet.toArray(jRSeriesColorArray);
                for (int i3 = 0; i3 < jRSeriesColorArray.length; ++i3) {
                    paintArray[i3] = jRSeriesColorArray[i3].getColor();
                }
                plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(paintArray, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            }
        }
    }

    private void configureAxisSeriesColors(CategoryItemRenderer categoryItemRenderer, JRChartPlot jRChartPlot) {
        SortedSet sortedSet = jRChartPlot.getSeriesColors();
        if (sortedSet != null) {
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                JRChartPlot.JRSeriesColor jRSeriesColor = (JRChartPlot.JRSeriesColor)iterator.next();
                categoryItemRenderer.setSeriesPaint(jRSeriesColor.getSeriesOrder(), (Paint)jRSeriesColor.getColor());
            }
        }
    }

    private void configureAxisSeriesColors(XYItemRenderer xYItemRenderer, JRChartPlot jRChartPlot) {
        SortedSet sortedSet = jRChartPlot.getSeriesColors();
        if (sortedSet != null) {
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                JRChartPlot.JRSeriesColor jRSeriesColor = (JRChartPlot.JRSeriesColor)iterator.next();
                xYItemRenderer.setSeriesPaint(jRSeriesColor.getSeriesOrder(), (Paint)jRSeriesColor.getColor());
            }
        }
    }

    private void configureAxis(Axis axis, JRFont jRFont, Color color, JRFont jRFont2, Color color2, String string, Color color3) {
        axis.setLabelFont(new Font(JRFontUtil.getAttributes(jRFont)));
        axis.setTickLabelFont(new Font(JRFontUtil.getAttributes(jRFont2)));
        if (color != null) {
            axis.setLabelPaint((Paint)color);
        }
        if (color2 != null) {
            axis.setTickLabelPaint((Paint)color2);
        }
        if (color3 != null) {
            axis.setAxisLinePaint((Paint)color3);
            axis.setTickMarkPaint((Paint)color3);
        }
        if (string != null) {
            if (axis instanceof NumberAxis) {
                NumberFormat numberFormat = NumberFormat.getInstance();
                if (numberFormat instanceof DecimalFormat) {
                    ((DecimalFormat)numberFormat).applyPattern(string);
                }
                ((NumberAxis)axis).setNumberFormatOverride(numberFormat);
            } else if (axis instanceof DateAxis) {
                DateFormat dateFormat = null;
                dateFormat = string.equals("SHORT") || string.equals("DateFormat.SHORT") ? DateFormat.getDateInstance(3) : (string.equals("MEDIUM") || string.equals("DateFormat.MEDIUM") ? DateFormat.getDateInstance(2) : (string.equals("LONG") || string.equals("DateFormat.LONG") ? DateFormat.getDateInstance(1) : (string.equals("FULL") || string.equals("DateFormat.FULL") ? DateFormat.getDateInstance(0) : new SimpleDateFormat(string))));
                ((DateAxis)axis).setDateFormatOverride(dateFormat);
            }
        }
    }

    public JFreeChartRenderer evaluateAreaImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createAreaChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), by2)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        JRFillAreaPlot jRFillAreaPlot = (JRFillAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jFreeChart.getPlot()).getDomainAxis(), jRFillAreaPlot.getCategoryAxisLabelFont(), jRFillAreaPlot.getCategoryAxisLabelColor(), jRFillAreaPlot.getCategoryAxisTickLabelFont(), jRFillAreaPlot.getCategoryAxisTickLabelColor(), jRFillAreaPlot.getCategoryAxisTickLabelMask(), jRFillAreaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)((CategoryPlot)jFreeChart.getPlot()).getRangeAxis(), jRFillAreaPlot.getValueAxisLabelFont(), jRFillAreaPlot.getValueAxisLabelColor(), jRFillAreaPlot.getValueAxisTickLabelFont(), jRFillAreaPlot.getValueAxisTickLabelColor(), jRFillAreaPlot.getCategoryAxisTickLabelMask(), jRFillAreaPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateBar3DImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), by2)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        JRFillBar3DPlot jRFillBar3DPlot = (JRFillBar3DPlot)this.getPlot();
        BarRenderer3D barRenderer3D = new BarRenderer3D(jRFillBar3DPlot.getXOffset(), jRFillBar3DPlot.getYOffset());
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer3D);
        barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        barRenderer3D.setItemLabelsVisible(jRFillBar3DPlot.isShowLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), jRFillBar3DPlot.getCategoryAxisLabelFont(), jRFillBar3DPlot.getCategoryAxisLabelColor(), jRFillBar3DPlot.getCategoryAxisTickLabelFont(), jRFillBar3DPlot.getCategoryAxisTickLabelColor(), jRFillBar3DPlot.getCategoryAxisTickLabelMask(), jRFillBar3DPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), jRFillBar3DPlot.getValueAxisLabelFont(), jRFillBar3DPlot.getValueAxisLabelColor(), jRFillBar3DPlot.getValueAxisTickLabelFont(), jRFillBar3DPlot.getValueAxisTickLabelColor(), jRFillBar3DPlot.getValueAxisTickLabelMask(), jRFillBar3DPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateBarImage(byte by2) throws JRException {
        CategoryDataset categoryDataset = (CategoryDataset)this.dataset.getDataset();
        JFreeChart jFreeChart = ChartFactory.createBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), by2)), (CategoryDataset)categoryDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        JRFillBarPlot jRFillBarPlot = (JRFillBarPlot)this.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(jRFillBarPlot.isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(jRFillBarPlot.isShowTickLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), jRFillBarPlot.getCategoryAxisLabelFont(), jRFillBarPlot.getCategoryAxisLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelFont(), jRFillBarPlot.getCategoryAxisTickLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelMask(), jRFillBarPlot.getCategoryAxisLineColor());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(jRFillBarPlot.isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(jRFillBarPlot.isShowTickLabels());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), jRFillBarPlot.getValueAxisLabelFont(), jRFillBarPlot.getValueAxisLabelColor(), jRFillBarPlot.getValueAxisTickLabelFont(), jRFillBarPlot.getValueAxisTickLabelColor(), jRFillBarPlot.getValueAxisTickLabelMask(), jRFillBarPlot.getValueAxisLineColor());
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryItemRenderer.setItemLabelsVisible(jRFillBarPlot.isShowLabels());
        return this.getCategoryRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateBubbleImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createBubbleChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression(), by2)), (XYZDataset)((XYZDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        JRBubblePlot jRBubblePlot = (JRBubblePlot)this.getPlot();
        XYBubbleRenderer xYBubbleRenderer = new XYBubbleRenderer(jRBubblePlot.getScaleType());
        xYPlot.setRenderer((XYItemRenderer)xYBubbleRenderer);
        this.configureAxis((Axis)xYPlot.getDomainAxis(), jRBubblePlot.getXAxisLabelFont(), jRBubblePlot.getXAxisLabelColor(), jRBubblePlot.getXAxisTickLabelFont(), jRBubblePlot.getXAxisTickLabelColor(), jRBubblePlot.getXAxisTickLabelMask(), jRBubblePlot.getXAxisLineColor());
        this.configureAxis((Axis)xYPlot.getRangeAxis(), jRBubblePlot.getYAxisLabelFont(), jRBubblePlot.getYAxisLabelColor(), jRBubblePlot.getYAxisTickLabelFont(), jRBubblePlot.getYAxisTickLabelColor(), jRBubblePlot.getYAxisTickLabelMask(), jRBubblePlot.getYAxisLineColor());
        return this.getXYZRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateCandlestickImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createCandlestickChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression(), by2)), (OHLCDataset)((DefaultHighLowDataset)this.dataset.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jFreeChart, this.getPlot(), by2);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        JRCandlestickPlot jRCandlestickPlot = (JRCandlestickPlot)this.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xYPlot.getRenderer();
        candlestickRenderer.setDrawVolume(jRCandlestickPlot.isShowVolume());
        this.configureAxis((Axis)xYPlot.getDomainAxis(), jRCandlestickPlot.getTimeAxisLabelFont(), jRCandlestickPlot.getTimeAxisLabelColor(), jRCandlestickPlot.getTimeAxisTickLabelFont(), jRCandlestickPlot.getTimeAxisTickLabelColor(), jRCandlestickPlot.getTimeAxisTickLabelMask(), jRCandlestickPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xYPlot.getRangeAxis(), jRCandlestickPlot.getValueAxisLabelFont(), jRCandlestickPlot.getValueAxisLabelColor(), jRCandlestickPlot.getValueAxisTickLabelFont(), jRCandlestickPlot.getValueAxisTickLabelColor(), jRCandlestickPlot.getValueAxisTickLabelMask(), jRCandlestickPlot.getValueAxisLineColor());
        return this.getHighLowRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateHighLowImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createHighLowChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression(), by2)), (OHLCDataset)((DefaultHighLowDataset)this.dataset.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jFreeChart, this.getPlot(), by2);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        JRHighLowPlot jRHighLowPlot = (JRHighLowPlot)this.getPlot();
        HighLowRenderer highLowRenderer = (HighLowRenderer)xYPlot.getRenderer();
        highLowRenderer.setDrawOpenTicks(jRHighLowPlot.isShowOpenTicks());
        highLowRenderer.setDrawCloseTicks(jRHighLowPlot.isShowCloseTicks());
        this.configureAxis((Axis)xYPlot.getDomainAxis(), jRHighLowPlot.getTimeAxisLabelFont(), jRHighLowPlot.getTimeAxisLabelColor(), jRHighLowPlot.getTimeAxisTickLabelFont(), jRHighLowPlot.getTimeAxisTickLabelColor(), jRHighLowPlot.getTimeAxisTickLabelMask(), jRHighLowPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xYPlot.getRangeAxis(), jRHighLowPlot.getValueAxisLabelFont(), jRHighLowPlot.getValueAxisLabelColor(), jRHighLowPlot.getValueAxisTickLabelFont(), jRHighLowPlot.getValueAxisTickLabelColor(), jRHighLowPlot.getValueAxisTickLabelMask(), jRHighLowPlot.getValueAxisLineColor());
        return this.getHighLowRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateLineImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createLineChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression(), by2)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        JRFillLinePlot jRFillLinePlot = (JRFillLinePlot)this.getPlot();
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineAndShapeRenderer.setShapesVisible(jRFillLinePlot.isShowShapes());
        lineAndShapeRenderer.setLinesVisible(jRFillLinePlot.isShowLines());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), jRFillLinePlot.getCategoryAxisLabelFont(), jRFillLinePlot.getCategoryAxisLabelColor(), jRFillLinePlot.getCategoryAxisTickLabelFont(), jRFillLinePlot.getCategoryAxisTickLabelColor(), jRFillLinePlot.getCategoryAxisTickLabelMask(), jRFillLinePlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), jRFillLinePlot.getValueAxisLabelFont(), jRFillLinePlot.getValueAxisLabelColor(), jRFillLinePlot.getValueAxisTickLabelFont(), jRFillLinePlot.getValueAxisTickLabelColor(), jRFillLinePlot.getValueAxisTickLabelMask(), jRFillLinePlot.getValueAxisLineColor());
        return this.getCategoryRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluatePie3DImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createPieChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (PieDataset)((PieDataset)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        PiePlot3D piePlot3D = (PiePlot3D)jFreeChart.getPlot();
        piePlot3D.setDepthFactor(((JRFillPie3DPlot)this.getPlot()).getDepthFactor());
        piePlot3D.setCircular(((JRFillPie3DPlot)this.getPlot()).isCircular());
        PieLabelGenerator pieLabelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (pieLabelGenerator != null) {
            piePlot3D.setLabelGenerator((PieSectionLabelGenerator)pieLabelGenerator);
        }
        piePlot3D.setLabelFont(new Font(JRFontUtil.getAttributes(new JRBaseFont(null, null, this, null))));
        piePlot3D.setLabelPaint((Paint)this.getForecolor());
        return this.getPieRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluatePieImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createPieChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (PieDataset)((PieDataset)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        piePlot.setCircular(((JRFillPiePlot)this.getPlot()).isCircular());
        PieLabelGenerator pieLabelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (pieLabelGenerator != null) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)pieLabelGenerator);
        }
        piePlot.setLabelFont(new Font(JRFontUtil.getAttributes(new JRBaseFont(null, null, this, null))));
        piePlot.setLabelPaint((Paint)this.getForecolor());
        return this.getPieRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateScatterImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression(), by2)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)((XYPlot)jFreeChart.getPlot()).getRenderer();
        JRScatterPlot jRScatterPlot = (JRScatterPlot)this.getPlot();
        xYLineAndShapeRenderer.setLinesVisible(jRScatterPlot.isShowLines());
        xYLineAndShapeRenderer.setShapesVisible(jRScatterPlot.isShowShapes());
        this.configureAxis((Axis)jFreeChart.getXYPlot().getDomainAxis(), jRScatterPlot.getXAxisLabelFont(), jRScatterPlot.getXAxisLabelColor(), jRScatterPlot.getXAxisTickLabelFont(), jRScatterPlot.getXAxisTickLabelColor(), jRScatterPlot.getXAxisTickLabelMask(), jRScatterPlot.getXAxisLineColor());
        this.configureAxis((Axis)jFreeChart.getXYPlot().getRangeAxis(), jRScatterPlot.getYAxisLabelFont(), jRScatterPlot.getYAxisLabelColor(), jRScatterPlot.getYAxisTickLabelFont(), jRScatterPlot.getYAxisTickLabelColor(), jRScatterPlot.getYAxisTickLabelMask(), jRScatterPlot.getYAxisLineColor());
        return this.getXYRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateStackedBar3DImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), by2)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        JRFillBar3DPlot jRFillBar3DPlot = (JRFillBar3DPlot)this.getPlot();
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(jRFillBar3DPlot.getXOffset(), jRFillBar3DPlot.getYOffset());
        categoryPlot.setRenderer((CategoryItemRenderer)stackedBarRenderer3D);
        stackedBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        stackedBarRenderer3D.setItemLabelsVisible(jRFillBar3DPlot.isShowLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), jRFillBar3DPlot.getCategoryAxisLabelFont(), jRFillBar3DPlot.getCategoryAxisLabelColor(), jRFillBar3DPlot.getCategoryAxisTickLabelFont(), jRFillBar3DPlot.getCategoryAxisTickLabelColor(), jRFillBar3DPlot.getCategoryAxisTickLabelMask(), jRFillBar3DPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), jRFillBar3DPlot.getValueAxisLabelFont(), jRFillBar3DPlot.getValueAxisLabelColor(), jRFillBar3DPlot.getValueAxisTickLabelFont(), jRFillBar3DPlot.getValueAxisTickLabelColor(), jRFillBar3DPlot.getValueAxisTickLabelMask(), jRFillBar3DPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateStackedBarImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), by2)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        JRFillBarPlot jRFillBarPlot = (JRFillBarPlot)this.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(jRFillBarPlot.isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(jRFillBarPlot.isShowTickLabels());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(jRFillBarPlot.isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(jRFillBarPlot.isShowTickLabels());
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryItemRenderer.setItemLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), jRFillBarPlot.getCategoryAxisLabelFont(), jRFillBarPlot.getCategoryAxisLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelFont(), jRFillBarPlot.getCategoryAxisTickLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelMask(), jRFillBarPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), jRFillBarPlot.getValueAxisLabelFont(), jRFillBarPlot.getValueAxisLabelColor(), jRFillBarPlot.getValueAxisTickLabelFont(), jRFillBarPlot.getValueAxisTickLabelColor(), jRFillBarPlot.getValueAxisTickLabelMask(), jRFillBarPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateStackedAreaImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createStackedAreaChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), by2)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        JRFillAreaPlot jRFillAreaPlot = (JRFillAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jFreeChart.getPlot()).getDomainAxis(), jRFillAreaPlot.getCategoryAxisLabelFont(), jRFillAreaPlot.getCategoryAxisLabelColor(), jRFillAreaPlot.getCategoryAxisTickLabelFont(), jRFillAreaPlot.getCategoryAxisTickLabelColor(), jRFillAreaPlot.getCategoryAxisTickLabelMask(), jRFillAreaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)((CategoryPlot)jFreeChart.getPlot()).getRangeAxis(), jRFillAreaPlot.getValueAxisLabelFont(), jRFillAreaPlot.getValueAxisLabelColor(), jRFillAreaPlot.getValueAxisTickLabelFont(), jRFillAreaPlot.getValueAxisTickLabelColor(), jRFillAreaPlot.getCategoryAxisTickLabelMask(), jRFillAreaPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateXyAreaImage(byte by2) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createXYAreaChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), by2)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        JRAreaPlot jRAreaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)jFreeChart.getXYPlot().getDomainAxis(), jRAreaPlot.getCategoryAxisLabelFont(), jRAreaPlot.getCategoryAxisLabelColor(), jRAreaPlot.getCategoryAxisTickLabelFont(), jRAreaPlot.getCategoryAxisTickLabelColor(), jRAreaPlot.getCategoryAxisTickLabelMask(), jRAreaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)jFreeChart.getXYPlot().getRangeAxis(), jRAreaPlot.getValueAxisLabelFont(), jRAreaPlot.getValueAxisLabelColor(), jRAreaPlot.getValueAxisTickLabelFont(), jRAreaPlot.getValueAxisTickLabelColor(), jRAreaPlot.getValueAxisTickLabelMask(), jRAreaPlot.getValueAxisLineColor());
        return this.getXYRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateXYBarImage(byte by2) throws JRException {
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)this.dataset.getDataset();
        boolean bl2 = true;
        if (this.dataset.getDatasetType() == 3) {
            bl2 = false;
        }
        JFreeChart jFreeChart = ChartFactory.createXYBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), by2)), (boolean)bl2, (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), by2)), (IntervalXYDataset)intervalXYDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (this.getDataset().getDatasetType() == 6) {
            xYItemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillTimeSeriesDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 5) {
            xYItemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillTimePeriodDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 3) {
            xYItemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillXyDataset)this.getDataset()).getLabelGenerator());
        }
        JRFillBarPlot jRFillBarPlot = (JRFillBarPlot)this.getPlot();
        xYItemRenderer.setBaseItemLabelsVisible(jRFillBarPlot.isShowLabels());
        this.configureAxis((Axis)xYPlot.getDomainAxis(), jRFillBarPlot.getCategoryAxisLabelFont(), jRFillBarPlot.getCategoryAxisLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelFont(), jRFillBarPlot.getCategoryAxisTickLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelMask(), jRFillBarPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)xYPlot.getRangeAxis(), jRFillBarPlot.getValueAxisLabelFont(), jRFillBarPlot.getValueAxisLabelColor(), jRFillBarPlot.getValueAxisTickLabelFont(), jRFillBarPlot.getValueAxisTickLabelColor(), jRFillBarPlot.getValueAxisTickLabelMask(), jRFillBarPlot.getValueAxisLineColor());
        return this.getXYBarRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateXyLineImage(byte by2) throws JRException {
        JRLinePlot jRLinePlot = (JRLinePlot)this.getPlot();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)((String)this.evaluateExpression(jRLinePlot.getCategoryAxisLabelExpression(), by2)), (String)((String)this.evaluateExpression(jRLinePlot.getValueAxisLabelExpression(), by2)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)jRLinePlot.getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        this.configureAxis((Axis)jFreeChart.getXYPlot().getDomainAxis(), jRLinePlot.getCategoryAxisLabelFont(), jRLinePlot.getCategoryAxisLabelColor(), jRLinePlot.getCategoryAxisTickLabelFont(), jRLinePlot.getCategoryAxisTickLabelColor(), jRLinePlot.getCategoryAxisTickLabelMask(), jRLinePlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)jFreeChart.getXYPlot().getRangeAxis(), jRLinePlot.getValueAxisLabelFont(), jRLinePlot.getValueAxisLabelColor(), jRLinePlot.getValueAxisTickLabelFont(), jRLinePlot.getValueAxisTickLabelColor(), jRLinePlot.getValueAxisTickLabelMask(), jRLinePlot.getValueAxisLineColor());
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)jFreeChart.getXYPlot().getRenderer();
        xYLineAndShapeRenderer.setShapesVisible(jRLinePlot.isShowShapes());
        xYLineAndShapeRenderer.setLinesVisible(jRLinePlot.isShowLines());
        return this.getXYRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateTimeSeriesImage(byte by2) throws JRException {
        String string = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression(), by2);
        String string2 = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression(), by2);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by2)), (String)string, (String)string2, (XYDataset)((TimeSeriesCollection)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        JRTimeSeriesPlot jRTimeSeriesPlot = (JRTimeSeriesPlot)this.getPlot();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        xYLineAndShapeRenderer.setLinesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowLines());
        xYLineAndShapeRenderer.setShapesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowShapes());
        this.configureAxis((Axis)xYPlot.getDomainAxis(), jRTimeSeriesPlot.getTimeAxisLabelFont(), jRTimeSeriesPlot.getTimeAxisLabelColor(), jRTimeSeriesPlot.getTimeAxisTickLabelFont(), jRTimeSeriesPlot.getTimeAxisTickLabelColor(), jRTimeSeriesPlot.getTimeAxisTickLabelMask(), jRTimeSeriesPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xYPlot.getRangeAxis(), jRTimeSeriesPlot.getValueAxisLabelFont(), jRTimeSeriesPlot.getValueAxisLabelColor(), jRTimeSeriesPlot.getValueAxisTickLabelFont(), jRTimeSeriesPlot.getValueAxisTickLabelColor(), jRTimeSeriesPlot.getValueAxisTickLabelMask(), jRTimeSeriesPlot.getValueAxisLineColor());
        return this.getTimeSeriesRenderer(jFreeChart);
    }

    public Range convertRange(JRDataRange jRDataRange, byte by2) throws JRException {
        if (jRDataRange == null) {
            return null;
        }
        Number number = (Number)this.evaluateExpression(jRDataRange.getLowExpression(), by2);
        Number number2 = (Number)this.evaluateExpression(jRDataRange.getHighExpression(), by2);
        return new Range(number != null ? number.doubleValue() : 0.0, number2 != null ? number2.doubleValue() : 100.0);
    }

    public MeterInterval convertInterval(JRMeterInterval jRMeterInterval, byte by2) throws JRException {
        String string = jRMeterInterval.getLabel();
        if (string == null) {
            string = "";
        }
        Range range = this.convertRange(jRMeterInterval.getDataRange(), by2);
        Color color = jRMeterInterval.getBackgroundColor();
        float[] fArray = color.getRGBColorComponents(null);
        Color color2 = new Color(fArray[0], fArray[1], fArray[2], (float)jRMeterInterval.getAlpha());
        return new MeterInterval(string, range, (Paint)color2, null, (Paint)color2);
    }

    public JFreeChartRenderer evaluateMeterImage(byte by2) throws JRException {
        JFreeChart jFreeChart;
        List list;
        JRValueDisplay jRValueDisplay;
        JRFillMeterPlot jRFillMeterPlot = (JRFillMeterPlot)this.getPlot();
        MeterPlot meterPlot = new MeterPlot((ValueDataset)this.dataset.getDataset());
        byte by3 = jRFillMeterPlot.getShape();
        if (by3 == 0) {
            meterPlot.setDialShape(DialShape.CHORD);
        } else if (by3 == 1) {
            meterPlot.setDialShape(DialShape.CIRCLE);
        } else {
            meterPlot.setDialShape(DialShape.PIE);
        }
        meterPlot.setRange(this.convertRange(jRFillMeterPlot.getDataRange(), by2));
        meterPlot.setMeterAngle(jRFillMeterPlot.getMeterAngle());
        String string = jRFillMeterPlot.getUnits();
        if (string != null && string.length() > 0) {
            meterPlot.setUnits(string);
        }
        meterPlot.setTickSize(jRFillMeterPlot.getTickInterval());
        Color color = jRFillMeterPlot.getMeterBackgroundColor();
        if (color != null) {
            meterPlot.setDialBackgroundPaint((Paint)color);
        }
        if ((color = jRFillMeterPlot.getNeedleColor()) != null) {
            meterPlot.setNeedlePaint((Paint)color);
        }
        if ((jRValueDisplay = jRFillMeterPlot.getValueDisplay()) != null) {
            if (jRValueDisplay.getColor() != null) {
                meterPlot.setValuePaint((Paint)jRValueDisplay.getColor());
            }
            if (jRValueDisplay.getMask() != null) {
                meterPlot.setTickLabelFormat((NumberFormat)new DecimalFormat(jRValueDisplay.getMask()));
            }
            if (jRValueDisplay.getFont() != null) {
                meterPlot.setValueFont(new Font(JRFontUtil.getAttributes(jRValueDisplay.getFont())));
            }
        }
        if ((color = jRFillMeterPlot.getTickColor()) != null) {
            meterPlot.setTickPaint((Paint)color);
        }
        if ((list = jRFillMeterPlot.getIntervals()) != null) {
            jFreeChart = list.iterator();
            while (jFreeChart.hasNext()) {
                JRMeterInterval jRMeterInterval = (JRMeterInterval)jFreeChart.next();
                meterPlot.addInterval(this.convertInterval(jRMeterInterval, by2));
            }
        }
        jFreeChart = new JFreeChart((String)this.evaluateExpression(this.getTitleExpression(), by2), null, (Plot)meterPlot, this.isShowLegend());
        this.configureChart(jFreeChart, this.getPlot(), by2);
        return new JFreeChartRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateThermometerImage(byte by2) throws JRException {
        JRValueDisplay jRValueDisplay;
        JRFillThermometerPlot jRFillThermometerPlot = (JRFillThermometerPlot)this.getPlot();
        ThermometerPlot thermometerPlot = new ThermometerPlot((ValueDataset)this.dataset.getDataset());
        Range range = this.convertRange(jRFillThermometerPlot.getDataRange(), by2);
        thermometerPlot.setLowerBound(range.getLowerBound());
        thermometerPlot.setUpperBound(range.getUpperBound());
        thermometerPlot.setShowValueLines(jRFillThermometerPlot.isShowValueLines());
        thermometerPlot.setUnits(0);
        Color color = jRFillThermometerPlot.getMercuryColor();
        if (color != null) {
            thermometerPlot.setMercuryPaint((Paint)color);
        }
        if ((jRValueDisplay = jRFillThermometerPlot.getValueDisplay()) != null) {
            if (jRValueDisplay.getColor() != null) {
                thermometerPlot.setValuePaint((Paint)jRValueDisplay.getColor());
            }
            if (jRValueDisplay.getMask() != null) {
                thermometerPlot.setValueFormat((NumberFormat)new DecimalFormat(jRValueDisplay.getMask()));
            }
            if (jRValueDisplay.getFont() != null) {
                thermometerPlot.setValueFont(new Font(JRFontUtil.getAttributes(jRValueDisplay.getFont())));
            }
        }
        switch (jRFillThermometerPlot.getValueLocation()) {
            case 0: {
                thermometerPlot.setValueLocation(0);
                break;
            }
            case 1: {
                thermometerPlot.setValueLocation(2);
                break;
            }
            case 2: {
                thermometerPlot.setValueLocation(1);
                break;
            }
            default: {
                thermometerPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jRFillThermometerPlot.getLowRange(), by2);
        if (range != null) {
            thermometerPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jRFillThermometerPlot.getMediumRange(), by2)) != null) {
            thermometerPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jRFillThermometerPlot.getHighRange(), by2)) != null) {
            thermometerPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        JFreeChart jFreeChart = new JFreeChart((Plot)thermometerPlot);
        this.configureChart(jFreeChart, this.getPlot(), by2);
        return new JFreeChartRenderer(jFreeChart);
    }

    public JFreeChartRenderer evaluateMultiAxisImage(byte by2) throws JRException {
        Object object;
        JFreeChart jFreeChart = null;
        Plot plot = null;
        JRFillMultiAxisPlot jRFillMultiAxisPlot = (JRFillMultiAxisPlot)this.getPlot();
        Iterator iterator = jRFillMultiAxisPlot.getAxes().iterator();
        if (iterator.hasNext()) {
            JRFillChartAxis jRFillChartAxis = (JRFillChartAxis)iterator.next();
            object = jRFillChartAxis.getFillChart();
            jFreeChart = ((JRFillChart)object).evaluateImage(by2).getChart();
            this.configureChart(jFreeChart, this.getPlot(), by2);
            plot = jFreeChart.getPlot();
            if (jRFillChartAxis.getPosition() == 2) {
                if (plot instanceof CategoryPlot) {
                    ((CategoryPlot)plot).setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_RIGHT);
                }
                if (plot instanceof XYPlot) {
                    ((XYPlot)plot).setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_RIGHT);
                }
            } else {
                if (plot instanceof CategoryPlot) {
                    ((CategoryPlot)plot).setRangeAxisLocation(0, AxisLocation.TOP_OR_LEFT);
                }
                if (plot instanceof XYPlot) {
                    ((XYPlot)plot).setRangeAxisLocation(0, AxisLocation.TOP_OR_LEFT);
                }
            }
        }
        int n2 = 0;
        while (iterator.hasNext()) {
            CategoryPlot categoryPlot;
            CategoryPlot categoryPlot2;
            ++n2;
            object = (JRFillChartAxis)iterator.next();
            JRFillChart jRFillChart = ((JRFillChartAxis)object).getFillChart();
            JFreeChart jFreeChart2 = jRFillChart.evaluateImage(by2).getChart();
            if (plot instanceof CategoryPlot) {
                categoryPlot2 = (CategoryPlot)plot;
                if (!(jFreeChart2.getPlot() instanceof CategoryPlot)) {
                    throw new JRException("You can not mix plot types in a MultiAxisChart");
                }
                categoryPlot = (CategoryPlot)jFreeChart2.getPlot();
                categoryPlot2.setRangeAxis(n2, categoryPlot.getRangeAxis());
                if (((JRFillChartAxis)object).getPosition() == 2) {
                    categoryPlot2.setRangeAxisLocation(n2, AxisLocation.BOTTOM_OR_RIGHT);
                } else {
                    categoryPlot2.setRangeAxisLocation(n2, AxisLocation.TOP_OR_LEFT);
                }
                categoryPlot2.setDataset(n2, categoryPlot.getDataset());
                categoryPlot2.mapDatasetToRangeAxis(n2, n2);
                categoryPlot2.setRenderer(n2, categoryPlot.getRenderer());
                this.configureAxisSeriesColors(categoryPlot.getRenderer(), jRFillChart.getPlot());
                continue;
            }
            if (plot instanceof XYPlot) {
                categoryPlot2 = (XYPlot)plot;
                if (!(jFreeChart2.getPlot() instanceof XYPlot)) {
                    throw new JRException("You can not mix plot types in a MultiAxisChart");
                }
                categoryPlot = (XYPlot)jFreeChart2.getPlot();
                categoryPlot2.setRangeAxis(n2, categoryPlot.getRangeAxis());
                if (((JRFillChartAxis)object).getPosition() == 2) {
                    categoryPlot2.setRangeAxisLocation(n2, AxisLocation.BOTTOM_OR_RIGHT);
                } else {
                    categoryPlot2.setRangeAxisLocation(n2, AxisLocation.TOP_OR_LEFT);
                }
                categoryPlot2.setDataset(n2, categoryPlot.getDataset());
                categoryPlot2.mapDatasetToRangeAxis(n2, n2);
                categoryPlot2.setRenderer(n2, categoryPlot.getRenderer());
                this.configureAxisSeriesColors(categoryPlot.getRenderer(), jRFillChart.getPlot());
                continue;
            }
            throw new JRException("MultiAxis charts only support Category and XY plots.");
        }
        return new JFreeChartRenderer(jFreeChart);
    }

    public void resolveElement(JRPrintElement jRPrintElement, byte by2) throws JRException {
        this.evaluateImage(by2);
        this.copy((JRPrintImage)jRPrintElement);
    }

    public int getBookmarkLevel() {
        return ((JRChart)this.parent).getBookmarkLevel();
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    private void evaluateDatasetRun(byte by2) throws JRException {
        this.dataset.evaluateDatasetRun(by2);
    }

    public JRFillCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return null;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRChart)this.parent).getHyperlinkParameters();
    }

    public String getLinkType() {
        return ((JRChart)this.parent).getLinkType();
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRChart)this.parent).getHyperlinkTooltipExpression();
    }

    public JFreeChartRenderer getCategoryRenderer(JFreeChart jFreeChart) {
        JRFillCategoryDataset jRFillCategoryDataset = (JRFillCategoryDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillCategoryDataset.hasItemHyperlinks() ? new JRCategoryChartImageMapRenderer(jFreeChart, jRFillCategoryDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    public JFreeChartRenderer getPieRenderer(JFreeChart jFreeChart) {
        JRFillPieDataset jRFillPieDataset = (JRFillPieDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillPieDataset.hasSectionHyperlinks() ? new JRPieChartImageMapRenderer(jFreeChart, jRFillPieDataset.getSectionHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    public JFreeChartRenderer getXYRenderer(JFreeChart jFreeChart) {
        JRFillXyDataset jRFillXyDataset = (JRFillXyDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillXyDataset.hasItemHyperlinks() ? new JRXYChartImageMapRenderer(jFreeChart, jRFillXyDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    public JFreeChartRenderer getXYBarRenderer(JFreeChart jFreeChart) {
        JFreeChartRenderer jFreeChartRenderer = this.getDataset().getDatasetType() == 6 ? this.getTimeSeriesRenderer(jFreeChart) : (this.getDataset().getDatasetType() == 5 ? this.getTimePeriodRenderer(jFreeChart) : (this.getDataset().getDatasetType() == 3 ? this.getXYRenderer(jFreeChart) : new JFreeChartRenderer(jFreeChart)));
        return jFreeChartRenderer;
    }

    public JFreeChartRenderer getXYZRenderer(JFreeChart jFreeChart) {
        JRFillXyzDataset jRFillXyzDataset = (JRFillXyzDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillXyzDataset.hasItemHyperlinks() ? new JRXYChartImageMapRenderer(jFreeChart, jRFillXyzDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    public JFreeChartRenderer getHighLowRenderer(JFreeChart jFreeChart) {
        JRFillHighLowDataset jRFillHighLowDataset = (JRFillHighLowDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillHighLowDataset.hasItemHyperlink() ? new JRHighLowChartImageMapRenderer(jFreeChart, jRFillHighLowDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    public JFreeChartRenderer getTimeSeriesRenderer(JFreeChart jFreeChart) {
        JRFillTimeSeriesDataset jRFillTimeSeriesDataset = (JRFillTimeSeriesDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillTimeSeriesDataset.hasItemHyperlinks() ? new JRTimeSeriesChartImageMapRenderer(jFreeChart, jRFillTimeSeriesDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    public JFreeChartRenderer getTimePeriodRenderer(JFreeChart jFreeChart) {
        JRFillTimePeriodDataset jRFillTimePeriodDataset = (JRFillTimePeriodDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillTimePeriodDataset.hasItemHyperlinks() ? new JRTimePeriodChartImageMapRenderer(jFreeChart, jRFillTimePeriodDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    private static RectangleEdge getEdge(byte by2) {
        RectangleEdge rectangleEdge = RectangleEdge.TOP;
        switch (by2) {
            case 1: {
                rectangleEdge = RectangleEdge.TOP;
                break;
            }
            case 2: {
                rectangleEdge = RectangleEdge.BOTTOM;
                break;
            }
            case 3: {
                rectangleEdge = RectangleEdge.LEFT;
                break;
            }
            case 4: {
                rectangleEdge = RectangleEdge.RIGHT;
            }
        }
        return rectangleEdge;
    }
}

