/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRClonePool;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.util.LineBoxWrapper;
import org.apache.commons.collections.ReferenceMap;

public class JRFillCellContents
extends JRFillElementContainer
implements JRCellContents,
JRFillCloneable,
JRStyleSetter {
    private final Map transformedContentsCache;
    private final Map boxContentsCache;
    private final JRClonePool clonePool;
    private JRFillCellContents original;
    private final JRCellContents parentCell;
    private JRLineBox lineBox;
    private int height;
    private int width;
    private int x;
    private int y;
    private int verticalSpan;
    private byte verticalPositionType = 1;
    private Map templateFrames;
    private JRDefaultStyleProvider defaultStyleProvider;
    private JRStyle initStyle;

    public JRFillCellContents(JRBaseFiller jRBaseFiller, JRCellContents jRCellContents, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRCellContents, jRFillObjectFactory);
        this.defaultStyleProvider = jRFillObjectFactory.getDefaultStyleProvider();
        this.parentCell = jRCellContents;
        this.lineBox = jRCellContents.getLineBox();
        this.width = jRCellContents.getWidth();
        this.height = jRCellContents.getHeight();
        jRFillObjectFactory.registerDelayedStyleSetter((JRStyleSetter)this, this.parentCell);
        this.initElements();
        this.initConditionalStyles();
        this.initTemplatesMap();
        this.transformedContentsCache = new ReferenceMap();
        this.boxContentsCache = new HashMap();
        this.clonePool = new JRClonePool(this, true, true);
    }

    private void initTemplatesMap() {
        this.templateFrames = new HashMap();
    }

    public JRFillCellContents(JRFillCellContents jRFillCellContents, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillCellContents, jRFillCloneFactory);
        this.defaultStyleProvider = jRFillCellContents.defaultStyleProvider;
        this.parentCell = jRFillCellContents.parentCell;
        this.lineBox = jRFillCellContents.lineBox;
        this.width = jRFillCellContents.width;
        this.height = jRFillCellContents.height;
        this.initStyle = jRFillCellContents.initStyle;
        this.initElements();
        this.initConditionalStyles();
        this.templateFrames = jRFillCellContents.templateFrames;
        this.transformedContentsCache = new ReferenceMap();
        this.boxContentsCache = new HashMap();
        this.clonePool = new JRClonePool(this, true, true);
        this.verticalPositionType = jRFillCellContents.verticalPositionType;
    }

    public Color getBackcolor() {
        return this.parentCell.getBackcolor();
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void setBox(JRLineBox jRLineBox) {
        this.lineBox = jRLineBox;
        this.initTemplatesMap();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public JRFillCellContents getBoxContents(boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5;
        if (this.lineBox == null) {
            return this;
        }
        boolean bl6 = bl2 && this.lineBox.getLeftPen().getLineWidth().floatValue() <= 0.0f && this.lineBox.getRightPen().getLineWidth().floatValue() > 0.0f;
        boolean bl7 = bl3 && this.lineBox.getRightPen().getLineWidth().floatValue() <= 0.0f && this.lineBox.getLeftPen().getLineWidth().floatValue() > 0.0f;
        boolean bl8 = bl5 = bl4 && this.lineBox.getTopPen().getLineWidth().floatValue() <= 0.0f && this.lineBox.getBottomPen().getLineWidth().floatValue() > 0.0f;
        if (!(bl6 || bl7 || bl5)) {
            return this;
        }
        BoxContents boxContents = new BoxContents(bl6, bl7, bl5);
        JRFillCellContents jRFillCellContents = (JRFillCellContents)this.boxContentsCache.get(boxContents);
        if (jRFillCellContents == null) {
            jRFillCellContents = (JRFillCellContents)this.createClone();
            JRLineBox jRLineBox = this.lineBox.clone(this.parentCell);
            if (bl6) {
                jRLineBox.copyLeftPen(this.lineBox.getRightPen());
            }
            if (bl7) {
                jRLineBox.copyRightPen(this.lineBox.getLeftPen());
            }
            if (bl5) {
                jRLineBox.copyTopPen(this.lineBox.getBottomPen());
            }
            jRFillCellContents.setBox(jRLineBox);
            this.boxContentsCache.put(boxContents, jRFillCellContents);
        }
        return jRFillCellContents;
    }

    public JRFillCellContents getTransformedContents(int n2, int n3, byte by2, byte by3) throws JRException {
        if (this.getHeight() == n3 && this.getWidth() == n2) {
            return this;
        }
        if (n3 < this.getHeight() || n2 < this.getWidth()) {
            throw new JRException("Cannot shrink cell contents.");
        }
        StretchedContents stretchedContents = new StretchedContents(n2, n3, by2, by3);
        JRFillCellContents jRFillCellContents = (JRFillCellContents)this.transformedContentsCache.get(stretchedContents);
        if (jRFillCellContents == null) {
            jRFillCellContents = (JRFillCellContents)this.createClone();
            jRFillCellContents.transform(n2, n3, by2, by3);
            jRFillCellContents.setElementsBandBottomY();
            this.transformedContentsCache.put(stretchedContents, jRFillCellContents);
        }
        return jRFillCellContents;
    }

    private void transform(int n2, int n3, byte by2, byte by3) {
        this.transformElements(n2, n3, by2, by3);
        this.width = n2;
        this.height = n3;
    }

    private void transformElements(int n2, int n3, byte by2, byte by3) {
        if (!(this.height != n3 && by3 != 1 || this.width != n2 && by2 != 1)) {
            return;
        }
        double d2 = -1.0;
        int n4 = 0;
        switch (by2) {
            case 2: {
                n4 = (n2 - this.width) / 2;
                break;
            }
            case 3: {
                n4 = n2 - this.width;
                break;
            }
            case 4: {
                d2 = (double)n2 / (double)this.width;
            }
        }
        double d3 = -1.0;
        int n5 = 0;
        switch (by3) {
            case 2: {
                n5 = (n3 - this.height) / 2;
                break;
            }
            case 3: {
                n5 = n3 - this.height;
                break;
            }
            case 4: {
                d3 = (double)n3 / (double)this.height;
            }
        }
        JRFillCellContents.transformElements(this.getElements(), d2, n4, d3, n5);
    }

    private static void transformElements(JRElement[] jRElementArray, double d2, int n2, double d3, int n3) {
        if (jRElementArray != null) {
            for (int i2 = 0; i2 < jRElementArray.length; ++i2) {
                JRFillElement jRFillElement = (JRFillElement)jRElementArray[i2];
                if (d2 != -1.0) {
                    jRFillElement.setX((int)((double)jRFillElement.getX() * d2));
                    jRFillElement.setWidth((int)((double)jRFillElement.getWidth() * d2));
                }
                if (n2 != 0) {
                    jRFillElement.setX(jRFillElement.getX() + n2);
                }
                if (d3 != -1.0) {
                    jRFillElement.setY((int)((double)jRFillElement.getY() * d3));
                    jRFillElement.setHeight((int)((double)jRFillElement.getHeight() * d3));
                }
                if (n3 != 0) {
                    jRFillElement.setY(jRFillElement.getY() + n3);
                }
                if (!(jRFillElement instanceof JRFrame)) continue;
                JRElement[] jRElementArray2 = ((JRFrame)((Object)jRFillElement)).getElements();
                JRFillCellContents.transformElements(jRElementArray2, d2, n2, d3, n3);
            }
        }
    }

    public void prepare(int n2) throws JRException {
        this.initFill();
        this.resetElements();
        this.prepareElements(n2, true);
    }

    public JRPrintFrame fill() throws JRException {
        this.stretchElements();
        this.moveBandBottomElements();
        this.removeBlankElements();
        JRTemplatePrintFrame jRTemplatePrintFrame = new JRTemplatePrintFrame(this.getTemplateFrame());
        jRTemplatePrintFrame.setX(this.x);
        jRTemplatePrintFrame.setY(this.y);
        jRTemplatePrintFrame.setWidth(this.width);
        this.fillElements(jRTemplatePrintFrame);
        this.verticallyPositionElements(jRTemplatePrintFrame);
        jRTemplatePrintFrame.setHeight(this.getPrintHeight());
        return jRTemplatePrintFrame;
    }

    private JRTemplateFrame getTemplateFrame() {
        JRStyle jRStyle = this.getStyle();
        JRTemplateFrame jRTemplateFrame = (JRTemplateFrame)this.templateFrames.get(jRStyle);
        if (jRTemplateFrame == null) {
            jRTemplateFrame = new JRTemplateFrame(null, this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.templateFrames.put(jRStyle, jRTemplateFrame);
        }
        return jRTemplateFrame;
    }

    public void verticallyPositionElements(JRTemplatePrintFrame jRTemplatePrintFrame) {
        int n2;
        switch (this.verticalPositionType) {
            case 2: {
                n2 = (this.getStretchHeight() - this.getContainerHeight()) / 2;
                break;
            }
            case 3: {
                n2 = this.getStretchHeight() - this.getContainerHeight();
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if (n2 != 0) {
            JRPrintElement jRPrintElement;
            List list = jRTemplatePrintFrame.getElements();
            int n3 = this.getStretchHeight() - n2;
            boolean bl2 = false;
            Iterator iterator = list.iterator();
            while (!bl2 && iterator.hasNext()) {
                jRPrintElement = (JRPrintElement)iterator.next();
                bl2 = jRPrintElement.getY() > n3;
            }
            if (!bl2) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    jRPrintElement = (JRPrintElement)iterator.next();
                    jRPrintElement.setY(jRPrintElement.getY() + n2);
                }
            }
        }
    }

    public int getPrintHeight() {
        return this.getStretchHeight() + this.getTopPadding() + this.getBottomPadding();
    }

    public void stretchTo(int n2) {
        this.setStretchHeight(n2 - this.getTopPadding() - this.getBottomPadding());
    }

    public int getContainerHeight() {
        return this.getHeight() - this.getTopPadding() - this.getBottomPadding();
    }

    public int getTopPadding() {
        return this.lineBox == null ? 0 : this.lineBox.getTopPadding();
    }

    public int getBottomPadding() {
        return this.lineBox == null ? 0 : this.lineBox.getBottomPadding();
    }

    public JRFillCloneable createClone() {
        JRFillCloneFactory jRFillCloneFactory = new JRFillCloneFactory();
        return this.createClone(jRFillCloneFactory);
    }

    public JRFillCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return new JRFillCellContents(this, jRFillCloneFactory);
    }

    public JRFillCellContents getWorkingClone() {
        JRFillCellContents jRFillCellContents = (JRFillCellContents)this.clonePool.getClone();
        jRFillCellContents.original = this;
        return jRFillCellContents;
    }

    public void releaseWorkingClone() {
        this.original.clonePool.releaseClone(this);
    }

    public void setX(int n2) {
        this.x = n2;
    }

    public void setY(int n2) {
        this.y = n2;
    }

    public int getVerticalSpan() {
        return this.verticalSpan;
    }

    public void setVerticalSpan(int n2) {
        this.verticalSpan = n2;
    }

    public void setVerticalPositionType(byte by2) {
        this.verticalPositionType = by2;
    }

    public void evaluate(byte by2) throws JRException {
        this.evaluateConditionalStyles(by2);
        super.evaluate(by2);
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    public JRStyle getStyle() {
        JRStyle jRStyle = this.initStyle;
        boolean bl2 = false;
        if (jRStyle == null) {
            jRStyle = this.filler.getDefaultStyle();
            bl2 = true;
        }
        JRStyle jRStyle2 = this.getEvaluatedConditionalStyle(jRStyle);
        if (bl2 && jRStyle2 == jRStyle) {
            jRStyle2 = null;
        }
        return jRStyle2;
    }

    public void initConditionalStyles() {
        super.initConditionalStyles();
        this.collectConditionalStyle(this.initStyle);
    }

    public Byte getMode() {
        return this.parentCell.getMode();
    }

    public String getStyleNameReference() {
        return null;
    }

    public void setStyle(JRStyle jRStyle) {
        this.initStyle = jRStyle;
        this.collectConditionalStyle(jRStyle);
    }

    public void setStyleNameReference(String string) {
        throw new UnsupportedOperationException("Style name references not allowed at fill time");
    }

    public Color getDefaultLineColor() {
        return this.parentCell.getDefaultLineColor();
    }

    protected static class StretchedContents {
        public final int d;
        public final int c;
        public final int a;
        public final byte e;
        public final byte b;

        public StretchedContents(int n2, int n3, byte by2, byte by3) {
            this.d = n3;
            this.c = n2;
            this.e = by2;
            this.b = by3;
            int n4 = n3;
            n4 = 31 * n4 + n2;
            n4 = 31 * n4 + by2;
            this.a = n4 = 31 * n4 + by3;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            StretchedContents stretchedContents = (StretchedContents)object;
            return stretchedContents.d == this.d && stretchedContents.c == this.c && stretchedContents.e == this.e && stretchedContents.b == this.b;
        }

        public int hashCode() {
            return this.a;
        }
    }

    protected static class BoxContents {
        public final boolean d;
        public final boolean b;
        public final boolean c;
        public final int a;

        public BoxContents(boolean bl2, boolean bl3, boolean bl4) {
            this.d = bl2;
            this.b = bl3;
            this.c = bl4;
            int n2 = bl2 ? 1231 : 1237;
            n2 = 31 * n2 + (bl3 ? 1231 : 1237);
            this.a = n2 = 31 * n2 + (bl4 ? 1231 : 1237);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            BoxContents boxContents = (BoxContents)object;
            return boxContents.d == this.d && boxContents.b == this.b && boxContents.c == this.c;
        }

        public int hashCode() {
            return this.a;
        }
    }
}

