/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRAbstractLRUVirtualizer
implements JRVirtualizer {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRAbstractLRUVirtualizer.a("net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer")) : a);
    public static final int CLASSLOADER_IDX_NOT_SET = -1;
    public final Map classLoadersIndexes = new HashMap();
    public final List classLoadersList = new ArrayList();
    private final Cache pagedIn;
    private final ReferenceMap pagedOut;
    public JRVirtualizable lastObject;
    public ReferenceMap lastObjectMap;
    public ReferenceMap lastObjectSet;
    private boolean readOnly;
    public static Class a;

    public static boolean isAncestorClassLoader(ClassLoader classLoader) {
        for (ClassLoader classLoader2 = (a == null ? (a = JRAbstractLRUVirtualizer.a("net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer")) : a).getClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            if (!classLoader2.equals(classLoader)) continue;
            return true;
        }
        return false;
    }

    public JRAbstractLRUVirtualizer(int n2) {
        this.pagedIn = new Cache(this, n2);
        this.pagedOut = new ReferenceMap(0, 2);
        this.lastObject = null;
        this.lastObjectMap = new ReferenceMap(2, 2);
        this.lastObjectSet = new ReferenceMap(2, 0);
    }

    public final synchronized boolean isPagedOut(String string) {
        return this.pagedOut.containsKey(string);
    }

    public synchronized boolean isPagedOutAndTouch(JRVirtualizable jRVirtualizable, String string) {
        boolean bl2 = this.isPagedOut(string);
        if (!bl2) {
            this.touch(jRVirtualizable);
        }
        return bl2;
    }

    public final void setLastObject(JRVirtualizable jRVirtualizable) {
        if (this.lastObject != jRVirtualizable) {
            JRVirtualizationContext jRVirtualizationContext;
            Object object;
            if (jRVirtualizable != null && (object = this.lastObjectMap.get(jRVirtualizationContext = jRVirtualizable.getContext())) != jRVirtualizable) {
                if (object != null) {
                    this.lastObjectSet.remove(object);
                }
                this.lastObjectMap.put(jRVirtualizationContext, jRVirtualizable);
                this.lastObjectSet.put(jRVirtualizable, Boolean.TRUE);
            }
            this.lastObject = jRVirtualizable;
        }
    }

    public void setReadOnly(boolean bl2) {
        this.readOnly = bl2;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isReadOnly(JRVirtualizable jRVirtualizable) {
        return this.readOnly || jRVirtualizable.getContext().isReadOnly();
    }

    public synchronized void registerObject(JRVirtualizable jRVirtualizable) {
        this.setLastObject(jRVirtualizable);
        JRVirtualizable jRVirtualizable2 = this.pagedIn.put(jRVirtualizable.getUID(), jRVirtualizable);
        if (jRVirtualizable2 != null) {
            this.pagedIn.put(jRVirtualizable.getUID(), jRVirtualizable2);
            throw new IllegalStateException("Wrong object stored with UID \"" + jRVirtualizable.getUID() + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterObject(JRVirtualizable jRVirtualizable) {
        String string = jRVirtualizable.getUID();
        try {
            this.dispose(jRVirtualizable.getUID());
        }
        catch (Exception exception) {
            log.error("Error removing virtual data", exception);
        }
        JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
        synchronized (jRAbstractLRUVirtualizer) {
            JRVirtualizable jRVirtualizable2 = this.pagedIn.remove(string);
            if (jRVirtualizable2 != null) {
                if (jRVirtualizable2 != jRVirtualizable) {
                    this.pagedIn.put(string, jRVirtualizable2);
                    throw new IllegalStateException("Wrong object stored with UID \"" + jRVirtualizable.getUID() + "\"");
                }
            } else {
                Object object = this.pagedOut.remove(string);
                if (object != null && object != jRVirtualizable) {
                    this.pagedOut.put(string, object);
                    throw new IllegalStateException("Wrong object stored with UID \"" + jRVirtualizable.getUID() + "\"");
                }
            }
        }
    }

    public synchronized void touch(JRVirtualizable jRVirtualizable) {
        if (this.lastObject != jRVirtualizable) {
            this.setLastObject(this.pagedIn.get(jRVirtualizable.getUID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestData(JRVirtualizable jRVirtualizable) {
        String string = jRVirtualizable.getUID();
        if (this.isPagedOutAndTouch(jRVirtualizable, string)) {
            try {
                this.pageIn(jRVirtualizable);
            }
            catch (IOException iOException) {
                log.error("Error devirtualizing object", iOException);
                throw new JRRuntimeException(iOException);
            }
            jRVirtualizable.afterInternalization();
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.setLastObject(jRVirtualizable);
                this.pagedOut.remove(string);
                this.pagedIn.put(string, jRVirtualizable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData(JRVirtualizable jRVirtualizable) {
        String string = jRVirtualizable.getUID();
        if (this.isPagedOutAndTouch(jRVirtualizable, string)) {
            this.dispose(string);
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void virtualizeData(JRVirtualizable jRVirtualizable) {
        String string = jRVirtualizable.getUID();
        if (!this.isPagedOut(string)) {
            jRVirtualizable.beforeExternalization();
            try {
                this.pageOut(jRVirtualizable);
            }
            catch (IOException iOException) {
                log.error("Error virtualizing object", iOException);
                throw new JRRuntimeException(iOException);
            }
            jRVirtualizable.afterExternalization();
            jRVirtualizable.removeVirtualData();
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.put(string, jRVirtualizable);
            }
        }
    }

    public void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    public final void writeData(JRVirtualizable jRVirtualizable, OutputStream outputStream) throws JRRuntimeException {
        try {
            ClassLoaderAnnotationObjectOutputStream classLoaderAnnotationObjectOutputStream = new ClassLoaderAnnotationObjectOutputStream(this, outputStream);
            classLoaderAnnotationObjectOutputStream.writeObject(jRVirtualizable.getIdentityData());
            classLoaderAnnotationObjectOutputStream.writeObject(jRVirtualizable.getVirtualData());
            classLoaderAnnotationObjectOutputStream.flush();
        }
        catch (IOException iOException) {
            log.error("Error virtualizing object", iOException);
            throw new JRRuntimeException(iOException);
        }
    }

    public final void readData(JRVirtualizable jRVirtualizable, InputStream inputStream) throws JRRuntimeException {
        try {
            ClassLoaderAnnotationObjectInputStream classLoaderAnnotationObjectInputStream = new ClassLoaderAnnotationObjectInputStream(this, inputStream);
            jRVirtualizable.setIdentityData(classLoaderAnnotationObjectInputStream.readObject());
            jRVirtualizable.setVirtualData(classLoaderAnnotationObjectInputStream.readObject());
        }
        catch (IOException iOException) {
            log.error("Error devirtualizing object", iOException);
            throw new JRRuntimeException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error("Error devirtualizing object", classNotFoundException);
            throw new JRRuntimeException(classNotFoundException);
        }
    }

    public synchronized void reset() {
        this.readOnly = false;
    }

    public final void disposeAll() {
        String string;
        Iterator iterator = this.pagedOut.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            try {
                this.dispose(string);
                iterator.remove();
            }
            catch (Exception exception) {
                log.error("Error cleaning up virtualizer.", exception);
            }
        }
        iterator = this.pagedIn.idIterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            try {
                this.dispose(string);
                iterator.remove();
            }
            catch (Exception exception) {
                log.error("Error cleaning up virtualizer.", exception);
            }
        }
    }

    public abstract void pageOut(JRVirtualizable var1) throws IOException;

    public abstract void pageIn(JRVirtualizable var1) throws IOException;

    public abstract void dispose(String var1);

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class ClassLoaderAnnotationObjectInputStream
    extends ObjectInputStream {
        private final JRAbstractLRUVirtualizer this$0;

        public ClassLoaderAnnotationObjectInputStream(JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer, InputStream inputStream) throws IOException {
            super(inputStream);
            this.this$0 = jRAbstractLRUVirtualizer;
        }

        public Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            Class<?> clazz;
            try {
                clazz = super.resolveClass(objectStreamClass);
                this.readShort();
            }
            catch (ClassNotFoundException classNotFoundException) {
                short s2 = this.readShort();
                if (s2 == -1) {
                    throw classNotFoundException;
                }
                ClassLoader classLoader = (ClassLoader)this.this$0.classLoadersList.get(s2);
                clazz = Class.forName(objectStreamClass.getName(), false, classLoader);
            }
            return clazz;
        }
    }

    protected class ClassLoaderAnnotationObjectOutputStream
    extends ObjectOutputStream {
        private final JRAbstractLRUVirtualizer this$0;

        public ClassLoaderAnnotationObjectOutputStream(JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer, OutputStream outputStream) throws IOException {
            super(outputStream);
            this.this$0 = jRAbstractLRUVirtualizer;
        }

        public void annotateClass(Class clazz) throws IOException {
            int n2;
            super.annotateClass(clazz);
            ClassLoader classLoader = clazz.getClassLoader();
            if (clazz.isPrimitive() || classLoader == null || JRAbstractLRUVirtualizer.isAncestorClassLoader(classLoader)) {
                n2 = -1;
            } else {
                Integer n3 = (Integer)this.this$0.classLoadersIndexes.get(classLoader);
                if (n3 == null) {
                    n3 = new Integer(this.this$0.classLoadersList.size());
                    this.this$0.classLoadersIndexes.put(classLoader, n3);
                    this.this$0.classLoadersList.add(classLoader);
                }
                n2 = n3;
            }
            this.writeShort(n2);
        }
    }

    protected class Cache {
        private final ReferenceQueue refQueue;
        private final LRUScanMap map;
        private final JRAbstractLRUVirtualizer this$0;

        public Cache(JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer, int n2) {
            this.this$0 = jRAbstractLRUVirtualizer;
            this.map = new LRUScanMap(this, n2);
            this.refQueue = new ReferenceQueue();
        }

        public JRVirtualizable getMapValue(Object object) {
            Reference reference;
            JRVirtualizable jRVirtualizable = object == null ? null : ((reference = (Reference)object).isEnqueued() ? null : (JRVirtualizable)reference.get());
            return jRVirtualizable;
        }

        public Object toMapValue(JRVirtualizable jRVirtualizable) {
            return jRVirtualizable == null ? null : new CacheReference(jRVirtualizable, this.refQueue);
        }

        public void purge() {
            CacheReference cacheReference;
            while ((cacheReference = (CacheReference)this.refQueue.poll()) != null) {
                this.map.remove(cacheReference.getId());
            }
        }

        public JRVirtualizable get(String string) {
            this.purge();
            return this.getMapValue(this.map.get(string));
        }

        public JRVirtualizable put(String string, JRVirtualizable jRVirtualizable) {
            this.purge();
            return this.getMapValue(this.map.put(string, this.toMapValue(jRVirtualizable)));
        }

        public JRVirtualizable remove(String string) {
            this.purge();
            return this.getMapValue(this.map.remove(string));
        }

        public Iterator idIterator() {
            this.purge();
            Iterator iterator = this.map.values().iterator();
            return new Iterator(this, iterator){
                private final Iterator val$valsIt;
                private final Cache this$1;
                {
                    this.this$1 = cache;
                    this.val$valsIt = iterator;
                }

                public boolean hasNext() {
                    return this.val$valsIt.hasNext();
                }

                public Object next() {
                    CacheReference cacheReference = (CacheReference)this.val$valsIt.next();
                    return cacheReference.getId();
                }

                public void remove() {
                    this.val$valsIt.remove();
                }
            };
        }

        public static JRAbstractLRUVirtualizer a(Cache cache) {
            return cache.this$0;
        }

        protected class LRUScanMap
        extends LRUMap {
            private static final long serialVersionUID = 10200L;
            private final Cache this$1;

            public LRUScanMap(Cache cache, int n2) {
                super(n2);
                this.this$1 = cache;
            }

            public void removeLRU() {
                Iterator<Object> iterator;
                Map.Entry entry = this.getFirst();
                boolean bl2 = this.isRemovable(entry);
                if (!bl2) {
                    iterator = this.entrySet().iterator();
                    iterator.next();
                    while (!bl2 && iterator.hasNext()) {
                        entry = (Map.Entry)iterator.next();
                        bl2 = this.isRemovable(entry);
                    }
                }
                if (!bl2) {
                    throw new JRRuntimeException("The virtualizer is used by more contexts than its in-memory cache size " + this.getMaximumSize());
                }
                iterator = entry.getKey();
                Object v2 = entry.getValue();
                this.remove(iterator);
                this.processRemovedLRU(iterator, v2);
            }

            public boolean isRemovable(Map.Entry entry) {
                JRVirtualizable jRVirtualizable = this.this$1.getMapValue(entry.getValue());
                return jRVirtualizable == null || !Cache.a((Cache)this.this$1).lastObjectSet.containsKey(jRVirtualizable);
            }

            public void processRemovedLRU(Object object, Object object2) {
                JRVirtualizable jRVirtualizable = this.this$1.getMapValue(object2);
                if (jRVirtualizable != null) {
                    Cache.a(this.this$1).virtualizeData(jRVirtualizable);
                }
            }
        }
    }

    protected static class CacheReference
    extends WeakReference {
        private final String id;

        public CacheReference(JRVirtualizable jRVirtualizable, ReferenceQueue referenceQueue) {
            super(jRVirtualizable, referenceQueue);
            this.id = jRVirtualizable.getUID();
        }

        public String getId() {
            return this.id;
        }
    }
}

