/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.export.oasis.Utility;

public class TableBuilder {
    private String tableName = null;
    private int reportIndex = 0;
    private Writer bodyWriter = null;
    private Writer styleWriter = null;
    private boolean isFrame = false;
    private boolean isPageBreak = false;

    public TableBuilder(String string, Writer writer, Writer writer2) {
        this.isFrame = true;
        this.isPageBreak = false;
        this.bodyWriter = writer;
        this.styleWriter = writer2;
        this.tableName = "TBL_" + string;
    }

    public TableBuilder(int n2, int n3, Writer writer, Writer writer2) {
        this.isFrame = false;
        this.isPageBreak = n2 != 0 || n3 != 0;
        this.reportIndex = n2;
        this.bodyWriter = writer;
        this.styleWriter = writer2;
        this.tableName = "TBL_" + n2 + "_" + n3;
    }

    public void buildTableStyle() throws IOException {
        this.styleWriter.write(" <style:style style:name=\"" + this.tableName + "\"");
        if (!this.isFrame) {
            this.styleWriter.write(" style:master-page-name=\"master_" + this.reportIndex + "\"");
        }
        this.styleWriter.write(" style:family=\"table\">\n");
        this.styleWriter.write("   <style:table-properties");
        if (this.isPageBreak) {
            this.styleWriter.write(" fo:break-before=\"page\"");
        }
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" </style:style>\n");
    }

    public void buildTableHeader() throws IOException {
        this.bodyWriter.write("<table:table");
        if (this.isFrame) {
            this.bodyWriter.write(" is-subtable=\"true\"");
        }
        this.bodyWriter.write(" table:name=\"");
        this.bodyWriter.write(this.tableName);
        this.bodyWriter.write("\"");
        this.bodyWriter.write(" table:style-name=\"");
        this.bodyWriter.write(this.tableName);
        this.bodyWriter.write("\"");
        this.bodyWriter.write(">\n");
    }

    public void buildTableFooter() throws IOException {
        this.bodyWriter.write("</table:table>\n");
    }

    public void buildRowStyle(int n2, int n3) throws IOException {
        String string = this.tableName + "_row_" + n2;
        this.styleWriter.write(" <style:style style:name=\"" + string + "\"");
        this.styleWriter.write(" style:family=\"table-row\">\n");
        this.styleWriter.write("   <style:table-row-properties");
        this.styleWriter.write(" style:use-optimal-row-height=\"false\"");
        this.styleWriter.write(" style:row-height=\"" + Utility.translatePixelsToInches(n3) + "in\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" </style:style>\n");
    }

    public void buildRowHeader(int n2) throws IOException {
        String string = this.tableName + "_row_" + n2;
        this.bodyWriter.write("<table:table-row");
        this.bodyWriter.write(" table:style-name=\"" + string + "\"");
        this.bodyWriter.write(">\n");
    }

    public void buildRowFooter() throws IOException {
        this.bodyWriter.write("</table:table-row>\n");
    }

    public void buildColumnStyle(int n2, int n3) throws IOException {
        String string = this.tableName + "_col_" + n2;
        this.styleWriter.write(" <style:style style:name=\"" + string + "\"");
        this.styleWriter.write(" style:family=\"table-column\">\n");
        this.styleWriter.write("   <style:table-column-properties");
        this.styleWriter.write(" style:column-width=\"" + Utility.translatePixelsToInches(n3) + "in\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write(" </style:style>\n");
    }

    public void buildColumnHeader(int n2) throws IOException {
        String string = this.tableName + "_col_" + n2;
        this.bodyWriter.write("<table:table-column");
        this.bodyWriter.write(" table:style-name=\"" + string + "\"");
        this.bodyWriter.write(">\n");
    }

    public void buildColumnFooter() throws IOException {
        this.bodyWriter.write("</table:table-column>\n");
    }

    public void buildCellHeader(String string, int n2, int n3) throws IOException {
        this.bodyWriter.write("<table:table-cell");
        if (string != null) {
            this.bodyWriter.write(" table:style-name=\"" + string + "\"");
        }
        if (n2 > 1) {
            this.bodyWriter.write(" table:number-columns-spanned=\"" + n2 + "\"");
        }
        if (n3 > 1) {
            this.bodyWriter.write(" table:number-rows-spanned=\"" + n3 + "\"");
        }
        this.bodyWriter.write(">\n");
    }

    public void buildCellFooter() throws IOException {
        this.bodyWriter.write("</table:table-cell>\n");
    }
}

