/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.oasis.Style;

public class ParagraphStyle
extends Style {
    public static final String HORIZONTAL_ALIGN_LEFT = "start";
    public static final String HORIZONTAL_ALIGN_RIGHT = "end";
    public static final String HORIZONTAL_ALIGN_CENTER = "center";
    public static final String HORIZONTAL_ALIGN_JUSTIFY = "justified";
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_MIDDLE = "middle";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    private String verticalAlignment = "top";
    private String horizontalAlignment = null;
    private String runDirection = null;
    private String textRotation = "0";

    public ParagraphStyle(Writer writer, JRPrintText jRPrintText) {
        super(writer);
        switch (jRPrintText.getVerticalAlignment()) {
            case 3: {
                this.verticalAlignment = VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                this.verticalAlignment = VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                this.verticalAlignment = VERTICAL_ALIGN_TOP;
            }
        }
        this.horizontalAlignment = HORIZONTAL_ALIGN_LEFT;
        switch (jRPrintText.getHorizontalAlignment()) {
            case 3: {
                this.horizontalAlignment = HORIZONTAL_ALIGN_RIGHT;
                break;
            }
            case 2: {
                this.horizontalAlignment = HORIZONTAL_ALIGN_CENTER;
                break;
            }
            case 4: {
                this.horizontalAlignment = HORIZONTAL_ALIGN_JUSTIFY;
                break;
            }
            default: {
                this.horizontalAlignment = HORIZONTAL_ALIGN_LEFT;
            }
        }
        this.runDirection = null;
        if (jRPrintText.getRunDirection() == 1) {
            this.runDirection = "rl";
        }
        switch (jRPrintText.getRotation()) {
            case 1: {
                this.textRotation = "90";
                break;
            }
            case 2: {
                this.textRotation = "270";
            }
        }
    }

    public String getId() {
        return this.verticalAlignment + "|" + this.horizontalAlignment + "|" + this.runDirection + "|" + this.textRotation;
    }

    public void write(String string) throws IOException {
        this.styleWriter.write("<style:style style:name=\"" + string + "\"");
        this.styleWriter.write(" style:family=\"paragraph\">\n");
        this.styleWriter.write("<style:paragraph-properties");
        this.styleWriter.write(" fo:text-align=\"" + this.horizontalAlignment + "\"");
        this.styleWriter.write(" style:vertical-align=\"" + this.verticalAlignment + "\"");
        if (this.runDirection != null) {
            this.styleWriter.write(" style:writing-mode=\"" + this.runDirection + "\"");
        }
        this.styleWriter.write("> \r\n");
        this.styleWriter.write("</style:paragraph-properties>\n");
        this.styleWriter.write("<style:text-properties");
        this.styleWriter.write(" style:text-rotation-angle=\"" + this.textRotation + "\"");
        this.styleWriter.write("> \r\n");
        this.styleWriter.write("</style:text-properties>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

