/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;

public class RectangleDrawer
extends ElementDrawer {
    public void draw(Graphics2D graphics2D, JRPrintElement jRPrintElement, int n2, int n3) {
        JRPrintRectangle jRPrintRectangle = (JRPrintRectangle)jRPrintElement;
        if (jRPrintRectangle.getMode() == 1) {
            graphics2D.setColor(jRPrintRectangle.getBackcolor());
            if (jRPrintRectangle.getRadius() > 0) {
                graphics2D.fillRoundRect(jRPrintRectangle.getX() + n2, jRPrintRectangle.getY() + n3, jRPrintRectangle.getWidth(), jRPrintRectangle.getHeight(), 2 * jRPrintRectangle.getRadius(), 2 * jRPrintRectangle.getRadius());
            } else {
                graphics2D.fillRect(jRPrintRectangle.getX() + n2, jRPrintRectangle.getY() + n3, jRPrintRectangle.getWidth(), jRPrintRectangle.getHeight());
            }
        }
        graphics2D.setColor(jRPrintRectangle.getLinePen().getLineColor());
        Stroke stroke = RectangleDrawer.getStroke(jRPrintRectangle.getLinePen());
        if (stroke != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(jRPrintRectangle.getX() + n2, jRPrintRectangle.getY() + n3);
            graphics2D.setStroke(stroke);
            if (jRPrintRectangle.getRadius() > 0) {
                graphics2D.drawRoundRect(0, 0, jRPrintRectangle.getWidth(), jRPrintRectangle.getHeight(), 2 * jRPrintRectangle.getRadius(), 2 * jRPrintRectangle.getRadius());
            } else {
                graphics2D.drawRect(0, 0, jRPrintRectangle.getWidth(), jRPrintRectangle.getHeight());
            }
            graphics2D.setTransform(affineTransform);
        }
    }
}

