/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.export.draw.EllipseDrawer;
import net.sf.jasperreports.engine.export.draw.FrameDrawer;
import net.sf.jasperreports.engine.export.draw.ImageDrawer;
import net.sf.jasperreports.engine.export.draw.LineDrawer;
import net.sf.jasperreports.engine.export.draw.RectangleDrawer;
import net.sf.jasperreports.engine.export.draw.TextDrawer;

public class DrawVisitor
implements JRVisitor {
    private TextRenderer textRenderer = new TextRenderer(false);
    private ConvertVisitor convertVisitor = null;
    private Graphics2D grx = null;
    private LineDrawer lineDrawer = new LineDrawer();
    private RectangleDrawer rectangleDrawer = new RectangleDrawer();
    private EllipseDrawer ellipseDrawer = new EllipseDrawer();
    private ImageDrawer imageDrawer = new ImageDrawer();
    private TextDrawer textDrawer = new TextDrawer(this.textRenderer);
    private FrameDrawer frameDrawer = new FrameDrawer(null, this.textRenderer);

    public DrawVisitor(JRReport jRReport, Graphics2D graphics2D) {
        this(new ReportConverter(jRReport, true), graphics2D);
    }

    public DrawVisitor(ReportConverter reportConverter, Graphics2D graphics2D) {
        this.convertVisitor = new ConvertVisitor(reportConverter);
        this.setGraphics2D(graphics2D);
        this.frameDrawer.setClip(true);
    }

    public void setGraphics2D(Graphics2D graphics2D) {
        this.grx = graphics2D;
    }

    public void visitBreak(JRBreak jRBreak) {
    }

    public void visitChart(JRChart jRChart) {
        try {
            this.imageDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(jRChart), -jRChart.getX(), -jRChart.getY());
        }
        catch (JRException jRException) {
            throw new JRRuntimeException(jRException);
        }
    }

    public void visitCrosstab(JRCrosstab jRCrosstab) {
        try {
            this.frameDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(jRCrosstab), -jRCrosstab.getX(), -jRCrosstab.getY());
        }
        catch (JRException jRException) {
            throw new JRRuntimeException(jRException);
        }
    }

    public void visitElementGroup(JRElementGroup jRElementGroup) {
    }

    public void visitEllipse(JREllipse jREllipse) {
        this.ellipseDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(jREllipse), -jREllipse.getX(), -jREllipse.getY());
    }

    public void visitFrame(JRFrame jRFrame) {
        try {
            this.frameDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(jRFrame), -jRFrame.getX(), -jRFrame.getY());
        }
        catch (JRException jRException) {
            throw new JRRuntimeException(jRException);
        }
    }

    public void visitImage(JRImage jRImage) {
        try {
            this.imageDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(jRImage), -jRImage.getX(), -jRImage.getY());
        }
        catch (JRException jRException) {
            throw new JRRuntimeException(jRException);
        }
    }

    public void visitLine(JRLine jRLine) {
        this.lineDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(jRLine), -jRLine.getX(), -jRLine.getY());
    }

    public void visitRectangle(JRRectangle jRRectangle) {
        this.rectangleDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(jRRectangle), -jRRectangle.getX(), -jRRectangle.getY());
    }

    public void visitStaticText(JRStaticText jRStaticText) {
        this.textDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(jRStaticText), -jRStaticText.getX(), -jRStaticText.getY());
    }

    public void visitSubreport(JRSubreport jRSubreport) {
        try {
            this.imageDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(jRSubreport), -jRSubreport.getX(), -jRSubreport.getY());
        }
        catch (JRException jRException) {
            throw new JRRuntimeException(jRException);
        }
    }

    public void visitTextField(JRTextField jRTextField) {
        this.textDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(jRTextField), -jRTextField.getX(), -jRTextField.getY());
    }
}

