/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.tools.codec.Base64Encoder;

public class JRXmlExporter
extends JRAbstractExporter {
    private static final String XML_ORIGIN_EXPORTER_FILTER_PREFIX = "net.sf.jasperreports.export.xml.exclude.origin.";
    public static final String DEFAULT_XML_ENCODING = "UTF-8";
    public static final String DEFAULT_OBJECT_TYPE = "java.lang.String";
    public static final String HTML_FILES_SUFFIX = "_files";
    public static final String IMAGE_PREFIX = "img_";
    public JRXmlWriteHelper xmlWriter = null;
    public String encoding = null;
    public JRExportProgressMonitor progressMonitor = null;
    public Map rendererToImagePathMap = null;
    public Map imageNameToImageDataMap = null;
    public Map fontsMap = new HashMap();
    public Map stylesMap = new HashMap();
    public String dtdLocation = null;
    public boolean isEmbeddingImages = true;
    public File destFile = null;
    public File imagesDir = null;
    private static int imageId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block17: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                Object object;
                StringBuffer stringBuffer;
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = JROriginExporterFilter.getFilter(this.jasperPrint.getPropertiesMap(), XML_ORIGIN_EXPORTER_FILTER_PREFIX);
                }
                this.setPageRange();
                this.dtdLocation = (String)this.parameters.get(JRXmlExporterParameter.DTD_LOCATION);
                if (this.dtdLocation == null) {
                    this.dtdLocation = "http://jasperreports.sourceforge.net/dtds/jasperprint.dtd";
                }
                this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
                if (this.encoding == null) {
                    this.encoding = DEFAULT_XML_ENCODING;
                }
                if ((stringBuffer = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
                    StringBuffer stringBuffer2 = this.exportReportToBuffer();
                    stringBuffer.append(stringBuffer2.toString());
                    break block17;
                }
                Writer writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (writer != null) {
                    try {
                        this.exportReportToStream(writer);
                        break block17;
                    }
                    catch (IOException iOException) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), iOException);
                    }
                }
                OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (outputStream != null) {
                    try {
                        this.exportReportToStream(new OutputStreamWriter(outputStream, this.encoding));
                        break block17;
                    }
                    catch (Exception exception) {
                        throw new JRException("Error writing to OutputStream : " + this.jasperPrint.getName(), exception);
                    }
                }
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    object = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (object != null) {
                        this.destFile = new File((String)object);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                this.imagesDir = new File(this.destFile.getParent(), this.destFile.getName() + HTML_FILES_SUFFIX);
                object = (Boolean)this.parameters.get(JRXmlExporterParameter.IS_EMBEDDING_IMAGES);
                if (object == null) {
                    object = Boolean.TRUE;
                }
                this.isEmbeddingImages = (Boolean)object;
                this.exportReportToFile();
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public void exportReportToFile() throws JRException {
        Object object;
        this.rendererToImagePathMap = new HashMap();
        this.imageNameToImageDataMap = new HashMap();
        Writer writer = null;
        try {
            object = new FileOutputStream(this.destFile);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)object, this.encoding));
            this.exportReportToStream(writer);
        }
        catch (IOException iOException) {
            throw new JRException("Error writing to file : " + this.destFile, iOException);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!this.isEmbeddingImages && (object = this.imageNameToImageDataMap.keySet()) != null && object.size() > 0) {
            if (!this.imagesDir.exists()) {
                this.imagesDir.mkdir();
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[] byArray = (byte[])this.imageNameToImageDataMap.get(string);
                File file = new File(this.imagesDir, string);
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    ((OutputStream)fileOutputStream).write(byArray, 0, byArray.length);
                }
                catch (IOException iOException) {
                    throw new JRException("Error writing to image file : " + file, iOException);
                }
                finally {
                    if (fileOutputStream == null) continue;
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public StringBuffer exportReportToBuffer() throws JRException {
        StringWriter stringWriter = new StringWriter();
        try {
            this.exportReportToStream(stringWriter);
        }
        catch (IOException iOException) {
            throw new JRException("Error while exporting report to buffer", iOException);
        }
        return stringWriter.getBuffer();
    }

    public void exportReportToStream(Writer writer) throws JRException, IOException {
        List list;
        JRStyle[] jRStyleArray;
        JRReportFont[] jRReportFontArray;
        this.xmlWriter = new JRXmlWriteHelper(writer);
        this.xmlWriter.writeProlog(this.encoding);
        this.xmlWriter.writePublicDoctype("jasperPrint", "-//JasperReports//DTD JasperPrint//EN", this.dtdLocation);
        this.xmlWriter.startElement("jasperPrint");
        this.xmlWriter.addEncodedAttribute("name", this.jasperPrint.getName());
        this.xmlWriter.addAttribute("pageWidth", this.jasperPrint.getPageWidth());
        this.xmlWriter.addAttribute("pageHeight", this.jasperPrint.getPageHeight());
        this.xmlWriter.addAttribute("orientation", this.jasperPrint.getOrientation(), JRXmlConstants.getOrientationMap(), (byte)1);
        this.xmlWriter.addAttribute("formatFactoryClass", this.jasperPrint.getFormatFactoryClass());
        this.xmlWriter.addEncodedAttribute("locale", this.jasperPrint.getLocaleCode());
        this.xmlWriter.addEncodedAttribute("timezone", this.jasperPrint.getTimeZoneId());
        this.exportProperties(this.jasperPrint);
        JROrigin[] jROriginArray = this.jasperPrint.getOrigins();
        if (jROriginArray != null && jROriginArray.length > 0) {
            for (int i2 = 0; i2 < jROriginArray.length; ++i2) {
                this.exportOrigin(jROriginArray[i2]);
            }
        }
        if ((jRReportFontArray = this.jasperPrint.getFonts()) != null && jRReportFontArray.length > 0) {
            for (int i3 = 0; i3 < jRReportFontArray.length; ++i3) {
                this.fontsMap.put(jRReportFontArray[i3].getName(), jRReportFontArray[i3]);
                this.exportReportFont(jRReportFontArray[i3]);
            }
        }
        if ((jRStyleArray = this.jasperPrint.getStyles()) != null && jRStyleArray.length > 0) {
            for (int i4 = 0; i4 < jRStyleArray.length; ++i4) {
                this.stylesMap.put(jRStyleArray[i4].getName(), jRStyleArray[i4]);
                this.exportStyle(jRStyleArray[i4]);
            }
        }
        if ((list = this.jasperPrint.getPages()) != null && list.size() > 0) {
            JRPrintPage jRPrintPage = null;
            for (int i5 = this.startPageIndex; i5 <= this.endPageIndex; ++i5) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                jRPrintPage = (JRPrintPage)list.get(i5);
                this.exportPage(jRPrintPage);
            }
        }
        this.xmlWriter.closeElement();
        writer.flush();
    }

    public void exportProperties(JRPropertiesHolder jRPropertiesHolder) throws IOException {
        JRPropertiesMap jRPropertiesMap;
        String[] stringArray;
        if (jRPropertiesHolder.hasProperties() && (stringArray = (jRPropertiesMap = jRPropertiesHolder.getPropertiesMap()).getPropertyNames()) != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.xmlWriter.startElement("property");
                this.xmlWriter.addEncodedAttribute("name", stringArray[i2]);
                String string = jRPropertiesMap.getProperty(stringArray[i2]);
                if (string != null) {
                    this.xmlWriter.addEncodedAttribute("value", string);
                }
                this.xmlWriter.closeElement();
            }
        }
    }

    public void exportReportFont(JRReportFont jRReportFont) throws IOException {
        this.xmlWriter.startElement("reportFont");
        this.xmlWriter.addEncodedAttribute("name", jRReportFont.getName());
        this.xmlWriter.addAttribute("isDefault", jRReportFont.isDefault());
        this.xmlWriter.addEncodedAttribute("fontName", jRReportFont.getFontName());
        this.xmlWriter.addAttribute("size", jRReportFont.getFontSize());
        this.xmlWriter.addAttribute("isBold", jRReportFont.isBold());
        this.xmlWriter.addAttribute("isItalic", jRReportFont.isItalic());
        this.xmlWriter.addAttribute("isUnderline", jRReportFont.isUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", jRReportFont.isStrikeThrough());
        this.xmlWriter.addEncodedAttribute("pdfFontName", jRReportFont.getPdfFontName());
        this.xmlWriter.addEncodedAttribute("pdfEncoding", jRReportFont.getPdfEncoding());
        this.xmlWriter.addAttribute("isPdfEmbedded", jRReportFont.isPdfEmbedded());
        this.xmlWriter.closeElement();
    }

    public void exportStyle(JRStyle jRStyle) throws IOException {
        this.xmlWriter.startElement("style");
        this.xmlWriter.addEncodedAttribute("name", jRStyle.getName());
        this.xmlWriter.addAttribute("isDefault", jRStyle.isDefault());
        if (jRStyle.getStyle() != null) {
            JRStyle jRStyle2 = (JRStyle)this.stylesMap.get(jRStyle.getStyle().getName());
            if (jRStyle2 != null) {
                this.xmlWriter.addEncodedAttribute("style", jRStyle.getStyle().getName());
            } else {
                throw new JRRuntimeException("Referenced report style not found : " + jRStyle.getStyle().getName());
            }
        }
        this.xmlWriter.addAttribute("mode", jRStyle.getOwnMode(), JRXmlConstants.getModeMap());
        this.xmlWriter.addAttribute("forecolor", jRStyle.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", jRStyle.getOwnBackcolor());
        this.xmlWriter.addAttribute("fill", jRStyle.getOwnFill(), JRXmlConstants.getFillMap());
        this.xmlWriter.addAttribute("radius", jRStyle.getOwnRadius());
        this.xmlWriter.addAttribute("scaleImage", jRStyle.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.xmlWriter.addAttribute("hAlign", jRStyle.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("vAlign", jRStyle.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("rotation", jRStyle.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.xmlWriter.addAttribute("lineSpacing", jRStyle.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.xmlWriter.addAttribute("isStyledText", jRStyle.isOwnStyledText());
        this.xmlWriter.addEncodedAttribute("fontName", jRStyle.getOwnFontName());
        this.xmlWriter.addAttribute("fontSize", jRStyle.getOwnFontSize());
        this.xmlWriter.addAttribute("isBold", jRStyle.isOwnBold());
        this.xmlWriter.addAttribute("isItalic", jRStyle.isOwnItalic());
        this.xmlWriter.addAttribute("isUnderline", jRStyle.isOwnUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", jRStyle.isOwnStrikeThrough());
        this.xmlWriter.addEncodedAttribute("pdfFontName", jRStyle.getOwnPdfFontName());
        this.xmlWriter.addEncodedAttribute("pdfEncoding", jRStyle.getOwnPdfEncoding());
        this.xmlWriter.addAttribute("isPdfEmbedded", jRStyle.isOwnPdfEmbedded());
        this.exportPen(jRStyle.getLinePen());
        this.exportBox(jRStyle.getLineBox());
        this.xmlWriter.closeElement();
    }

    public void exportOrigin(JROrigin jROrigin) throws IOException {
        this.xmlWriter.startElement("origin");
        this.xmlWriter.addEncodedAttribute("report", jROrigin.getReportName());
        this.xmlWriter.addEncodedAttribute("group", jROrigin.getGroupName());
        this.xmlWriter.addAttribute("band", jROrigin.getBandType(), JRXmlConstants.getBandTypeMap());
        this.xmlWriter.closeElement();
    }

    public void exportPage(JRPrintPage jRPrintPage) throws JRException, IOException {
        this.xmlWriter.startElement("page");
        List list = jRPrintPage.getElements();
        this.exportElements(list);
        this.xmlWriter.closeElement();
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    public void exportElements(Collection collection) throws IOException, JRException {
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
                if (this.filter != null && !this.filter.isToExport(jRPrintElement)) continue;
                if (jRPrintElement instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintText) {
                    this.exportText((JRPrintText)jRPrintElement);
                    continue;
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)jRPrintElement);
            }
        }
    }

    public void exportLine(JRPrintLine jRPrintLine) throws IOException {
        this.xmlWriter.startElement("line");
        this.xmlWriter.addAttribute("direction", jRPrintLine.getDirection(), JRXmlConstants.getDirectionMap(), (byte)1);
        this.exportReportElement(jRPrintLine);
        this.exportGraphicElement(jRPrintLine);
        this.xmlWriter.closeElement();
    }

    public void exportReportElement(JRPrintElement jRPrintElement) throws IOException {
        this.xmlWriter.startElement("reportElement");
        this.xmlWriter.addEncodedAttribute("key", jRPrintElement.getKey());
        JRStyle jRStyle = jRPrintElement.getStyle();
        if (jRStyle != null) {
            this.xmlWriter.addEncodedAttribute("style", jRStyle.getName());
        }
        this.xmlWriter.addAttribute("mode", jRPrintElement.getOwnMode(), JRXmlConstants.getModeMap());
        this.xmlWriter.addAttribute("x", jRPrintElement.getX() + this.getOffsetX());
        this.xmlWriter.addAttribute("y", jRPrintElement.getY() + this.getOffsetY());
        this.xmlWriter.addAttribute("width", jRPrintElement.getWidth());
        this.xmlWriter.addAttribute("height", jRPrintElement.getHeight());
        this.xmlWriter.addAttribute("forecolor", jRPrintElement.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", jRPrintElement.getOwnBackcolor());
        JROrigin jROrigin = jRPrintElement.getOrigin();
        if (jROrigin != null) {
            this.xmlWriter.addAttribute("origin", this.jasperPrint.getOriginsMap().get(jROrigin));
        }
        this.xmlWriter.closeElement();
    }

    public void exportGraphicElement(JRPrintGraphicElement jRPrintGraphicElement) throws IOException {
        this.xmlWriter.startElement("graphicElement");
        this.xmlWriter.addAttribute("fill", jRPrintGraphicElement.getOwnFill(), JRXmlConstants.getFillMap());
        this.exportPen(jRPrintGraphicElement.getLinePen());
        this.xmlWriter.closeElement(true);
    }

    public void exportPen(JRPen jRPen) throws IOException {
        this.exportPen("pen", jRPen);
    }

    public void exportPen(String string, JRPen jRPen) throws IOException {
        this.xmlWriter.startElement(string);
        this.xmlWriter.addAttribute("lineWidth", jRPen.getOwnLineWidth());
        this.xmlWriter.addAttribute("lineStyle", jRPen.getOwnLineStyle(), JRXmlConstants.getLineStyleMap());
        this.xmlWriter.addAttribute("lineColor", jRPen.getOwnLineColor());
        this.xmlWriter.closeElement(true);
    }

    public void exportRectangle(JRPrintRectangle jRPrintRectangle) throws IOException {
        this.xmlWriter.startElement("rectangle");
        this.xmlWriter.addAttribute("radius", jRPrintRectangle.getOwnRadius());
        this.exportReportElement(jRPrintRectangle);
        this.exportGraphicElement(jRPrintRectangle);
        this.xmlWriter.closeElement();
    }

    public void exportEllipse(JRPrintEllipse jRPrintEllipse) throws IOException {
        this.xmlWriter.startElement("ellipse");
        this.exportReportElement(jRPrintEllipse);
        this.exportGraphicElement(jRPrintEllipse);
        this.xmlWriter.closeElement();
    }

    public void exportImage(JRPrintImage jRPrintImage) throws JRException, IOException {
        this.xmlWriter.startElement("image");
        this.xmlWriter.addAttribute("scaleImage", jRPrintImage.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.xmlWriter.addAttribute("hAlign", jRPrintImage.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("vAlign", jRPrintImage.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("isLazy", jRPrintImage.isLazy(), false);
        this.xmlWriter.addAttribute("onErrorType", jRPrintImage.getOnErrorType(), JRXmlConstants.getOnErrorTypeMap(), (byte)1);
        this.xmlWriter.addEncodedAttribute("hyperlinkType", jRPrintImage.getLinkType());
        this.xmlWriter.addAttribute("hyperlinkTarget", jRPrintImage.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.xmlWriter.addEncodedAttribute("anchorName", jRPrintImage.getAnchorName());
        this.xmlWriter.addEncodedAttribute("hyperlinkReference", jRPrintImage.getHyperlinkReference());
        this.xmlWriter.addEncodedAttribute("hyperlinkAnchor", jRPrintImage.getHyperlinkAnchor());
        this.xmlWriter.addAttribute("hyperlinkPage", jRPrintImage.getHyperlinkPage());
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", jRPrintImage.getHyperlinkTooltip());
        this.xmlWriter.addAttribute("bookmarkLevel", jRPrintImage.getBookmarkLevel(), 0);
        this.exportReportElement(jRPrintImage);
        this.exportBox(jRPrintImage.getLineBox());
        this.exportGraphicElement(jRPrintImage);
        JRRenderable jRRenderable = jRPrintImage.getRenderer();
        if (jRRenderable != null) {
            this.xmlWriter.startElement("imageSource");
            this.xmlWriter.addAttribute("isEmbedded", this.isEmbeddingImages && !jRPrintImage.isLazy(), false);
            String string = "";
            if (jRRenderable.getType() == 1) {
                jRRenderable = new JRWrappingSvgRenderer(jRRenderable, new Dimension(jRPrintImage.getWidth(), jRPrintImage.getHeight()), 1 == jRPrintImage.getMode() ? jRPrintImage.getBackcolor() : null);
            }
            if (jRPrintImage.isLazy()) {
                string = ((JRImageRenderer)jRRenderable).getImageLocation();
            } else if (this.isEmbeddingImages) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(jRRenderable.getImageData());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    Base64Encoder base64Encoder = new Base64Encoder(byteArrayInputStream, byteArrayOutputStream);
                    base64Encoder.process();
                    string = new String(byteArrayOutputStream.toByteArray(), DEFAULT_XML_ENCODING);
                }
                catch (IOException iOException) {
                    throw new JRException("Error embedding image into XML.", iOException);
                }
            } else if (jRRenderable.getType() == 0 && this.rendererToImagePathMap.containsKey(jRRenderable)) {
                string = (String)this.rendererToImagePathMap.get(jRRenderable);
            } else {
                string = IMAGE_PREFIX + JRXmlExporter.getNextImageId();
                this.imageNameToImageDataMap.put(string, jRRenderable.getImageData());
                string = new File(this.imagesDir, string).getPath();
                this.rendererToImagePathMap.put(jRRenderable, string);
            }
            this.xmlWriter.writeCDATA(string);
            this.xmlWriter.closeElement();
        }
        this.exportHyperlinkParameters(jRPrintImage);
        this.xmlWriter.closeElement();
    }

    public void exportText(JRPrintText jRPrintText) throws IOException {
        this.xmlWriter.startElement("text");
        this.xmlWriter.addAttribute("textAlignment", jRPrintText.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("verticalAlignment", jRPrintText.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("textHeight", jRPrintText.getTextHeight());
        this.xmlWriter.addAttribute("rotation", jRPrintText.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.xmlWriter.addAttribute("runDirection", jRPrintText.getRunDirection(), JRXmlConstants.getRunDirectionMap(), (byte)0);
        this.xmlWriter.addAttribute("lineSpacing", jRPrintText.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.xmlWriter.addAttribute("isStyledText", jRPrintText.isOwnStyledText());
        this.xmlWriter.addAttribute("lineSpacingFactor", jRPrintText.getLineSpacingFactor());
        this.xmlWriter.addAttribute("leadingOffset", jRPrintText.getLeadingOffset());
        this.xmlWriter.addEncodedAttribute("hyperlinkType", jRPrintText.getLinkType());
        this.xmlWriter.addAttribute("hyperlinkTarget", jRPrintText.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.xmlWriter.addEncodedAttribute("anchorName", jRPrintText.getAnchorName());
        this.xmlWriter.addEncodedAttribute("hyperlinkReference", jRPrintText.getHyperlinkReference());
        this.xmlWriter.addEncodedAttribute("hyperlinkAnchor", jRPrintText.getHyperlinkAnchor());
        this.xmlWriter.addAttribute("hyperlinkPage", jRPrintText.getHyperlinkPage());
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", jRPrintText.getHyperlinkTooltip());
        this.xmlWriter.addAttribute("bookmarkLevel", jRPrintText.getBookmarkLevel(), 0);
        this.xmlWriter.addAttribute("valueClass", jRPrintText.getValueClassName());
        this.xmlWriter.addEncodedAttribute("pattern", jRPrintText.getPattern());
        this.xmlWriter.addAttribute("formatFactoryClass", jRPrintText.getFormatFactoryClass());
        this.xmlWriter.addEncodedAttribute("locale", jRPrintText.getLocaleCode());
        this.xmlWriter.addEncodedAttribute("timezone", jRPrintText.getTimeZoneId());
        this.exportReportElement(jRPrintText);
        this.exportBox(jRPrintText.getLineBox());
        this.exportFont(jRPrintText);
        if (jRPrintText.getOriginalText() != null) {
            this.xmlWriter.writeCDATAElement("textContent", jRPrintText.getOriginalText(), "truncateIndex", jRPrintText.getTextTruncateIndex());
        }
        this.xmlWriter.writeCDATAElement("textTruncateSuffix", jRPrintText.getTextTruncateSuffix());
        this.exportHyperlinkParameters(jRPrintText);
        this.xmlWriter.closeElement();
    }

    private void exportBox(JRLineBox jRLineBox) throws IOException {
        if (jRLineBox != null) {
            this.xmlWriter.startElement("box");
            this.xmlWriter.addAttribute("padding", jRLineBox.getOwnPadding());
            this.xmlWriter.addAttribute("topPadding", jRLineBox.getOwnTopPadding());
            this.xmlWriter.addAttribute("leftPadding", jRLineBox.getOwnLeftPadding());
            this.xmlWriter.addAttribute("bottomPadding", jRLineBox.getOwnBottomPadding());
            this.xmlWriter.addAttribute("rightPadding", jRLineBox.getOwnRightPadding());
            this.exportPen("pen", jRLineBox.getPen());
            this.exportPen("topPen", jRLineBox.getTopPen());
            this.exportPen("leftPen", jRLineBox.getLeftPen());
            this.exportPen("bottomPen", jRLineBox.getBottomPen());
            this.exportPen("rightPen", jRLineBox.getRightPen());
            this.xmlWriter.closeElement(true);
        }
    }

    public void exportFont(JRFont jRFont) throws IOException {
        if (jRFont != null) {
            this.xmlWriter.startElement("font");
            if (jRFont.getReportFont() != null) {
                JRFont jRFont2 = (JRFont)this.fontsMap.get(jRFont.getReportFont().getName());
                if (jRFont2 != null) {
                    this.xmlWriter.addEncodedAttribute("reportFont", jRFont.getReportFont().getName());
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + jRFont.getReportFont().getName());
                }
            }
            this.xmlWriter.addEncodedAttribute("fontName", jRFont.getOwnFontName());
            this.xmlWriter.addAttribute("size", jRFont.getOwnFontSize());
            this.xmlWriter.addAttribute("isBold", jRFont.isOwnBold());
            this.xmlWriter.addAttribute("isItalic", jRFont.isOwnItalic());
            this.xmlWriter.addAttribute("isUnderline", jRFont.isOwnUnderline());
            this.xmlWriter.addAttribute("isStrikeThrough", jRFont.isOwnStrikeThrough());
            this.xmlWriter.addEncodedAttribute("pdfFontName", jRFont.getOwnPdfFontName());
            this.xmlWriter.addEncodedAttribute("pdfEncoding", jRFont.getOwnPdfEncoding());
            this.xmlWriter.addAttribute("isPdfEmbedded", jRFont.isOwnPdfEmbedded());
            this.xmlWriter.closeElement(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFrame(JRPrintFrame jRPrintFrame) throws IOException, JRException {
        this.xmlWriter.startElement("frame");
        this.setFrameElementsOffset(jRPrintFrame, true);
        try {
            this.exportReportElement(jRPrintFrame);
            this.exportBox(jRPrintFrame.getLineBox());
            this.exportElements(jRPrintFrame.getElements());
            this.xmlWriter.closeElement();
        }
        finally {
            this.restoreElementOffsets();
        }
    }

    private static synchronized int getNextImageId() {
        return imageId++;
    }

    public void exportHyperlinkParameters(JRPrintHyperlink jRPrintHyperlink) throws IOException {
        JRPrintHyperlinkParameters jRPrintHyperlinkParameters = jRPrintHyperlink.getHyperlinkParameters();
        if (jRPrintHyperlinkParameters != null) {
            Iterator iterator = jRPrintHyperlinkParameters.getParameters().iterator();
            while (iterator.hasNext()) {
                JRPrintHyperlinkParameter jRPrintHyperlinkParameter = (JRPrintHyperlinkParameter)iterator.next();
                this.exportHyperlinkParameter(jRPrintHyperlinkParameter);
            }
        }
    }

    public void exportHyperlinkParameter(JRPrintHyperlinkParameter jRPrintHyperlinkParameter) throws IOException {
        this.xmlWriter.startElement("hyperlinkParameter");
        this.xmlWriter.addEncodedAttribute("name", jRPrintHyperlinkParameter.getName());
        this.xmlWriter.addAttribute("class", jRPrintHyperlinkParameter.getValueClass(), DEFAULT_OBJECT_TYPE);
        if (jRPrintHyperlinkParameter.getValue() != null) {
            String string = JRValueStringUtils.serialize(jRPrintHyperlinkParameter.getValueClass(), jRPrintHyperlinkParameter.getValue());
            this.xmlWriter.writeCDATAElement("hyperlinkParameterValue", string);
        }
        this.xmlWriter.closeElement();
    }
}

