/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.util.JRStyledText;

public abstract class JRXlsAbstractExporter
extends JRAbstractExporter {
    private static final String XLS_ORIGIN_EXPORTER_FILTER_PREFIX = "net.sf.jasperreports.export.xls.exclude.origin.";
    public List loadedFonts = new ArrayList();
    public boolean isOnePagePerSheet;
    public boolean isRemoveEmptySpaceBetweenRows;
    public boolean isRemoveEmptySpaceBetweenColumns;
    public boolean isWhitePageBackground;
    public boolean isAutoDetectCellType = false;
    public boolean isDetectCellType;
    public boolean isFontSizeFixEnabled;
    public boolean isIgnoreGraphics;
    public boolean isCollapseRowSpan;
    public boolean isIgnoreCellBorder;
    public int maxRowsPerSheet;
    public JRHyperlinkProducerFactory hyperlinkProducerFactory;
    public String[] sheetNames = null;
    public JRExportProgressMonitor progressMonitor = null;
    public int reportIndex = 0;
    public Map fontMap = null;
    public JRFont defaultFont = null;
    public int sheetIndex = 0;
    public Map sheetNamesMap = null;
    public String currentSheetName = null;

    public JRFont getDefaultFont() {
        return this.defaultFont;
    }

    public JRHyperlinkProducer getCustomHandler(JRPrintHyperlink jRPrintHyperlink) {
        return this.hyperlinkProducerFactory == null ? null : this.hyperlinkProducerFactory.getHandler(jRPrintHyperlink.getLinkType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block19: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = JROriginExporterFilter.getFilter(this.jasperPrint.getPropertiesMap(), XLS_ORIGIN_EXPORTER_FILTER_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.setParameters();
                OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (outputStream != null) {
                    this.exportReportToStream(outputStream);
                    break block19;
                }
                File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (file == null) {
                    String string = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (string != null) {
                        file = new File(string);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    outputStream = new FileOutputStream(file);
                    this.exportReportToStream(outputStream);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    throw new JRException("Error trying to export to file : " + file, iOException);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public void setParameters() {
        this.isOnePagePerSheet = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, "net.sf.jasperreports.export.xls.one.page.per.sheet", false);
        this.isRemoveEmptySpaceBetweenRows = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, "net.sf.jasperreports.export.xls.remove.empty.space.between.rows", false);
        this.isRemoveEmptySpaceBetweenColumns = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, "net.sf.jasperreports.export.xls.remove.empty.space.between.columns", false);
        this.isWhitePageBackground = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, "net.sf.jasperreports.export.xls.white.page.background", false);
        this.setBackground();
        Boolean bl2 = (Boolean)this.parameters.get(JRXlsAbstractExporterParameter.IS_AUTO_DETECT_CELL_TYPE);
        if (bl2 != null) {
            this.isAutoDetectCellType = bl2;
        }
        this.isDetectCellType = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_DETECT_CELL_TYPE, "net.sf.jasperreports.export.xls.detect.cell.type", false);
        this.isFontSizeFixEnabled = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_FONT_SIZE_FIX_ENABLED, "net.sf.jasperreports.export.xls.font.size.fix.enabled", false);
        this.isIgnoreGraphics = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_GRAPHICS, "net.sf.jasperreports.export.xls.ignore.graphics", false);
        this.isCollapseRowSpan = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_COLLAPSE_ROW_SPAN, "net.sf.jasperreports.export.xls.collapse.row.span", false);
        this.isIgnoreCellBorder = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BORDER, "net.sf.jasperreports.export.xls.ignore.cell.border", false);
        this.sheetNames = (String[])this.parameters.get(JRXlsAbstractExporterParameter.SHEET_NAMES);
        this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
        this.maxRowsPerSheet = this.getIntegerParameter(JRXlsAbstractExporterParameter.MAXIMUM_ROWS_PER_SHEET, "net.sf.jasperreports.export.xls.max.rows.per.sheet", 0);
    }

    public abstract void setBackground();

    public void exportReportToStream(OutputStream outputStream) throws JRException {
        this.openWorkbook(outputStream);
        this.sheetNamesMap = new HashMap();
        this.sheetNamesMap.put("Page", new Integer(0));
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            this.defaultFont = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            List list = this.jasperPrint.getPages();
            if (list != null && list.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = list.size() - 1;
                }
                if (this.isOnePagePerSheet) {
                    for (int i2 = this.startPageIndex; i2 <= this.endPageIndex; ++i2) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage jRPrintPage = (JRPrintPage)list.get(i2);
                        if (this.sheetNames != null && this.sheetIndex < this.sheetNames.length) {
                            this.createSheet(this.getSheetName(this.sheetNames[this.sheetIndex]));
                        } else {
                            this.createSheet(this.getSheetName("Page"));
                        }
                        ++this.sheetIndex;
                        this.exportPage(jRPrintPage, null, 0);
                    }
                } else {
                    if (this.sheetNames != null && this.sheetIndex < this.sheetNames.length) {
                        this.createSheet(this.getSheetName(this.sheetNames[this.sheetIndex]));
                    } else {
                        this.createSheet(this.getSheetName(this.jasperPrint.getName()));
                    }
                    ++this.sheetIndex;
                    CutsInfo cutsInfo = JRGridLayout.calculateXCuts(this.getNature(), list, this.startPageIndex, this.endPageIndex, this.jasperPrint.getPageWidth(), this.globalOffsetX);
                    if (this.filter instanceof ResetableExporterFilter) {
                        ((ResetableExporterFilter)this.filter).reset();
                    }
                    int n2 = 0;
                    for (int i3 = this.startPageIndex; i3 <= this.endPageIndex; ++i3) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage jRPrintPage = (JRPrintPage)list.get(i3);
                        n2 = this.exportPage(jRPrintPage, cutsInfo, n2);
                    }
                    if (this.isRemoveEmptySpaceBetweenColumns) {
                        this.removeEmptyColumns(cutsInfo);
                    }
                }
            }
            ++this.reportIndex;
        }
        this.closeWorkbook(outputStream);
    }

    public int exportPage(JRPrintPage jRPrintPage, CutsInfo cutsInfo, int n2) throws JRException {
        boolean bl2;
        JRGridLayout jRGridLayout = new JRGridLayout(this.getNature(), jRPrintPage.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, cutsInfo);
        JRExporterGridCell[][] jRExporterGridCellArray = jRGridLayout.getGrid();
        boolean bl3 = bl2 = cutsInfo == null;
        if (bl2) {
            cutsInfo = jRGridLayout.getXCuts();
        }
        CutsInfo cutsInfo2 = jRGridLayout.getYCuts();
        int n3 = 0;
        int n4 = n2;
        boolean bl4 = true;
        for (int i2 = 0; i2 < jRExporterGridCellArray.length; ++i2) {
            n4 = i2 - n3 + n2;
            if (this.maxRowsPerSheet > 0 && n4 >= this.maxRowsPerSheet) {
                this.createSheet(this.getSheetName(this.currentSheetName));
                n2 = 0;
                n4 = 0;
                n3 = i2;
                bl4 = true;
            }
            if (bl4) {
                this.setColumnWidths(cutsInfo);
                bl4 = false;
            }
            if (cutsInfo2.isCutNotEmpty(i2) || (!this.isRemoveEmptySpaceBetweenRows || cutsInfo2.isCutSpanned(i2)) && !this.isCollapseRowSpan) {
                JRExporterGridCell[] jRExporterGridCellArray2 = jRExporterGridCellArray[i2];
                int n5 = 0;
                int n6 = 0;
                this.setRowHeight(n4, this.isCollapseRowSpan ? JRGridLayout.getMaxRowHeight(jRExporterGridCellArray2) : JRGridLayout.getRowHeight(jRExporterGridCellArray2));
                int n7 = 0;
                for (int i3 = 0; i3 < jRExporterGridCellArray2.length; ++i3) {
                    n7 += this.isRemoveEmptySpaceBetweenColumns && !cutsInfo.isCutNotEmpty(i3) && !cutsInfo.isCutSpanned(i3) ? 1 : 0;
                    this.setCell(i3, n4);
                    JRExporterGridCell jRExporterGridCell = jRExporterGridCellArray2[i3];
                    if (jRExporterGridCell.getWrapper() != null) {
                        JRPrintElement jRPrintElement;
                        if (n5 > 0) {
                            if (n5 > 1) {
                                // empty if block
                            }
                            n5 = 0;
                            n6 = 0;
                        }
                        if ((jRPrintElement = jRExporterGridCell.getWrapper().getElement()) instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)jRPrintElement, jRExporterGridCell, i3, n4);
                        } else if (jRPrintElement instanceof JRPrintRectangle) {
                            this.exportRectangle((JRPrintRectangle)jRPrintElement, jRExporterGridCell, i3, n4);
                        } else if (jRPrintElement instanceof JRPrintEllipse) {
                            this.exportRectangle((JRPrintEllipse)jRPrintElement, jRExporterGridCell, i3, n4);
                        } else if (jRPrintElement instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)jRPrintElement, jRExporterGridCell, i3, n4, n7);
                        } else if (jRPrintElement instanceof JRPrintText) {
                            this.exportText((JRPrintText)jRPrintElement, jRExporterGridCell, i3, n4);
                        } else if (jRPrintElement instanceof JRPrintFrame) {
                            this.exportFrame((JRPrintFrame)jRPrintElement, jRExporterGridCell, i3, i2);
                        }
                        i3 += jRExporterGridCell.getColSpan() - 1;
                        continue;
                    }
                    ++n5;
                    n6 += jRExporterGridCell.getWidth();
                    this.addBlankCell(jRExporterGridCell, i3, n4);
                }
                if (n5 <= 0 || n5 > 1) {
                    // empty if block
                }
                ++n4;
                continue;
            }
            ++n3;
        }
        if (bl2 && this.isRemoveEmptySpaceBetweenColumns) {
            this.removeEmptyColumns(cutsInfo);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
        return n4;
    }

    public void setColumnWidths(CutsInfo cutsInfo) {
        for (int i2 = 0; i2 < cutsInfo.size() - 1; ++i2) {
            if (this.isRemoveEmptySpaceBetweenColumns && !cutsInfo.isCutNotEmpty(i2) && !cutsInfo.isCutSpanned(i2)) continue;
            int n2 = cutsInfo.getCut(i2 + 1) - cutsInfo.getCut(i2);
            this.setColumnWidth((short)i2, (short)(n2 * 43));
        }
    }

    public void removeEmptyColumns(CutsInfo cutsInfo) {
        for (int i2 = cutsInfo.size() - 1; i2 >= 0; --i2) {
            if (cutsInfo.isCutNotEmpty(i2) || cutsInfo.isCutSpanned(i2)) continue;
            this.removeColumn(i2);
        }
    }

    public JRStyledText getStyledText(JRPrintText jRPrintText) {
        return jRPrintText.getFullStyledText(JRStyledTextAttributeSelector.NONE);
    }

    public static TextAlignHolder getTextAlignHolder(JRPrintText jRPrintText) {
        short s2;
        short s3;
        short s4 = jRPrintText.getRotation();
        block0 : switch (jRPrintText.getRotation()) {
            case 1: {
                switch (jRPrintText.getHorizontalAlignment()) {
                    case 1: {
                        s3 = 3;
                        break;
                    }
                    case 2: {
                        s3 = 2;
                        break;
                    }
                    case 3: {
                        s3 = 1;
                        break;
                    }
                    case 4: {
                        s3 = 4;
                        break;
                    }
                    default: {
                        s3 = 3;
                    }
                }
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        s2 = 1;
                        break block0;
                    }
                    case 2: {
                        s2 = 2;
                        break block0;
                    }
                    case 3: {
                        s2 = 3;
                        break block0;
                    }
                }
                s2 = 1;
                break;
            }
            case 2: {
                switch (jRPrintText.getHorizontalAlignment()) {
                    case 1: {
                        s3 = 1;
                        break;
                    }
                    case 2: {
                        s3 = 2;
                        break;
                    }
                    case 3: {
                        s3 = 3;
                        break;
                    }
                    case 4: {
                        s3 = 4;
                        break;
                    }
                    default: {
                        s3 = 1;
                    }
                }
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        s2 = 3;
                        break block0;
                    }
                    case 2: {
                        s2 = 2;
                        break block0;
                    }
                    case 3: {
                        s2 = 1;
                        break block0;
                    }
                }
                s2 = 3;
                break;
            }
            default: {
                s2 = jRPrintText.getHorizontalAlignment();
                s3 = jRPrintText.getVerticalAlignment();
            }
        }
        return new TextAlignHolder(s2, s3, s4);
    }

    private String getSheetName(String string) {
        this.currentSheetName = string;
        if (!this.sheetNamesMap.containsKey(string)) {
            this.sheetNamesMap.put(string, new Integer(1));
            return string;
        }
        int n2 = (Integer)this.sheetNamesMap.get(string) + 1;
        this.sheetNamesMap.put(string, new Integer(n2));
        return string + " " + n2;
    }

    public abstract ExporterNature getNature();

    public abstract void openWorkbook(OutputStream var1) throws JRException;

    public abstract void createSheet(String var1);

    public abstract void closeWorkbook(OutputStream var1) throws JRException;

    public abstract void setColumnWidth(int var1, int var2);

    public abstract void removeColumn(int var1);

    public abstract void setRowHeight(int var1, int var2) throws JRException;

    public abstract void setCell(int var1, int var2);

    public abstract void addBlankCell(JRExporterGridCell var1, int var2, int var3) throws JRException;

    public abstract void exportText(JRPrintText var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    public abstract void exportImage(JRPrintImage var1, JRExporterGridCell var2, int var3, int var4, int var5) throws JRException;

    public abstract void exportRectangle(JRPrintGraphicElement var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    public abstract void exportLine(JRPrintLine var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    public abstract void exportFrame(JRPrintFrame var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected static class TextAlignHolder {
        public final short horizontalAlignment;
        public final short verticalAlignment;
        public final short rotation;

        public TextAlignHolder(short s2, short s3, short s4) {
            this.horizontalAlignment = s2;
            this.verticalAlignment = s3;
            this.rotation = s4;
        }
    }
}

