/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRTextExporter
extends JRAbstractExporter {
    public int pageWidth;
    public int pageHeight;
    public int characterHeight;
    public int characterWidth;
    public JRExportProgressMonitor progressMonitor;
    public Writer writer;
    public char[][] l;
    public String betweenPagesText;
    public String lineSeparator;
    public static final String systemLineSeparator = System.getProperty("line.separator");

    public void exportReport() throws JRException {
        Comparable<Integer> comparable;
        Integer n2;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        if (!this.isModeBatch) {
            this.setPageRange();
        }
        String string = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
        Integer n3 = (Integer)this.parameters.get(JRTextExporterParameter.CHARACTER_WIDTH);
        if (n3 != null) {
            this.characterWidth = n3;
            if (this.characterWidth < 0) {
                throw new JRException("Character width must be greater than 0");
            }
        } else {
            n2 = (Integer)this.parameters.get(JRTextExporterParameter.PAGE_WIDTH);
            if (n2 != null) {
                this.pageWidth = n2;
                if (this.pageWidth <= 0) {
                    throw new JRException("Page width must be greater than 0");
                }
            } else {
                throw new JRException("Character or page width must be specified");
            }
        }
        if ((n2 = (Integer)this.parameters.get(JRTextExporterParameter.CHARACTER_HEIGHT)) != null) {
            this.characterHeight = n2;
            if (this.characterHeight < 0) {
                throw new JRException("Character height must be greater than 0");
            }
        } else {
            comparable = (Integer)this.parameters.get(JRTextExporterParameter.PAGE_HEIGHT);
            if (comparable != null) {
                this.pageHeight = (Integer)comparable;
                if (this.pageHeight <= 0) {
                    throw new JRException("Page height must be greater than 0");
                }
            } else {
                throw new JRException("Character or page height must be specified");
            }
        }
        this.betweenPagesText = (String)this.parameters.get(JRTextExporterParameter.BETWEEN_PAGES_TEXT);
        if (this.betweenPagesText == null) {
            this.betweenPagesText = systemLineSeparator + systemLineSeparator;
        }
        this.lineSeparator = (String)this.parameters.get(JRTextExporterParameter.LINE_SEPARATOR);
        if (this.lineSeparator == null) {
            this.lineSeparator = systemLineSeparator;
        }
        if ((comparable = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            try {
                this.writer = new StringWriter();
                this.exportReportToWriter();
                ((StringBuffer)comparable).append(this.writer.toString());
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), iOException);
            }
            finally {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), iOException);
            }
        }
        OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (outputStream != null) {
            try {
                this.writer = new OutputStreamWriter(outputStream, string);
                this.exportReportToWriter();
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), iOException);
            }
        }
        File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (file == null) {
            String string2 = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (string2 != null) {
                file = new File(string2);
            } else {
                throw new JRException("No output specified for the exporter.");
            }
        }
        try {
            outputStream = new FileOutputStream(file);
            this.writer = new OutputStreamWriter(outputStream, string);
            this.exportReportToWriter();
        }
        catch (IOException iOException) {
            throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), iOException);
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void exportReportToWriter() throws JRException, IOException {
        for (int i2 = 0; i2 < this.jasperPrintList.size(); ++i2) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(i2);
            List list = this.jasperPrint.getPages();
            if (list == null || list.size() <= 0) continue;
            if (this.isModeBatch) {
                this.startPageIndex = 0;
                this.endPageIndex = list.size() - 1;
            }
            if (this.characterWidth > 0) {
                this.pageWidth = this.jasperPrint.getPageWidth() / this.characterWidth;
            }
            if (this.characterHeight > 0) {
                this.pageHeight = this.jasperPrint.getPageHeight() / this.characterHeight;
            }
            for (int i3 = this.startPageIndex; i3 <= this.endPageIndex; ++i3) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                JRPrintPage jRPrintPage = (JRPrintPage)list.get(i3);
                this.exportPage(jRPrintPage);
            }
        }
        this.writer.flush();
    }

    public void exportPage(JRPrintPage jRPrintPage) throws IOException {
        int n2;
        List list = jRPrintPage.getElements();
        this.l = new char[this.pageHeight][];
        for (n2 = 0; n2 < this.pageHeight; ++n2) {
            this.l[n2] = new char[this.pageWidth];
            Arrays.fill(this.l[n2], ' ');
        }
        this.exportElements(list);
        for (n2 = 0; n2 < this.pageHeight; ++n2) {
            this.writer.write(this.l[n2]);
            this.writer.write(this.lineSeparator);
        }
        this.writer.write(this.betweenPagesText);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportElements(List list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (e2 instanceof JRPrintText) {
                this.exportText((JRPrintText)e2);
                continue;
            }
            if (!(e2 instanceof JRPrintFrame)) continue;
            JRPrintFrame jRPrintFrame = (JRPrintFrame)e2;
            this.setFrameElementsOffset(jRPrintFrame, false);
            try {
                this.exportElements(jRPrintFrame.getElements());
                continue;
            }
            finally {
                this.restoreElementOffsets();
            }
        }
    }

    public void exportText(JRPrintText jRPrintText) {
        JRStyledText jRStyledText;
        int n2 = this.calculateYCoord(jRPrintText.getHeight());
        int n3 = this.calculateXCoord(jRPrintText.getWidth());
        int n4 = this.calculateXCoord(jRPrintText.getX() + this.getOffsetX());
        int n5 = this.calculateYCoord(jRPrintText.getY() + this.getOffsetY());
        if (n4 + n3 > this.pageWidth) {
            n3 = this.pageWidth - n4;
        }
        String string = (jRStyledText = this.getStyledText(jRPrintText)) == null ? "" : jRStyledText.getText();
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        if (string != null && string.length() == 0) {
            return;
        }
        StringBuffer[] stringBufferArray = new StringBuffer[n2];
        stringBufferArray[0] = new StringBuffer();
        int n6 = 0;
        int n7 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        block0: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ", true);
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                while (string3.length() > n3) {
                    stringBufferArray[n6].append(string3.substring(0, n3 - n7));
                    string3 = string3.substring(n3 - n7, string3.length());
                    if (++n6 == n2) break block0;
                    n7 = 0;
                    stringBufferArray[n6] = new StringBuffer();
                }
                if (n7 + string3.length() > n3) {
                    if (++n6 == n2) break block0;
                    n7 = 0;
                    stringBufferArray[n6] = new StringBuffer();
                }
                if (n6 > 9 && n7 == 0 && string3.equals(" ")) break;
                stringBufferArray[n6].append(string3);
                n7 += string3.length();
            }
            if (++n6 == n2) break;
            n7 = 0;
            stringBufferArray[n6] = new StringBuffer();
        }
        int n8 = 0;
        int n9 = 0;
        if (jRPrintText.getVerticalAlignment() == 3) {
            n9 = n2 - n6;
        }
        if (jRPrintText.getVerticalAlignment() == 2) {
            n9 = (n2 - n6) / 2;
        }
        for (int i2 = 0; i2 < n6; ++i2) {
            int n10;
            String string4 = stringBufferArray[i2].toString();
            for (n10 = string4.length() - 1; n10 >= 0 && string4.charAt(n10) == ' '; --n10) {
            }
            string4 = string4.substring(0, n10 + 1);
            if (jRPrintText.getHorizontalAlignment() == 3) {
                n8 = n3 - string4.length();
            }
            if (jRPrintText.getHorizontalAlignment() == 2) {
                n8 = (n3 - string4.length()) / 2;
            }
            if (jRPrintText.getHorizontalAlignment() == 4 && i2 < n6 - 1) {
                string4 = this.justifyText(string4, n3);
            }
            char[] cArray = string4.toCharArray();
            System.arraycopy(cArray, 0, this.l[n5 + n9 + i2], n4 + n8, cArray.length);
        }
    }

    private String justifyText(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n3 = stringTokenizer.countTokens();
        if (n3 <= 1) {
            return string;
        }
        String[] stringArray = new String[n3];
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n4++] = stringTokenizer.nextToken();
        }
        int n5 = n2 - string.length() + (stringArray.length - 1);
        int n6 = n5 / (stringArray.length - 1);
        int n7 = n5 % (stringArray.length - 1);
        char[] cArray = new char[n6];
        Arrays.fill(cArray, ' ');
        for (n4 = 0; n4 < stringArray.length - 1; ++n4) {
            stringBuffer.append(stringArray[n4]);
            stringBuffer.append(cArray);
            if (n4 >= n7) continue;
            stringBuffer.append(' ');
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }

    public int calculateYCoord(int n2) {
        return this.pageHeight * n2 / this.jasperPrint.getPageHeight();
    }

    public int calculateXCoord(int n2) {
        return this.pageWidth * n2 / this.jasperPrint.getPageWidth();
    }

    public JRStyledText getStyledText(JRPrintText jRPrintText) {
        return jRPrintText.getStyledText(JRStyledTextAttributeSelector.NONE);
    }
}

